/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.emitter.core;

import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class EmittedBatchCounter {
    private static final int MAX_PHASE = Integer.MAX_VALUE;
    private final Phaser phaser = new Phaser(1);

    EmittedBatchCounter() {
    }

    static int nextBatchNumber(int prevBatchNumber) {
        return prevBatchNumber + 1 & Integer.MAX_VALUE;
    }

    void batchEmitted() {
        this.phaser.arrive();
    }

    void awaitBatchEmitted(int batchNumberToAwait, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        batchNumberToAwait &= Integer.MAX_VALUE;
        int currentBatch = this.phaser.getPhase();
        this.checkNotTerminated(currentBatch);
        while (EmittedBatchCounter.comparePhases(batchNumberToAwait, currentBatch) >= 0) {
            currentBatch = this.phaser.awaitAdvanceInterruptibly(currentBatch, timeout, unit);
            this.checkNotTerminated(currentBatch);
        }
    }

    private static int comparePhases(int phase1, int phase2) {
        int diff = phase1 - phase2 & Integer.MAX_VALUE;
        if (diff == 0) {
            return 0;
        }
        return diff < 0x3FFFFFFF ? 1 : -1;
    }

    private void checkNotTerminated(int phase) {
        if (phase < 0) {
            throw new IllegalStateException("Phaser[" + this.phaser + "] unexpectedly terminated.");
        }
    }
}

