/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.RetryUtils;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.metadata.MetadataCASUpdate;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageConnector;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.RetryTransactionException;
import org.skife.jdbi.v2.Batch;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.util.ByteArrayMapper;
import org.skife.jdbi.v2.util.IntegerMapper;

public abstract class SQLMetadataConnector
implements MetadataStorageConnector {
    private static final Logger log = new Logger(SQLMetadataConnector.class);
    private static final String PAYLOAD_TYPE = "BLOB";
    static final int DEFAULT_MAX_TRIES = 10;
    private final Supplier<MetadataStorageConnectorConfig> config;
    private final Supplier<MetadataStorageTablesConfig> tablesConfigSupplier;
    private final Predicate<Throwable> shouldRetry;

    public SQLMetadataConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> tablesConfigSupplier) {
        this.config = config;
        this.tablesConfigSupplier = tablesConfigSupplier;
        this.shouldRetry = new Predicate<Throwable>(){

            @Override
            public boolean apply(Throwable e) {
                return SQLMetadataConnector.this.isTransientException(e);
            }
        };
    }

    protected String getPayloadType() {
        return PAYLOAD_TYPE;
    }

    protected abstract String getSerialType();

    protected abstract int getStreamingFetchSize();

    public abstract String getQuoteString();

    public String getValidationQuery() {
        return "SELECT 1";
    }

    public abstract boolean tableExists(Handle var1, String var2);

    public <T> T retryWithHandle(final HandleCallback<T> callback, Predicate<Throwable> myShouldRetry) {
        Callable call = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return SQLMetadataConnector.this.getDBI().withHandle(callback);
            }
        };
        try {
            return RetryUtils.retry(call, myShouldRetry, 10);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public <T> T retryWithHandle(HandleCallback<T> callback) {
        return this.retryWithHandle(callback, this.shouldRetry);
    }

    public <T> T retryTransaction(final TransactionCallback<T> callback, int quietTries, int maxTries) {
        Callable call = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return SQLMetadataConnector.this.getDBI().inTransaction(callback);
            }
        };
        try {
            return RetryUtils.retry(call, this.shouldRetry, quietTries, maxTries);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public final boolean isTransientException(Throwable e) {
        return e != null && (e instanceof RetryTransactionException || e instanceof SQLTransientException || e instanceof SQLRecoverableException || e instanceof UnableToObtainConnectionException || e instanceof UnableToExecuteStatementException || this.connectorIsTransientException(e) || e instanceof SQLException && this.isTransientException(e.getCause()) || e instanceof DBIException && this.isTransientException(e.getCause()));
    }

    protected boolean connectorIsTransientException(Throwable e) {
        return false;
    }

    public void createTable(final String tableName, final Iterable<String> sql) {
        try {
            this.retryWithHandle(new HandleCallback<Void>(){

                @Override
                public Void withHandle(Handle handle) throws Exception {
                    if (!SQLMetadataConnector.this.tableExists(handle, tableName)) {
                        log.info("Creating table[%s]", tableName);
                        Batch batch = handle.createBatch();
                        for (String s : sql) {
                            batch.add(s);
                        }
                        batch.execute();
                    } else {
                        log.info("Table[%s] already exists", tableName);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.warn(e, "Exception creating table", new Object[0]);
        }
    }

    public void createPendingSegmentsTable(String tableName) {
        this.createTable(tableName, ImmutableList.of(StringUtils.format("CREATE TABLE %1$s (\n  id VARCHAR(255) NOT NULL,\n  dataSource VARCHAR(255) NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  start VARCHAR(255) NOT NULL,\n  %3$send%3$s VARCHAR(255) NOT NULL,\n  sequence_name VARCHAR(255) NOT NULL,\n  sequence_prev_id VARCHAR(255) NOT NULL,\n  sequence_name_prev_id_sha1 VARCHAR(255) NOT NULL,\n  payload %2$s NOT NULL,\n  PRIMARY KEY (id),\n  UNIQUE (sequence_name_prev_id_sha1)\n)", tableName, this.getPayloadType(), this.getQuoteString())));
    }

    public void createDataSourceTable(String tableName) {
        this.createTable(tableName, ImmutableList.of(StringUtils.format("CREATE TABLE %1$s (\n  dataSource VARCHAR(255) NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  commit_metadata_payload %2$s NOT NULL,\n  commit_metadata_sha1 VARCHAR(255) NOT NULL,\n  PRIMARY KEY (dataSource)\n)", tableName, this.getPayloadType())));
    }

    public void createSegmentTable(String tableName) {
        this.createTable(tableName, ImmutableList.of(StringUtils.format("CREATE TABLE %1$s (\n  id VARCHAR(255) NOT NULL,\n  dataSource VARCHAR(255) NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  start VARCHAR(255) NOT NULL,\n  %3$send%3$s VARCHAR(255) NOT NULL,\n  partitioned BOOLEAN NOT NULL,\n  version VARCHAR(255) NOT NULL,\n  used BOOLEAN NOT NULL,\n  payload %2$s NOT NULL,\n  PRIMARY KEY (id)\n)", tableName, this.getPayloadType(), this.getQuoteString()), StringUtils.format("CREATE INDEX idx_%1$s_datasource ON %1$s(dataSource)", tableName), StringUtils.format("CREATE INDEX idx_%1$s_used ON %1$s(used)", tableName)));
    }

    public void createRulesTable(String tableName) {
        this.createTable(tableName, ImmutableList.of(StringUtils.format("CREATE TABLE %1$s (\n  id VARCHAR(255) NOT NULL,\n  dataSource VARCHAR(255) NOT NULL,\n  version VARCHAR(255) NOT NULL,\n  payload %2$s NOT NULL,\n  PRIMARY KEY (id)\n)", tableName, this.getPayloadType()), StringUtils.format("CREATE INDEX idx_%1$s_datasource ON %1$s(dataSource)", tableName)));
    }

    public void createConfigTable(String tableName) {
        this.createTable(tableName, ImmutableList.of(StringUtils.format("CREATE TABLE %1$s (\n  name VARCHAR(255) NOT NULL,\n  payload %2$s NOT NULL,\n  PRIMARY KEY(name)\n)", tableName, this.getPayloadType())));
    }

    public void createEntryTable(String tableName) {
        this.createTable(tableName, ImmutableList.of(StringUtils.format("CREATE TABLE %1$s (\n  id VARCHAR(255) NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  datasource VARCHAR(255) NOT NULL,\n  payload %2$s NOT NULL,\n  status_payload %2$s NOT NULL,\n  active BOOLEAN NOT NULL DEFAULT FALSE,\n  PRIMARY KEY (id)\n)", tableName, this.getPayloadType()), StringUtils.format("CREATE INDEX idx_%1$s_active_created_date ON %1$s(active, created_date)", tableName)));
    }

    public void createLogTable(String tableName, String entryTypeName) {
        this.createTable(tableName, ImmutableList.of(StringUtils.format("CREATE TABLE %1$s (\n  id %2$s NOT NULL,\n  %4$s_id VARCHAR(255) DEFAULT NULL,\n  log_payload %3$s,\n  PRIMARY KEY (id)\n)", tableName, this.getSerialType(), this.getPayloadType(), entryTypeName), StringUtils.format("CREATE INDEX idx_%1$s_%2$s_id ON %1$s(%2$s_id)", tableName, entryTypeName)));
    }

    public void createLockTable(String tableName, String entryTypeName) {
        this.createTable(tableName, ImmutableList.of(StringUtils.format("CREATE TABLE %1$s (\n  id %2$s NOT NULL,\n  %4$s_id VARCHAR(255) DEFAULT NULL,\n  lock_payload %3$s,\n  PRIMARY KEY (id)\n)", tableName, this.getSerialType(), this.getPayloadType(), entryTypeName), StringUtils.format("CREATE INDEX idx_%1$s_%2$s_id ON %1$s(%2$s_id)", tableName, entryTypeName)));
    }

    public void createSupervisorsTable(String tableName) {
        this.createTable(tableName, ImmutableList.of(StringUtils.format("CREATE TABLE %1$s (\n  id %2$s NOT NULL,\n  spec_id VARCHAR(255) NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  payload %3$s NOT NULL,\n  PRIMARY KEY (id)\n)", tableName, this.getSerialType(), this.getPayloadType()), StringUtils.format("CREATE INDEX idx_%1$s_spec_id ON %1$s(spec_id)", tableName)));
    }

    @Override
    public Void insertOrUpdate(final String tableName, final String keyColumn, final String valueColumn, final String key, final byte[] value) throws Exception {
        return this.getDBI().inTransaction(new TransactionCallback<Void>(){

            @Override
            public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                int count = ((Query)handle.createQuery(StringUtils.format("SELECT COUNT(*) FROM %1$s WHERE %2$s = :key", tableName, keyColumn)).bind("key", key)).map(IntegerMapper.FIRST).first();
                if (count == 0) {
                    ((Update)((Update)handle.createStatement(StringUtils.format("INSERT INTO %1$s (%2$s, %3$s) VALUES (:key, :value)", tableName, keyColumn, valueColumn)).bind("key", key)).bind("value", value)).execute();
                } else {
                    ((Update)((Update)handle.createStatement(StringUtils.format("UPDATE %1$s SET %3$s=:value WHERE %2$s=:key", tableName, keyColumn, valueColumn)).bind("key", key)).bind("value", value)).execute();
                }
                return null;
            }
        });
    }

    @Override
    public boolean compareAndSwap(final List<MetadataCASUpdate> updates) throws Exception {
        return this.getDBI().inTransaction(new TransactionCallback<Boolean>(){

            @Override
            public Boolean inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                byte[] currentValue;
                ArrayList<byte[]> currentValues = new ArrayList<byte[]>();
                for (MetadataCASUpdate update : updates) {
                    currentValue = ((Query)handle.createQuery(StringUtils.format("SELECT %1$s FROM %2$s WHERE %3$s = :key", update.getValueColumn(), update.getTableName(), update.getKeyColumn())).bind("key", update.getKey())).map(ByteArrayMapper.FIRST).first();
                    if (!Arrays.equals(currentValue, update.getOldValue())) {
                        return false;
                    }
                    currentValues.add(currentValue);
                }
                for (int i = 0; i < updates.size(); ++i) {
                    MetadataCASUpdate update;
                    update = (MetadataCASUpdate)updates.get(i);
                    currentValue = (byte[])currentValues.get(i);
                    if (currentValue == null) {
                        ((Update)((Update)handle.createStatement(StringUtils.format("INSERT INTO %1$s (%2$s, %3$s) VALUES (:key, :value)", update.getTableName(), update.getKeyColumn(), update.getValueColumn())).bind("key", update.getKey())).bind("value", update.getNewValue())).execute();
                        continue;
                    }
                    ((Update)((Update)handle.createStatement(StringUtils.format("UPDATE %1$s SET %3$s=:value WHERE %2$s=:key", update.getTableName(), update.getKeyColumn(), update.getValueColumn())).bind("key", update.getKey())).bind("value", update.getNewValue())).execute();
                }
                return true;
            }
        });
    }

    public abstract DBI getDBI();

    @Override
    public void createDataSourceTable() {
        if (this.config.get().isCreateTables()) {
            this.createDataSourceTable(this.tablesConfigSupplier.get().getDataSourceTable());
        }
    }

    @Override
    public void createPendingSegmentsTable() {
        if (this.config.get().isCreateTables()) {
            this.createPendingSegmentsTable(this.tablesConfigSupplier.get().getPendingSegmentsTable());
        }
    }

    @Override
    public void createSegmentTable() {
        if (this.config.get().isCreateTables()) {
            this.createSegmentTable(this.tablesConfigSupplier.get().getSegmentsTable());
        }
    }

    @Override
    public void createRulesTable() {
        if (this.config.get().isCreateTables()) {
            this.createRulesTable(this.tablesConfigSupplier.get().getRulesTable());
        }
    }

    @Override
    public void createConfigTable() {
        if (this.config.get().isCreateTables()) {
            this.createConfigTable(this.tablesConfigSupplier.get().getConfigTable());
        }
    }

    @Override
    public void createTaskTables() {
        if (this.config.get().isCreateTables()) {
            MetadataStorageTablesConfig tablesConfig = this.tablesConfigSupplier.get();
            String entryType = tablesConfig.getTaskEntryType();
            this.createEntryTable(tablesConfig.getEntryTable(entryType));
            this.createLogTable(tablesConfig.getLogTable(entryType), entryType);
            this.createLockTable(tablesConfig.getLockTable(entryType), entryType);
        }
    }

    @Override
    public void createSupervisorsTable() {
        if (this.config.get().isCreateTables()) {
            this.createSupervisorsTable(this.tablesConfigSupplier.get().getSupervisorTable());
        }
    }

    @Override
    public byte[] lookup(final String tableName, final String keyColumn, final String valueColumn, final String key) {
        return this.getDBI().withHandle(new HandleCallback<byte[]>(){

            @Override
            public byte[] withHandle(Handle handle) throws Exception {
                return SQLMetadataConnector.this.lookupWithHandle(handle, tableName, keyColumn, valueColumn, key);
            }
        });
    }

    public byte[] lookupWithHandle(Handle handle, String tableName, String keyColumn, String valueColumn, String key) {
        String selectStatement = StringUtils.format("SELECT %s FROM %s WHERE %s = :key", valueColumn, tableName, keyColumn);
        List<byte[]> matched = ((Query)handle.createQuery(selectStatement).bind("key", key)).map(ByteArrayMapper.FIRST).list();
        if (matched.isEmpty()) {
            return null;
        }
        if (matched.size() > 1) {
            throw new ISE("Error! More than one matching entry[%d] found for [%s]?!", matched.size(), key);
        }
        return matched.get(0);
    }

    public MetadataStorageConnectorConfig getConfig() {
        return this.config.get();
    }

    protected BasicDataSource getDatasource() {
        MetadataStorageConnectorConfig connectorConfig = this.getConfig();
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setUsername(connectorConfig.getUser());
        dataSource.setPassword(connectorConfig.getPassword());
        String uri = connectorConfig.getConnectURI();
        dataSource.setUrl(uri);
        dataSource.setValidationQuery(this.getValidationQuery());
        dataSource.setTestOnBorrow(true);
        return dataSource;
    }

    protected final <T> T inReadOnlyTransaction(final TransactionCallback<T> callback) {
        return (T)this.getDBI().withHandle(new HandleCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T withHandle(Handle handle) throws Exception {
                Connection connection = handle.getConnection();
                boolean readOnly = connection.isReadOnly();
                connection.setReadOnly(true);
                try {
                    Object ReturnType = handle.inTransaction(callback);
                    return ReturnType;
                }
                finally {
                    try {
                        connection.setReadOnly(readOnly);
                    }
                    catch (SQLException e) {
                        log.error(e, "Unable to reset connection read-only state", new Object[0]);
                    }
                }
            }
        });
    }

    private void createAuditTable(String tableName) {
        this.createTable(tableName, ImmutableList.of(StringUtils.format("CREATE TABLE %1$s (\n  id %2$s NOT NULL,\n  audit_key VARCHAR(255) NOT NULL,\n  type VARCHAR(255) NOT NULL,\n  author VARCHAR(255) NOT NULL,\n  comment VARCHAR(2048) NOT NULL,\n  created_date VARCHAR(255) NOT NULL,\n  payload %3$s NOT NULL,\n  PRIMARY KEY(id)\n)", tableName, this.getSerialType(), this.getPayloadType()), StringUtils.format("CREATE INDEX idx_%1$s_key_time ON %1$s(audit_key, created_date)", tableName), StringUtils.format("CREATE INDEX idx_%1$s_type_time ON %1$s(type, created_date)", tableName), StringUtils.format("CREATE INDEX idx_%1$s_audit_time ON %1$s(created_date)", tableName)));
    }

    @Override
    public void createAuditTable() {
        if (this.config.get().isCreateTables()) {
            this.createAuditTable(this.tablesConfigSupplier.get().getAuditTable());
        }
    }

    @Override
    public void deleteAllRecords(final String tableName) {
        try {
            this.retryWithHandle(new HandleCallback<Void>(){

                @Override
                public Void withHandle(Handle handle) throws Exception {
                    if (SQLMetadataConnector.this.tableExists(handle, tableName)) {
                        log.info("Deleting all records from table[%s]", tableName);
                        Batch batch = handle.createBatch();
                        batch.add("DELETE FROM " + tableName);
                        batch.execute();
                    } else {
                        log.info("Table[%s] does not exit.", tableName);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.warn(e, "Exception while deleting records from table", new Object[0]);
        }
    }
}

