/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.metadata.EntryExistsException;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageActionHandler;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageActionHandlerTypes;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.skife.jdbi.v2.exceptions.StatementException;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.ByteArrayMapper;

public abstract class SQLMetadataStorageActionHandler<EntryType, StatusType, LogType, LockType>
implements MetadataStorageActionHandler<EntryType, StatusType, LogType, LockType> {
    private static final EmittingLogger log = new EmittingLogger(SQLMetadataStorageActionHandler.class);
    private final SQLMetadataConnector connector;
    private final ObjectMapper jsonMapper;
    private final TypeReference entryType;
    private final TypeReference statusType;
    private final TypeReference logType;
    private final TypeReference lockType;
    private final String entryTypeName;
    private final String entryTable;
    private final String logTable;
    private final String lockTable;

    public SQLMetadataStorageActionHandler(SQLMetadataConnector connector, ObjectMapper jsonMapper, MetadataStorageActionHandlerTypes<EntryType, StatusType, LogType, LockType> types, String entryTypeName, String entryTable, String logTable, String lockTable) {
        this.connector = connector;
        this.jsonMapper = jsonMapper;
        this.entryType = types.getEntryType();
        this.statusType = types.getStatusType();
        this.logType = types.getLogType();
        this.lockType = types.getLockType();
        this.entryTypeName = entryTypeName;
        this.entryTable = entryTable;
        this.logTable = logTable;
        this.lockTable = lockTable;
    }

    protected SQLMetadataConnector getConnector() {
        return this.connector;
    }

    protected ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    protected TypeReference getStatusType() {
        return this.statusType;
    }

    protected String getEntryTable() {
        return this.entryTable;
    }

    @Override
    public void insert(final String id, final DateTime timestamp, final String dataSource, final EntryType entry, final boolean active, final StatusType status) throws EntryExistsException {
        try {
            this.connector.retryWithHandle(new HandleCallback<Void>(){

                @Override
                public Void withHandle(Handle handle) throws Exception {
                    ((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(StringUtils.format("INSERT INTO %s (id, created_date, datasource, payload, active, status_payload) VALUES (:id, :created_date, :datasource, :payload, :active, :status_payload)", SQLMetadataStorageActionHandler.this.entryTable)).bind("id", id)).bind("created_date", timestamp.toString())).bind("datasource", dataSource)).bind("payload", SQLMetadataStorageActionHandler.this.jsonMapper.writeValueAsBytes(entry))).bind("active", active)).bind("status_payload", SQLMetadataStorageActionHandler.this.jsonMapper.writeValueAsBytes(status))).execute();
                    return null;
                }
            }, new Predicate<Throwable>(){

                @Override
                public boolean apply(Throwable e) {
                    boolean isStatementException = e instanceof StatementException || e instanceof CallbackFailedException && e.getCause() instanceof StatementException;
                    return SQLMetadataStorageActionHandler.this.connector.isTransientException(e) && (!isStatementException || !SQLMetadataStorageActionHandler.this.getEntry(id).isPresent());
                }
            });
        }
        catch (Exception e) {
            boolean isStatementException;
            boolean bl = isStatementException = e instanceof StatementException || e instanceof CallbackFailedException && e.getCause() instanceof StatementException;
            if (isStatementException && this.getEntry(id).isPresent()) {
                throw new EntryExistsException(id, e);
            }
            throw Throwables.propagate(e);
        }
    }

    @Override
    public boolean setStatus(final String entryId, final boolean active, final StatusType status) {
        return this.connector.retryWithHandle(new HandleCallback<Boolean>(){

            @Override
            public Boolean withHandle(Handle handle) throws Exception {
                return ((Update)((Update)((Update)handle.createStatement(StringUtils.format("UPDATE %s SET active = :active, status_payload = :status_payload WHERE id = :id AND active = TRUE", SQLMetadataStorageActionHandler.this.entryTable)).bind("id", entryId)).bind("active", active)).bind("status_payload", SQLMetadataStorageActionHandler.this.jsonMapper.writeValueAsBytes(status))).execute() == 1;
            }
        });
    }

    @Override
    public Optional<EntryType> getEntry(final String entryId) {
        return (Optional)this.connector.retryWithHandle(new HandleCallback<Optional<EntryType>>(){

            @Override
            public Optional<EntryType> withHandle(Handle handle) throws Exception {
                byte[] res = ((Query)handle.createQuery(StringUtils.format("SELECT payload FROM %s WHERE id = :id", SQLMetadataStorageActionHandler.this.entryTable)).bind("id", entryId)).map(ByteArrayMapper.FIRST).first();
                return Optional.fromNullable(res == null ? null : (Object)SQLMetadataStorageActionHandler.this.jsonMapper.readValue(res, SQLMetadataStorageActionHandler.this.entryType));
            }
        });
    }

    @Override
    public Optional<StatusType> getStatus(final String entryId) {
        return (Optional)this.connector.retryWithHandle(new HandleCallback<Optional<StatusType>>(){

            @Override
            public Optional<StatusType> withHandle(Handle handle) throws Exception {
                byte[] res = ((Query)handle.createQuery(StringUtils.format("SELECT status_payload FROM %s WHERE id = :id", SQLMetadataStorageActionHandler.this.entryTable)).bind("id", entryId)).map(ByteArrayMapper.FIRST).first();
                return Optional.fromNullable(res == null ? null : (Object)SQLMetadataStorageActionHandler.this.jsonMapper.readValue(res, SQLMetadataStorageActionHandler.this.statusType));
            }
        });
    }

    @Override
    public List<Pair<EntryType, StatusType>> getActiveEntriesWithStatus() {
        return (List)this.connector.retryWithHandle(new HandleCallback<List<Pair<EntryType, StatusType>>>(){

            @Override
            public List<Pair<EntryType, StatusType>> withHandle(Handle handle) throws Exception {
                return handle.createQuery(StringUtils.format("SELECT id, payload, status_payload FROM %s WHERE active = TRUE ORDER BY created_date", SQLMetadataStorageActionHandler.this.entryTable)).map(new ResultSetMapper<Pair<EntryType, StatusType>>(){

                    @Override
                    public Pair<EntryType, StatusType> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return Pair.of(SQLMetadataStorageActionHandler.this.jsonMapper.readValue(r.getBytes("payload"), SQLMetadataStorageActionHandler.this.entryType), SQLMetadataStorageActionHandler.this.jsonMapper.readValue(r.getBytes("status_payload"), SQLMetadataStorageActionHandler.this.statusType));
                        }
                        catch (IOException e) {
                            log.makeAlert(e, "Failed to parse entry payload", new Object[0]).addData("entry", r.getString("id")).emit();
                            throw new SQLException(e);
                        }
                    }
                }).list();
            }
        });
    }

    @Override
    public List<StatusType> getInactiveStatusesSince(DateTime timestamp, @Nullable Integer maxNumStatuses) {
        return this.getConnector().retryWithHandle(handle -> {
            Query<Map<String, Object>> query = this.createInactiveStatusesSinceQuery(handle, timestamp, maxNumStatuses);
            return query.map((index, r, ctx) -> {
                try {
                    return this.getJsonMapper().readValue(r.getBytes("status_payload"), this.getStatusType());
                }
                catch (IOException e) {
                    log.makeAlert(e, "Failed to parse status payload", new Object[0]).addData("entry", r.getString("id")).emit();
                    throw new SQLException(e);
                }
            }).list();
        });
    }

    protected abstract Query<Map<String, Object>> createInactiveStatusesSinceQuery(Handle var1, DateTime var2, @Nullable Integer var3);

    @Override
    @Nullable
    public Pair<DateTime, String> getCreatedDateAndDataSource(String entryId) {
        return this.connector.retryWithHandle(handle -> ((Query)handle.createQuery(StringUtils.format("SELECT created_date, datasource FROM %s WHERE id = :entryId", this.entryTable)).bind("entryId", entryId)).map((index, resultSet, ctx) -> Pair.of(DateTimes.of(resultSet.getString("created_date")), resultSet.getString("datasource"))).first());
    }

    @Override
    public boolean addLock(final String entryId, final LockType lock) {
        return this.connector.retryWithHandle(new HandleCallback<Boolean>(){

            @Override
            public Boolean withHandle(Handle handle) throws Exception {
                return SQLMetadataStorageActionHandler.this.addLock(handle, entryId, lock);
            }
        });
    }

    private boolean addLock(Handle handle, String entryId, LockType lock) throws JsonProcessingException {
        String statement = StringUtils.format("INSERT INTO %1$s (%2$s_id, lock_payload) VALUES (:entryId, :payload)", this.lockTable, this.entryTypeName);
        return ((Update)((Update)handle.createStatement(statement).bind("entryId", entryId)).bind("payload", this.jsonMapper.writeValueAsBytes(lock))).execute() == 1;
    }

    @Override
    public boolean replaceLock(String entryId, long oldLockId, LockType newLock) {
        return this.connector.retryTransaction((handle, transactionStatus) -> {
            int numDeletedRows = this.removeLock(handle, oldLockId);
            if (numDeletedRows != 1) {
                transactionStatus.setRollbackOnly();
                String message = numDeletedRows == 0 ? StringUtils.format("Cannot find lock[%d]", oldLockId) : StringUtils.format("Found multiple locks for lockId[%d]", oldLockId);
                throw new RuntimeException(message);
            }
            return this.addLock(handle, entryId, newLock);
        }, 3, 10);
    }

    @Override
    public void removeLock(final long lockId) {
        this.connector.retryWithHandle(new HandleCallback<Void>(){

            @Override
            public Void withHandle(Handle handle) throws Exception {
                SQLMetadataStorageActionHandler.this.removeLock(handle, lockId);
                return null;
            }
        });
    }

    private int removeLock(Handle handle, long lockId) {
        return ((Update)handle.createStatement(StringUtils.format("DELETE FROM %s WHERE id = :id", this.lockTable)).bind("id", lockId)).execute();
    }

    @Override
    public boolean addLog(final String entryId, final LogType log) {
        return this.connector.retryWithHandle(new HandleCallback<Boolean>(){

            @Override
            public Boolean withHandle(Handle handle) throws Exception {
                return ((Update)((Update)handle.createStatement(StringUtils.format("INSERT INTO %1$s (%2$s_id, log_payload) VALUES (:entryId, :payload)", SQLMetadataStorageActionHandler.this.logTable, SQLMetadataStorageActionHandler.this.entryTypeName)).bind("entryId", entryId)).bind("payload", SQLMetadataStorageActionHandler.this.jsonMapper.writeValueAsBytes(log))).execute() == 1;
            }
        });
    }

    @Override
    public List<LogType> getLogs(final String entryId) {
        return (List)this.connector.retryWithHandle(new HandleCallback<List<LogType>>(){

            @Override
            public List<LogType> withHandle(Handle handle) throws Exception {
                return ((Query)handle.createQuery(StringUtils.format("SELECT log_payload FROM %1$s WHERE %2$s_id = :entryId", SQLMetadataStorageActionHandler.this.logTable, SQLMetadataStorageActionHandler.this.entryTypeName)).bind("entryId", entryId)).map(ByteArrayMapper.FIRST).fold(Lists.newLinkedList(), new Folder3<List<LogType>, byte[]>(){

                    @Override
                    public List<LogType> fold(List<LogType> list, byte[] bytes, FoldController control, StatementContext ctx) throws SQLException {
                        try {
                            list.add(SQLMetadataStorageActionHandler.this.jsonMapper.readValue(bytes, SQLMetadataStorageActionHandler.this.logType));
                            return list;
                        }
                        catch (IOException e) {
                            log.makeAlert(e, "Failed to deserialize log", new Object[0]).addData("entryId", entryId).addData("payload", StringUtils.fromUtf8(bytes)).emit();
                            throw new SQLException(e);
                        }
                    }
                });
            }
        });
    }

    @Override
    public Map<Long, LockType> getLocks(final String entryId) {
        return (Map)this.connector.retryWithHandle(new HandleCallback<Map<Long, LockType>>(){

            @Override
            public Map<Long, LockType> withHandle(Handle handle) throws Exception {
                return ((Query)handle.createQuery(StringUtils.format("SELECT id, lock_payload FROM %1$s WHERE %2$s_id = :entryId", SQLMetadataStorageActionHandler.this.lockTable, SQLMetadataStorageActionHandler.this.entryTypeName)).bind("entryId", entryId)).map(new ResultSetMapper<Pair<Long, LockType>>(){

                    @Override
                    public Pair<Long, LockType> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return Pair.of(r.getLong("id"), SQLMetadataStorageActionHandler.this.jsonMapper.readValue(r.getBytes("lock_payload"), SQLMetadataStorageActionHandler.this.lockType));
                        }
                        catch (IOException e) {
                            log.makeAlert(e, "Failed to deserialize " + SQLMetadataStorageActionHandler.this.lockType.getType(), new Object[0]).addData("id", r.getLong("id")).addData("lockPayload", StringUtils.fromUtf8(r.getBytes("lock_payload"))).emit();
                            throw new SQLException(e);
                        }
                    }
                }).fold(Maps.newLinkedHashMap(), new Folder3<Map<Long, LockType>, Pair<Long, LockType>>(){

                    @Override
                    public Map<Long, LockType> fold(Map<Long, LockType> accumulator, Pair<Long, LockType> lock, FoldController control, StatementContext ctx) throws SQLException {
                        accumulator.put((Long)lock.lhs, (Object)lock.rhs);
                        return accumulator;
                    }
                });
            }
        });
    }

    @Override
    @Nullable
    public Long getLockId(String entryId, LockType lock) {
        return this.getLocks(entryId).entrySet().stream().filter(entry -> entry.getValue().equals(lock)).map(Map.Entry::getKey).findAny().orElse(null);
    }
}

