/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.io.druid.query.GenericQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryMetrics;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;

public class DruidMetrics {
    public static final String DATASOURCE = "dataSource";
    public static final String TYPE = "type";
    public static final String INTERVAL = "interval";
    public static final String ID = "id";
    public static final String TASK_ID = "taskId";
    public static final String STATUS = "status";
    public static final String TASK_TYPE = "taskType";
    public static final String TASK_STATUS = "taskStatus";
    public static final String SERVER = "server";
    public static final String TIER = "tier";

    public static int findNumComplexAggs(List<AggregatorFactory> aggs) {
        int retVal = 0;
        for (AggregatorFactory agg : aggs) {
            if (agg.getTypeName().equals("float") || agg.getTypeName().equals("long") || agg.getTypeName().equals("double")) continue;
            ++retVal;
        }
        return retVal;
    }

    public static <T> QueryMetrics<?> makeRequestMetrics(GenericQueryMetricsFactory queryMetricsFactory, QueryToolChest<T, Query<T>> toolChest, Query<T> query, String remoteAddr) throws JsonProcessingException {
        QueryMetrics<Query<Object>> queryMetrics = toolChest != null ? toolChest.makeMetrics(query) : queryMetricsFactory.makeMetrics(query);
        queryMetrics.context(query);
        queryMetrics.remoteAddress(remoteAddr);
        return queryMetrics;
    }
}

