/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryMetrics;
import org.apache.hive.druid.io.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;

public final class QueryPlus<T> {
    private final Query<T> query;
    private final QueryMetrics<?> queryMetrics;

    public static <T> QueryPlus<T> wrap(Query<T> query) {
        Preconditions.checkNotNull(query);
        return new QueryPlus<T>(query, null);
    }

    private QueryPlus(Query<T> query, QueryMetrics<?> queryMetrics) {
        this.query = query;
        this.queryMetrics = queryMetrics;
    }

    public Query<T> getQuery() {
        return this.query;
    }

    @Nullable
    public QueryMetrics<?> getQueryMetrics() {
        return this.queryMetrics;
    }

    public QueryPlus<T> withQueryMetrics(QueryToolChest<T, ? extends Query<T>> queryToolChest) {
        if (this.queryMetrics != null) {
            return this;
        }
        return new QueryPlus<T>(this.query, queryToolChest.makeMetrics(this.query));
    }

    public QueryPlus<T> withoutThreadUnsafeState() {
        return this.withoutQueryMetrics();
    }

    private QueryPlus<T> withoutQueryMetrics() {
        if (this.queryMetrics == null) {
            return this;
        }
        return new QueryPlus<T>(this.query, null);
    }

    public QueryPlus<T> withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new QueryPlus<T>(this.query.withQuerySegmentSpec(spec), this.queryMetrics);
    }

    public <U> QueryPlus<U> withQuery(Query<U> replacementQuery) {
        return new QueryPlus<U>(replacementQuery, this.queryMetrics);
    }

    public Sequence<T> run(QuerySegmentWalker walker, Map<String, Object> context) {
        return this.query.getRunner(walker).run(this, context);
    }
}

