/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.function.Function;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class Result<T>
implements Comparable<Result<T>> {
    public static String MISSING_SEGMENTS_KEY = "missingSegments";
    private final DateTime timestamp;
    private final T value;

    @JsonCreator
    public Result(@JsonProperty(value="timestamp") DateTime timestamp, @JsonProperty(value="result") T value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    public <U> Result<U> map(Function<? super T, ? extends U> mapper) {
        return new Result<U>(this.timestamp, mapper.apply(this.value));
    }

    @Override
    public int compareTo(Result<T> tResult) {
        return this.timestamp.compareTo((ReadableInstant)tResult.timestamp);
    }

    @JsonProperty
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="result")
    public T getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        if (this.timestamp != null ? !this.timestamp.isEqual((ReadableInstant)result.timestamp) || this.timestamp.getZone().getOffset((ReadableInstant)this.timestamp) != result.timestamp.getZone().getOffset((ReadableInstant)result.timestamp) : result.timestamp != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(result.value) : result.value != null);
    }

    public int hashCode() {
        int result = this.timestamp != null ? this.timestamp.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Result{timestamp=" + this.timestamp + ", value=" + this.value + '}';
    }
}

