/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.java.util.common.guava.MergeSequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.common.guava.Yielder;
import org.apache.hive.druid.io.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.hive.druid.io.druid.java.util.common.guava.YieldingSequenceBase;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.RetryQueryRunnerConfig;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.apache.hive.druid.io.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.hive.druid.io.druid.segment.SegmentMissingException;

public class RetryQueryRunner<T>
implements QueryRunner<T> {
    private static final EmittingLogger log = new EmittingLogger(RetryQueryRunner.class);
    private final QueryRunner<T> baseRunner;
    private final RetryQueryRunnerConfig config;
    private final ObjectMapper jsonMapper;

    public RetryQueryRunner(QueryRunner<T> baseRunner, RetryQueryRunnerConfig config, ObjectMapper jsonMapper) {
        this.baseRunner = baseRunner;
        this.config = config;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public Sequence<T> run(final QueryPlus<T> queryPlus, final Map<String, Object> context) {
        final ArrayList<Sequence<T>> listOfSequences = Lists.newArrayList();
        listOfSequences.add(this.baseRunner.run(queryPlus, context));
        return new YieldingSequenceBase<T>(){

            @Override
            public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                List missingSegments = RetryQueryRunner.this.getMissingSegments(context);
                if (!missingSegments.isEmpty()) {
                    for (int i = 0; i < RetryQueryRunner.this.config.getNumTries(); ++i) {
                        log.info("[%,d] missing segments found. Retry attempt [%,d]", missingSegments.size(), i);
                        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
                        QueryPlus retryQueryPlus = queryPlus.withQuerySegmentSpec(new MultipleSpecificSegmentSpec(missingSegments));
                        Sequence retrySequence = RetryQueryRunner.this.baseRunner.run(retryQueryPlus, context);
                        listOfSequences.add(retrySequence);
                        missingSegments = RetryQueryRunner.this.getMissingSegments(context);
                        if (missingSegments.isEmpty()) break;
                    }
                    List finalMissingSegs = RetryQueryRunner.this.getMissingSegments(context);
                    if (!RetryQueryRunner.this.config.isReturnPartialResults() && !finalMissingSegs.isEmpty()) {
                        throw new SegmentMissingException("No results found for segments[%s]", finalMissingSegs);
                    }
                    return new MergeSequence(queryPlus.getQuery().getResultOrdering(), Sequences.simple(listOfSequences)).toYielder(initValue, accumulator);
                }
                return ((Sequence)Iterables.getOnlyElement(listOfSequences)).toYielder(initValue, accumulator);
            }
        };
    }

    private List<SegmentDescriptor> getMissingSegments(Map<String, Object> context) {
        Object maybeMissingSegments = context.get(Result.MISSING_SEGMENTS_KEY);
        if (maybeMissingSegments == null) {
            return Lists.newArrayList();
        }
        return (List)this.jsonMapper.convertValue(maybeMissingSegments, new TypeReference<List<SegmentDescriptor>>(){});
    }
}

