/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMaxAggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMaxAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMaxBufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;

public class DoubleMaxAggregatorFactory
extends SimpleDoubleAggregatorFactory {
    @JsonCreator
    public DoubleMaxAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="expression") String expression, @JacksonInject ExprMacroTable macroTable) {
        super(macroTable, fieldName, name, expression);
    }

    public DoubleMaxAggregatorFactory(String name, String fieldName) {
        this(name, fieldName, null, ExprMacroTable.nil());
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new DoubleMaxAggregator(this.getDoubleColumnSelector(metricFactory, Double.NEGATIVE_INFINITY));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new DoubleMaxBufferAggregator(this.getDoubleColumnSelector(metricFactory, Double.NEGATIVE_INFINITY));
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return DoubleMaxAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new DoubleMaxAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new DoubleMaxAggregatorFactory(this.name, this.name, null, this.macroTable);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new DoubleMaxAggregatorFactory(this.fieldName, this.fieldName, this.expression, this.macroTable));
    }

    @Override
    public Object finalizeComputation(Object object) {
        return object;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8WithNullToEmpty(this.fieldName);
        byte[] expressionBytes = StringUtils.toUtf8WithNullToEmpty(this.expression);
        return ByteBuffer.allocate(2 + fieldNameBytes.length + expressionBytes.length).put((byte)3).put(fieldNameBytes).put((byte)-1).put(expressionBytes).array();
    }

    public String toString() {
        return "DoubleMaxAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", expression='" + this.expression + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

