/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.BaseLongColumnValueSelector;

public class LongFirstBufferAggregator
implements BufferAggregator {
    private final BaseLongColumnValueSelector timeSelector;
    private final BaseLongColumnValueSelector valueSelector;

    public LongFirstBufferAggregator(BaseLongColumnValueSelector timeSelector, BaseLongColumnValueSelector valueSelector) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, Long.MAX_VALUE);
        buf.putLong(position + 8, 0L);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        long firstTime;
        long time = this.timeSelector.getLong();
        if (time < (firstTime = buf.getLong(position))) {
            buf.putLong(position, time);
            buf.putLong(position + 8, this.valueSelector.getLong());
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return new SerializablePair<Long, Long>(buf.getLong(position), buf.getLong(position + 8));
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return buf.getLong(position + 8);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return buf.getLong(position + 8);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return buf.getLong(position + 8);
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("timeSelector", this.timeSelector);
        inspector.visit("valueSelector", this.valueSelector);
    }
}

