/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.hyperloglog;

import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.hll.HyperLogLogCollector;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.segment.BaseObjectColumnValueSelector;

public class HyperUniquesAggregator
implements Aggregator {
    private final BaseObjectColumnValueSelector selector;
    private HyperLogLogCollector collector;

    public HyperUniquesAggregator(BaseObjectColumnValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public void aggregate() {
        Object object = this.selector.getObject();
        if (object == null) {
            return;
        }
        if (this.collector == null) {
            this.collector = HyperLogLogCollector.makeLatestCollector();
        }
        this.collector.fold((HyperLogLogCollector)object);
    }

    @Override
    @Nullable
    public Object get() {
        if (this.collector == null) {
            return null;
        }
        return HyperLogLogCollector.makeCollectorSharingStorage(this.collector);
    }

    @Override
    public float getFloat() {
        throw new UnsupportedOperationException("HyperUniquesAggregator does not support getFloat()");
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException("HyperUniquesAggregator does not support getLong()");
    }

    @Override
    public double getDouble() {
        throw new UnsupportedOperationException("HyperUniquesAggregator does not support getDouble()");
    }

    public Aggregator clone() {
        return new HyperUniquesAggregator(this.selector);
    }

    @Override
    public void close() {
    }
}

