/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.extraction;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;

@JsonTypeName(value="map")
public class MapLookupExtractor
extends LookupExtractor {
    private final Map<String, String> map;
    private final boolean isOneToOne;

    @JsonCreator
    public MapLookupExtractor(@JsonProperty(value="map") Map<String, String> map, @JsonProperty(value="isOneToOne") boolean isOneToOne) {
        this.map = Preconditions.checkNotNull(map, "map");
        this.isOneToOne = isOneToOne;
    }

    @JsonProperty
    public Map<String, String> getMap() {
        return ImmutableMap.copyOf(this.map);
    }

    @Override
    @Nullable
    public String apply(@NotNull String val) {
        return this.map.get(val);
    }

    @Override
    public List<String> unapply(final String value) {
        return Lists.newArrayList(Maps.filterKeys(this.map, new Predicate<String>(){

            @Override
            public boolean apply(@Nullable String key) {
                return ((String)MapLookupExtractor.this.map.get(key)).equals(Strings.nullToEmpty(value));
            }
        }).keySet());
    }

    @Override
    @JsonProperty(value="isOneToOne")
    public boolean isOneToOne() {
        return this.isOneToOne;
    }

    @Override
    public byte[] getCacheKey() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (!Strings.isNullOrEmpty(key)) {
                    outputStream.write(StringUtils.toUtf8(key));
                }
                outputStream.write(-1);
                if (!Strings.isNullOrEmpty(val)) {
                    outputStream.write(StringUtils.toUtf8(val));
                }
                outputStream.write(-1);
            }
            return outputStream.toByteArray();
        }
        catch (IOException ex) {
            throw Throwables.propagate(ex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapLookupExtractor that = (MapLookupExtractor)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }
}

