/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonValue;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.common.utils.IntArrayUtils;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.granularity.AllGranularity;
import org.apache.hive.druid.io.druid.java.util.common.guava.Accumulator;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.query.ColumnSelectorPlus;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.ColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.RowBasedColumnSelectorFactory;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.ConcurrentGrouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.RowBasedKeySerdeHelper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.SpillingGrouper;
import org.apache.hive.druid.io.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.hive.druid.io.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.hive.druid.io.druid.query.groupby.strategy.GroupByStrategyV2;
import org.apache.hive.druid.io.druid.query.ordering.StringComparator;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.joda.time.DateTime;

public class RowBasedGrouperHelper {
    private static final int ROUGH_OVERHEAD_PER_DICTIONARY_ENTRY = 44;
    private static final int SINGLE_THREAD_CONCURRENCY_HINT = -1;
    private static final int UNKNOWN_THREAD_PRIORITY = -1;
    private static final long UNKNOWN_TIMEOUT = -1L;
    private static final InputRawSupplierColumnSelectorStrategyFactory STRATEGY_FACTORY = new InputRawSupplierColumnSelectorStrategyFactory();

    public static Pair<Grouper<RowBasedKey>, Accumulator<AggregateResult, Row>> createGrouperAccumulatorPair(GroupByQuery query, boolean isInputRaw, Map<String, ValueType> rawInputRowSignature, GroupByQueryConfig config, Supplier<ByteBuffer> bufferSupplier, LimitedTemporaryStorage temporaryStorage, ObjectMapper spillMapper, AggregatorFactory[] aggregatorFactories, int mergeBufferSize) {
        return RowBasedGrouperHelper.createGrouperAccumulatorPair(query, isInputRaw, rawInputRowSignature, config, bufferSupplier, null, -1, temporaryStorage, spillMapper, aggregatorFactories, null, -1, false, -1L, mergeBufferSize);
    }

    public static Pair<Grouper<RowBasedKey>, Accumulator<AggregateResult, Row>> createGrouperAccumulatorPair(GroupByQuery query, boolean isInputRaw, Map<String, ValueType> rawInputRowSignature, GroupByQueryConfig config, Supplier<ByteBuffer> bufferSupplier, Supplier<ResourceHolder<ByteBuffer>> combineBufferSupplier, int concurrencyHint, LimitedTemporaryStorage temporaryStorage, ObjectMapper spillMapper, AggregatorFactory[] aggregatorFactories, @Nullable ListeningExecutorService grouperSorter, int priority, boolean hasQueryTimeout, long queryTimeoutAt, int mergeBufferSize) {
        Grouper<RowBasedKey> grouper;
        Preconditions.checkArgument(concurrencyHint >= 1 || concurrencyHint == -1, "invalid concurrencyHint");
        List<ValueType> valueTypes = DimensionHandlerUtils.getValueTypesFromDimensionSpecs(query.getDimensions());
        GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        boolean includeTimestamp = GroupByStrategyV2.getUniversalTimestamp(query) == null;
        final ThreadLocal columnSelectorRow = new ThreadLocal();
        ColumnSelectorFactory columnSelectorFactory = query.getVirtualColumns().wrap(RowBasedColumnSelectorFactory.create(columnSelectorRow, rawInputRowSignature));
        boolean willApplyLimitPushDown = query.isApplyLimitPushDown();
        DefaultLimitSpec limitSpec = willApplyLimitPushDown ? (DefaultLimitSpec)query.getLimitSpec() : null;
        boolean sortHasNonGroupingFields = false;
        if (willApplyLimitPushDown) {
            sortHasNonGroupingFields = DefaultLimitSpec.sortingOrderHasNonGroupingFields(limitSpec, query.getDimensions());
        }
        RowBasedKeySerdeFactory keySerdeFactory = new RowBasedKeySerdeFactory(includeTimestamp, query.getContextSortByDimsFirst(), query.getDimensions(), querySpecificConfig.getMaxMergingDictionarySize() / (long)(concurrencyHint == -1 ? 1 : concurrencyHint), valueTypes, aggregatorFactories, limitSpec);
        if (concurrencyHint == -1) {
            grouper = new SpillingGrouper<RowBasedKey>(bufferSupplier, keySerdeFactory, columnSelectorFactory, aggregatorFactories, querySpecificConfig.getBufferGrouperMaxSize(), querySpecificConfig.getBufferGrouperMaxLoadFactor(), querySpecificConfig.getBufferGrouperInitialBuckets(), temporaryStorage, spillMapper, true, limitSpec, sortHasNonGroupingFields, mergeBufferSize);
        } else {
            RowBasedKeySerdeFactory combineKeySerdeFactory = new RowBasedKeySerdeFactory(includeTimestamp, query.getContextSortByDimsFirst(), query.getDimensions(), querySpecificConfig.getMaxMergingDictionarySize(), valueTypes, aggregatorFactories, limitSpec);
            grouper = new ConcurrentGrouper<RowBasedKey>(querySpecificConfig, bufferSupplier, combineBufferSupplier, keySerdeFactory, combineKeySerdeFactory, columnSelectorFactory, aggregatorFactories, temporaryStorage, spillMapper, concurrencyHint, limitSpec, sortHasNonGroupingFields, grouperSorter, priority, hasQueryTimeout, queryTimeoutAt);
        }
        final int keySize = includeTimestamp ? query.getDimensions().size() + 1 : query.getDimensions().size();
        final ValueExtractFunction valueExtractFn = RowBasedGrouperHelper.makeValueExtractFunction(query, isInputRaw, includeTimestamp, columnSelectorFactory, valueTypes);
        Accumulator<AggregateResult, Row> accumulator = new Accumulator<AggregateResult, Row>(){

            @Override
            public AggregateResult accumulate(AggregateResult priorResult, Row row) {
                BaseQuery.checkInterrupted();
                if (priorResult != null && !priorResult.isOk()) {
                    return priorResult;
                }
                if (!grouper.isInitialized()) {
                    grouper.init();
                }
                columnSelectorRow.set(row);
                Object[] key = new Comparable[keySize];
                valueExtractFn.apply(row, (Comparable[])key);
                AggregateResult aggregateResult = grouper.aggregate(new RowBasedKey(key));
                columnSelectorRow.set(null);
                return aggregateResult;
            }
        };
        return new Pair<Grouper<RowBasedKey>, Accumulator<AggregateResult, Row>>(grouper, accumulator);
    }

    private static TimestampExtractFunction makeTimestampExtractFunction(final GroupByQuery query, boolean isInputRaw) {
        if (isInputRaw) {
            if (query.getGranularity() instanceof AllGranularity) {
                return new TimestampExtractFunction(){

                    @Override
                    public long apply(Row row) {
                        return query.getIntervals().get(0).getStartMillis();
                    }
                };
            }
            return new TimestampExtractFunction(){

                @Override
                public long apply(Row row) {
                    return query.getGranularity().bucketStart(row.getTimestamp()).getMillis();
                }
            };
        }
        return new TimestampExtractFunction(){

            @Override
            public long apply(Row row) {
                return row.getTimestampFromEpoch();
            }
        };
    }

    private static ValueExtractFunction makeValueExtractFunction(final GroupByQuery query, boolean isInputRaw, boolean includeTimestamp, ColumnSelectorFactory columnSelectorFactory, List<ValueType> valueTypes) {
        final TimestampExtractFunction timestampExtractFn = includeTimestamp ? RowBasedGrouperHelper.makeTimestampExtractFunction(query, isInputRaw) : null;
        final Function[] valueConvertFns = RowBasedGrouperHelper.makeValueConvertFunctions(valueTypes);
        if (isInputRaw) {
            final Supplier[] inputRawSuppliers = RowBasedGrouperHelper.getValueSuppliersForDimensions(columnSelectorFactory, query.getDimensions());
            if (includeTimestamp) {
                return new ValueExtractFunction(){

                    @Override
                    public Comparable[] apply(Row row, Comparable[] key) {
                        key[0] = Long.valueOf(timestampExtractFn.apply(row));
                        for (int i = 1; i < key.length; ++i) {
                            Comparable val = (Comparable)inputRawSuppliers[i - 1].get();
                            key[i] = (Comparable)valueConvertFns[i - 1].apply(val);
                        }
                        return key;
                    }
                };
            }
            return new ValueExtractFunction(){

                @Override
                public Comparable[] apply(Row row, Comparable[] key) {
                    for (int i = 0; i < key.length; ++i) {
                        Comparable val = (Comparable)inputRawSuppliers[i].get();
                        key[i] = (Comparable)valueConvertFns[i].apply(val);
                    }
                    return key;
                }
            };
        }
        if (includeTimestamp) {
            return new ValueExtractFunction(){

                @Override
                public Comparable[] apply(Row row, Comparable[] key) {
                    key[0] = Long.valueOf(timestampExtractFn.apply(row));
                    for (int i = 1; i < key.length; ++i) {
                        Comparable val = (Comparable)row.getRaw(query.getDimensions().get(i - 1).getOutputName());
                        key[i] = (Comparable)valueConvertFns[i - 1].apply(val);
                    }
                    return key;
                }
            };
        }
        return new ValueExtractFunction(){

            @Override
            public Comparable[] apply(Row row, Comparable[] key) {
                for (int i = 0; i < key.length; ++i) {
                    Comparable val = (Comparable)row.getRaw(query.getDimensions().get(i).getOutputName());
                    key[i] = (Comparable)valueConvertFns[i].apply(val);
                }
                return key;
            }
        };
    }

    public static CloseableGrouperIterator<RowBasedKey, Row> makeGrouperIterator(Grouper<RowBasedKey> grouper, final GroupByQuery query, Closeable closeable) {
        final boolean includeTimestamp = GroupByStrategyV2.getUniversalTimestamp(query) == null;
        return new CloseableGrouperIterator<RowBasedKey, Row>(grouper, true, new Function<Grouper.Entry<RowBasedKey>, Row>(){

            @Override
            public Row apply(Grouper.Entry<RowBasedKey> entry) {
                int i;
                int dimStart;
                DateTime timestamp;
                LinkedHashMap<String, Object> theMap = Maps.newLinkedHashMap();
                if (includeTimestamp) {
                    timestamp = query.getGranularity().toDateTime((Long)entry.getKey().getKey()[0]);
                    dimStart = 1;
                } else {
                    timestamp = null;
                    dimStart = 0;
                }
                for (i = dimStart; i < entry.getKey().getKey().length; ++i) {
                    Object dimVal = entry.getKey().getKey()[i];
                    theMap.put(query.getDimensions().get(i - dimStart).getOutputName(), dimVal instanceof String ? Strings.emptyToNull((String)dimVal) : dimVal);
                }
                for (i = 0; i < entry.getValues().length; ++i) {
                    theMap.put(query.getAggregatorSpecs().get(i).getName(), entry.getValues()[i]);
                }
                return new MapBasedRow(timestamp, theMap);
            }
        }, closeable);
    }

    private static Supplier<Comparable>[] getValueSuppliersForDimensions(ColumnSelectorFactory columnSelectorFactory, List<DimensionSpec> dimensions) {
        Supplier[] inputRawSuppliers = new Supplier[dimensions.size()];
        ColumnSelectorPlus<InputRawSupplierColumnSelectorStrategy>[] selectorPluses = DimensionHandlerUtils.createColumnSelectorPluses(STRATEGY_FACTORY, dimensions, columnSelectorFactory);
        for (int i = 0; i < selectorPluses.length; ++i) {
            ColumnSelectorPlus<InputRawSupplierColumnSelectorStrategy> selectorPlus = selectorPluses[i];
            InputRawSupplierColumnSelectorStrategy strategy = selectorPlus.getColumnSelectorStrategy();
            inputRawSuppliers[i] = strategy.makeInputRawSupplier(selectorPlus.getSelector());
        }
        return inputRawSuppliers;
    }

    private static Function<Comparable, Comparable>[] makeValueConvertFunctions(List<ValueType> valueTypes) {
        Function[] functions = new Function[valueTypes.size()];
        block6: for (int i = 0; i < functions.length; ++i) {
            ValueType type = valueTypes.get(i);
            type = type == null ? ValueType.STRING : type;
            switch (type) {
                case STRING: {
                    functions[i] = input -> input == null ? "" : input.toString();
                    continue block6;
                }
                case LONG: {
                    functions[i] = input -> {
                        Long val = DimensionHandlerUtils.convertObjectToLong(input);
                        return Long.valueOf(val == null ? 0L : val);
                    };
                    continue block6;
                }
                case FLOAT: {
                    functions[i] = input -> {
                        Float val = DimensionHandlerUtils.convertObjectToFloat(input);
                        return Float.valueOf(val == null ? 0.0f : val.floatValue());
                    };
                    continue block6;
                }
                case DOUBLE: {
                    functions[i] = input -> {
                        Double val = DimensionHandlerUtils.convertObjectToDouble(input);
                        return Double.valueOf(val == null ? 0.0 : val);
                    };
                    continue block6;
                }
                default: {
                    throw new IAE("invalid type: [%s]", new Object[]{type});
                }
            }
        }
        return functions;
    }

    static long estimateStringKeySize(String key) {
        return (long)key.length() * 2L + 44L;
    }

    private static int compareDimsInBuffersForNullFudgeTimestamp(Grouper.BufferComparator[] serdeHelperComparators, ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
        for (Grouper.BufferComparator comparator : serdeHelperComparators) {
            int cmp = comparator.compare(lhsBuffer, rhsBuffer, lhsPosition + 8, rhsPosition + 8);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static int compareDimsInBuffersForNullFudgeTimestampForPushDown(Grouper.BufferComparator[] serdeHelperComparators, List<Boolean> needsReverses, int dimCount, ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
        for (int i = 0; i < dimCount; ++i) {
            int cmp = needsReverses.get(i) != false ? serdeHelperComparators[i].compare(rhsBuffer, lhsBuffer, rhsPosition + 8, lhsPosition + 8) : serdeHelperComparators[i].compare(lhsBuffer, rhsBuffer, lhsPosition + 8, rhsPosition + 8);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static class RowBasedKeySerde
    implements Grouper.KeySerde<RowBasedKey> {
        private static final int DICTIONARY_INITIAL_CAPACITY = 10000;
        private static final int UNKNOWN_DICTIONARY_ID = -1;
        private final boolean includeTimestamp;
        private final boolean sortByDimsFirst;
        private final List<DimensionSpec> dimensions;
        private final int dimCount;
        private final int keySize;
        private final ByteBuffer keyBuffer;
        private final RowBasedKeySerdeHelper[] serdeHelpers;
        private final Grouper.BufferComparator[] serdeHelperComparators;
        private final DefaultLimitSpec limitSpec;
        private final List<ValueType> valueTypes;
        private final boolean enableRuntimeDictionaryGeneration;
        private final List<String> dictionary;
        private final Object2IntMap<String> reverseDictionary;
        private final long maxDictionarySize;
        private long currentEstimatedSize = 0L;
        private int[] rankOfDictionaryIds = null;

        RowBasedKeySerde(boolean includeTimestamp, boolean sortByDimsFirst, List<DimensionSpec> dimensions, long maxDictionarySize, DefaultLimitSpec limitSpec, List<ValueType> valueTypes, @Nullable List<String> dictionary) {
            this.includeTimestamp = includeTimestamp;
            this.sortByDimsFirst = sortByDimsFirst;
            this.dimensions = dimensions;
            this.dimCount = dimensions.size();
            this.valueTypes = valueTypes;
            this.limitSpec = limitSpec;
            this.enableRuntimeDictionaryGeneration = dictionary == null;
            this.dictionary = this.enableRuntimeDictionaryGeneration ? new ArrayList(10000) : dictionary;
            this.reverseDictionary = this.enableRuntimeDictionaryGeneration ? new Object2IntOpenHashMap<String>(10000) : new Object2IntOpenHashMap(dictionary.size());
            this.reverseDictionary.defaultReturnValue(-1);
            this.maxDictionarySize = maxDictionarySize;
            this.serdeHelpers = this.makeSerdeHelpers(limitSpec != null, this.enableRuntimeDictionaryGeneration);
            this.serdeHelperComparators = new Grouper.BufferComparator[this.serdeHelpers.length];
            Arrays.setAll(this.serdeHelperComparators, i -> this.serdeHelpers[i].getBufferComparator());
            this.keySize = (includeTimestamp ? 8 : 0) + this.getTotalKeySize();
            this.keyBuffer = ByteBuffer.allocate(this.keySize);
            if (!this.enableRuntimeDictionaryGeneration) {
                long initialDictionarySize = dictionary.stream().mapToLong(RowBasedGrouperHelper::estimateStringKeySize).sum();
                Preconditions.checkState(maxDictionarySize >= initialDictionarySize, "Dictionary size[%s] exceeds threshold[%s]", initialDictionarySize, maxDictionarySize);
                for (int i2 = 0; i2 < dictionary.size(); ++i2) {
                    this.reverseDictionary.put((String)dictionary.get(i2), i2);
                }
                this.initializeRankOfDictionaryIds();
            }
        }

        private void initializeRankOfDictionaryIds() {
            int dictionarySize = this.dictionary.size();
            this.rankOfDictionaryIds = IntStream.range(0, dictionarySize).toArray();
            IntArrays.quickSort(this.rankOfDictionaryIds, (i1, i2) -> this.dictionary.get(i1).compareTo(this.dictionary.get(i2)));
            IntArrayUtils.inverse(this.rankOfDictionaryIds);
        }

        @Override
        public int keySize() {
            return this.keySize;
        }

        @Override
        public Class<RowBasedKey> keyClazz() {
            return RowBasedKey.class;
        }

        @Override
        public List<String> getDictionary() {
            return this.dictionary;
        }

        @Override
        public ByteBuffer toByteBuffer(RowBasedKey key) {
            int dimStart;
            this.keyBuffer.rewind();
            if (this.includeTimestamp) {
                this.keyBuffer.putLong((Long)key.getKey()[0]);
                dimStart = 1;
            } else {
                dimStart = 0;
            }
            for (int i = dimStart; i < key.getKey().length; ++i) {
                if (this.serdeHelpers[i - dimStart].putToKeyBuffer(key, i)) continue;
                return null;
            }
            this.keyBuffer.flip();
            return this.keyBuffer;
        }

        @Override
        public RowBasedKey fromByteBuffer(ByteBuffer buffer, int position) {
            int dimStart;
            int dimsPosition;
            Object[] key;
            if (this.includeTimestamp) {
                key = new Comparable[this.dimCount + 1];
                key[0] = Long.valueOf(buffer.getLong(position));
                dimsPosition = position + 8;
                dimStart = 1;
            } else {
                key = new Comparable[this.dimCount];
                dimsPosition = position;
                dimStart = 0;
            }
            for (int i = dimStart; i < key.length; ++i) {
                this.serdeHelpers[i - dimStart].getFromByteBuffer(buffer, dimsPosition, i, (Comparable[])key);
            }
            return new RowBasedKey(key);
        }

        @Override
        public Grouper.BufferComparator bufferComparator() {
            if (this.rankOfDictionaryIds == null) {
                this.initializeRankOfDictionaryIds();
            }
            if (this.includeTimestamp) {
                if (this.sortByDimsFirst) {
                    return new Grouper.BufferComparator(){

                        @Override
                        public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                            int cmp = RowBasedGrouperHelper.compareDimsInBuffersForNullFudgeTimestamp(serdeHelperComparators, lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return Longs.compare(lhsBuffer.getLong(lhsPosition), rhsBuffer.getLong(rhsPosition));
                        }
                    };
                }
                return new Grouper.BufferComparator(){

                    @Override
                    public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                        int timeCompare = Longs.compare(lhsBuffer.getLong(lhsPosition), rhsBuffer.getLong(rhsPosition));
                        if (timeCompare != 0) {
                            return timeCompare;
                        }
                        return RowBasedGrouperHelper.compareDimsInBuffersForNullFudgeTimestamp(serdeHelperComparators, lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                    }
                };
            }
            return new Grouper.BufferComparator(){

                @Override
                public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                    for (int i = 0; i < dimCount; ++i) {
                        int cmp = serdeHelperComparators[i].compare(lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }
            };
        }

        @Override
        public Grouper.BufferComparator bufferComparatorWithAggregators(AggregatorFactory[] aggregatorFactories, int[] aggregatorOffsets) {
            final ArrayList<Boolean> needsReverses = Lists.newArrayList();
            ArrayList<RowBasedKeySerdeHelper> orderByHelpers = new ArrayList<RowBasedKeySerdeHelper>();
            ArrayList<RowBasedKeySerdeHelper> otherDimHelpers = new ArrayList<RowBasedKeySerdeHelper>();
            HashSet<Integer> orderByIndices = new HashSet<Integer>();
            int aggCount = 0;
            for (OrderByColumnSpec orderSpec : this.limitSpec.getColumns()) {
                boolean needsReverse = orderSpec.getDirection() != OrderByColumnSpec.Direction.ASCENDING;
                int dimIndex = OrderByColumnSpec.getDimIndexForOrderBy(orderSpec, this.dimensions);
                if (dimIndex >= 0) {
                    RowBasedKeySerdeHelper serdeHelper = this.serdeHelpers[dimIndex];
                    orderByHelpers.add(serdeHelper);
                    orderByIndices.add(dimIndex);
                    needsReverses.add(needsReverse);
                    continue;
                }
                int aggIndex = OrderByColumnSpec.getAggIndexForOrderBy(orderSpec, Arrays.asList(aggregatorFactories));
                if (aggIndex < 0) continue;
                StringComparator stringComparator = orderSpec.getDimensionComparator();
                String typeName = aggregatorFactories[aggIndex].getTypeName();
                int aggOffset = aggregatorOffsets[aggIndex] - 4;
                ++aggCount;
                ValueType valueType = ValueType.fromString(typeName);
                if (!ValueType.isNumeric(valueType)) {
                    throw new IAE("Cannot order by a non-numeric aggregator[%s]", orderSpec);
                }
                RowBasedKeySerdeHelper serdeHelper = this.makeNumericSerdeHelper(valueType, aggOffset, true, stringComparator);
                orderByHelpers.add(serdeHelper);
                needsReverses.add(needsReverse);
            }
            for (int i2 = 0; i2 < this.dimCount; ++i2) {
                if (orderByIndices.contains(i2)) continue;
                otherDimHelpers.add(this.serdeHelpers[i2]);
                needsReverses.add(false);
            }
            ArrayList<RowBasedKeySerdeHelper> adjustedSerdeHelpers = orderByHelpers;
            adjustedSerdeHelpers.addAll(otherDimHelpers);
            final Grouper.BufferComparator[] adjustedSerdeHelperComparators = new Grouper.BufferComparator[adjustedSerdeHelpers.size()];
            Arrays.setAll(adjustedSerdeHelperComparators, i -> ((RowBasedKeySerdeHelper)adjustedSerdeHelpers.get(i)).getBufferComparator());
            final int fieldCount = this.dimCount + aggCount;
            if (this.includeTimestamp) {
                if (this.sortByDimsFirst) {
                    return new Grouper.BufferComparator(){

                        @Override
                        public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                            int cmp = RowBasedGrouperHelper.compareDimsInBuffersForNullFudgeTimestampForPushDown(adjustedSerdeHelperComparators, needsReverses, fieldCount, lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return Longs.compare(lhsBuffer.getLong(lhsPosition), rhsBuffer.getLong(rhsPosition));
                        }
                    };
                }
                return new Grouper.BufferComparator(){

                    @Override
                    public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                        int timeCompare = Longs.compare(lhsBuffer.getLong(lhsPosition), rhsBuffer.getLong(rhsPosition));
                        if (timeCompare != 0) {
                            return timeCompare;
                        }
                        int cmp = RowBasedGrouperHelper.compareDimsInBuffersForNullFudgeTimestampForPushDown(adjustedSerdeHelperComparators, needsReverses, fieldCount, lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                        return cmp;
                    }
                };
            }
            return new Grouper.BufferComparator(){

                @Override
                public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                    for (int i = 0; i < fieldCount; ++i) {
                        int cmp = (Boolean)needsReverses.get(i) != false ? adjustedSerdeHelperComparators[i].compare(rhsBuffer, lhsBuffer, rhsPosition, lhsPosition) : adjustedSerdeHelperComparators[i].compare(lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }
            };
        }

        @Override
        public void reset() {
            if (this.enableRuntimeDictionaryGeneration) {
                this.dictionary.clear();
                this.reverseDictionary.clear();
                this.rankOfDictionaryIds = null;
                this.currentEstimatedSize = 0L;
            }
        }

        private int getTotalKeySize() {
            int size = 0;
            for (RowBasedKeySerdeHelper helper : this.serdeHelpers) {
                size += helper.getKeyBufferValueSize();
            }
            return size;
        }

        private RowBasedKeySerdeHelper[] makeSerdeHelpers(boolean pushLimitDown, boolean enableRuntimeDictionaryGeneration) {
            ArrayList<RowBasedKeySerdeHelper> helpers = new ArrayList<RowBasedKeySerdeHelper>();
            int keyBufferPosition = 0;
            for (int i = 0; i < this.dimCount; ++i) {
                StringComparator stringComparator;
                if (this.limitSpec != null) {
                    String dimName = this.dimensions.get(i).getOutputName();
                    stringComparator = DefaultLimitSpec.getComparatorForDimName(this.limitSpec, dimName);
                } else {
                    stringComparator = null;
                }
                RowBasedKeySerdeHelper helper = this.makeSerdeHelper(this.valueTypes.get(i), keyBufferPosition, pushLimitDown, stringComparator, enableRuntimeDictionaryGeneration);
                keyBufferPosition += helper.getKeyBufferValueSize();
                helpers.add(helper);
            }
            return helpers.toArray(new RowBasedKeySerdeHelper[helpers.size()]);
        }

        private RowBasedKeySerdeHelper makeSerdeHelper(ValueType valueType, int keyBufferPosition, boolean pushLimitDown, @Nullable StringComparator stringComparator, boolean enableRuntimeDictionaryGeneration) {
            switch (valueType) {
                case STRING: {
                    if (enableRuntimeDictionaryGeneration) {
                        return new DynamicDictionaryStringRowBasedKeySerdeHelper(keyBufferPosition, pushLimitDown, stringComparator);
                    }
                    return new StaticDictionaryStringRowBasedKeySerdeHelper(keyBufferPosition, pushLimitDown, stringComparator);
                }
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    return this.makeNumericSerdeHelper(valueType, keyBufferPosition, pushLimitDown, stringComparator);
                }
            }
            throw new IAE("invalid type: %s", new Object[]{valueType});
        }

        private RowBasedKeySerdeHelper makeNumericSerdeHelper(ValueType valueType, int keyBufferPosition, boolean pushLimitDown, @Nullable StringComparator stringComparator) {
            switch (valueType) {
                case LONG: {
                    return new LongRowBasedKeySerdeHelper(keyBufferPosition, pushLimitDown, stringComparator);
                }
                case FLOAT: {
                    return new FloatRowBasedKeySerdeHelper(keyBufferPosition, pushLimitDown, stringComparator);
                }
                case DOUBLE: {
                    return new DoubleRowBasedKeySerdeHelper(keyBufferPosition, pushLimitDown, stringComparator);
                }
            }
            throw new IAE("invalid type: %s", new Object[]{valueType});
        }

        private static boolean isPrimitiveComparable(boolean pushLimitDown, @Nullable StringComparator stringComparator) {
            return !pushLimitDown || stringComparator == null || stringComparator.equals(StringComparators.NUMERIC);
        }

        private class DoubleRowBasedKeySerdeHelper
        implements RowBasedKeySerdeHelper {
            final int keyBufferPosition;
            final Grouper.BufferComparator bufferComparator;

            DoubleRowBasedKeySerdeHelper(int keyBufferPosition, @Nullable boolean pushLimitDown, StringComparator stringComparator) {
                this.keyBufferPosition = keyBufferPosition;
                this.bufferComparator = RowBasedKeySerde.isPrimitiveComparable(pushLimitDown, stringComparator) ? (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> Double.compare(lhsBuffer.getDouble(lhsPosition + keyBufferPosition), rhsBuffer.getDouble(rhsPosition + keyBufferPosition)) : (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
                    double lhs = lhsBuffer.getDouble(lhsPosition + keyBufferPosition);
                    double rhs = rhsBuffer.getDouble(rhsPosition + keyBufferPosition);
                    return stringComparator.compare(String.valueOf(lhs), String.valueOf(rhs));
                };
            }

            @Override
            public int getKeyBufferValueSize() {
                return 8;
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                RowBasedKeySerde.this.keyBuffer.putDouble((Double)key.getKey()[idx]);
                return true;
            }

            @Override
            public void getFromByteBuffer(ByteBuffer buffer, int initialOffset, int dimValIdx, Comparable[] dimValues) {
                dimValues[dimValIdx] = Double.valueOf(buffer.getDouble(initialOffset + this.keyBufferPosition));
            }

            @Override
            public Grouper.BufferComparator getBufferComparator() {
                return this.bufferComparator;
            }
        }

        private class FloatRowBasedKeySerdeHelper
        implements RowBasedKeySerdeHelper {
            final int keyBufferPosition;
            final Grouper.BufferComparator bufferComparator;

            FloatRowBasedKeySerdeHelper(int keyBufferPosition, @Nullable boolean pushLimitDown, StringComparator stringComparator) {
                this.keyBufferPosition = keyBufferPosition;
                this.bufferComparator = RowBasedKeySerde.isPrimitiveComparable(pushLimitDown, stringComparator) ? (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> Float.compare(lhsBuffer.getFloat(lhsPosition + keyBufferPosition), rhsBuffer.getFloat(rhsPosition + keyBufferPosition)) : (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
                    float lhs = lhsBuffer.getFloat(lhsPosition + keyBufferPosition);
                    float rhs = rhsBuffer.getFloat(rhsPosition + keyBufferPosition);
                    return stringComparator.compare(String.valueOf(lhs), String.valueOf(rhs));
                };
            }

            @Override
            public int getKeyBufferValueSize() {
                return 4;
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                RowBasedKeySerde.this.keyBuffer.putFloat(((Float)key.getKey()[idx]).floatValue());
                return true;
            }

            @Override
            public void getFromByteBuffer(ByteBuffer buffer, int initialOffset, int dimValIdx, Comparable[] dimValues) {
                dimValues[dimValIdx] = Float.valueOf(buffer.getFloat(initialOffset + this.keyBufferPosition));
            }

            @Override
            public Grouper.BufferComparator getBufferComparator() {
                return this.bufferComparator;
            }
        }

        private class LongRowBasedKeySerdeHelper
        implements RowBasedKeySerdeHelper {
            final int keyBufferPosition;
            final Grouper.BufferComparator bufferComparator;

            LongRowBasedKeySerdeHelper(int keyBufferPosition, @Nullable boolean pushLimitDown, StringComparator stringComparator) {
                this.keyBufferPosition = keyBufferPosition;
                this.bufferComparator = RowBasedKeySerde.isPrimitiveComparable(pushLimitDown, stringComparator) ? (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> Longs.compare(lhsBuffer.getLong(lhsPosition + keyBufferPosition), rhsBuffer.getLong(rhsPosition + keyBufferPosition)) : (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
                    long lhs = lhsBuffer.getLong(lhsPosition + keyBufferPosition);
                    long rhs = rhsBuffer.getLong(rhsPosition + keyBufferPosition);
                    return stringComparator.compare(String.valueOf(lhs), String.valueOf(rhs));
                };
            }

            @Override
            public int getKeyBufferValueSize() {
                return 8;
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                RowBasedKeySerde.this.keyBuffer.putLong((Long)key.getKey()[idx]);
                return true;
            }

            @Override
            public void getFromByteBuffer(ByteBuffer buffer, int initialOffset, int dimValIdx, Comparable[] dimValues) {
                dimValues[dimValIdx] = Long.valueOf(buffer.getLong(initialOffset + this.keyBufferPosition));
            }

            @Override
            public Grouper.BufferComparator getBufferComparator() {
                return this.bufferComparator;
            }
        }

        private class StaticDictionaryStringRowBasedKeySerdeHelper
        extends AbstractStringRowBasedKeySerdeHelper {
            StaticDictionaryStringRowBasedKeySerdeHelper(int keyBufferPosition, @Nullable boolean pushLimitDown, StringComparator stringComparator) {
                super(keyBufferPosition, pushLimitDown, stringComparator);
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                String stringKey = (String)key.getKey()[idx];
                int dictIndex = RowBasedKeySerde.this.reverseDictionary.getInt(stringKey);
                if (dictIndex == -1) {
                    throw new ISE("Cannot find key[%s] from dictionary", stringKey);
                }
                RowBasedKeySerde.this.keyBuffer.putInt(dictIndex);
                return true;
            }
        }

        private class DynamicDictionaryStringRowBasedKeySerdeHelper
        extends AbstractStringRowBasedKeySerdeHelper {
            DynamicDictionaryStringRowBasedKeySerdeHelper(int keyBufferPosition, @Nullable boolean pushLimitDown, StringComparator stringComparator) {
                super(keyBufferPosition, pushLimitDown, stringComparator);
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                int id = this.addToDictionary((String)key.getKey()[idx]);
                if (id < 0) {
                    return false;
                }
                RowBasedKeySerde.this.keyBuffer.putInt(id);
                return true;
            }

            private int addToDictionary(String s) {
                int idx = RowBasedKeySerde.this.reverseDictionary.getInt(s);
                if (idx == -1) {
                    long additionalEstimatedSize = RowBasedGrouperHelper.estimateStringKeySize(s);
                    if (RowBasedKeySerde.this.currentEstimatedSize + additionalEstimatedSize > RowBasedKeySerde.this.maxDictionarySize) {
                        return -1;
                    }
                    idx = RowBasedKeySerde.this.dictionary.size();
                    RowBasedKeySerde.this.reverseDictionary.put(s, idx);
                    RowBasedKeySerde.this.dictionary.add(s);
                    RowBasedKeySerde.this.currentEstimatedSize = RowBasedKeySerde.this.currentEstimatedSize + additionalEstimatedSize;
                }
                return idx;
            }
        }

        private abstract class AbstractStringRowBasedKeySerdeHelper
        implements RowBasedKeySerdeHelper {
            final int keyBufferPosition;
            final Grouper.BufferComparator bufferComparator;

            AbstractStringRowBasedKeySerdeHelper(int keyBufferPosition, @Nullable boolean pushLimitDown, StringComparator stringComparator) {
                this.keyBufferPosition = keyBufferPosition;
                if (!pushLimitDown) {
                    this.bufferComparator = (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> Ints.compare(RowBasedKeySerde.this.rankOfDictionaryIds[lhsBuffer.getInt(lhsPosition + keyBufferPosition)], RowBasedKeySerde.this.rankOfDictionaryIds[rhsBuffer.getInt(rhsPosition + keyBufferPosition)]);
                } else {
                    StringComparator realComparator = stringComparator == null ? StringComparators.LEXICOGRAPHIC : stringComparator;
                    this.bufferComparator = (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
                        String lhsStr = (String)RowBasedKeySerde.this.dictionary.get(lhsBuffer.getInt(lhsPosition + keyBufferPosition));
                        String rhsStr = (String)RowBasedKeySerde.this.dictionary.get(rhsBuffer.getInt(rhsPosition + keyBufferPosition));
                        return realComparator.compare(lhsStr, rhsStr);
                    };
                }
            }

            @Override
            public int getKeyBufferValueSize() {
                return 4;
            }

            @Override
            public void getFromByteBuffer(ByteBuffer buffer, int initialOffset, int dimValIdx, Comparable[] dimValues) {
                dimValues[dimValIdx] = (Comparable)RowBasedKeySerde.this.dictionary.get(buffer.getInt(initialOffset + this.keyBufferPosition));
            }

            @Override
            public Grouper.BufferComparator getBufferComparator() {
                return this.bufferComparator;
            }
        }
    }

    private static class RowBasedKeySerdeFactory
    implements Grouper.KeySerdeFactory<RowBasedKey> {
        private final boolean includeTimestamp;
        private final boolean sortByDimsFirst;
        private final int dimCount;
        private final long maxDictionarySize;
        private final DefaultLimitSpec limitSpec;
        private final List<DimensionSpec> dimensions;
        final AggregatorFactory[] aggregatorFactories;
        private final List<ValueType> valueTypes;

        RowBasedKeySerdeFactory(boolean includeTimestamp, boolean sortByDimsFirst, List<DimensionSpec> dimensions, long maxDictionarySize, List<ValueType> valueTypes, AggregatorFactory[] aggregatorFactories, DefaultLimitSpec limitSpec) {
            this.includeTimestamp = includeTimestamp;
            this.sortByDimsFirst = sortByDimsFirst;
            this.dimensions = dimensions;
            this.dimCount = dimensions.size();
            this.maxDictionarySize = maxDictionarySize;
            this.limitSpec = limitSpec;
            this.aggregatorFactories = aggregatorFactories;
            this.valueTypes = valueTypes;
        }

        @Override
        public long getMaxDictionarySize() {
            return this.maxDictionarySize;
        }

        @Override
        public Grouper.KeySerde<RowBasedKey> factorize() {
            return new RowBasedKeySerde(this.includeTimestamp, this.sortByDimsFirst, this.dimensions, this.maxDictionarySize, this.limitSpec, this.valueTypes, null);
        }

        @Override
        public Grouper.KeySerde<RowBasedKey> factorizeWithDictionary(List<String> dictionary) {
            return new RowBasedKeySerde(this.includeTimestamp, this.sortByDimsFirst, this.dimensions, this.maxDictionarySize, this.limitSpec, this.valueTypes, dictionary);
        }

        @Override
        public Comparator<Grouper.Entry<RowBasedKey>> objectComparator(boolean forceDefaultOrder) {
            if (this.limitSpec != null && !forceDefaultOrder) {
                return this.objectComparatorWithAggs();
            }
            if (this.includeTimestamp) {
                if (this.sortByDimsFirst) {
                    return new Comparator<Grouper.Entry<RowBasedKey>>(){

                        @Override
                        public int compare(Grouper.Entry<RowBasedKey> entry1, Grouper.Entry<RowBasedKey> entry2) {
                            int cmp = RowBasedKeySerdeFactory.compareDimsInRows(entry1.getKey(), entry2.getKey(), 1);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return Longs.compare((Long)entry1.getKey().getKey()[0], (Long)entry2.getKey().getKey()[0]);
                        }
                    };
                }
                return new Comparator<Grouper.Entry<RowBasedKey>>(){

                    @Override
                    public int compare(Grouper.Entry<RowBasedKey> entry1, Grouper.Entry<RowBasedKey> entry2) {
                        int timeCompare = Longs.compare((Long)entry1.getKey().getKey()[0], (Long)entry2.getKey().getKey()[0]);
                        if (timeCompare != 0) {
                            return timeCompare;
                        }
                        return RowBasedKeySerdeFactory.compareDimsInRows(entry1.getKey(), entry2.getKey(), 1);
                    }
                };
            }
            return new Comparator<Grouper.Entry<RowBasedKey>>(){

                @Override
                public int compare(Grouper.Entry<RowBasedKey> entry1, Grouper.Entry<RowBasedKey> entry2) {
                    return RowBasedKeySerdeFactory.compareDimsInRows(entry1.getKey(), entry2.getKey(), 0);
                }
            };
        }

        private Comparator<Grouper.Entry<RowBasedKey>> objectComparatorWithAggs() {
            final ArrayList<Boolean> needsReverses = Lists.newArrayList();
            final ArrayList<Boolean> aggFlags = Lists.newArrayList();
            final ArrayList<Boolean> isNumericField = Lists.newArrayList();
            final ArrayList<StringComparator> comparators = Lists.newArrayList();
            final ArrayList<Integer> fieldIndices = Lists.newArrayList();
            HashSet<Integer> orderByIndices = new HashSet<Integer>();
            for (OrderByColumnSpec orderSpec : this.limitSpec.getColumns()) {
                boolean needsReverse = orderSpec.getDirection() != OrderByColumnSpec.Direction.ASCENDING;
                int dimIndex = OrderByColumnSpec.getDimIndexForOrderBy(orderSpec, this.dimensions);
                if (dimIndex >= 0) {
                    fieldIndices.add(dimIndex);
                    orderByIndices.add(dimIndex);
                    needsReverses.add(needsReverse);
                    aggFlags.add(false);
                    ValueType type = this.dimensions.get(dimIndex).getOutputType();
                    isNumericField.add(ValueType.isNumeric(type));
                    comparators.add(orderSpec.getDimensionComparator());
                    continue;
                }
                int aggIndex = OrderByColumnSpec.getAggIndexForOrderBy(orderSpec, Arrays.asList(this.aggregatorFactories));
                if (aggIndex < 0) continue;
                fieldIndices.add(aggIndex);
                needsReverses.add(needsReverse);
                aggFlags.add(true);
                String typeName = this.aggregatorFactories[aggIndex].getTypeName();
                isNumericField.add(ValueType.isNumeric(ValueType.fromString(typeName)));
                comparators.add(orderSpec.getDimensionComparator());
            }
            for (int i = 0; i < this.dimCount; ++i) {
                if (orderByIndices.contains(i)) continue;
                fieldIndices.add(i);
                aggFlags.add(false);
                needsReverses.add(false);
                ValueType type = this.dimensions.get(i).getOutputType();
                isNumericField.add(ValueType.isNumeric(type));
                comparators.add(StringComparators.LEXICOGRAPHIC);
            }
            if (this.includeTimestamp) {
                if (this.sortByDimsFirst) {
                    return new Comparator<Grouper.Entry<RowBasedKey>>(){

                        @Override
                        public int compare(Grouper.Entry<RowBasedKey> entry1, Grouper.Entry<RowBasedKey> entry2) {
                            int cmp = RowBasedKeySerdeFactory.compareDimsInRowsWithAggs(entry1, entry2, 1, needsReverses, aggFlags, fieldIndices, isNumericField, comparators);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return Longs.compare((Long)entry1.getKey().getKey()[0], (Long)entry2.getKey().getKey()[0]);
                        }
                    };
                }
                return new Comparator<Grouper.Entry<RowBasedKey>>(){

                    @Override
                    public int compare(Grouper.Entry<RowBasedKey> entry1, Grouper.Entry<RowBasedKey> entry2) {
                        int timeCompare = Longs.compare((Long)entry1.getKey().getKey()[0], (Long)entry2.getKey().getKey()[0]);
                        if (timeCompare != 0) {
                            return timeCompare;
                        }
                        return RowBasedKeySerdeFactory.compareDimsInRowsWithAggs(entry1, entry2, 1, needsReverses, aggFlags, fieldIndices, isNumericField, comparators);
                    }
                };
            }
            return new Comparator<Grouper.Entry<RowBasedKey>>(){

                @Override
                public int compare(Grouper.Entry<RowBasedKey> entry1, Grouper.Entry<RowBasedKey> entry2) {
                    return RowBasedKeySerdeFactory.compareDimsInRowsWithAggs(entry1, entry2, 0, needsReverses, aggFlags, fieldIndices, isNumericField, comparators);
                }
            };
        }

        private static int compareDimsInRows(RowBasedKey key1, RowBasedKey key2, int dimStart) {
            for (int i = dimStart; i < key1.getKey().length; ++i) {
                int cmp = ((Comparable)key1.getKey()[i]).compareTo(key2.getKey()[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        private static int compareDimsInRowsWithAggs(Grouper.Entry<RowBasedKey> entry1, Grouper.Entry<RowBasedKey> entry2, int dimStart, List<Boolean> needsReverses, List<Boolean> aggFlags, List<Integer> fieldIndices, List<Boolean> isNumericField, List<StringComparator> comparators) {
            for (int i = 0; i < fieldIndices.size(); ++i) {
                Comparable rhs;
                Comparable lhs;
                int fieldIndex = fieldIndices.get(i);
                boolean needsReverse = needsReverses.get(i);
                if (aggFlags.get(i).booleanValue()) {
                    if (needsReverse) {
                        lhs = (Comparable)entry2.getValues()[fieldIndex];
                        rhs = (Comparable)entry1.getValues()[fieldIndex];
                    } else {
                        lhs = (Comparable)entry1.getValues()[fieldIndex];
                        rhs = (Comparable)entry2.getValues()[fieldIndex];
                    }
                } else if (needsReverse) {
                    lhs = (Comparable)entry2.getKey().getKey()[fieldIndex + dimStart];
                    rhs = (Comparable)entry1.getKey().getKey()[fieldIndex + dimStart];
                } else {
                    lhs = (Comparable)entry1.getKey().getKey()[fieldIndex + dimStart];
                    rhs = (Comparable)entry2.getKey().getKey()[fieldIndex + dimStart];
                }
                StringComparator comparator = comparators.get(i);
                int cmp = isNumericField.get(i) != false && comparator.equals(StringComparators.NUMERIC) ? lhs.compareTo(rhs) : comparator.compare(lhs.toString(), rhs.toString());
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }

    private static class InputRawSupplierColumnSelectorStrategyFactory
    implements ColumnSelectorStrategyFactory<InputRawSupplierColumnSelectorStrategy> {
        private InputRawSupplierColumnSelectorStrategyFactory() {
        }

        @Override
        public InputRawSupplierColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
            ValueType type = capabilities.getType();
            switch (type) {
                case STRING: {
                    return new StringInputRawSupplierColumnSelectorStrategy();
                }
                case LONG: {
                    return columnSelector -> columnSelector::getLong;
                }
                case FLOAT: {
                    return columnSelector -> columnSelector::getFloat;
                }
                case DOUBLE: {
                    return columnSelector -> columnSelector::getDouble;
                }
            }
            throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{type});
        }
    }

    private static class StringInputRawSupplierColumnSelectorStrategy
    implements InputRawSupplierColumnSelectorStrategy<DimensionSelector> {
        private StringInputRawSupplierColumnSelectorStrategy() {
        }

        @Override
        public Supplier<Comparable> makeInputRawSupplier(final DimensionSelector selector) {
            return new Supplier<Comparable>(){

                @Override
                public Comparable get() {
                    IndexedInts index = selector.getRow();
                    String value = index.size() == 0 ? "" : selector.lookupName(index.get(0));
                    return Strings.nullToEmpty(value);
                }
            };
        }
    }

    private static interface InputRawSupplierColumnSelectorStrategy<ValueSelectorType>
    extends ColumnSelectorStrategy {
        public Supplier<Comparable> makeInputRawSupplier(ValueSelectorType var1);
    }

    static class RowBasedKey {
        private final Object[] key;

        RowBasedKey(Object[] key) {
            this.key = key;
        }

        @JsonCreator
        public static RowBasedKey fromJsonArray(Object[] key) {
            for (int i = 0; i < key.length; ++i) {
                if (key[i] instanceof Integer) {
                    key[i] = ((Integer)key[i]).longValue();
                    continue;
                }
                if (!(key[i] instanceof Double)) continue;
                key[i] = Float.valueOf(((Double)key[i]).floatValue());
            }
            return new RowBasedKey(key);
        }

        @JsonValue
        public Object[] getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowBasedKey that = (RowBasedKey)o;
            return Arrays.equals(this.key, that.key);
        }

        public int hashCode() {
            return Arrays.hashCode(this.key);
        }

        public String toString() {
            return Arrays.toString(this.key);
        }
    }

    private static interface ValueExtractFunction {
        public Comparable[] apply(Row var1, Comparable[] var2);
    }

    private static interface TimestampExtractFunction {
        public long apply(Row var1);
    }
}

