/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.having;

import java.math.BigDecimal;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hive.druid.com.google.common.primitives.Doubles;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;

class HavingSpecMetricComparator {
    static final Pattern LONG_PAT = Pattern.compile("[-|+]?\\d+");

    HavingSpecMetricComparator() {
    }

    static int compare(Row row, String aggregationName, Number value, Map<String, AggregatorFactory> aggregators) {
        Object metricValueObj = row.getRaw(aggregationName);
        if (metricValueObj != null) {
            if (aggregators != null && aggregators.containsKey(aggregationName)) {
                metricValueObj = aggregators.get(aggregationName).finalizeComputation(metricValueObj);
            }
            if (metricValueObj instanceof Long || metricValueObj instanceof Integer) {
                long n = ((Number)metricValueObj).longValue();
                if (value instanceof Long || value instanceof Integer) {
                    return Longs.compare(n, value.longValue());
                }
                if (value instanceof Double || value instanceof Float) {
                    return -HavingSpecMetricComparator.compareDoubleToLong(value.doubleValue(), n);
                }
                throw new ISE("Number was[%s]?!?", value.getClass().getName());
            }
            if (metricValueObj instanceof Double || metricValueObj instanceof Float) {
                double n = ((Number)metricValueObj).doubleValue();
                if (value instanceof Long || value instanceof Integer) {
                    return HavingSpecMetricComparator.compareDoubleToLong(n, value.longValue());
                }
                if (value instanceof Double || value instanceof Float) {
                    return Doubles.compare(n, value.doubleValue());
                }
                throw new ISE("Number was[%s]?!?", value.getClass().getName());
            }
            if (metricValueObj instanceof String) {
                String metricValueStr = (String)metricValueObj;
                if (LONG_PAT.matcher(metricValueStr).matches()) {
                    long l = Long.parseLong(metricValueStr);
                    return Long.compare(l, value.longValue());
                }
                double d = Double.parseDouble(metricValueStr);
                return Double.compare(d, value.doubleValue());
            }
            throw new ISE("Unknown type of metric value: %s", metricValueObj);
        }
        return Double.compare(0.0, value.doubleValue());
    }

    private static int compareDoubleToLong(double a, long b) {
        return BigDecimal.valueOf(a).compareTo(BigDecimal.valueOf(b));
    }
}

