/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.strategy;

import com.google.inject.Inject;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.strategy.GroupByStrategy;
import org.apache.hive.druid.io.druid.query.groupby.strategy.GroupByStrategyV1;
import org.apache.hive.druid.io.druid.query.groupby.strategy.GroupByStrategyV2;

public class GroupByStrategySelector {
    public static final String STRATEGY_V2 = "v2";
    public static final String STRATEGY_V1 = "v1";
    private final GroupByQueryConfig config;
    private final GroupByStrategyV1 strategyV1;
    private final GroupByStrategyV2 strategyV2;

    @Inject
    public GroupByStrategySelector(Supplier<GroupByQueryConfig> configSupplier, GroupByStrategyV1 strategyV1, GroupByStrategyV2 strategyV2) {
        this.config = configSupplier.get();
        this.strategyV1 = strategyV1;
        this.strategyV2 = strategyV2;
    }

    public GroupByStrategy strategize(GroupByQuery query) {
        String strategyString;
        switch (strategyString = this.config.withOverrides(query).getDefaultStrategy()) {
            case "v2": {
                return this.strategyV2;
            }
            case "v1": {
                return this.strategyV1;
            }
        }
        throw new ISE("No such strategy[%s]", strategyString);
    }
}

