/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.monomorphicprocessing;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.SpecializationState;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;
import sun.misc.Unsafe;

public final class SpecializationService {
    private static final Logger LOG = new Logger(SpecializationService.class);
    private static final Unsafe UNSAFE;
    private static final boolean fakeSpecialize;
    private static final int triggerSpecializationIterationsThreshold;
    private static final int maxSpecializations;
    private static final AtomicBoolean maxSpecializationsWarningEmitted;
    private static final ExecutorService classSpecializationExecutor;
    private static final AtomicLong specializedClassCounter;
    private static final ClassValue<PerPrototypeClassState> perPrototypeClassState;

    public static <T> SpecializationState<T> getSpecializationState(Class<? extends T> prototypeClass, String runtimeShape) {
        return SpecializationService.getSpecializationState(prototypeClass, runtimeShape, ImmutableMap.of());
    }

    public static <T> SpecializationState<T> getSpecializationState(Class<? extends T> prototypeClass, String runtimeShape, ImmutableMap<Class<?>, Class<?>> classRemapping) {
        return perPrototypeClassState.get(prototypeClass).getSpecializationState(runtimeShape, classRemapping);
    }

    private SpecializationService() {
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot access Unsafe methods", e);
        }
        fakeSpecialize = Boolean.getBoolean("fakeSpecialize");
        triggerSpecializationIterationsThreshold = Integer.getInteger("triggerSpecializationIterationsThreshold", 10000);
        maxSpecializations = Integer.getInteger("maxSpecializations", 1000);
        maxSpecializationsWarningEmitted = new AtomicBoolean(false);
        classSpecializationExecutor = Execs.singleThreaded("class-specialization-%d");
        specializedClassCounter = new AtomicLong();
        perPrototypeClassState = new ClassValue<PerPrototypeClassState>(){

            @Override
            protected PerPrototypeClassState computeValue(Class<?> type) {
                return new PerPrototypeClassState(type);
            }
        };
    }

    static class Specialized<T>
    extends SpecializationState<T> {
        private final T specialized;

        Specialized(T specialized) {
            this.specialized = specialized;
        }

        @Override
        public T getSpecialized() {
            return this.specialized;
        }

        @Override
        public void accountLoopIterations(long loopIterations) {
        }
    }

    static class WindowedLoopIterationCounter<T>
    extends SpecializationState<T>
    implements Runnable {
        private final PerPrototypeClassState<T> perPrototypeClassState;
        private final SpecializationId specializationId;
        private final ConcurrentMap<Long, AtomicLong> perMinuteIterations = new ConcurrentHashMap<Long, AtomicLong>();
        private final AtomicBoolean specializationScheduled = new AtomicBoolean(false);

        WindowedLoopIterationCounter(PerPrototypeClassState<T> perPrototypeClassState, SpecializationId specializationId) {
            this.perPrototypeClassState = perPrototypeClassState;
            this.specializationId = specializationId;
        }

        @Override
        @Nullable
        public T getSpecialized() {
            return null;
        }

        @Override
        public void accountLoopIterations(long loopIterations) {
            if (this.specializationScheduled.get()) {
                return;
            }
            if ((loopIterations > (long)triggerSpecializationIterationsThreshold || this.addAndGetTotalIterationsOverTheLastHour(loopIterations) > (long)triggerSpecializationIterationsThreshold) && this.specializationScheduled.compareAndSet(false, true)) {
                classSpecializationExecutor.submit(this);
            }
        }

        private long addAndGetTotalIterationsOverTheLastHour(long newIterations) {
            long currentMillis = System.currentTimeMillis();
            long currentMinute = TimeUnit.MILLISECONDS.toMinutes(currentMillis);
            long minuteOneHourAgo = currentMinute - TimeUnit.HOURS.toMinutes(1L);
            long totalIterations = 0L;
            boolean currentMinutePresent = false;
            Iterator it = this.perMinuteIterations.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry minuteStats = it.next();
                long minute = (Long)minuteStats.getKey();
                if (minute < minuteOneHourAgo) {
                    it.remove();
                    continue;
                }
                if (minute == currentMinute) {
                    totalIterations += ((AtomicLong)minuteStats.getValue()).addAndGet(newIterations);
                    currentMinutePresent = true;
                    continue;
                }
                totalIterations += ((AtomicLong)minuteStats.getValue()).get();
            }
            if (!currentMinutePresent) {
                this.perMinuteIterations.computeIfAbsent(currentMinute, m -> new AtomicLong()).addAndGet(newIterations);
                totalIterations += newIterations;
            }
            return totalIterations;
        }

        @Override
        public void run() {
            try {
                Object specialized;
                if (specializedClassCounter.get() > (long)maxSpecializations) {
                    specialized = ((PerPrototypeClassState)this.perPrototypeClassState).prototypeClass.newInstance();
                    if (!maxSpecializationsWarningEmitted.get() && maxSpecializationsWarningEmitted.compareAndSet(false, true)) {
                        LOG.warn("SpecializationService couldn't make more than [%d] specializations. Not doing specialization for runtime shape[%s] and class remapping[%s], using the prototype class[%s]", maxSpecializations, this.specializationId.runtimeShape, this.specializationId.classRemapping, ((PerPrototypeClassState)this.perPrototypeClassState).prototypeClass);
                    }
                } else if (fakeSpecialize) {
                    specialized = ((PerPrototypeClassState)this.perPrototypeClassState).prototypeClass.newInstance();
                    LOG.info("Not specializing prototype class[%s] for runtime shape[%s] and class remapping[%s] because fakeSpecialize=true, using the prototype class instead", ((PerPrototypeClassState)this.perPrototypeClassState).prototypeClass, this.specializationId.runtimeShape, this.specializationId.classRemapping);
                } else {
                    specialized = this.perPrototypeClassState.specialize(this.specializationId.classRemapping);
                    LOG.info("Specializing prototype class[%s] for runtime shape[%s] and class remapping[%s]", ((PerPrototypeClassState)this.perPrototypeClassState).prototypeClass, this.specializationId.runtimeShape, this.specializationId.classRemapping);
                }
                ((PerPrototypeClassState)this.perPrototypeClassState).specializationStates.put(this.specializationId, new Specialized(specialized));
            }
            catch (Exception e) {
                LOG.error(e, "Error specializing prototype class[%s] for runtime shape[%s] and class remapping[%s]", ((PerPrototypeClassState)this.perPrototypeClassState).prototypeClass, this.specializationId.runtimeShape, this.specializationId.classRemapping);
            }
        }
    }

    private static class SpecializationId {
        private final String runtimeShape;
        private final ImmutableMap<Class<?>, Class<?>> classRemapping;
        private final int hashCode;

        private SpecializationId(String runtimeShape, ImmutableMap<Class<?>, Class<?>> classRemapping) {
            this.runtimeShape = runtimeShape;
            this.classRemapping = classRemapping;
            this.hashCode = runtimeShape.hashCode() * 1000003 + classRemapping.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SpecializationId)) {
                return false;
            }
            SpecializationId other = (SpecializationId)obj;
            return this.runtimeShape.equals(other.runtimeShape) && this.classRemapping.equals(other.classRemapping);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    static class PerPrototypeClassState<T> {
        private final Class<T> prototypeClass;
        private final ConcurrentMap<SpecializationId, SpecializationState<T>> specializationStates = new ConcurrentHashMap<SpecializationId, SpecializationState<T>>();
        private final String prototypeClassBytecodeName;
        private final String specializedClassNamePrefix;
        private byte[] prototypeClassBytecode;

        PerPrototypeClassState(Class<T> prototypeClass) {
            this.prototypeClass = prototypeClass;
            String prototypeClassName = prototypeClass.getName();
            this.prototypeClassBytecodeName = PerPrototypeClassState.classBytecodeName(prototypeClassName);
            this.specializedClassNamePrefix = prototypeClassName + "$Copy";
        }

        SpecializationState<T> getSpecializationState(String runtimeShape, ImmutableMap<Class<?>, Class<?>> classRemapping) {
            SpecializationId specializationId = new SpecializationId(runtimeShape, classRemapping);
            SpecializationState alreadyExistingState = (SpecializationState)this.specializationStates.get(specializationId);
            if (alreadyExistingState != null) {
                return alreadyExistingState;
            }
            return this.specializationStates.computeIfAbsent(specializationId, id -> new WindowedLoopIterationCounter(this, (SpecializationId)id));
        }

        T specialize(ImmutableMap<Class<?>, Class<?>> classRemapping) {
            String specializedClassName = this.specializedClassNamePrefix + specializedClassCounter.get();
            ClassWriter specializedClassWriter = new ClassWriter(0);
            SimpleRemapper remapper = new SimpleRemapper(this.createRemapping(classRemapping, specializedClassName));
            ClassRemapper classTransformer = new ClassRemapper((ClassVisitor)specializedClassWriter, (Remapper)remapper);
            try {
                ClassReader prototypeClassReader = new ClassReader(this.getPrototypeClassBytecode());
                prototypeClassReader.accept((ClassVisitor)classTransformer, 0);
                byte[] specializedClassBytecode = specializedClassWriter.toByteArray();
                Class<T> specializedClass = this.defineClass(specializedClassName, specializedClassBytecode);
                specializedClassCounter.incrementAndGet();
                return specializedClass.newInstance();
            }
            catch (IOException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }

        private HashMap<String, String> createRemapping(ImmutableMap<Class<?>, Class<?>> classRemapping, String specializedClassName) {
            HashMap<String, String> remapping = new HashMap<String, String>();
            remapping.put(this.prototypeClassBytecodeName, PerPrototypeClassState.classBytecodeName(specializedClassName));
            for (Map.Entry classRemappingEntry : classRemapping.entrySet()) {
                Class sourceClass = (Class)classRemappingEntry.getKey();
                Class remappingClass = (Class)classRemappingEntry.getValue();
                remapping.put(PerPrototypeClassState.classBytecodeName(sourceClass.getName()), PerPrototypeClassState.classBytecodeName(remappingClass.getName()));
            }
            return remapping;
        }

        private Class<T> defineClass(String specializedClassName, byte[] specializedClassBytecode) {
            return UNSAFE.defineClass(specializedClassName, specializedClassBytecode, 0, specializedClassBytecode.length, this.prototypeClass.getClassLoader(), this.prototypeClass.getProtectionDomain());
        }

        byte[] getPrototypeClassBytecode() throws IOException {
            if (this.prototypeClassBytecode == null) {
                ClassLoader cl = this.prototypeClass.getClassLoader();
                try (InputStream prototypeClassBytecodeStream = cl.getResourceAsStream(this.prototypeClassBytecodeName + ".class");){
                    this.prototypeClassBytecode = ByteStreams.toByteArray(prototypeClassBytecodeStream);
                }
            }
            return this.prototypeClassBytecode;
        }

        private static String classBytecodeName(String className) {
            return className.replace('.', '/');
        }
    }
}

