/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hive.druid.io.druid.segment.DimensionHandler;
import org.apache.hive.druid.io.druid.segment.DimensionIndexer;
import org.apache.hive.druid.io.druid.segment.DimensionMergerV9;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.LongDimensionIndexer;
import org.apache.hive.druid.io.druid.segment.LongDimensionMergerV9;
import org.apache.hive.druid.io.druid.segment.ProgressIndicator;
import org.apache.hive.druid.io.druid.segment.SegmentValidationException;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.GenericColumn;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMedium;

public class LongDimensionHandler
implements DimensionHandler<Long, Long, Long> {
    private final String dimensionName;

    public LongDimensionHandler(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public DimensionIndexer<Long, Long, Long> makeIndexer() {
        return new LongDimensionIndexer();
    }

    @Override
    public DimensionMergerV9<Long> makeMerger(IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ColumnCapabilities capabilities, ProgressIndicator progress) throws IOException {
        return new LongDimensionMergerV9(this.dimensionName, indexSpec, segmentWriteOutMedium);
    }

    @Override
    public int getLengthOfEncodedKeyComponent(Long dimVals) {
        return 1;
    }

    @Override
    public int compareSortedEncodedKeyComponents(Long lhs, Long rhs) {
        return lhs.compareTo(rhs);
    }

    @Override
    public void validateSortedEncodedKeyComponents(Long lhs, Long rhs, Indexed<Long> lhsEncodings, Indexed<Long> rhsEncodings) throws SegmentValidationException {
        if (!lhs.equals(rhs)) {
            throw new SegmentValidationException("Dim [%s] value not equal. Expected [%s] found [%s]", this.dimensionName, lhs, rhs);
        }
    }

    @Override
    public Closeable getSubColumn(Column column) {
        return column.getGenericColumn();
    }

    @Override
    public Long getEncodedKeyComponentFromColumn(Closeable column, int currRow) {
        return ((GenericColumn)column).getLongSingleValueRow(currRow);
    }
}

