/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.io.Closer;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelectorUtils;
import org.apache.hive.druid.io.druid.segment.NilColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.QueryableIndexStorageAdapter;
import org.apache.hive.druid.io.druid.segment.SingleScanTimeDimSelector;
import org.apache.hive.druid.io.druid.segment.VirtualColumns;
import org.apache.hive.druid.io.druid.segment.column.BaseColumn;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.DictionaryEncodedColumn;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.ReadableOffset;

class QueryableIndexColumnSelectorFactory
implements ColumnSelectorFactory {
    private final QueryableIndex index;
    private final VirtualColumns virtualColumns;
    private final boolean descending;
    private final Closer closer;
    protected final ReadableOffset offset;
    private final Map<String, BaseColumn> columnCache;

    QueryableIndexColumnSelectorFactory(QueryableIndex index, VirtualColumns virtualColumns, boolean descending, Closer closer, ReadableOffset offset, Map<String, BaseColumn> columnCache) {
        this.index = index;
        this.virtualColumns = virtualColumns;
        this.descending = descending;
        this.closer = closer;
        this.offset = offset;
        this.columnCache = columnCache;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        if (this.virtualColumns.exists(dimensionSpec.getDimension())) {
            return this.virtualColumns.makeDimensionSelector(dimensionSpec, this);
        }
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        String dimension = dimensionSpec.getDimension();
        ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        Column columnDesc = this.index.getColumn(dimension);
        if (columnDesc == null) {
            return DimensionSelectorUtils.constantSelector(null, extractionFn);
        }
        if (dimension.equals("__time")) {
            return new SingleScanTimeDimSelector(this.makeColumnValueSelector(dimension), extractionFn, this.descending);
        }
        ValueType type = columnDesc.getCapabilities().getType();
        if (type.isNumeric()) {
            return type.makeNumericWrappingDimensionSelector(this.makeColumnValueSelector(dimension), extractionFn);
        }
        DictionaryEncodedColumn column = (DictionaryEncodedColumn)this.columnCache.computeIfAbsent(dimension, d -> this.closer.register(columnDesc.getDictionaryEncoding()));
        if (column == null) {
            return DimensionSelectorUtils.constantSelector(null, extractionFn);
        }
        return column.makeDimensionSelector(this.offset, extractionFn);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeColumnValueSelector(columnName, this);
        }
        BaseColumn column = this.columnCache.get(columnName);
        if (column == null) {
            Column holder = this.index.getColumn(columnName);
            if (holder != null) {
                ColumnCapabilities capabilities = holder.getCapabilities();
                if (capabilities.isDictionaryEncoded()) {
                    column = holder.getDictionaryEncoding();
                } else if (capabilities.getType() == ValueType.COMPLEX) {
                    column = holder.getComplexColumn();
                } else if (capabilities.getType().isNumeric()) {
                    column = holder.getGenericColumn();
                } else {
                    throw new ISE("Unknown column type: %s", new Object[]{capabilities.getType()});
                }
                this.closer.register(column);
                this.columnCache.put(columnName, column);
            } else {
                return NilColumnValueSelector.instance();
            }
        }
        return column.makeColumnValueSelector(this.offset);
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.getColumnCapabilities(columnName);
        }
        return QueryableIndexStorageAdapter.getColumnCapabilites(this.index, columnName);
    }
}

