/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.common.utils.SerializerUtils;
import org.apache.hive.druid.io.druid.io.Channels;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.java.util.common.io.Closer;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.data.CacheableObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.data.DecompressingByteBufferObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.IndexedIterable;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;
import org.apache.hive.druid.io.druid.segment.serde.MetaSerdeHelper;
import org.apache.hive.druid.io.druid.segment.serde.Serializer;
import org.apache.hive.druid.io.druid.segment.writeout.HeapByteBufferWriteOutBytes;

public class GenericIndexed<T>
implements Indexed<T>,
Serializer {
    static final byte VERSION_ONE = 1;
    static final byte VERSION_TWO = 2;
    static final byte REVERSE_LOOKUP_ALLOWED = 1;
    static final byte REVERSE_LOOKUP_DISALLOWED = 0;
    private static final MetaSerdeHelper<GenericIndexed> metaSerdeHelper = MetaSerdeHelper.firstWriteByte(x -> 1).writeByte(x -> x.allowReverseLookup ? (byte)1 : (byte)0).writeInt(x -> Ints.checkedCast((long)x.theBuffer.remaining() + 4L)).writeInt(x -> x.size);
    private static final SerializerUtils SERIALIZER_UTILS = new SerializerUtils();
    public static final ObjectStrategy<String> STRING_STRATEGY = new CacheableObjectStrategy<String>(){

        @Override
        public Class<? extends String> getClazz() {
            return String.class;
        }

        @Override
        public String fromByteBuffer(ByteBuffer buffer, int numBytes) {
            return StringUtils.fromUtf8(buffer, numBytes);
        }

        @Override
        public byte[] toBytes(String val) {
            if (Strings.isNullOrEmpty(val)) {
                return ByteArrays.EMPTY_ARRAY;
            }
            return StringUtils.toUtf8(val);
        }

        @Override
        public int compare(String o1, String o2) {
            return Comparators.naturalNullsFirst().compare(o1, o2);
        }
    };
    private final boolean versionOne;
    private final ObjectStrategy<T> strategy;
    private final boolean allowReverseLookup;
    private final int size;
    private final ByteBuffer headerBuffer;
    private final ByteBuffer firstValueBuffer;
    private final ByteBuffer[] valueBuffers;
    private int logBaseTwoOfElementsPerValueFile;
    private int relativeIndexMask;
    private final ByteBuffer theBuffer;

    public static <T> GenericIndexed<T> read(ByteBuffer buffer, ObjectStrategy<T> strategy) {
        byte versionFromBuffer = buffer.get();
        if (1 == versionFromBuffer) {
            return GenericIndexed.createGenericIndexedVersionOne(buffer, strategy);
        }
        if (2 == versionFromBuffer) {
            throw new IAE("use read(ByteBuffer buffer, ObjectStrategy<T> strategy, SmooshedFileMapper fileMapper) to read version 2 indexed.", new Object[0]);
        }
        throw new IAE("Unknown version[%d]", versionFromBuffer);
    }

    public static <T> GenericIndexed<T> read(ByteBuffer buffer, ObjectStrategy<T> strategy, SmooshedFileMapper fileMapper) {
        byte versionFromBuffer = buffer.get();
        if (1 == versionFromBuffer) {
            return GenericIndexed.createGenericIndexedVersionOne(buffer, strategy);
        }
        if (2 == versionFromBuffer) {
            return GenericIndexed.createGenericIndexedVersionTwo(buffer, strategy, fileMapper);
        }
        throw new IAE("Unknown version [%s]", versionFromBuffer);
    }

    public static <T> GenericIndexed<T> fromArray(T[] objects, ObjectStrategy<T> strategy) {
        return GenericIndexed.fromIterable(Arrays.asList(objects), strategy);
    }

    static GenericIndexed<ResourceHolder<ByteBuffer>> ofCompressedByteBuffers(Iterable<ByteBuffer> buffers, CompressionStrategy compression, int bufferSize, ByteOrder order, Closer closer) {
        return GenericIndexed.fromIterableVersionOne(buffers, GenericIndexedWriter.compressedByteBuffersWriteObjectStrategy(compression, bufferSize, closer), false, new DecompressingByteBufferObjectStrategy(order, compression));
    }

    public static <T> GenericIndexed<T> fromIterable(Iterable<T> objectsIterable, ObjectStrategy<T> strategy) {
        return GenericIndexed.fromIterableVersionOne(objectsIterable, strategy, true, strategy);
    }

    static int getNumberOfFilesRequired(int bagSize, long numWritten) {
        int numberOfFilesRequired = (int)(numWritten / (long)bagSize);
        if (numWritten % (long)bagSize != 0L) {
            ++numberOfFilesRequired;
        }
        return numberOfFilesRequired;
    }

    GenericIndexed(ByteBuffer buffer, ObjectStrategy<T> strategy, boolean allowReverseLookup) {
        this.versionOne = true;
        this.theBuffer = buffer;
        this.strategy = strategy;
        this.allowReverseLookup = allowReverseLookup;
        this.size = this.theBuffer.getInt();
        int indexOffset = this.theBuffer.position();
        int valuesOffset = this.theBuffer.position() + this.size * 4;
        buffer.position(valuesOffset);
        this.firstValueBuffer = buffer.slice();
        this.valueBuffers = new ByteBuffer[]{this.firstValueBuffer};
        buffer.position(indexOffset);
        this.headerBuffer = buffer.slice();
    }

    GenericIndexed(ByteBuffer[] valueBuffs, ByteBuffer headerBuff, ObjectStrategy<T> strategy, boolean allowReverseLookup, int logBaseTwoOfElementsPerValueFile, int numWritten) {
        this.versionOne = false;
        this.theBuffer = null;
        this.strategy = strategy;
        this.allowReverseLookup = allowReverseLookup;
        this.valueBuffers = valueBuffs;
        this.firstValueBuffer = this.valueBuffers[0];
        this.headerBuffer = headerBuff;
        this.size = numWritten;
        this.logBaseTwoOfElementsPerValueFile = logBaseTwoOfElementsPerValueFile;
        this.relativeIndexMask = (1 << logBaseTwoOfElementsPerValueFile) - 1;
        this.headerBuffer.order(ByteOrder.nativeOrder());
    }

    private void checkIndex(int index) {
        if (index < 0) {
            throw new IAE("Index[%s] < 0", index);
        }
        if (index >= this.size) {
            throw new IAE("Index[%d] >= size[%d]", index, this.size);
        }
    }

    @Override
    public Class<? extends T> getClazz() {
        return this.strategy.getClazz();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T get(int index) {
        return this.versionOne ? this.getVersionOne(index) : this.getVersionTwo(index);
    }

    @Override
    public int indexOf(T value) {
        return this.indexOf(this, value);
    }

    private int indexOf(Indexed<T> indexed, T value) {
        if (!this.allowReverseLookup) {
            throw new UnsupportedOperationException("Reverse lookup not allowed.");
        }
        value = value != null && value.equals("") ? null : value;
        int minIndex = 0;
        int maxIndex = this.size - 1;
        while (minIndex <= maxIndex) {
            int currIndex = minIndex + maxIndex >>> 1;
            T currValue = indexed.get(currIndex);
            int comparison = this.strategy.compare(currValue, value);
            if (comparison == 0) {
                return currIndex;
            }
            if (comparison < 0) {
                minIndex = currIndex + 1;
                continue;
            }
            maxIndex = currIndex - 1;
        }
        return -(minIndex + 1);
    }

    @Override
    public Iterator<T> iterator() {
        return IndexedIterable.create(this).iterator();
    }

    @Override
    public long getSerializedSize() {
        if (!this.versionOne) {
            throw new UnsupportedOperationException("Method not supported for version 2 GenericIndexed.");
        }
        return this.getSerializedSizeVersionOne();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        if (!this.versionOne) {
            throw new UnsupportedOperationException("GenericIndexed serialization for V2 is unsupported. Use GenericIndexedWriter instead.");
        }
        this.writeToVersionOne(channel);
    }

    public BufferIndexed singleThreaded() {
        return this.versionOne ? this.singleThreadedVersionOne() : this.singleThreadedVersionTwo();
    }

    private T copyBufferAndGet(ByteBuffer valueBuffer, int startOffset, int endOffset) {
        int size = endOffset - startOffset;
        if (size == 0) {
            return null;
        }
        ByteBuffer copyValueBuffer = valueBuffer.asReadOnlyBuffer();
        copyValueBuffer.position(startOffset);
        return this.strategy.fromByteBuffer(copyValueBuffer, size);
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("versionOne", this.versionOne);
        inspector.visit("headerBuffer", this.headerBuffer);
        if (this.versionOne) {
            inspector.visit("firstValueBuffer", this.firstValueBuffer);
        } else {
            inspector.visit("valueBuffer", this.valueBuffers.length > 0 ? this.valueBuffers[0] : null);
        }
        inspector.visit("strategy", this.strategy);
    }

    private static <T> GenericIndexed<T> createGenericIndexedVersionOne(ByteBuffer byteBuffer, ObjectStrategy<T> strategy) {
        boolean allowReverseLookup = byteBuffer.get() == 1;
        int size = byteBuffer.getInt();
        ByteBuffer bufferToUse = byteBuffer.asReadOnlyBuffer();
        bufferToUse.limit(bufferToUse.position() + size);
        byteBuffer.position(bufferToUse.limit());
        return new GenericIndexed<T>(bufferToUse, strategy, allowReverseLookup);
    }

    private static <T, U> GenericIndexed<U> fromIterableVersionOne(Iterable<T> objectsIterable, ObjectStrategy<T> strategy, boolean allowReverseLookup, ObjectStrategy<U> resultObjectStrategy) {
        Iterator<T> objects = objectsIterable.iterator();
        if (!objects.hasNext()) {
            ByteBuffer buffer = ByteBuffer.allocate(4).putInt(0);
            buffer.flip();
            return new GenericIndexed<U>(buffer, resultObjectStrategy, allowReverseLookup);
        }
        int count = 0;
        HeapByteBufferWriteOutBytes headerOut = new HeapByteBufferWriteOutBytes();
        HeapByteBufferWriteOutBytes valuesOut = new HeapByteBufferWriteOutBytes();
        try {
            Object prevVal = null;
            do {
                ++count;
                T next = objects.next();
                if (allowReverseLookup && prevVal != null && strategy.compare(prevVal, next) >= 0) {
                    allowReverseLookup = false;
                }
                valuesOut.writeInt(0);
                if (next != null) {
                    strategy.writeTo(next, valuesOut);
                }
                headerOut.writeInt(Ints.checkedCast(valuesOut.size()));
                if (prevVal instanceof Closeable) {
                    CloseQuietly.close((Closeable)prevVal);
                }
                prevVal = next;
            } while (objects.hasNext());
            if (prevVal instanceof Closeable) {
                CloseQuietly.close((Closeable)prevVal);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ByteBuffer theBuffer = ByteBuffer.allocate(Ints.checkedCast(4L + headerOut.size() + valuesOut.size()));
        theBuffer.putInt(count);
        headerOut.writeTo(theBuffer);
        valuesOut.writeTo(theBuffer);
        theBuffer.flip();
        return new GenericIndexed<U>(theBuffer.asReadOnlyBuffer(), resultObjectStrategy, allowReverseLookup);
    }

    private long getSerializedSizeVersionOne() {
        return (long)metaSerdeHelper.size(this) + (long)this.theBuffer.remaining();
    }

    private T getVersionOne(int index) {
        int endOffset;
        int startOffset;
        this.checkIndex(index);
        if (index == 0) {
            startOffset = 4;
            endOffset = this.headerBuffer.getInt(0);
        } else {
            int headerPosition = (index - 1) * 4;
            startOffset = this.headerBuffer.getInt(headerPosition) + 4;
            endOffset = this.headerBuffer.getInt(headerPosition + 4);
        }
        return this.copyBufferAndGet(this.firstValueBuffer, startOffset, endOffset);
    }

    private BufferIndexed singleThreadedVersionOne() {
        final ByteBuffer copyBuffer = this.firstValueBuffer.asReadOnlyBuffer();
        return new BufferIndexed(){

            @Override
            public T get(int index) {
                int endOffset;
                int startOffset;
                GenericIndexed.this.checkIndex(index);
                if (index == 0) {
                    startOffset = 4;
                    endOffset = GenericIndexed.this.headerBuffer.getInt(0);
                } else {
                    int headerPosition = (index - 1) * 4;
                    startOffset = GenericIndexed.this.headerBuffer.getInt(headerPosition) + 4;
                    endOffset = GenericIndexed.this.headerBuffer.getInt(headerPosition + 4);
                }
                return this.bufferedIndexedGet(copyBuffer, startOffset, endOffset);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("headerBuffer", GenericIndexed.this.headerBuffer);
                inspector.visit("copyBuffer", copyBuffer);
                inspector.visit("strategy", GenericIndexed.this.strategy);
            }
        };
    }

    private void writeToVersionOne(WritableByteChannel channel) throws IOException {
        metaSerdeHelper.writeTo(channel, this);
        Channels.writeFully(channel, this.theBuffer.asReadOnlyBuffer());
    }

    private static <T> GenericIndexed<T> createGenericIndexedVersionTwo(ByteBuffer byteBuffer, ObjectStrategy<T> strategy, SmooshedFileMapper fileMapper) {
        if (fileMapper == null) {
            throw new IAE("SmooshedFileMapper can not be null for version 2.", new Object[0]);
        }
        boolean allowReverseLookup = byteBuffer.get() == 1;
        int logBaseTwoOfElementsPerValueFile = byteBuffer.getInt();
        int numElements = byteBuffer.getInt();
        try {
            String columnName = SERIALIZER_UTILS.readString(byteBuffer);
            int elementsPerValueFile = 1 << logBaseTwoOfElementsPerValueFile;
            int numberOfFilesRequired = GenericIndexed.getNumberOfFilesRequired(elementsPerValueFile, numElements);
            ByteBuffer[] valueBuffersToUse = new ByteBuffer[numberOfFilesRequired];
            for (int i = 0; i < numberOfFilesRequired; ++i) {
                ByteBuffer valueBuffer = fileMapper.mapFile(GenericIndexedWriter.generateValueFileName(columnName, i));
                valueBuffersToUse[i] = valueBuffer.asReadOnlyBuffer();
            }
            ByteBuffer headerBuffer = fileMapper.mapFile(GenericIndexedWriter.generateHeaderFileName(columnName));
            return new GenericIndexed<T>(valueBuffersToUse, headerBuffer, strategy, allowReverseLookup, logBaseTwoOfElementsPerValueFile, numElements);
        }
        catch (IOException e) {
            throw new RuntimeException("File mapping failed.", e);
        }
    }

    private T getVersionTwo(int index) {
        int endOffset;
        int startOffset;
        int headerPosition;
        this.checkIndex(index);
        int relativePositionOfIndex = index & this.relativeIndexMask;
        if (relativePositionOfIndex == 0) {
            headerPosition = index * 4;
            startOffset = 4;
            endOffset = this.headerBuffer.getInt(headerPosition);
        } else {
            headerPosition = (index - 1) * 4;
            startOffset = this.headerBuffer.getInt(headerPosition) + 4;
            endOffset = this.headerBuffer.getInt(headerPosition + 4);
        }
        int fileNum = index >> this.logBaseTwoOfElementsPerValueFile;
        return this.copyBufferAndGet(this.valueBuffers[fileNum], startOffset, endOffset);
    }

    private BufferIndexed singleThreadedVersionTwo() {
        final ByteBuffer[] copyValueBuffers = new ByteBuffer[this.valueBuffers.length];
        for (int i = 0; i < this.valueBuffers.length; ++i) {
            copyValueBuffers[i] = this.valueBuffers[i].asReadOnlyBuffer();
        }
        return new BufferIndexed(){

            @Override
            public T get(int index) {
                int endOffset;
                int startOffset;
                int headerPosition;
                GenericIndexed.this.checkIndex(index);
                int relativePositionOfIndex = index & GenericIndexed.this.relativeIndexMask;
                if (relativePositionOfIndex == 0) {
                    headerPosition = index * 4;
                    startOffset = 4;
                    endOffset = GenericIndexed.this.headerBuffer.getInt(headerPosition);
                } else {
                    headerPosition = (index - 1) * 4;
                    startOffset = GenericIndexed.this.headerBuffer.getInt(headerPosition) + 4;
                    endOffset = GenericIndexed.this.headerBuffer.getInt(headerPosition + 4);
                }
                int fileNum = index >> GenericIndexed.this.logBaseTwoOfElementsPerValueFile;
                return this.bufferedIndexedGet(copyValueBuffers[fileNum], startOffset, endOffset);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("headerBuffer", GenericIndexed.this.headerBuffer);
                inspector.visit("copyValueBuffer", copyValueBuffers.length > 0 ? copyValueBuffers[0] : null);
                inspector.visit("strategy", GenericIndexed.this.strategy);
            }
        };
    }

    abstract class BufferIndexed
    implements Indexed<T> {
        int lastReadSize;

        BufferIndexed() {
        }

        @Override
        public Class<? extends T> getClazz() {
            return GenericIndexed.this.strategy.getClazz();
        }

        @Override
        public int size() {
            return GenericIndexed.this.size;
        }

        T bufferedIndexedGet(ByteBuffer copyValueBuffer, int startOffset, int endOffset) {
            int size;
            this.lastReadSize = size = endOffset - startOffset;
            if (size == 0) {
                return null;
            }
            copyValueBuffer.clear();
            copyValueBuffer.position(startOffset);
            return GenericIndexed.this.strategy.fromByteBuffer(copyValueBuffer, size);
        }

        int getLastValueSize() {
            return this.lastReadSize;
        }

        @Override
        public int indexOf(T value) {
            return GenericIndexed.this.indexOf(this, value);
        }

        @Override
        public Iterator<T> iterator() {
            return GenericIndexed.this.iterator();
        }
    }
}

