/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.io.Closer;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;
import org.apache.hive.druid.io.druid.segment.serde.MetaSerdeHelper;
import org.apache.hive.druid.io.druid.segment.serde.Serializer;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.hive.druid.io.druid.segment.writeout.WriteOutBytes;

public class GenericIndexedWriter<T>
implements Serializer {
    private static int PAGE_SIZE = 4096;
    private static final MetaSerdeHelper<GenericIndexedWriter> singleFileMetaSerdeHelper = MetaSerdeHelper.firstWriteByte(x -> 1).writeByte(x -> x.objectsSorted ? (byte)1 : (byte)0).writeInt(x -> Ints.checkedCast(x.headerOut.size() + x.valuesOut.size() + 4L)).writeInt(x -> x.numWritten);
    private static final MetaSerdeHelper<GenericIndexedWriter> multiFileMetaSerdeHelper = MetaSerdeHelper.firstWriteByte(x -> 2).writeByte(x -> x.objectsSorted ? (byte)1 : (byte)0).writeInt(GenericIndexedWriter::bagSizePower).writeInt(x -> x.numWritten).writeInt(x -> x.fileNameByteArray.length).writeByteArray(x -> x.fileNameByteArray);
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final String filenameBase;
    private final ObjectStrategy<T> strategy;
    private final int fileSizeLimit;
    private final byte[] fileNameByteArray;
    private boolean objectsSorted = true;
    private T prevObject = null;
    private WriteOutBytes headerOut = null;
    private WriteOutBytes valuesOut = null;
    private int numWritten = 0;
    private boolean requireMultipleFiles = false;
    private LongList headerOutLong;
    private final ByteBuffer getOffsetBuffer = ByteBuffer.allocate(4);

    static GenericIndexedWriter<ByteBuffer> ofCompressedByteBuffers(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, CompressionStrategy compressionStrategy, int bufferSize) {
        GenericIndexedWriter<ByteBuffer> writer = new GenericIndexedWriter<ByteBuffer>(segmentWriteOutMedium, filenameBase, GenericIndexedWriter.compressedByteBuffersWriteObjectStrategy(compressionStrategy, bufferSize, segmentWriteOutMedium.getCloser()));
        writer.objectsSorted = false;
        return writer;
    }

    static ObjectStrategy<ByteBuffer> compressedByteBuffersWriteObjectStrategy(final CompressionStrategy compressionStrategy, final int bufferSize, final Closer closer) {
        return new ObjectStrategy<ByteBuffer>(){
            private final CompressionStrategy.Compressor compressor;
            private final ByteBuffer compressedDataBuffer;
            {
                this.compressor = compressionStrategy.getCompressor();
                this.compressedDataBuffer = this.compressor.allocateOutBuffer(bufferSize, closer);
            }

            @Override
            public Class<ByteBuffer> getClazz() {
                return ByteBuffer.class;
            }

            @Override
            public ByteBuffer fromByteBuffer(ByteBuffer buffer, int numBytes) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte[] toBytes(ByteBuffer val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void writeTo(ByteBuffer val, WriteOutBytes out) throws IOException {
                this.compressedDataBuffer.clear();
                int valPos = val.position();
                out.write(this.compressor.compress(val, this.compressedDataBuffer));
                val.position(valPos);
            }

            @Override
            public int compare(ByteBuffer o1, ByteBuffer o2) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public GenericIndexedWriter(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ObjectStrategy<T> strategy) {
        this(segmentWriteOutMedium, filenameBase, strategy, Integer.MAX_VALUE & ~PAGE_SIZE);
    }

    public GenericIndexedWriter(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ObjectStrategy<T> strategy, int fileSizeLimit) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.filenameBase = filenameBase;
        this.strategy = strategy;
        this.fileSizeLimit = fileSizeLimit;
        this.fileNameByteArray = StringUtils.toUtf8(filenameBase);
    }

    public static String generateValueFileName(String fileNameBase, int fileNum) {
        return StringUtils.format("%s_value_%d", fileNameBase, fileNum);
    }

    public static String generateHeaderFileName(String fileNameBase) {
        return StringUtils.format("%s_header", fileNameBase);
    }

    private static void writeBytesIntoSmooshedChannel(long numBytesToPutInFile, byte[] buffer, SmooshedWriter smooshChannel, InputStream is) throws IOException {
        ByteBuffer holderBuffer = ByteBuffer.wrap(buffer);
        while (numBytesToPutInFile > 0L) {
            int bytesRead = is.read(buffer, 0, Math.min(buffer.length, Ints.saturatedCast(numBytesToPutInFile)));
            if (bytesRead != -1) {
                smooshChannel.write((ByteBuffer)holderBuffer.clear().limit(bytesRead));
                numBytesToPutInFile -= (long)bytesRead;
                continue;
            }
            throw new ISE("Could not write [%d] bytes into smooshChannel.", numBytesToPutInFile);
        }
    }

    public void open() throws IOException {
        this.headerOut = this.segmentWriteOutMedium.makeWriteOutBytes();
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    public void setObjectsNotSorted() {
        this.objectsSorted = false;
    }

    public void write(T objectToWrite) throws IOException {
        if (this.objectsSorted && this.prevObject != null && this.strategy.compare(this.prevObject, objectToWrite) >= 0) {
            this.objectsSorted = false;
        }
        ++this.numWritten;
        this.valuesOut.writeInt(0);
        if (objectToWrite != null) {
            this.strategy.writeTo(objectToWrite, this.valuesOut);
        }
        if (!this.requireMultipleFiles) {
            this.headerOut.writeInt(Ints.checkedCast(this.valuesOut.size()));
        } else {
            this.headerOutLong.add(this.valuesOut.size());
        }
        if (!this.requireMultipleFiles && this.getSerializedSize() > (long)this.fileSizeLimit) {
            this.requireMultipleFiles = true;
            this.initializeHeaderOutLong();
        }
        if (this.objectsSorted) {
            this.prevObject = objectToWrite;
        }
    }

    @Nullable
    public T get(int index) throws IOException {
        long startOffset = index == 0 ? 4L : this.getOffset(index - 1) + 4L;
        long endOffset = this.getOffset(index);
        int valueSize = Ints.checkedCast(endOffset - startOffset);
        if (valueSize == 0) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.allocate(valueSize);
        this.valuesOut.readFully(startOffset, bb);
        bb.clear();
        return this.strategy.fromByteBuffer(bb, valueSize);
    }

    private long getOffset(int index) throws IOException {
        if (!this.requireMultipleFiles) {
            this.getOffsetBuffer.clear();
            this.headerOut.readFully((long)index * 4L, this.getOffsetBuffer);
            return this.getOffsetBuffer.getInt(0);
        }
        return this.headerOutLong.getLong(index);
    }

    @Override
    public long getSerializedSize() throws IOException {
        if (this.requireMultipleFiles) {
            return multiFileMetaSerdeHelper.size(this);
        }
        return (long)singleFileMetaSerdeHelper.size(this) + this.headerOut.size() + this.valuesOut.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        if (this.requireMultipleFiles) {
            this.writeToMultiFiles(channel, smoosher);
        } else {
            this.writeToSingleFile(channel);
        }
    }

    private void writeToSingleFile(WritableByteChannel channel) throws IOException {
        long numBytesWritten = this.headerOut.size() + this.valuesOut.size();
        Preconditions.checkState(this.headerOut.size() == (long)(this.numWritten * 4), "numWritten[%s] number of rows should have [%s] bytes written to headerOut, had[%s]", this.numWritten, this.numWritten * 4, this.headerOut.size());
        Preconditions.checkState(numBytesWritten < (long)this.fileSizeLimit, "Wrote[%s] bytes, which is too many.", numBytesWritten);
        singleFileMetaSerdeHelper.writeTo(channel, this);
        this.headerOut.writeTo(channel);
        this.valuesOut.writeTo(channel);
    }

    private void writeToMultiFiles(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        Preconditions.checkState(this.headerOutLong.size() == this.numWritten, "numWritten[%s] number of rows doesn't match headerOutLong's size[%s]", this.numWritten, this.headerOutLong.size());
        Preconditions.checkState((long)this.headerOutLong.size() * 8L < (long)(Integer.MAX_VALUE & ~PAGE_SIZE), "Wrote[%s] bytes in header, which is too many.", (long)this.headerOutLong.size() * 8L);
        if (smoosher == null) {
            throw new IAE("version 2 GenericIndexedWriter requires FileSmoosher.", new Object[0]);
        }
        int bagSizePower = this.bagSizePower();
        multiFileMetaSerdeHelper.writeTo(channel, this);
        long previousValuePosition = 0L;
        int bagSize = 1 << bagSizePower;
        int numberOfFilesRequired = GenericIndexed.getNumberOfFilesRequired(bagSize, this.numWritten);
        byte[] buffer = new byte[65536];
        try (InputStream is = this.valuesOut.asInputStream();){
            int counter = -1;
            for (int i = 0; i < numberOfFilesRequired; ++i) {
                long valuePosition;
                if (i != numberOfFilesRequired - 1) {
                    valuePosition = this.headerOutLong.getLong(bagSize + counter);
                    counter += bagSize;
                } else {
                    valuePosition = this.headerOutLong.getLong(this.numWritten - 1);
                }
                long numBytesToPutInFile = valuePosition - previousValuePosition;
                try (SmooshedWriter smooshChannel = smoosher.addWithSmooshedWriter(GenericIndexedWriter.generateValueFileName(this.filenameBase, i), numBytesToPutInFile);){
                    GenericIndexedWriter.writeBytesIntoSmooshedChannel(numBytesToPutInFile, buffer, smooshChannel, is);
                    previousValuePosition = valuePosition;
                    continue;
                }
            }
        }
        this.writeHeaderLong(smoosher, bagSizePower);
    }

    private int bagSizePower() throws IOException {
        long avgObjectSize = (this.valuesOut.size() + (long)this.numWritten - 1L) / (long)this.numWritten;
        for (int i = 31; i >= 0; --i) {
            if ((1L << i) * avgObjectSize > (long)this.fileSizeLimit || !this.actuallyFits(i)) continue;
            return i;
        }
        throw new ISE("no value split found with fileSizeLimit [%d], avgObjectSize [%d]", this.fileSizeLimit, avgObjectSize);
    }

    private boolean actuallyFits(int powerTwo) throws IOException {
        long lastValueOffset = 0L;
        long currentValueOffset = 0L;
        long valueBytesWritten = this.valuesOut.size();
        long headerIndex = 0L;
        long bagSize = 1L << powerTwo;
        while (lastValueOffset < valueBytesWritten) {
            if (headerIndex >= (long)this.numWritten) {
                return true;
            }
            if (headerIndex + bagSize <= (long)this.numWritten) {
                currentValueOffset = this.headerOutLong.getLong(Ints.checkedCast(headerIndex + bagSize - 1L));
            } else if ((long)this.numWritten < headerIndex + bagSize) {
                currentValueOffset = this.headerOutLong.getLong(this.numWritten - 1);
            }
            if (currentValueOffset - lastValueOffset <= (long)this.fileSizeLimit) {
                lastValueOffset = currentValueOffset;
                headerIndex += bagSize;
                continue;
            }
            return false;
        }
        return true;
    }

    private void writeHeaderLong(FileSmoosher smoosher, int bagSizePower) throws IOException {
        ByteBuffer helperBuffer = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());
        int numberOfElementsPerValueFile = 1 << bagSizePower;
        long currentNumBytes = 0L;
        long relativeRefBytes = 0L;
        try (SmooshedWriter smooshChannel = smoosher.addWithSmooshedWriter(GenericIndexedWriter.generateHeaderFileName(this.filenameBase), this.numWritten * 4);){
            for (int pos = 0; pos < this.numWritten; ++pos) {
                if ((pos & numberOfElementsPerValueFile - 1) == 0) {
                    relativeRefBytes = currentNumBytes;
                }
                currentNumBytes = this.headerOutLong.getLong(pos);
                long relativeNumBytes = currentNumBytes - relativeRefBytes;
                helperBuffer.putInt(0, Ints.checkedCast(relativeNumBytes));
                helperBuffer.clear();
                smooshChannel.write(helperBuffer);
            }
        }
    }

    private void initializeHeaderOutLong() throws IOException {
        this.headerOutLong = new LongArrayList();
        DataInputStream headerOutAsIntInput = new DataInputStream(this.headerOut.asInputStream());
        for (int i = 0; i < this.numWritten; ++i) {
            int count = headerOutAsIntInput.readInt();
            this.headerOutLong.add(count);
        }
    }
}

