/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.common.utils.ByteUtils;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.data.SingleValueColumnarIntsSerializer;
import org.apache.hive.druid.io.druid.segment.data.VSizeColumnarInts;
import org.apache.hive.druid.io.druid.segment.serde.MetaSerdeHelper;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.hive.druid.io.druid.segment.writeout.WriteOutBytes;

public class VSizeColumnarIntsSerializer
extends SingleValueColumnarIntsSerializer {
    private static final byte VERSION = 0;
    private static final MetaSerdeHelper<VSizeColumnarIntsSerializer> metaSerdeHelper = MetaSerdeHelper.firstWriteByte(x -> 0).writeByte(x -> ByteUtils.checkedCast(x.numBytes)).writeInt(x -> Ints.checkedCast(x.valuesOut.size()));
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final int numBytes;
    private final ByteBuffer helperBuffer = ByteBuffer.allocate(4);
    private WriteOutBytes valuesOut = null;
    private boolean bufPaddingWritten = false;

    public VSizeColumnarIntsSerializer(SegmentWriteOutMedium segmentWriteOutMedium, int maxValue) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.numBytes = VSizeColumnarInts.getNumBytesForMax(maxValue);
    }

    @Override
    public void open() throws IOException {
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    @Override
    protected void addValue(int val) throws IOException {
        if (this.bufPaddingWritten) {
            throw new IllegalStateException("written out already");
        }
        this.helperBuffer.putInt(0, val);
        this.valuesOut.write(this.helperBuffer.array(), 4 - this.numBytes, this.numBytes);
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.writeBufPadding();
        return (long)metaSerdeHelper.size(this) + this.valuesOut.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeBufPadding();
        metaSerdeHelper.writeTo(channel, this);
        this.valuesOut.writeTo(channel);
    }

    private void writeBufPadding() throws IOException {
        if (!this.bufPaddingWritten) {
            byte[] bufPadding = new byte[4 - this.numBytes];
            this.valuesOut.write(bufPadding);
            this.bufPaddingWritten = true;
        }
    }
}

