/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.tools.FileObject;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.io.druid.java.util.common.CompressionUtils;
import org.apache.hive.druid.io.druid.java.util.common.FileUtils;
import org.apache.hive.druid.io.druid.java.util.common.MapUtils;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.UOE;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentPuller;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.segment.loading.URIDataPuller;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class LocalDataSegmentPuller
implements DataSegmentPuller,
URIDataPuller {
    public static final int DEFAULT_RETRY_COUNT = 3;
    private static final Logger log = new Logger(LocalDataSegmentPuller.class);

    public static FileObject buildFileObject(final URI uri) {
        final Path path = Paths.get(uri);
        final File file = path.toFile();
        return new FileObject(){

            @Override
            public URI toUri() {
                return uri;
            }

            @Override
            public String getName() {
                return path.getFileName().toString();
            }

            @Override
            public InputStream openInputStream() throws IOException {
                return new FileInputStream(file);
            }

            @Override
            public OutputStream openOutputStream() throws IOException {
                return new FileOutputStream(file);
            }

            @Override
            public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
                return Files.newReader(file, Charset.defaultCharset());
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                throw new UOE("CharSequence not supported", new Object[0]);
            }

            @Override
            public Writer openWriter() throws IOException {
                return Files.newWriter(file, Charset.defaultCharset());
            }

            @Override
            public long getLastModified() {
                return file.lastModified();
            }

            @Override
            public boolean delete() {
                return file.delete();
            }
        };
    }

    @Override
    public void getSegmentFiles(DataSegment segment, File dir) throws SegmentLoadingException {
        this.getSegmentFiles(this.getFile(segment), dir);
    }

    public FileUtils.FileCopyResult getSegmentFiles(File sourceFile, File dir) throws SegmentLoadingException {
        if (sourceFile.isDirectory()) {
            if (sourceFile.equals(dir)) {
                log.info("Asked to load [%s] into itself, done!", dir);
                return new FileUtils.FileCopyResult(sourceFile);
            }
            File[] files = sourceFile.listFiles();
            if (files == null) {
                throw new SegmentLoadingException("No files found in [%s]", sourceFile.getAbsolutePath());
            }
            FileUtils.FileCopyResult result = new FileUtils.FileCopyResult(sourceFile);
            for (File oldFile : files) {
                if (oldFile.isDirectory()) {
                    log.info("[%s] is a child directory, skipping", oldFile.getAbsolutePath());
                    continue;
                }
                result.addFiles(FileUtils.retryCopy(Files.asByteSource(oldFile), new File(dir, oldFile.getName()), this.shouldRetryPredicate(), 3).getFiles());
            }
            log.info("Coppied %d bytes from [%s] to [%s]", result.size(), sourceFile.getAbsolutePath(), dir.getAbsolutePath());
            return result;
        }
        if (CompressionUtils.isZip(sourceFile.getName())) {
            try {
                FileUtils.FileCopyResult result = CompressionUtils.unzip(Files.asByteSource(sourceFile), dir, this.shouldRetryPredicate(), false);
                log.info("Unzipped %d bytes from [%s] to [%s]", result.size(), sourceFile.getAbsolutePath(), dir.getAbsolutePath());
                return result;
            }
            catch (IOException e) {
                throw new SegmentLoadingException(e, "Unable to unzip file [%s]", sourceFile.getAbsolutePath());
            }
        }
        if (CompressionUtils.isGz(sourceFile.getName())) {
            File outFile = new File(dir, CompressionUtils.getGzBaseName(sourceFile.getName()));
            FileUtils.FileCopyResult result = CompressionUtils.gunzip(Files.asByteSource(sourceFile), outFile, this.shouldRetryPredicate());
            log.info("Gunzipped %d bytes from [%s] to [%s]", result.size(), sourceFile.getAbsolutePath(), outFile.getAbsolutePath());
            return result;
        }
        throw new SegmentLoadingException("Do not know how to handle source [%s]", sourceFile.getAbsolutePath());
    }

    @Override
    public InputStream getInputStream(URI uri) throws IOException {
        return LocalDataSegmentPuller.buildFileObject(uri).openInputStream();
    }

    @Override
    public String getVersion(URI uri) {
        return StringUtils.format("%d", LocalDataSegmentPuller.buildFileObject(uri).getLastModified());
    }

    @Override
    public Predicate<Throwable> shouldRetryPredicate() {
        return new Predicate<Throwable>(){

            @Override
            public boolean apply(Throwable input) {
                return !(input instanceof InterruptedException) && !(input instanceof CancellationException) && input instanceof Exception;
            }
        };
    }

    private File getFile(DataSegment segment) throws SegmentLoadingException {
        Map<String, Object> loadSpec = segment.getLoadSpec();
        File path = new File(MapUtils.getString(loadSpec, "path"));
        if (!path.exists()) {
            throw new SegmentLoadingException("Asked to load path[%s], but it doesn't exist.", path);
        }
        return path;
    }
}

