/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.io.druid.segment.ReferenceCountingSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.joda.time.Interval;

public class FireHydrant {
    private final int count;
    private final AtomicReference<ReferenceCountingSegment> adapter;
    private volatile IncrementalIndex index;

    public FireHydrant(IncrementalIndex index, int count, String segmentIdentifier) {
        this.index = index;
        this.adapter = new AtomicReference<ReferenceCountingSegment>(new ReferenceCountingSegment(new IncrementalIndexSegment(index, segmentIdentifier)));
        this.count = count;
    }

    public FireHydrant(Segment adapter, int count) {
        this.index = null;
        this.adapter = new AtomicReference<ReferenceCountingSegment>(new ReferenceCountingSegment(adapter));
        this.count = count;
    }

    public IncrementalIndex getIndex() {
        return this.index;
    }

    public String getSegmentIdentifier() {
        return this.adapter.get().getIdentifier();
    }

    public Interval getSegmentDataInterval() {
        return this.adapter.get().getDataInterval();
    }

    public ReferenceCountingSegment getIncrementedSegment() {
        ReferenceCountingSegment segment = this.adapter.get();
        while (!segment.increment()) {
            ReferenceCountingSegment newSegment = this.adapter.get();
            if (segment == newSegment) {
                throw new ISE("segment.close() is called somewhere outside FireHydrant.swapSegment()", new Object[0]);
            }
            if (newSegment == null) {
                throw new ISE("FireHydrant was 'closed' by swapping segment to null while acquiring a segment", new Object[0]);
            }
            segment = newSegment;
        }
        return segment;
    }

    public int getCount() {
        return this.count;
    }

    public boolean hasSwapped() {
        return this.index == null;
    }

    public void swapSegment(@Nullable Segment newSegment) {
        ReferenceCountingSegment newReferenceCountingSegment;
        ReferenceCountingSegment currentSegment;
        do {
            if ((currentSegment = this.adapter.get()) == null && newSegment == null) {
                return;
            }
            if (currentSegment != null && newSegment != null && !newSegment.getIdentifier().equals(currentSegment.getIdentifier())) {
                throw new ISE("WTF?! Cannot swap identifier[%s] -> [%s]!", currentSegment.getIdentifier(), newSegment.getIdentifier());
            }
            if (currentSegment != newSegment) continue;
            throw new ISE("Cannot swap to the same segment", new Object[0]);
        } while (!this.adapter.compareAndSet(currentSegment, newReferenceCountingSegment = newSegment != null ? new ReferenceCountingSegment(newSegment) : null));
        if (currentSegment != null) {
            currentSegment.close();
        }
        this.index = null;
    }

    public Pair<Segment, Closeable> getAndIncrementSegment() {
        ReferenceCountingSegment segment = this.getIncrementedSegment();
        return new Pair<Segment, Closeable>(segment, segment.decrementOnceCloseable());
    }

    public String toString() {
        return "FireHydrant{index=" + this.index + ", queryable=" + this.adapter.get().getIdentifier() + ", count=" + this.count + '}';
    }
}

