/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.appenderator;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.Appenderator;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorDriverAddResult;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.BaseAppenderatorDriver;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentIdentifier;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentWithState;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.TransactionalSegmentPublisher;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.UsedSegmentChecker;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class BatchAppenderatorDriver
extends BaseAppenderatorDriver {
    public BatchAppenderatorDriver(Appenderator appenderator, SegmentAllocator segmentAllocator, UsedSegmentChecker usedSegmentChecker) {
        super(appenderator, segmentAllocator, usedSegmentChecker);
    }

    @Override
    @Nullable
    public Object startJob() {
        Object metadata = this.appenderator.startJob();
        if (metadata != null) {
            throw new ISE("Metadata should be null because BatchAppenderatorDriver never persists it", new Object[0]);
        }
        return null;
    }

    public AppenderatorDriverAddResult add(InputRow row, String sequenceName) throws IOException {
        return this.append(row, sequenceName, null, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentsAndMetadata pushAllAndClear(long pushAndClearTimeoutMs) throws InterruptedException, ExecutionException, TimeoutException {
        ImmutableList<String> sequences;
        Map map = this.segments;
        synchronized (map) {
            sequences = ImmutableList.copyOf(this.segments.keySet());
        }
        return this.pushAndClear(sequences, pushAndClearTimeoutMs);
    }

    private SegmentsAndMetadata pushAndClear(Collection<String> sequenceNames, long pushAndClearTimeoutMs) throws InterruptedException, ExecutionException, TimeoutException {
        List<SegmentIdentifier> segmentIdentifierList = this.getSegmentWithStates(sequenceNames).filter(segmentWithState -> segmentWithState.getState() == SegmentWithState.SegmentState.APPENDING).map(SegmentWithState::getSegmentIdentifier).collect(Collectors.toList());
        ListenableFuture future = Futures.transform(this.pushInBackground(null, segmentIdentifierList), this::dropInBackground);
        SegmentsAndMetadata segmentsAndMetadata = pushAndClearTimeoutMs == 0L ? (SegmentsAndMetadata)future.get() : (SegmentsAndMetadata)future.get(pushAndClearTimeoutMs, TimeUnit.MILLISECONDS);
        Map<SegmentIdentifier, DataSegment> pushedSegmentIdToSegmentMap = segmentsAndMetadata.getSegments().stream().collect(Collectors.toMap(SegmentIdentifier::fromDataSegment, dataSegment -> dataSegment));
        Map<SegmentIdentifier, SegmentWithState> requestedSegmentIdsForSequences = this.getSegmentWithStates(sequenceNames).filter(segmentWithState -> segmentWithState.getState() == SegmentWithState.SegmentState.APPENDING).collect(Collectors.toMap(SegmentWithState::getSegmentIdentifier, segmentWithState -> segmentWithState));
        if (!pushedSegmentIdToSegmentMap.keySet().equals(requestedSegmentIdsForSequences.keySet())) {
            throw new ISE("Pushed segments[%s] are different from the requested ones[%s]", pushedSegmentIdToSegmentMap.keySet(), requestedSegmentIdsForSequences.keySet());
        }
        requestedSegmentIdsForSequences.forEach((segmentId, segmentWithState) -> segmentWithState.pushAndDrop((DataSegment)pushedSegmentIdToSegmentMap.get(segmentId)));
        return segmentsAndMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<SegmentsAndMetadata> publishAll(TransactionalSegmentPublisher publisher) {
        ImmutableMap snapshot;
        Map map = this.segments;
        synchronized (map) {
            snapshot = ImmutableMap.copyOf(this.segments);
        }
        return this.publishInBackground(new SegmentsAndMetadata(snapshot.values().stream().flatMap(BaseAppenderatorDriver.SegmentsForSequence::segmentStateStream).map(segmentWithState -> Preconditions.checkNotNull(segmentWithState.getDataSegment(), "dataSegment for segmentId[%s]", segmentWithState.getSegmentIdentifier())).collect(Collectors.toList()), null), publisher);
    }
}

