/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.serde;

import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.segment.column.BitmapIndex;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;

public class BitmapIndexColumnPartSupplier
implements Supplier<BitmapIndex> {
    private final BitmapFactory bitmapFactory;
    private final GenericIndexed<ImmutableBitmap> bitmaps;
    private final GenericIndexed<String> dictionary;

    public BitmapIndexColumnPartSupplier(BitmapFactory bitmapFactory, GenericIndexed<ImmutableBitmap> bitmaps, GenericIndexed<String> dictionary) {
        this.bitmapFactory = bitmapFactory;
        this.bitmaps = bitmaps;
        this.dictionary = dictionary;
    }

    @Override
    public BitmapIndex get() {
        return new BitmapIndex(){

            @Override
            public int getCardinality() {
                return BitmapIndexColumnPartSupplier.this.dictionary.size();
            }

            @Override
            public String getValue(int index) {
                return (String)BitmapIndexColumnPartSupplier.this.dictionary.get(index);
            }

            @Override
            public boolean hasNulls() {
                return BitmapIndexColumnPartSupplier.this.dictionary.indexOf(null) >= 0;
            }

            @Override
            public BitmapFactory getBitmapFactory() {
                return BitmapIndexColumnPartSupplier.this.bitmapFactory;
            }

            @Override
            public int getIndex(String value) {
                return BitmapIndexColumnPartSupplier.this.dictionary.indexOf(value);
            }

            @Override
            public ImmutableBitmap getBitmap(int idx) {
                if (idx < 0) {
                    return BitmapIndexColumnPartSupplier.this.bitmapFactory.makeEmptyImmutableBitmap();
                }
                ImmutableBitmap bitmap = (ImmutableBitmap)BitmapIndexColumnPartSupplier.this.bitmaps.get(idx);
                return bitmap == null ? BitmapIndexColumnPartSupplier.this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
            }
        };
    }
}

