/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.serde;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.collections.spatial.ImmutableRTree;
import org.apache.hive.druid.io.druid.io.Channels;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.column.ColumnBuilder;
import org.apache.hive.druid.io.druid.segment.column.ColumnConfig;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerde;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.ByteBufferWriter;
import org.apache.hive.druid.io.druid.segment.data.ColumnarInts;
import org.apache.hive.druid.io.druid.segment.data.ColumnarIntsSerializer;
import org.apache.hive.druid.io.druid.segment.data.ColumnarMultiInts;
import org.apache.hive.druid.io.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.hive.druid.io.druid.segment.data.CompressedVSizeColumnarMultiIntsSupplier;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.io.druid.segment.data.ImmutableRTreeObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.V3CompressedVSizeColumnarMultiIntsSupplier;
import org.apache.hive.druid.io.druid.segment.data.VSizeColumnarInts;
import org.apache.hive.druid.io.druid.segment.data.VSizeColumnarMultiInts;
import org.apache.hive.druid.io.druid.segment.data.WritableSupplier;
import org.apache.hive.druid.io.druid.segment.serde.BitmapIndexColumnPartSupplier;
import org.apache.hive.druid.io.druid.segment.serde.ColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.serde.DictionaryEncodedColumnSupplier;
import org.apache.hive.druid.io.druid.segment.serde.Serializer;
import org.apache.hive.druid.io.druid.segment.serde.SpatialIndexColumnPartSupplier;

public class DictionaryEncodedColumnPartSerde
implements ColumnPartSerde {
    private static final int NO_FLAGS = 0;
    private final ByteOrder byteOrder;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final Serializer serializer;

    @JsonCreator
    public static DictionaryEncodedColumnPartSerde createDeserializer(@Nullable @JsonProperty(value="bitmapSerdeFactory") BitmapSerdeFactory bitmapSerdeFactory, @NotNull @JsonProperty(value="byteOrder") ByteOrder byteOrder) {
        return new DictionaryEncodedColumnPartSerde(byteOrder, bitmapSerdeFactory != null ? bitmapSerdeFactory : new BitmapSerde.LegacyBitmapSerdeFactory(), null);
    }

    private DictionaryEncodedColumnPartSerde(ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, Serializer serializer) {
        this.byteOrder = byteOrder;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.serializer = serializer;
    }

    @JsonProperty
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return new ColumnPartSerde.Deserializer(){

            @Override
            public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
                WritableSupplier<ColumnarInts> rSingleValuedColumn;
                WritableSupplier<ColumnarMultiInts> rMultiValuedColumn;
                VERSION rVersion = VERSION.fromByte(buffer.get());
                int rFlags = rVersion.compareTo(VERSION.COMPRESSED) >= 0 ? buffer.getInt() : (rVersion.equals((Object)VERSION.UNCOMPRESSED_MULTI_VALUE) ? Feature.MULTI_VALUE.getMask() : 0);
                boolean hasMultipleValues = Feature.MULTI_VALUE.isSet(rFlags) || Feature.MULTI_VALUE_V3.isSet(rFlags);
                GenericIndexed<String> rDictionary = GenericIndexed.read(buffer, GenericIndexed.STRING_STRATEGY, builder.getFileMapper());
                builder.setType(ValueType.STRING);
                if (hasMultipleValues) {
                    rMultiValuedColumn = this.readMultiValuedColumn(rVersion, buffer, rFlags);
                    rSingleValuedColumn = null;
                } else {
                    rSingleValuedColumn = this.readSingleValuedColumn(rVersion, buffer);
                    rMultiValuedColumn = null;
                }
                DictionaryEncodedColumnSupplier dictionaryEncodedColumnSupplier = new DictionaryEncodedColumnSupplier(rDictionary, rSingleValuedColumn, rMultiValuedColumn, columnConfig.columnCacheSizeBytes());
                builder.setHasMultipleValues(hasMultipleValues).setDictionaryEncodedColumn(dictionaryEncodedColumnSupplier);
                GenericIndexed<ImmutableBitmap> rBitmaps = GenericIndexed.read(buffer, DictionaryEncodedColumnPartSerde.this.bitmapSerdeFactory.getObjectStrategy(), builder.getFileMapper());
                builder.setBitmapIndex(new BitmapIndexColumnPartSupplier(DictionaryEncodedColumnPartSerde.this.bitmapSerdeFactory.getBitmapFactory(), rBitmaps, rDictionary));
                ImmutableRTree rSpatialIndex = null;
                if (buffer.hasRemaining()) {
                    rSpatialIndex = (ImmutableRTree)new ImmutableRTreeObjectStrategy(DictionaryEncodedColumnPartSerde.this.bitmapSerdeFactory.getBitmapFactory()).fromByteBufferWithSize(buffer);
                    builder.setSpatialIndex(new SpatialIndexColumnPartSupplier(rSpatialIndex));
                }
            }

            private WritableSupplier<ColumnarInts> readSingleValuedColumn(VERSION version, ByteBuffer buffer) {
                switch (version) {
                    case UNCOMPRESSED_SINGLE_VALUE: {
                        return VSizeColumnarInts.readFromByteBuffer(buffer);
                    }
                    case COMPRESSED: {
                        return CompressedVSizeColumnarIntsSupplier.fromByteBuffer(buffer, DictionaryEncodedColumnPartSerde.this.byteOrder);
                    }
                }
                throw new IAE("Unsupported single-value version[%s]", new Object[]{version});
            }

            private WritableSupplier<ColumnarMultiInts> readMultiValuedColumn(VERSION version, ByteBuffer buffer, int flags) {
                switch (version) {
                    case UNCOMPRESSED_MULTI_VALUE: {
                        return VSizeColumnarMultiInts.readFromByteBuffer(buffer);
                    }
                    case COMPRESSED: {
                        if (Feature.MULTI_VALUE.isSet(flags)) {
                            return CompressedVSizeColumnarMultiIntsSupplier.fromByteBuffer(buffer, DictionaryEncodedColumnPartSerde.this.byteOrder);
                        }
                        if (Feature.MULTI_VALUE_V3.isSet(flags)) {
                            return V3CompressedVSizeColumnarMultiIntsSupplier.fromByteBuffer(buffer, DictionaryEncodedColumnPartSerde.this.byteOrder);
                        }
                        throw new IAE("Unrecognized multi-value flag[%d]", flags);
                    }
                }
                throw new IAE("Unsupported multi-value version[%s]", new Object[]{version});
            }
        };
    }

    public static class SerializerBuilder {
        private VERSION version = null;
        private int flags = 0;
        private GenericIndexedWriter<String> dictionaryWriter = null;
        private ColumnarIntsSerializer valueWriter = null;
        private BitmapSerdeFactory bitmapSerdeFactory = null;
        private GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter = null;
        private ByteBufferWriter<ImmutableRTree> spatialIndexWriter = null;
        private ByteOrder byteOrder = null;

        public SerializerBuilder withDictionary(GenericIndexedWriter<String> dictionaryWriter) {
            this.dictionaryWriter = dictionaryWriter;
            return this;
        }

        public SerializerBuilder withBitmapSerdeFactory(BitmapSerdeFactory bitmapSerdeFactory) {
            this.bitmapSerdeFactory = bitmapSerdeFactory;
            return this;
        }

        public SerializerBuilder withBitmapIndex(GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter) {
            this.bitmapIndexWriter = bitmapIndexWriter;
            return this;
        }

        public SerializerBuilder withSpatialIndex(ByteBufferWriter<ImmutableRTree> spatialIndexWriter) {
            this.spatialIndexWriter = spatialIndexWriter;
            return this;
        }

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withValue(ColumnarIntsSerializer valueWriter, boolean hasMultiValue, boolean compressed) {
            this.valueWriter = valueWriter;
            if (hasMultiValue) {
                if (compressed) {
                    this.version = VERSION.COMPRESSED;
                    this.flags |= Feature.MULTI_VALUE_V3.getMask();
                } else {
                    this.version = VERSION.UNCOMPRESSED_MULTI_VALUE;
                    this.flags |= Feature.MULTI_VALUE.getMask();
                }
            } else {
                this.version = compressed ? VERSION.COMPRESSED : VERSION.UNCOMPRESSED_SINGLE_VALUE;
            }
            return this;
        }

        public DictionaryEncodedColumnPartSerde build() {
            return new DictionaryEncodedColumnPartSerde(this.byteOrder, this.bitmapSerdeFactory, new Serializer(){

                @Override
                public long getSerializedSize() throws IOException {
                    long size = 1 + (version.compareTo(VERSION.COMPRESSED) >= 0 ? 4 : 0);
                    if (dictionaryWriter != null) {
                        size += dictionaryWriter.getSerializedSize();
                    }
                    if (valueWriter != null) {
                        size += valueWriter.getSerializedSize();
                    }
                    if (bitmapIndexWriter != null) {
                        size += bitmapIndexWriter.getSerializedSize();
                    }
                    if (spatialIndexWriter != null) {
                        size += spatialIndexWriter.getSerializedSize();
                    }
                    return size;
                }

                @Override
                public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
                    Channels.writeFully(channel, ByteBuffer.wrap(new byte[]{version.asByte()}));
                    if (version.compareTo(VERSION.COMPRESSED) >= 0) {
                        channel.write(ByteBuffer.wrap(Ints.toByteArray(flags)));
                    }
                    if (dictionaryWriter != null) {
                        dictionaryWriter.writeTo(channel, smoosher);
                    }
                    if (valueWriter != null) {
                        valueWriter.writeTo(channel, smoosher);
                    }
                    if (bitmapIndexWriter != null) {
                        bitmapIndexWriter.writeTo(channel, smoosher);
                    }
                    if (spatialIndexWriter != null) {
                        spatialIndexWriter.writeTo(channel, smoosher);
                    }
                }
            });
        }
    }

    static enum VERSION {
        UNCOMPRESSED_SINGLE_VALUE,
        UNCOMPRESSED_MULTI_VALUE,
        COMPRESSED;


        public static VERSION fromByte(byte b) {
            VERSION[] values = VERSION.values();
            Preconditions.checkArgument(b < values.length, "Unsupported dictionary column version[%s]", b);
            return values[b];
        }

        public byte asByte() {
            return (byte)this.ordinal();
        }
    }

    static enum Feature {
        MULTI_VALUE,
        MULTI_VALUE_V3;


        public boolean isSet(int flags) {
            return (this.getMask() & flags) != 0;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

