/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.virtual;

import javax.annotation.Nonnull;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprEval;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.virtual.SingleInputBindings;

public class SingleLongInputCachingExpressionColumnValueSelector
implements ColumnValueSelector<ExprEval> {
    private final ColumnValueSelector selector;
    private final Expr expression;
    private final SingleInputBindings bindings = new SingleInputBindings();
    private long lastInput;
    private Validity validity = Validity.NONE;
    private double lastDoubleOutput;
    private long lastLongOutput;
    private ExprEval lastEvalOutput;

    public SingleLongInputCachingExpressionColumnValueSelector(ColumnValueSelector selector, Expr expression) {
        if (Parser.findRequiredBindings(expression).size() != 1) {
            throw new ISE("WTF?! Expected expression with just one binding", new Object[0]);
        }
        this.selector = Preconditions.checkNotNull(selector, "selector");
        this.expression = Preconditions.checkNotNull(expression, "expression");
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("expression", this.expression);
    }

    @Override
    public double getDouble() {
        long currentInput = this.selector.getLong();
        if (this.lastInput == currentInput && this.validity == Validity.DOUBLE) {
            return this.lastDoubleOutput;
        }
        double output = this.eval(currentInput).asDouble();
        this.lastInput = currentInput;
        this.lastDoubleOutput = output;
        this.validity = Validity.DOUBLE;
        return output;
    }

    @Override
    public float getFloat() {
        return (float)this.getDouble();
    }

    @Override
    public long getLong() {
        long currentInput = this.selector.getLong();
        if (this.lastInput == currentInput && this.validity == Validity.LONG) {
            return this.lastLongOutput;
        }
        long output = this.eval(currentInput).asLong();
        this.lastInput = currentInput;
        this.lastLongOutput = output;
        this.validity = Validity.LONG;
        return output;
    }

    @Override
    @Nonnull
    public ExprEval getObject() {
        long currentInput = this.selector.getLong();
        if (this.lastInput == currentInput && this.validity == Validity.EVAL) {
            return this.lastEvalOutput;
        }
        ExprEval output = this.eval(currentInput);
        this.lastInput = currentInput;
        this.lastEvalOutput = output;
        this.validity = Validity.EVAL;
        return output;
    }

    @Override
    public Class<ExprEval> classOfObject() {
        return ExprEval.class;
    }

    private ExprEval eval(long value) {
        this.bindings.set(value);
        return this.expression.eval(this.bindings);
    }

    static enum Validity {
        NONE,
        DOUBLE,
        LONG,
        EVAL;

    }
}

