/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordination;

import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonUnwrapped;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentChangeHandler;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class SegmentChangeRequestDrop
implements DataSegmentChangeRequest {
    private final DataSegment segment;

    @JsonCreator
    public SegmentChangeRequestDrop(@JsonUnwrapped DataSegment segment) {
        this.segment = segment;
    }

    @JsonProperty
    @JsonUnwrapped
    public DataSegment getSegment() {
        return this.segment;
    }

    @Override
    public void go(DataSegmentChangeHandler handler, DataSegmentChangeCallback callback) {
        handler.removeSegment(this.segment, callback);
    }

    @Override
    public String asString() {
        return StringUtils.format("DROP: %s", this.segment.getIdentifier());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentChangeRequestDrop that = (SegmentChangeRequestDrop)o;
        return Objects.equals(this.segment, that.segment);
    }

    public int hashCode() {
        return Objects.hash(this.segment);
    }

    public String toString() {
        return "SegmentChangeRequestDrop{segment=" + this.segment + '}';
    }
}

