/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http.security;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import javax.ws.rs.core.PathSegment;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.io.druid.server.http.security.AbstractResourceFilter;
import org.apache.hive.druid.io.druid.server.security.Access;
import org.apache.hive.druid.io.druid.server.security.AuthorizationUtils;
import org.apache.hive.druid.io.druid.server.security.AuthorizerMapper;
import org.apache.hive.druid.io.druid.server.security.ForbiddenException;
import org.apache.hive.druid.io.druid.server.security.Resource;
import org.apache.hive.druid.io.druid.server.security.ResourceAction;
import org.apache.hive.druid.io.druid.server.security.ResourceType;

public class RulesResourceFilter
extends AbstractResourceFilter {
    @Inject
    public RulesResourceFilter(AuthorizerMapper authorizerMapper) {
        super(authorizerMapper);
    }

    public ContainerRequest filter(ContainerRequest request) {
        String dataSourceName = ((PathSegment)request.getPathSegments().get(Iterables.indexOf(request.getPathSegments(), new Predicate<PathSegment>(){

            @Override
            public boolean apply(PathSegment input) {
                return input.getPath().equals("rules");
            }
        }) + 1)).getPath();
        Preconditions.checkNotNull(dataSourceName);
        ResourceAction resourceAction = new ResourceAction(new Resource(dataSourceName, ResourceType.DATASOURCE), this.getAction(request));
        Access authResult = AuthorizationUtils.authorizeResourceAction(this.getReq(), resourceAction, this.getAuthorizerMapper());
        if (!authResult.isAllowed()) {
            throw new ForbiddenException(authResult.toString());
        }
        return request;
    }

    @Override
    public boolean isApplicable(String requestPath) {
        ImmutableList<String> applicablePaths = ImmutableList.of("druid/coordinator/v1/rules/");
        for (String path : applicablePaths) {
            if (!requestPath.startsWith(path) || requestPath.equals(path)) continue;
            return true;
        }
        return false;
    }
}

