/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidJsonFilter;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.QueryType;
import org.apache.hive.druid.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPredicateList;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Aggregate;
import org.apache.hive.druid.org.apache.calcite.rel.core.AggregateCall;
import org.apache.hive.druid.org.apache.calcite.rel.core.Filter;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.core.RelFactories;
import org.apache.hive.druid.org.apache.calcite.rel.core.Sort;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.hive.druid.org.apache.calcite.rel.rules.AggregateExtractProjectRule;
import org.apache.hive.druid.org.apache.calcite.rel.rules.AggregateFilterTransposeRule;
import org.apache.hive.druid.org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.hive.druid.org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ProjectFilterTransposeRule;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ProjectSortTransposeRule;
import org.apache.hive.druid.org.apache.calcite.rel.rules.PushProjector;
import org.apache.hive.druid.org.apache.calcite.rel.rules.SortProjectTransposeRule;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexExecutor;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexShuttle;
import org.apache.hive.druid.org.apache.calcite.rex.RexSimplify;
import org.apache.hive.druid.org.apache.calcite.rex.RexUtil;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.apache.hive.druid.org.apache.calcite.util.trace.CalciteTrace;
import org.joda.time.Interval;
import org.slf4j.Logger;

public class DruidRules {
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    public static final DruidFilterRule FILTER = new DruidFilterRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidProjectRule PROJECT = new DruidProjectRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidAggregateRule AGGREGATE = new DruidAggregateRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidAggregateProjectRule AGGREGATE_PROJECT = new DruidAggregateProjectRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidSortRule SORT = new DruidSortRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidSortProjectTransposeRule SORT_PROJECT_TRANSPOSE = new DruidSortProjectTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidProjectSortTransposeRule PROJECT_SORT_TRANSPOSE = new DruidProjectSortTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidProjectFilterTransposeRule PROJECT_FILTER_TRANSPOSE = new DruidProjectFilterTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidFilterProjectTransposeRule FILTER_PROJECT_TRANSPOSE = new DruidFilterProjectTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidAggregateFilterTransposeRule AGGREGATE_FILTER_TRANSPOSE = new DruidAggregateFilterTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidFilterAggregateTransposeRule FILTER_AGGREGATE_TRANSPOSE = new DruidFilterAggregateTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidPostAggregationProjectRule POST_AGGREGATION_PROJECT = new DruidPostAggregationProjectRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidAggregateExtractProjectRule PROJECT_EXTRACT_RULE = new DruidAggregateExtractProjectRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidHavingFilterRule DRUID_HAVING_FILTER_RULE = new DruidHavingFilterRule(RelFactories.LOGICAL_BUILDER);
    public static final List<RelOptRule> RULES = ImmutableList.of(FILTER, PROJECT_FILTER_TRANSPOSE, AGGREGATE_FILTER_TRANSPOSE, AGGREGATE_PROJECT, PROJECT_EXTRACT_RULE, PROJECT, POST_AGGREGATION_PROJECT, AGGREGATE, FILTER_AGGREGATE_TRANSPOSE, FILTER_PROJECT_TRANSPOSE, PROJECT_SORT_TRANSPOSE, SORT, new RelOptRule[]{SORT_PROJECT_TRANSPOSE, DRUID_HAVING_FILTER_RULE});

    private DruidRules() {
    }

    public static class DruidAggregateExtractProjectRule
    extends AggregateExtractProjectRule {
        public DruidAggregateExtractProjectRule(RelBuilderFactory relBuilderFactory) {
            super(DruidAggregateExtractProjectRule.operand(Aggregate.class, DruidAggregateExtractProjectRule.operand(DruidQuery.class, DruidAggregateExtractProjectRule.none()), new RelOptRuleOperand[0]), relBuilderFactory);
        }
    }

    public static class DruidFilterAggregateTransposeRule
    extends FilterAggregateTransposeRule {
        public DruidFilterAggregateTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidFilterAggregateTransposeRule.operand(Filter.class, DruidFilterAggregateTransposeRule.operand(Aggregate.class, DruidFilterAggregateTransposeRule.operand(DruidQuery.class, DruidFilterAggregateTransposeRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), relBuilderFactory);
        }
    }

    public static class DruidAggregateFilterTransposeRule
    extends AggregateFilterTransposeRule {
        public DruidAggregateFilterTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidAggregateFilterTransposeRule.operand(Aggregate.class, DruidAggregateFilterTransposeRule.operand(Filter.class, DruidAggregateFilterTransposeRule.operand(DruidQuery.class, DruidAggregateFilterTransposeRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), relBuilderFactory);
        }
    }

    public static class DruidFilterProjectTransposeRule
    extends FilterProjectTransposeRule {
        public DruidFilterProjectTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidFilterProjectTransposeRule.operand(Filter.class, DruidFilterProjectTransposeRule.operand(Project.class, DruidFilterProjectTransposeRule.operand(DruidQuery.class, DruidFilterProjectTransposeRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), true, true, relBuilderFactory);
        }
    }

    public static class DruidProjectFilterTransposeRule
    extends ProjectFilterTransposeRule {
        public DruidProjectFilterTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidProjectFilterTransposeRule.operand(Project.class, DruidProjectFilterTransposeRule.operand(Filter.class, DruidProjectFilterTransposeRule.operand(DruidQuery.class, DruidProjectFilterTransposeRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), PushProjector.ExprCondition.FALSE, relBuilderFactory);
        }
    }

    public static class DruidSortRule
    extends RelOptRule {
        public DruidSortRule(RelBuilderFactory relBuilderFactory) {
            super(DruidSortRule.operand(Sort.class, DruidSortRule.operand(DruidQuery.class, DruidSortRule.none()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            if (!DruidQuery.isValidSignature(query.signature() + 'l')) {
                return;
            }
            if (sort.offset != null && RexLiteral.intValue(sort.offset) != 0) {
                return;
            }
            if (query.getQueryType() == QueryType.SCAN && !RelOptUtil.isPureLimit(sort)) {
                return;
            }
            RelNode newSort = sort.copy(sort.getTraitSet(), ImmutableList.of(Util.last(query.rels)));
            call.transformTo(DruidQuery.extendQuery(query, newSort));
        }
    }

    public static class DruidProjectSortTransposeRule
    extends ProjectSortTransposeRule {
        public DruidProjectSortTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidProjectSortTransposeRule.operand(Project.class, DruidProjectSortTransposeRule.operand(Sort.class, DruidProjectSortTransposeRule.operand(DruidQuery.class, DruidProjectSortTransposeRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }
    }

    public static class DruidSortProjectTransposeRule
    extends SortProjectTransposeRule {
        public DruidSortProjectTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidSortProjectTransposeRule.operand(Sort.class, DruidSortProjectTransposeRule.operand(Project.class, DruidSortProjectTransposeRule.operand(DruidQuery.class, DruidSortProjectTransposeRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }
    }

    public static class DruidAggregateProjectRule
    extends RelOptRule {
        public DruidAggregateProjectRule(RelBuilderFactory relBuilderFactory) {
            super(DruidAggregateProjectRule.operand(Aggregate.class, DruidAggregateProjectRule.operand(Project.class, DruidAggregateProjectRule.operand(DruidQuery.class, DruidAggregateProjectRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            DruidQuery query2;
            Aggregate aggregate = (Aggregate)call.rel(0);
            Project project = (Project)call.rel(1);
            DruidQuery query = (DruidQuery)call.rel(2);
            if (!DruidQuery.isValidSignature(query.signature() + 'p' + 'a')) {
                return;
            }
            if (aggregate.indicator || aggregate.getGroupSets().size() != 1) {
                return;
            }
            if (DruidQuery.computeProjectGroupSet(project, aggregate.getGroupSet(), query.table.getRowType(), query) == null) {
                return;
            }
            List<String> aggNames = Util.skip(aggregate.getRowType().getFieldNames(), aggregate.getGroupSet().cardinality());
            if (DruidQuery.computeDruidJsonAgg(aggregate.getAggCallList(), aggNames, project, query) == null) {
                return;
            }
            RelNode newProject = project.copy(project.getTraitSet(), ImmutableList.of(Util.last(query.rels)));
            RelNode newAggregate = aggregate.copy(aggregate.getTraitSet(), ImmutableList.of(newProject));
            List<Integer> filterRefs = DruidAggregateProjectRule.getFilterRefs(aggregate.getAggCallList());
            if (filterRefs.size() > 0) {
                query2 = this.optimizeFilteredAggregations(call, query, (Project)newProject, (Aggregate)newAggregate);
            } else {
                DruidQuery query1 = DruidQuery.extendQuery(query, newProject);
                query2 = DruidQuery.extendQuery(query1, newAggregate);
            }
            call.transformTo(query2);
        }

        private Set<Integer> getUniqueFilterRefs(List<AggregateCall> calls) {
            HashSet<Integer> refs = new HashSet<Integer>();
            for (AggregateCall call : calls) {
                if (!call.hasFilter()) continue;
                refs.add(call.filterArg);
            }
            return refs;
        }

        private DruidQuery optimizeFilteredAggregations(RelOptRuleCall call, DruidQuery query, Project project, Aggregate aggregate) {
            Filter filter = null;
            RexBuilder builder = query.getCluster().getRexBuilder();
            RexExecutor executor = Util.first(query.getCluster().getPlanner().getExecutor(), RexUtil.EXECUTOR);
            RelNode scan = (RelNode)query.rels.get(0);
            RelOptPredicateList predicates = call.getMetadataQuery().getPulledUpPredicates(scan);
            RexSimplify simplify = new RexSimplify(builder, predicates, true, executor);
            boolean containsFilter = false;
            for (RelNode node : query.rels) {
                if (!(node instanceof Filter)) continue;
                filter = (Filter)node;
                containsFilter = true;
                break;
            }
            boolean allHaveFilters = DruidAggregateProjectRule.allAggregatesHaveFilters(aggregate.getAggCallList());
            Set<Integer> uniqueFilterRefs = this.getUniqueFilterRefs(aggregate.getAggCallList());
            assert (uniqueFilterRefs.size() > 0);
            ArrayList<AggregateCall> newCalls = new ArrayList<AggregateCall>();
            ArrayList<RexNode> disjunctions = new ArrayList<RexNode>();
            for (Integer n : uniqueFilterRefs) {
                disjunctions.add(DruidAggregateProjectRule.stripFilter(project.getProjects().get(n)));
            }
            RexNode filterNode = RexUtil.composeDisjunction(builder, disjunctions);
            for (AggregateCall aggCall : aggregate.getAggCallList()) {
                int newFilterArg = aggCall.filterArg;
                if (!aggCall.hasFilter() || uniqueFilterRefs.size() == 1 && allHaveFilters || project.getProjects().get(newFilterArg).isAlwaysTrue()) {
                    newFilterArg = -1;
                }
                newCalls.add(aggCall.copy(aggCall.getArgList(), newFilterArg));
            }
            aggregate = aggregate.copy(aggregate.getTraitSet(), aggregate.getInput(), aggregate.indicator, aggregate.getGroupSet(), aggregate.getGroupSets(), newCalls);
            if (containsFilter) {
                filterNode = builder.makeCall((SqlOperator)SqlStdOperatorTable.AND, filterNode, filter.getCondition());
            }
            RexNode rexNode = filterNode;
            if ((filterNode = simplify.simplify(filterNode)).isAlwaysFalse()) {
                filterNode = rexNode;
            }
            boolean addNewFilter = !(filter = LogicalFilter.create(scan, filterNode)).getCondition().isAlwaysTrue() && allHaveFilters;
            int startIndex = containsFilter && addNewFilter ? 2 : 1;
            List<RelNode> newNodes = DruidAggregateProjectRule.constructNewNodes(query.rels, addNewFilter, startIndex, filter, project, aggregate);
            return DruidQuery.create(query.getCluster(), aggregate.getTraitSet().replace(query.getConvention()), query.getTable(), query.druidTable, newNodes);
        }

        private static boolean allAggregatesHaveFilters(List<AggregateCall> calls) {
            for (AggregateCall call : calls) {
                if (call.hasFilter()) continue;
                return false;
            }
            return true;
        }

        private static List<RelNode> constructNewNodes(List<RelNode> oldNodes, boolean addFilter, int startIndex, RelNode filter, RelNode ... trailingNodes) {
            ArrayList<RelNode> newNodes = new ArrayList<RelNode>();
            newNodes.add(oldNodes.get(0));
            if (addFilter) {
                newNodes.add(filter);
                if (startIndex < oldNodes.size()) {
                    RelNode next = oldNodes.get(startIndex);
                    newNodes.add(next.copy(next.getTraitSet(), Collections.singletonList(filter)));
                    ++startIndex;
                }
            }
            for (int i = startIndex; i < oldNodes.size(); ++i) {
                newNodes.add(oldNodes.get(i));
            }
            for (RelNode node : trailingNodes) {
                newNodes.add(node.copy(node.getTraitSet(), Collections.singletonList(Util.last(newNodes))));
            }
            return newNodes;
        }

        private static RexNode stripFilter(RexNode node) {
            if (node.getKind() == SqlKind.IS_TRUE) {
                return ((RexCall)node).getOperands().get(0);
            }
            return node;
        }

        private static List<Integer> getFilterRefs(List<AggregateCall> calls) {
            ArrayList<Integer> refs = new ArrayList<Integer>();
            for (AggregateCall call : calls) {
                if (!call.hasFilter()) continue;
                refs.add(call.filterArg);
            }
            return refs;
        }
    }

    public static class DruidAggregateRule
    extends RelOptRule {
        public DruidAggregateRule(RelBuilderFactory relBuilderFactory) {
            super(DruidAggregateRule.operand(Aggregate.class, DruidAggregateRule.operand(DruidQuery.class, DruidAggregateRule.none()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project;
            Aggregate aggregate = (Aggregate)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            RelNode topDruidNode = query.getTopNode();
            Project project2 = project = topDruidNode instanceof Project ? (Project)topDruidNode : null;
            if (!DruidQuery.isValidSignature(query.signature() + 'a')) {
                return;
            }
            if (aggregate.indicator || aggregate.getGroupSets().size() != 1) {
                return;
            }
            if (DruidQuery.computeProjectGroupSet(project, aggregate.getGroupSet(), query.table.getRowType(), query) == null) {
                return;
            }
            List<String> aggNames = Util.skip(aggregate.getRowType().getFieldNames(), aggregate.getGroupSet().cardinality());
            if (DruidQuery.computeDruidJsonAgg(aggregate.getAggCallList(), aggNames, project, query) == null) {
                return;
            }
            RelNode newAggregate = aggregate.copy(aggregate.getTraitSet(), ImmutableList.of(query.getTopNode()));
            call.transformTo(DruidQuery.extendQuery(query, newAggregate));
        }
    }

    public static class DruidPostAggregationProjectRule
    extends RelOptRule {
        public DruidPostAggregationProjectRule(RelBuilderFactory relBuilderFactory) {
            super(DruidPostAggregationProjectRule.operand(Project.class, DruidPostAggregationProjectRule.operand(DruidQuery.class, DruidPostAggregationProjectRule.none()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            if (!DruidQuery.isValidSignature(query.signature() + 'o')) {
                return;
            }
            boolean hasRexCalls = false;
            for (RexNode rexNode : project.getChildExps()) {
                if (!(rexNode instanceof RexCall)) continue;
                hasRexCalls = true;
                break;
            }
            if (hasRexCalls) {
                RelNode topNode = query.getTopNode();
                Aggregate topAgg = topNode instanceof Aggregate ? (Aggregate)topNode : (Aggregate)((Filter)topNode).getInput();
                for (RexNode rexNode : project.getProjects()) {
                    if (DruidExpressions.toDruidExpression(rexNode, topAgg.getRowType(), query) != null) continue;
                    return;
                }
                RelNode newProject = project.copy(project.getTraitSet(), ImmutableList.of(Util.last(query.rels)));
                DruidQuery newQuery = DruidQuery.extendQuery(query, newProject);
                call.transformTo(newQuery);
            }
        }
    }

    public static class DruidProjectRule
    extends RelOptRule {
        public DruidProjectRule(RelBuilderFactory relBuilderFactory) {
            super(DruidProjectRule.operand(Project.class, DruidProjectRule.operand(DruidQuery.class, DruidProjectRule.none()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            RelOptCluster cluster = project.getCluster();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            if (!DruidQuery.isValidSignature(query.signature() + 'p')) {
                return;
            }
            if (DruidQuery.computeProjectAsScan(project, query.getTable().getRowType(), query) != null) {
                RelNode newProject = project.copy(project.getTraitSet(), ImmutableList.of(Util.last(query.rels)));
                DruidQuery newNode = DruidQuery.extendQuery(query, newProject);
                call.transformTo(newNode);
                return;
            }
            Pair<List<RexNode>, List<RexNode>> pair = DruidProjectRule.splitProjects(rexBuilder, query, project.getProjects());
            if (pair == null) {
                return;
            }
            List above = (List)pair.left;
            List below = (List)pair.right;
            RelDataTypeFactory.FieldInfoBuilder builder = cluster.getTypeFactory().builder();
            RelNode input = Util.last(query.rels);
            for (RexNode e : below) {
                String name = e instanceof RexInputRef ? input.getRowType().getFieldNames().get(((RexInputRef)e).getIndex()) : null;
                ((RelDataTypeFactory.Builder)builder).add(name, e.getType());
            }
            Project newProject = project.copy(project.getTraitSet(), input, below, builder.build());
            DruidQuery newQuery = DruidQuery.extendQuery(query, newProject);
            Project newProject2 = project.copy(project.getTraitSet(), newQuery, above, project.getRowType());
            call.transformTo(newProject2);
        }

        private static Pair<List<RexNode>, List<RexNode>> splitProjects(final RexBuilder rexBuilder, RelNode input, List<RexNode> nodes) {
            RelOptUtil.InputReferencedVisitor visitor = new RelOptUtil.InputReferencedVisitor();
            for (RexNode node : nodes) {
                node.accept(visitor);
            }
            if (visitor.inputPosReferenced.size() == input.getRowType().getFieldCount()) {
                return null;
            }
            ArrayList<RexInputRef> belowNodes = new ArrayList<RexInputRef>();
            final ArrayList<RelDataType> belowTypes = new ArrayList<RelDataType>();
            final ArrayList<Integer> positions = Lists.newArrayList(visitor.inputPosReferenced);
            Iterator iterator = positions.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                RexNode node = rexBuilder.makeInputRef(input, i);
                belowNodes.add((RexInputRef)node);
                belowTypes.add(node.getType());
            }
            ArrayList<RexNode> aboveNodes = new ArrayList<RexNode>();
            for (RexNode node : nodes) {
                aboveNodes.add(node.accept(new RexShuttle(){

                    @Override
                    public RexNode visitInputRef(RexInputRef ref) {
                        int index = positions.indexOf(ref.getIndex());
                        return rexBuilder.makeInputRef((RelDataType)belowTypes.get(index), index);
                    }
                }));
            }
            return Pair.of(aboveNodes, belowNodes);
        }
    }

    public static class DruidHavingFilterRule
    extends RelOptRule {
        public DruidHavingFilterRule(RelBuilderFactory relBuilderFactory) {
            super(DruidHavingFilterRule.operand(Filter.class, DruidHavingFilterRule.operand(DruidQuery.class, DruidHavingFilterRule.none()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            if (!DruidQuery.isValidSignature(query.signature() + 'h')) {
                return;
            }
            RexNode cond = filter.getCondition();
            DruidJsonFilter druidJsonFilter = DruidJsonFilter.toDruidFilters(cond, query.getTopNode().getRowType(), query);
            if (druidJsonFilter != null) {
                Filter newFilter = filter.copy(filter.getTraitSet(), Util.last(query.rels), filter.getCondition());
                DruidQuery newDruidQuery = DruidQuery.extendQuery(query, newFilter);
                call.transformTo(newDruidQuery);
            }
        }
    }

    public static class DruidFilterRule
    extends RelOptRule {
        public DruidFilterRule(RelBuilderFactory relBuilderFactory) {
            super(DruidFilterRule.operand(Filter.class, DruidFilterRule.operand(DruidQuery.class, DruidFilterRule.none()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            final DruidQuery query = (DruidQuery)call.rel(1);
            RelOptCluster cluster = filter.getCluster();
            RelBuilder relBuilder = call.builder();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            if (!DruidQuery.isValidSignature(query.signature() + 'f')) {
                return;
            }
            ArrayList<RexNode> validPreds = new ArrayList<RexNode>();
            ArrayList<RexNode> nonValidPreds = new ArrayList<RexNode>();
            RexExecutor executor = Util.first(cluster.getPlanner().getExecutor(), RexUtil.EXECUTOR);
            RelOptPredicateList predicates = call.getMetadataQuery().getPulledUpPredicates(filter.getInput());
            RexSimplify simplify = new RexSimplify(rexBuilder, predicates, true, executor);
            RexNode cond = simplify.simplify(filter.getCondition());
            for (RexNode e : RelOptUtil.conjunctions(cond)) {
                DruidJsonFilter druidJsonFilter = DruidJsonFilter.toDruidFilters(e, filter.getInput().getRowType(), query);
                if (druidJsonFilter != null) {
                    validPreds.add(e);
                    continue;
                }
                nonValidPreds.add(e);
            }
            int timestampFieldIdx = Iterables.indexOf(query.getRowType().getFieldList(), new Predicate<RelDataTypeField>(){

                @Override
                public boolean apply(@Nullable RelDataTypeField input) {
                    return query.druidTable.timestampFieldName.equals(input.getName());
                }
            });
            RelNode newDruidQuery = query;
            Triple<List<RexNode>, List<RexNode>, List<RexNode>> triple = DruidFilterRule.splitFilters(rexBuilder, query, validPreds, nonValidPreds, timestampFieldIdx);
            if (triple.getLeft().isEmpty() && triple.getMiddle().isEmpty()) {
                return;
            }
            ArrayList residualPreds = new ArrayList(triple.getRight());
            List<Interval> intervals = null;
            if (!triple.getLeft().isEmpty()) {
                String timeZone = cluster.getPlanner().getContext().unwrap(CalciteConnectionConfig.class).timeZone();
                assert (timeZone != null);
                intervals = DruidDateTimeUtils.createInterval(RexUtil.composeConjunction(rexBuilder, (Iterable<? extends RexNode>)triple.getLeft(), false), query.getConnectionConfig().timeZone());
                if (intervals == null || intervals.isEmpty()) {
                    triple.getMiddle().addAll((Collection<RexNode>)triple.getLeft());
                }
            }
            if (!triple.getMiddle().isEmpty()) {
                Filter newFilter = filter.copy(filter.getTraitSet(), Util.last(query.rels), RexUtil.composeConjunction(rexBuilder, (Iterable<? extends RexNode>)triple.getMiddle(), false));
                newDruidQuery = DruidQuery.extendQuery(query, newFilter);
            }
            if (intervals != null && !intervals.isEmpty()) {
                newDruidQuery = DruidQuery.extendQuery(newDruidQuery, intervals);
            }
            if (!residualPreds.isEmpty()) {
                newDruidQuery = relBuilder.push(newDruidQuery).filter(residualPreds).build();
            }
            call.transformTo(newDruidQuery);
        }

        private static Triple<List<RexNode>, List<RexNode>, List<RexNode>> splitFilters(RexBuilder rexBuilder, DruidQuery input, List<RexNode> validPreds, List<RexNode> nonValidPreds, int timestampFieldIdx) {
            ArrayList<RexNode> timeRangeNodes = new ArrayList<RexNode>();
            ArrayList<RexNode> pushableNodes = new ArrayList<RexNode>();
            ArrayList<RexNode> nonPushableNodes = new ArrayList<RexNode>(nonValidPreds);
            for (RexNode conj : validPreds) {
                RelOptUtil.InputReferencedVisitor visitor = new RelOptUtil.InputReferencedVisitor();
                conj.accept(visitor);
                if (visitor.inputPosReferenced.contains(timestampFieldIdx) && visitor.inputPosReferenced.size() == 1) {
                    timeRangeNodes.add(conj);
                    continue;
                }
                pushableNodes.add(conj);
            }
            return ImmutableTriple.of(timeRangeNodes, pushableNodes, nonPushableNodes);
        }
    }
}

