/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.elasticsearch;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.hive.druid.org.apache.calcite.adapter.elasticsearch.ElasticsearchSchema;
import org.apache.hive.druid.org.apache.calcite.adapter.elasticsearch.ElasticsearchTableScan;
import org.apache.hive.druid.org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.hive.druid.org.apache.calcite.linq4j.Enumerable;
import org.apache.hive.druid.org.apache.calcite.linq4j.Enumerator;
import org.apache.hive.druid.org.apache.calcite.linq4j.QueryProvider;
import org.apache.hive.druid.org.apache.calcite.linq4j.Queryable;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptTable;
import org.apache.hive.druid.org.apache.calcite.plan.RelTrait;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaPlus;
import org.apache.hive.druid.org.apache.calcite.schema.TranslatableTable;
import org.apache.hive.druid.org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;

public abstract class AbstractElasticsearchTable
extends AbstractQueryableTable
implements TranslatableTable {
    protected final String indexName;
    protected final String typeName;

    public AbstractElasticsearchTable(String indexName, String typeName) {
        super((Type)((Object)Object[].class));
        this.indexName = indexName;
        this.typeName = typeName;
    }

    public String toString() {
        return "ElasticsearchTable{" + this.typeName + "}";
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory relDataTypeFactory) {
        RelDataType mapType = relDataTypeFactory.createMapType(relDataTypeFactory.createSqlType(SqlTypeName.VARCHAR), relDataTypeFactory.createTypeWithNullability(relDataTypeFactory.createSqlType(SqlTypeName.ANY), true));
        return relDataTypeFactory.builder().add("_MAP", mapType).build();
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new ElasticsearchQueryable(queryProvider, schema, this, tableName);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new ElasticsearchTableScan(cluster, cluster.traitSetOf((RelTrait)ElasticsearchRel.CONVENTION), relOptTable, this, null);
    }

    protected abstract Enumerable<Object> find(String var1, List<String> var2, List<Map.Entry<String, Class>> var3);

    public static class ElasticsearchQueryable<T>
    extends AbstractTableQueryable<T> {
        public ElasticsearchQueryable(QueryProvider queryProvider, SchemaPlus schema, AbstractElasticsearchTable table, String tableName) {
            super(queryProvider, schema, table, tableName);
        }

        @Override
        public Enumerator<T> enumerator() {
            return null;
        }

        private String getIndex() {
            return this.schema.unwrap(ElasticsearchSchema.class).getIndex();
        }

        private AbstractElasticsearchTable getTable() {
            return (AbstractElasticsearchTable)this.table;
        }

        public Enumerable<Object> find(List<String> ops, List<Map.Entry<String, Class>> fields) {
            return this.getTable().find(this.getIndex(), ops, fields);
        }
    }
}

