/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.type;

import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.hive.druid.org.apache.calcite.sql.SqlDialect;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.hive.druid.org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.hive.druid.org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.hive.druid.org.apache.calcite.sql.util.SqlString;

public class IntervalSqlType
extends AbstractSqlType {
    private final RelDataTypeSystem typeSystem;
    private final SqlIntervalQualifier intervalQualifier;

    public IntervalSqlType(RelDataTypeSystem typeSystem, SqlIntervalQualifier intervalQualifier, boolean isNullable) {
        super(intervalQualifier.typeName(), isNullable, null);
        this.typeSystem = Preconditions.checkNotNull(typeSystem);
        this.intervalQualifier = Preconditions.checkNotNull(intervalQualifier);
        this.computeDigest();
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("INTERVAL ");
        SqlDialect dialect = AnsiSqlDialect.DEFAULT;
        SqlPrettyWriter writer = new SqlPrettyWriter(dialect);
        writer.setAlwaysUseParentheses(false);
        writer.setSelectListItemsOnSeparateLines(false);
        writer.setIndentation(0);
        this.intervalQualifier.unparse(writer, 0, 0);
        String sql = writer.toString();
        sb.append(new SqlString(dialect, sql).getSql());
    }

    @Override
    public SqlIntervalQualifier getIntervalQualifier() {
        return this.intervalQualifier;
    }

    public IntervalSqlType combine(RelDataTypeFactoryImpl typeFactory, IntervalSqlType that) {
        assert (this.typeName.isYearMonth() == that.typeName.isYearMonth());
        boolean nullable = this.isNullable || that.isNullable;
        TimeUnit thisStart = Preconditions.checkNotNull(this.typeName.getStartUnit());
        TimeUnit thisEnd = this.typeName.getEndUnit();
        TimeUnit thatStart = Preconditions.checkNotNull(that.typeName.getStartUnit());
        TimeUnit thatEnd = that.typeName.getEndUnit();
        int secondPrec = this.intervalQualifier.getStartPrecisionPreservingDefault();
        int fracPrec = SqlIntervalQualifier.combineFractionalSecondPrecisionPreservingDefault(this.typeSystem, this.intervalQualifier, that.intervalQualifier);
        if (thisStart.ordinal() > thatStart.ordinal()) {
            thisEnd = thisStart;
            thisStart = thatStart;
            secondPrec = that.intervalQualifier.getStartPrecisionPreservingDefault();
        } else if (thisStart.ordinal() == thatStart.ordinal()) {
            secondPrec = SqlIntervalQualifier.combineStartPrecisionPreservingDefault(typeFactory.getTypeSystem(), this.intervalQualifier, that.intervalQualifier);
        } else if (null == thisEnd || thisEnd.ordinal() < thatStart.ordinal()) {
            thisEnd = thatStart;
        }
        if (null != thatEnd && (null == thisEnd || thisEnd.ordinal() < thatEnd.ordinal())) {
            thisEnd = thatEnd;
        }
        RelDataType intervalType = typeFactory.createSqlIntervalType(new SqlIntervalQualifier(thisStart, secondPrec, thisEnd, fracPrec, SqlParserPos.ZERO));
        intervalType = typeFactory.createTypeWithNullability(intervalType, nullable);
        return (IntervalSqlType)intervalType;
    }

    @Override
    public int getPrecision() {
        return this.intervalQualifier.getStartPrecision(this.typeSystem);
    }

    @Override
    public int getScale() {
        return this.intervalQualifier.getFractionalSecondPrecision(this.typeSystem);
    }
}

