/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.UnmodifiableListIterator;
import org.apache.hive.druid.org.apache.calcite.linq4j.function.Function1;
import org.apache.hive.druid.org.apache.calcite.linq4j.function.Functions;
import org.apache.hive.druid.org.apache.calcite.runtime.FlatLists;

public class ImmutableIntList
extends FlatLists.AbstractFlatList<Integer> {
    private final int[] ints;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final ImmutableIntList EMPTY = new EmptyImmutableIntList();

    private ImmutableIntList(int ... ints) {
        this.ints = ints;
    }

    public static ImmutableIntList of() {
        return EMPTY;
    }

    public static ImmutableIntList of(int ... ints) {
        return new ImmutableIntList((int[])ints.clone());
    }

    public static ImmutableIntList copyOf(Number ... numbers) {
        int[] ints = new int[numbers.length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = numbers[i].intValue();
        }
        return new ImmutableIntList(ints);
    }

    public static ImmutableIntList copyOf(Iterable<? extends Number> list) {
        if (list instanceof ImmutableIntList) {
            return (ImmutableIntList)list;
        }
        ArrayList<? extends Number> collection = list instanceof Collection ? (ArrayList<? extends Number>)list : Lists.newArrayList(list);
        return ImmutableIntList.copyFromCollection(collection);
    }

    public static ImmutableIntList copyOf(Iterator<? extends Number> list) {
        return ImmutableIntList.copyFromCollection(Lists.newArrayList(list));
    }

    private static ImmutableIntList copyFromCollection(Collection<? extends Number> list) {
        int[] ints = new int[list.size()];
        int i = 0;
        for (Number number : list) {
            ints[i++] = number.intValue();
        }
        return new ImmutableIntList(ints);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.ints);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof ImmutableIntList ? Arrays.equals(this.ints, ((ImmutableIntList)obj).ints) : obj instanceof List && obj.equals(this);
    }

    public String toString() {
        return Arrays.toString(this.ints);
    }

    @Override
    public boolean isEmpty() {
        return this.ints.length == 0;
    }

    @Override
    public int size() {
        return this.ints.length;
    }

    @Override
    public Object[] toArray() {
        Object[] objects = new Object[this.ints.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = this.ints[i];
        }
        return objects;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.ints.length;
        if (a.length < size) {
            Object[] objectArray = a = a.getClass() == Object[].class ? new Object[size] : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        if (a.getClass() == Integer[].class) {
            Integer[] integers = (Integer[])a;
            for (int i = 0; i < integers.length; ++i) {
                integers[i] = this.ints[i];
            }
        } else {
            System.arraycopy(this.toArray(), 0, a, 0, size);
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public int[] toIntArray() {
        return (int[])this.ints.clone();
    }

    @Override
    public Integer get(int index) {
        return this.ints[index];
    }

    public int getInt(int index) {
        return this.ints[index];
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Integer> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<Integer> listIterator(int index) {
        return new AbstractIndexedListIterator<Integer>(this.size(), index){

            @Override
            protected Integer get(int index) {
                return ImmutableIntList.this.get(index);
            }
        };
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Integer) {
            return this.indexOf((Integer)o);
        }
        return -1;
    }

    public int indexOf(int seek) {
        for (int i = 0; i < this.ints.length; ++i) {
            if (this.ints[i] != seek) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Integer) {
            return this.lastIndexOf((Integer)o);
        }
        return -1;
    }

    public int lastIndexOf(int seek) {
        for (int i = this.ints.length - 1; i >= 0; --i) {
            if (this.ints[i] != seek) continue;
            return i;
        }
        return -1;
    }

    public ImmutableIntList append(Integer e) {
        return this.append((int)e);
    }

    public ImmutableIntList append(int element) {
        if (this.ints.length == 0) {
            return ImmutableIntList.of(element);
        }
        int[] newInts = Arrays.copyOf(this.ints, this.ints.length + 1);
        newInts[this.ints.length] = element;
        return new ImmutableIntList(newInts);
    }

    public static List<Integer> range(final int lower, int upper) {
        return Functions.generate(upper - lower, new Function1<Integer, Integer>(){

            @Override
            public Integer apply(Integer index) {
                return lower + index;
            }
        });
    }

    public static ImmutableIntList identity(int count) {
        int[] integers = new int[count];
        for (int i = 0; i < integers.length; ++i) {
            integers[i] = i;
        }
        return new ImmutableIntList(integers);
    }

    private static abstract class AbstractIndexedListIterator<E>
    extends UnmodifiableListIterator<E> {
        private final int size;
        private int position;

        protected abstract E get(int var1);

        protected AbstractIndexedListIterator(int size, int position) {
            Preconditions.checkPositionIndex(position, size);
            this.size = size;
            this.position = position;
        }

        @Override
        public final boolean hasNext() {
            return this.position < this.size;
        }

        @Override
        public final E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.get(this.position++);
        }

        @Override
        public final int nextIndex() {
            return this.position;
        }

        @Override
        public final boolean hasPrevious() {
            return this.position > 0;
        }

        @Override
        public final E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.get(--this.position);
        }

        @Override
        public final int previousIndex() {
            return this.position - 1;
        }
    }

    private static class EmptyImmutableIntList
    extends ImmutableIntList {
        private EmptyImmutableIntList() {
            super(new int[0]);
        }

        @Override
        public Object[] toArray() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public Iterator<Integer> iterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public ListIterator<Integer> listIterator() {
            return Collections.emptyList().listIterator();
        }
    }
}

