/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.jboss.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.apache.hive.druid.org.jboss.netty.buffer.AbstractChannelBuffer;
import org.apache.hive.druid.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.hive.druid.org.jboss.netty.buffer.ChannelBufferFactory;
import org.apache.hive.druid.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.hive.druid.org.jboss.netty.buffer.WrappedChannelBuffer;

public class SlicedChannelBuffer
extends AbstractChannelBuffer
implements WrappedChannelBuffer {
    private final ChannelBuffer buffer;
    private final int adjustment;
    private final int length;

    public SlicedChannelBuffer(ChannelBuffer buffer, int index, int length) {
        if (index < 0 || index > buffer.capacity()) {
            throw new IndexOutOfBoundsException("Invalid index of " + index + ", maximum is " + buffer.capacity());
        }
        if (index + length > buffer.capacity()) {
            throw new IndexOutOfBoundsException("Invalid combined index of " + (index + length) + ", maximum is " + buffer.capacity());
        }
        this.buffer = buffer;
        this.adjustment = index;
        this.length = length;
        this.writerIndex(length);
    }

    public ChannelBuffer unwrap() {
        return this.buffer;
    }

    public ChannelBufferFactory factory() {
        return this.buffer.factory();
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public int capacity() {
        return this.length;
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset() + this.adjustment;
    }

    public byte getByte(int index) {
        this.checkIndex(index);
        return this.buffer.getByte(index + this.adjustment);
    }

    public short getShort(int index) {
        this.checkIndex(index, 2);
        return this.buffer.getShort(index + this.adjustment);
    }

    public int getUnsignedMedium(int index) {
        this.checkIndex(index, 3);
        return this.buffer.getUnsignedMedium(index + this.adjustment);
    }

    public int getInt(int index) {
        this.checkIndex(index, 4);
        return this.buffer.getInt(index + this.adjustment);
    }

    public long getLong(int index) {
        this.checkIndex(index, 8);
        return this.buffer.getLong(index + this.adjustment);
    }

    public ChannelBuffer duplicate() {
        SlicedChannelBuffer duplicate = new SlicedChannelBuffer(this.buffer, this.adjustment, this.length);
        duplicate.setIndex(this.readerIndex(), this.writerIndex());
        return duplicate;
    }

    public ChannelBuffer copy(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.copy(index + this.adjustment, length);
    }

    public ChannelBuffer slice(int index, int length) {
        this.checkIndex(index, length);
        if (length == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        return new SlicedChannelBuffer(this.buffer, index + this.adjustment, length);
    }

    public void getBytes(int index, ChannelBuffer dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.getBytes(index + this.adjustment, dst, dstIndex, length);
    }

    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.getBytes(index + this.adjustment, dst, dstIndex, length);
    }

    public void getBytes(int index, ByteBuffer dst) {
        this.checkIndex(index, dst.remaining());
        this.buffer.getBytes(index + this.adjustment, dst);
    }

    public void setByte(int index, int value) {
        this.checkIndex(index);
        this.buffer.setByte(index + this.adjustment, value);
    }

    public void setShort(int index, int value) {
        this.checkIndex(index, 2);
        this.buffer.setShort(index + this.adjustment, value);
    }

    public void setMedium(int index, int value) {
        this.checkIndex(index, 3);
        this.buffer.setMedium(index + this.adjustment, value);
    }

    public void setInt(int index, int value) {
        this.checkIndex(index, 4);
        this.buffer.setInt(index + this.adjustment, value);
    }

    public void setLong(int index, long value) {
        this.checkIndex(index, 8);
        this.buffer.setLong(index + this.adjustment, value);
    }

    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.setBytes(index + this.adjustment, src, srcIndex, length);
    }

    public void setBytes(int index, ChannelBuffer src, int srcIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.setBytes(index + this.adjustment, src, srcIndex, length);
    }

    public void setBytes(int index, ByteBuffer src) {
        this.checkIndex(index, src.remaining());
        this.buffer.setBytes(index + this.adjustment, src);
    }

    public void getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndex(index, length);
        this.buffer.getBytes(index + this.adjustment, out, length);
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        this.checkIndex(index, length);
        return this.buffer.getBytes(index + this.adjustment, out, length);
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        this.checkIndex(index, length);
        return this.buffer.setBytes(index + this.adjustment, in, length);
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.checkIndex(index, length);
        return this.buffer.setBytes(index + this.adjustment, in, length);
    }

    public ByteBuffer toByteBuffer(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.toByteBuffer(index + this.adjustment, length);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.capacity()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + ", maximum is " + this.capacity());
        }
    }

    private void checkIndex(int startIndex, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length is negative: " + length);
        }
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException("startIndex cannot be negative");
        }
        if (startIndex + length > this.capacity()) {
            throw new IndexOutOfBoundsException("Index too big - Bytes needed: " + (startIndex + length) + ", maximum is " + this.capacity());
        }
    }
}

