/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.generator;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.generator.BodyChunk;

public final class PushBody
implements Body {
    private final Queue<BodyChunk> queue;
    private Body.BodyState state = Body.BodyState.CONTINUE;

    public PushBody(Queue<BodyChunk> queue) {
        this.queue = queue;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public Body.BodyState transferTo(ByteBuf target) throws IOException {
        switch (this.state) {
            case CONTINUE: {
                return this.readNextChunk(target);
            }
            case STOP: {
                return Body.BodyState.STOP;
            }
        }
        throw new IllegalStateException("Illegal process state.");
    }

    private Body.BodyState readNextChunk(ByteBuf target) throws IOException {
        Body.BodyState res = Body.BodyState.SUSPEND;
        while (target.isWritable() && this.state != Body.BodyState.STOP) {
            BodyChunk nextChunk = this.queue.peek();
            if (nextChunk == null) {
                return res;
            }
            if (!nextChunk.buffer.hasRemaining() && !nextChunk.last) {
                this.queue.remove();
                continue;
            }
            res = Body.BodyState.CONTINUE;
            this.readChunk(target, nextChunk);
        }
        return res;
    }

    private void readChunk(ByteBuf target, BodyChunk part) {
        this.move(target, part.buffer);
        if (!part.buffer.hasRemaining()) {
            if (part.last) {
                this.state = Body.BodyState.STOP;
            }
            this.queue.remove();
        }
    }

    private void move(ByteBuf target, ByteBuffer source) {
        int size = Math.min(target.writableBytes(), source.remaining());
        if (size > 0) {
            ByteBuffer slice = source.slice();
            slice.limit(size);
            target.writeBytes(slice);
            source.position(source.position() + size);
        }
    }

    @Override
    public void close() {
    }
}

