/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import org.apache.hadoop.mapred.Counters;

public class MapRedStats {
    int numMap;
    int numReduce;
    long cpuMSec;
    Counters counters = null;
    boolean success;
    String jobId;

    public MapRedStats(int numMap, int numReduce, long cpuMSec, boolean ifSuccess, String jobId) {
        this.numMap = numMap;
        this.numReduce = numReduce;
        this.cpuMSec = cpuMSec;
        this.success = ifSuccess;
        this.jobId = jobId;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public long getCpuMSec() {
        return this.cpuMSec;
    }

    public int getNumMap() {
        return this.numMap;
    }

    public void setNumMap(int numMap) {
        this.numMap = numMap;
    }

    public int getNumReduce() {
        return this.numReduce;
    }

    public void setNumReduce(int numReduce) {
        this.numReduce = numReduce;
    }

    public void setCounters(Counters taskCounters) {
        this.counters = taskCounters;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public void setCpuMSec(long cpuMSec) {
        this.cpuMSec = cpuMSec;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.numMap > 0) {
            sb.append("Map: " + this.numMap + "  ");
        }
        if (this.numReduce > 0) {
            sb.append("Reduce: " + this.numReduce + "  ");
        }
        if (this.cpuMSec > 0L) {
            sb.append(" Accumulative CPU: " + (double)this.cpuMSec / 1000.0 + " sec  ");
        }
        if (this.counters != null) {
            long hdfsWritten;
            Counters.Counter hdfsWrittenCntr;
            long hdfsRead;
            Counters.Counter hdfsReadCntr = this.counters.findCounter("FileSystemCounters", "HDFS_BYTES_READ");
            if (hdfsReadCntr != null && (hdfsRead = hdfsReadCntr.getValue()) >= 0L) {
                sb.append(" HDFS Read: " + hdfsRead);
            }
            if ((hdfsWrittenCntr = this.counters.findCounter("FileSystemCounters", "HDFS_BYTES_WRITTEN")) != null && (hdfsWritten = hdfsWrittenCntr.getValue()) >= 0L) {
                sb.append(" HDFS Write: " + hdfsWritten);
            }
        }
        sb.append(" " + (this.success ? "SUCESS" : "FAIL"));
        return sb.toString();
    }
}

