/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ppd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.ppd.ExprWalkerInfo;
import org.apache.hadoop.hive.ql.ppd.ExprWalkerProcFactory;
import org.apache.hadoop.hive.ql.ppd.OpWalkerInfo;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.mapred.JobConf;

public final class OpProcFactory {
    protected static final Log LOG = LogFactory.getLog((String)OpProcFactory.class.getName());

    protected static Object createFilter(Operator op, ExprWalkerInfo pushDownPreds, OpWalkerInfo owi) {
        HiveConf hiveConf;
        boolean pushFilterToStorage;
        if (pushDownPreds == null || pushDownPreds.getFinalCandidates() == null || pushDownPreds.getFinalCandidates().size() == 0) {
            return null;
        }
        RowResolver inputRR = owi.getRowResolver(op);
        List<ExprNodeDesc> preds2 = null;
        ExprNodeDesc condn = null;
        for (List<ExprNodeDesc> preds2 : pushDownPreds.getFinalCandidates().values()) {
            int i = 0;
            if (condn == null) {
                condn = preds2.get(0);
                ++i;
            }
            while (i < preds2.size()) {
                ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>(2);
                children.add(condn);
                children.add(preds2.get(i));
                condn = new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), children);
                ++i;
            }
        }
        if (condn == null) {
            return null;
        }
        if (op instanceof TableScanOperator && (pushFilterToStorage = (hiveConf = owi.getParseContext().getConf()).getBoolVar(HiveConf.ConfVars.HIVEOPTPPD_STORAGE)) && (condn = OpProcFactory.pushFilterToStorageHandler((TableScanOperator)op, condn, owi, hiveConf)) == null) {
            return null;
        }
        List<Operator<? extends Serializable>> originalChilren = op.getChildOperators();
        op.setChildOperators(null);
        Operator<FilterDesc> output = OperatorFactory.getAndMakeChild(new FilterDesc(condn, false), new RowSchema(inputRR.getColumnInfos()), op);
        output.setChildOperators(originalChilren);
        for (Operator<? extends Serializable> ch : originalChilren) {
            List<Operator<Serializable>> parentOperators = ch.getParentOperators();
            int pos = parentOperators.indexOf(op);
            assert (pos != -1);
            parentOperators.remove(pos);
            parentOperators.add(pos, output);
        }
        OpParseContext ctx = new OpParseContext(inputRR);
        owi.put(output, ctx);
        if (HiveConf.getBoolVar(owi.getParseContext().getConf(), HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS)) {
            for (FilterOperator fop : owi.getCandidateFilterOps()) {
                List<Operator<Serializable>> children = fop.getChildOperators();
                List<Operator<Serializable>> parents = fop.getParentOperators();
                for (Operator<Serializable> parent : parents) {
                    parent.getChildOperators().addAll(children);
                    parent.removeChild(fop);
                }
                for (Operator<Serializable> child : children) {
                    child.getParentOperators().addAll(parents);
                    child.removeParent(fop);
                }
            }
            owi.getCandidateFilterOps().clear();
        }
        return output;
    }

    private static ExprNodeDesc pushFilterToStorageHandler(TableScanOperator tableScanOp, ExprNodeDesc originalPredicate, OpWalkerInfo owi, HiveConf hiveConf) {
        TableScanDesc tableScanDesc = (TableScanDesc)tableScanOp.getConf();
        Table tbl = owi.getParseContext().getTopToTable().get(tableScanOp);
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTINDEXFILTER)) {
            tableScanDesc.setFilterExpr(originalPredicate);
        }
        if (!tbl.isNonNative()) {
            return originalPredicate;
        }
        HiveStorageHandler storageHandler = tbl.getStorageHandler();
        if (!(storageHandler instanceof HiveStoragePredicateHandler)) {
            tableScanDesc.setFilterExpr(originalPredicate);
            return originalPredicate;
        }
        HiveStoragePredicateHandler predicateHandler = (HiveStoragePredicateHandler)((Object)storageHandler);
        JobConf jobConf = new JobConf((Configuration)owi.getParseContext().getConf());
        Utilities.setColumnNameList(jobConf, tableScanOp);
        Utilities.copyTableJobPropertiesToConf(Utilities.getTableDesc(tbl), jobConf);
        Deserializer deserializer = tbl.getDeserializer();
        HiveStoragePredicateHandler.DecomposedPredicate decomposed = predicateHandler.decomposePredicate(jobConf, deserializer, originalPredicate);
        if (decomposed == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No pushdown possible for predicate:  " + originalPredicate.getExprString()));
            }
            return originalPredicate;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Original predicate:  " + originalPredicate.getExprString()));
            if (decomposed.pushedPredicate != null) {
                LOG.debug((Object)("Pushed predicate:  " + decomposed.pushedPredicate.getExprString()));
            }
            if (decomposed.residualPredicate != null) {
                LOG.debug((Object)("Residual predicate:  " + decomposed.residualPredicate.getExprString()));
            }
        }
        tableScanDesc.setFilterExpr(decomposed.pushedPredicate);
        return decomposed.residualPredicate;
    }

    public static NodeProcessor getFilterProc() {
        return new FilterPPD();
    }

    public static NodeProcessor getJoinProc() {
        return new JoinPPD();
    }

    public static NodeProcessor getRSProc() {
        return new ReduceSinkPPD();
    }

    public static NodeProcessor getTSProc() {
        return new TableScanPPD();
    }

    public static NodeProcessor getDefaultProc() {
        return new DefaultPPD();
    }

    public static NodeProcessor getSCRProc() {
        return new ScriptPPD();
    }

    public static NodeProcessor getLIMProc() {
        return new ScriptPPD();
    }

    public static NodeProcessor getUDTFProc() {
        return new UDTFPPD();
    }

    public static NodeProcessor getLVFProc() {
        return new LateralViewForwardPPD();
    }

    private OpProcFactory() {
    }

    public static class DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            boolean hasUnpushedPredicates = this.mergeWithChildrenPred(nd, owi, null, null, false);
            if (HiveConf.getBoolVar(owi.getParseContext().getConf(), HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS) && hasUnpushedPredicates) {
                ExprWalkerInfo unpushedPreds = this.mergeChildrenPred(nd, owi, null, false);
                return OpProcFactory.createFilter((Operator)nd, unpushedPreds, owi);
            }
            return null;
        }

        protected void logExpr(Node nd, ExprWalkerInfo ewi) {
            for (Map.Entry<String, List<ExprNodeDesc>> e : ewi.getFinalCandidates().entrySet()) {
                LOG.info((Object)("Pushdown Predicates of " + nd.getName() + " For Alias : " + e.getKey()));
                for (ExprNodeDesc n : e.getValue()) {
                    LOG.info((Object)("\t" + n.getExprString()));
                }
            }
        }

        protected boolean mergeWithChildrenPred(Node nd, OpWalkerInfo owi, ExprWalkerInfo ewi, Set<String> aliases, boolean ignoreAliases) throws SemanticException {
            boolean hasUnpushedPredicates = false;
            if (nd.getChildren() == null || nd.getChildren().size() > 1) {
                return hasUnpushedPredicates;
            }
            Operator op = (Operator)nd;
            ExprWalkerInfo childPreds = owi.getPrunedPreds((Operator)nd.getChildren().get(0));
            if (childPreds == null) {
                return hasUnpushedPredicates;
            }
            if (ewi == null) {
                ewi = new ExprWalkerInfo();
            }
            for (Map.Entry<String, List<ExprNodeDesc>> e : childPreds.getFinalCandidates().entrySet()) {
                if (!ignoreAliases && aliases != null && !aliases.contains(e.getKey()) && e.getKey() != null) continue;
                ExprWalkerInfo extractPushdownPreds = ExprWalkerProcFactory.extractPushdownPreds(owi, (Operator<? extends Serializable>)op, e.getValue());
                if (!extractPushdownPreds.getNonFinalCandidates().isEmpty()) {
                    hasUnpushedPredicates = true;
                }
                ewi.merge(extractPushdownPreds);
                this.logExpr(nd, extractPushdownPreds);
            }
            owi.putPrunedPreds((Operator)nd, ewi);
            return hasUnpushedPredicates;
        }

        protected ExprWalkerInfo mergeChildrenPred(Node nd, OpWalkerInfo owi, Set<String> excludedAliases, boolean ignoreAliases) throws SemanticException {
            if (nd.getChildren() == null) {
                return null;
            }
            Operator op = (Operator)nd;
            ExprWalkerInfo ewi = new ExprWalkerInfo();
            for (Operator<Serializable> child : op.getChildOperators()) {
                ExprWalkerInfo childPreds = owi.getPrunedPreds(child);
                if (childPreds == null) continue;
                for (Map.Entry<String, List<ExprNodeDesc>> e : childPreds.getFinalCandidates().entrySet()) {
                    if (!ignoreAliases && excludedAliases != null && excludedAliases.contains(e.getKey()) && e.getKey() != null) continue;
                    ewi.addPushDowns(e.getKey(), e.getValue());
                    this.logExpr(nd, ewi);
                }
            }
            return ewi;
        }
    }

    public static class ReduceSinkPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            Set<String> aliases = owi.getRowResolver(nd).getTableNames();
            boolean ignoreAliases = false;
            if (aliases.size() == 1 && aliases.contains("")) {
                ignoreAliases = true;
            }
            this.mergeWithChildrenPred(nd, owi, null, aliases, ignoreAliases);
            return null;
        }
    }

    public static class JoinPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            Set<String> aliases = this.getQualifiedAliases((JoinOperator)nd, owi.getRowResolver(nd));
            boolean hasUnpushedPredicates = this.mergeWithChildrenPred(nd, owi, null, null, false);
            ExprWalkerInfo prunePreds = owi.getPrunedPreds((Operator)nd);
            if (prunePreds != null) {
                HashSet<String> toRemove = new HashSet<String>();
                for (String key : prunePreds.getFinalCandidates().keySet()) {
                    if (aliases.contains(key)) continue;
                    toRemove.add(key);
                }
                for (String alias : toRemove) {
                    for (ExprNodeDesc expr : prunePreds.getFinalCandidates().get(alias)) {
                        prunePreds.addAlias(expr, alias);
                        prunePreds.addNonFinalCandidate(expr);
                    }
                    prunePreds.getFinalCandidates().remove(alias);
                }
                if (HiveConf.getBoolVar(owi.getParseContext().getConf(), HiveConf.ConfVars.HIVEPPDRECOGNIZETRANSITIVITY)) {
                    this.applyFilterTransitivity((JoinOperator)nd, owi);
                }
                if (HiveConf.getBoolVar(owi.getParseContext().getConf(), HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS)) {
                    ExprWalkerInfo unpushedPreds = new ExprWalkerInfo();
                    for (Map.Entry<String, List<ExprNodeDesc>> entry : prunePreds.getNonFinalCandidates().entrySet()) {
                        for (ExprNodeDesc expr : entry.getValue()) {
                            assert (prunePreds.getNewToOldExprMap().containsKey(expr));
                            ExprNodeDesc oldExpr = prunePreds.getNewToOldExprMap().get(expr);
                            unpushedPreds.addAlias(oldExpr, entry.getKey());
                            unpushedPreds.addFinalCandidate(oldExpr);
                        }
                    }
                    return OpProcFactory.createFilter((Operator)nd, unpushedPreds, owi);
                }
            }
            return null;
        }

        private void applyFilterTransitivity(JoinOperator nd, OpWalkerInfo owi) throws SemanticException {
            ExprWalkerInfo prunePreds = owi.getPrunedPreds(nd);
            if (prunePreds != null) {
                HashMap<String, RowResolver> aliasToRR = new HashMap<String, RowResolver>();
                for (Operator<Serializable> o : nd.getParentOperators()) {
                    for (String alias : owi.getRowResolver(o).getTableNames()) {
                        aliasToRR.put(alias, owi.getRowResolver(o));
                    }
                }
                ArrayList<ArrayList<ASTNode>> eqExpressions = owi.getParseContext().getJoinContext().get(nd).getExpressions();
                int numColumns = eqExpressions.size();
                int numEqualities = eqExpressions.get(0).size();
                JoinCondDesc[] joins = ((JoinDesc)nd.getConf()).getConds();
                Map<String, List<ExprNodeDesc>> oldFilters = prunePreds.getFinalCandidates();
                HashMap newFilters = new HashMap();
                for (int i = 0; i < numEqualities; ++i) {
                    int j;
                    ColumnInfo[] equalColumns = new ColumnInfo[numColumns];
                    for (j = 0; j < numColumns; ++j) {
                        equalColumns[j] = this.getColumnInfoFromAST(eqExpressions.get(j).get(i), aliasToRR);
                    }
                    for (j = 0; j < numColumns; ++j) {
                        for (int k = 0; k < numColumns; ++k) {
                            if (j == k || equalColumns[j] == null || equalColumns[k] == null) continue;
                            ColumnInfo left = equalColumns[j];
                            ColumnInfo right = equalColumns[k];
                            if (oldFilters.get(left.getTabAlias()) == null) continue;
                            for (ExprNodeDesc expr : oldFilters.get(left.getTabAlias())) {
                                HashSet<String> colsreferenced = new HashSet<String>(expr.getCols());
                                if (colsreferenced.size() != 1 || !colsreferenced.contains(left.getInternalName())) continue;
                                ExprNodeDesc newexpr = expr.clone();
                                this.replaceColumnReference(newexpr, left.getInternalName(), right.getInternalName());
                                if (newFilters.get(right.getTabAlias()) == null) {
                                    newFilters.put(right.getTabAlias(), new ArrayList());
                                }
                                ((List)newFilters.get(right.getTabAlias())).add(newexpr);
                            }
                        }
                    }
                }
                for (Map.Entry aliasToFilters : newFilters.entrySet()) {
                    owi.getPrunedPreds(nd).addPushDowns((String)aliasToFilters.getKey(), (List)aliasToFilters.getValue());
                }
            }
        }

        private ColumnInfo getColumnInfoFromAST(ASTNode nd, Map<String, RowResolver> aliastoRR) throws SemanticException {
            if (nd.getType() == 310 && nd.getChildCount() == 2 && nd.getChild(0).getType() == 20 && nd.getChild(0).getChildCount() == 1 && nd.getChild(1).getType() == 261) {
                String alias = BaseSemanticAnalyzer.unescapeIdentifier(nd.getChild(0).getChild(0).getText().toLowerCase());
                String column = BaseSemanticAnalyzer.unescapeIdentifier(nd.getChild(1).getText().toLowerCase());
                RowResolver rr = aliastoRR.get(alias);
                if (rr == null) {
                    return null;
                }
                return rr.get(alias, column);
            }
            return null;
        }

        private void replaceColumnReference(ExprNodeDesc expr, String oldColumn, String newColumn) {
            if (expr instanceof ExprNodeColumnDesc && ((ExprNodeColumnDesc)expr).getColumn().equals(oldColumn)) {
                ((ExprNodeColumnDesc)expr).setColumn(newColumn);
            }
            if (expr.getChildren() != null) {
                for (ExprNodeDesc childexpr : expr.getChildren()) {
                    this.replaceColumnReference(childexpr, oldColumn, newColumn);
                }
            }
        }

        private Set<String> getQualifiedAliases(JoinOperator op, RowResolver rr) {
            int i;
            HashSet<String> aliases = new HashSet<String>();
            JoinCondDesc[] conds = ((JoinDesc)op.getConf()).getConds();
            Map<Integer, Set<String>> posToAliasMap = op.getPosToAliasMap();
            for (i = conds.length - 1; i >= 0; --i) {
                if (conds[i].getType() == 0) {
                    aliases.addAll((Collection<String>)posToAliasMap.get(i + 1));
                    continue;
                }
                if (conds[i].getType() == 3) break;
                if (conds[i].getType() == 2) {
                    aliases.addAll((Collection<String>)posToAliasMap.get(i + 1));
                    break;
                }
                if (conds[i].getType() != 1) continue;
            }
            if (i == -1) {
                aliases.addAll((Collection)posToAliasMap.get(0));
            }
            Set<String> aliases2 = rr.getTableNames();
            aliases.retainAll(aliases2);
            return aliases;
        }
    }

    public static class FilterPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            Operator op = (Operator)nd;
            ExprNodeDesc predicate = ((FilterDesc)((FilterOperator)nd).getConf()).getPredicate();
            ExprWalkerInfo ewi = new ExprWalkerInfo();
            if (!((FilterDesc)((FilterOperator)op).getConf()).getIsSamplingPred()) {
                ewi = ExprWalkerProcFactory.extractPushdownPreds(owi, (Operator<? extends Serializable>)op, predicate);
                if (!ewi.isDeterministic()) {
                    if (op.getChildren() != null && ((ArrayList)op.getChildren()).size() == 1) {
                        OpProcFactory.createFilter(op, owi.getPrunedPreds((Operator)((ArrayList)op.getChildren()).get(0)), owi);
                    }
                    return null;
                }
                if (HiveConf.getBoolVar(owi.getParseContext().getConf(), HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS) && ewi.getNonFinalCandidates().values().isEmpty()) {
                    owi.addCandidateFilterOp((FilterOperator)op);
                }
                this.logExpr(nd, ewi);
                owi.putPrunedPreds((Operator)nd, ewi);
            }
            boolean hasUnpushedPredicates = this.mergeWithChildrenPred(nd, owi, ewi, null, false);
            if (HiveConf.getBoolVar(owi.getParseContext().getConf(), HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS) && hasUnpushedPredicates) {
                ExprWalkerInfo unpushedPreds = this.mergeChildrenPred(nd, owi, null, false);
                return OpProcFactory.createFilter((Operator)nd, unpushedPreds, owi);
            }
            return null;
        }
    }

    public static class TableScanPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            TableScanOperator tsOp = (TableScanOperator)nd;
            this.mergeWithChildrenPred(tsOp, owi, null, null, false);
            ExprWalkerInfo pushDownPreds = owi.getPrunedPreds(tsOp);
            return OpProcFactory.createFilter(tsOp, pushDownPreds, owi);
        }
    }

    public static class LateralViewForwardPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            ExprWalkerInfo childPreds = owi.getPrunedPreds((Operator)nd.getChildren().get(0));
            owi.putPrunedPreds((Operator)nd, childPreds);
            return null;
        }
    }

    public static class UDTFPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            return null;
        }
    }

    public static class ScriptPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info((Object)("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")"));
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            if (HiveConf.getBoolVar(owi.getParseContext().getConf(), HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS)) {
                ExprWalkerInfo unpushedPreds = this.mergeChildrenPred(nd, owi, null, false);
                return OpProcFactory.createFilter((Operator)nd, unpushedPreds, owi);
            }
            return null;
        }
    }
}

