/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="day,dayofmonth", value="_FUNC_(date) - Returns the date of the month of date", extended="date is a string in the format of 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'.\nExample:\n   > SELECT _FUNC_('2009-30-07', 1) FROM src LIMIT 1;\n  30")
public class UDFDayOfMonth
extends UDF {
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private final Calendar calendar = Calendar.getInstance();
    private IntWritable result = new IntWritable();

    public IntWritable evaluate(Text dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            Date date = this.formatter.parse(dateString.toString());
            this.calendar.setTime(date);
            this.result.set(this.calendar.get(5));
            return this.result;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public IntWritable evaluate(TimestampWritable t) {
        if (t == null) {
            return null;
        }
        this.calendar.setTime(t.getTimestamp());
        this.result.set(this.calendar.get(5));
        return this.result;
    }
}

