/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ExecMapper;
import org.apache.hadoop.hive.ql.exec.ExecReducer;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.exec.HadoopJobExecHook;
import org.apache.hadoop.hive.ql.exec.JobCloseFeedBack;
import org.apache.hadoop.hive.ql.exec.MapredLocalTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Throttle;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormatImpl;
import org.apache.hadoop.hive.ql.io.IOPrepareCache;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.varia.NullAppender;

public class ExecDriver
extends Task<MapredWork>
implements Serializable,
HadoopJobExecHook {
    private static final long serialVersionUID = 1L;
    protected transient JobConf job;
    public static MemoryMXBean memoryMXBean;
    protected HadoopJobExecHelper jobExecHelper;
    protected static final transient Log LOG;

    public ExecDriver() {
        this.console = new SessionState.LogHelper(LOG);
        this.jobExecHelper = new HadoopJobExecHelper(this.job, this.console, this, this);
    }

    @Override
    public boolean requireLock() {
        return true;
    }

    private void initializeFiles(String prop, String files) {
        if (files != null && files.length() > 0) {
            this.job.set(prop, files);
            ShimLoader.getHadoopShims().setTmpFiles(prop, files);
        }
    }

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext driverContext) {
        String addedArchives;
        String addedJars;
        super.initialize(conf, queryPlan, driverContext);
        this.job = new JobConf((Configuration)conf, ExecDriver.class);
        String addedFiles = Utilities.getResourceFiles((Configuration)this.job, SessionState.ResourceType.FILE);
        if (StringUtils.isNotBlank(addedFiles)) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HIVEADDEDFILES, addedFiles);
        }
        if (StringUtils.isNotBlank(addedJars = Utilities.getResourceFiles((Configuration)this.job, SessionState.ResourceType.JAR))) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HIVEADDEDJARS, addedJars);
        }
        if (StringUtils.isNotBlank(addedArchives = Utilities.getResourceFiles((Configuration)this.job, SessionState.ResourceType.ARCHIVE))) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HIVEADDEDARCHIVES, addedArchives);
        }
        this.jobExecHelper = new HadoopJobExecHelper(this.job, this.console, this, this);
    }

    public ExecDriver(MapredWork plan, JobConf job, boolean isSilent) throws HiveException {
        this.setWork(plan);
        this.job = job;
        this.console = new SessionState.LogHelper(LOG, isSilent);
        this.jobExecHelper = new HadoopJobExecHelper(job, this.console, this, this);
    }

    @Override
    public boolean checkFatalErrors(Counters ctrs, StringBuilder errMsg) {
        for (Operator<? extends Serializable> op : ((MapredWork)this.work).getAliasToWork().values()) {
            if (!op.checkFatalErrors(ctrs, errMsg)) continue;
            return true;
        }
        return ((MapredWork)this.work).getReducer() != null && ((MapredWork)this.work).getReducer().checkFatalErrors(ctrs, errMsg);
    }

    protected void createTmpDirs() throws IOException {
        LinkedHashMap<String, ArrayList<String>> pa = ((MapredWork)this.work).getPathToAliases();
        if (pa != null) {
            ArrayList opList = new ArrayList();
            if (((MapredWork)this.work).getReducer() != null) {
                opList.add(((MapredWork)this.work).getReducer());
            }
            for (ArrayList ls : pa.values()) {
                for (String a : ls) {
                    opList.add(((MapredWork)this.work).getAliasToWork().get(a));
                    while (!opList.isEmpty()) {
                        FileSinkDesc fdesc;
                        String tempDir;
                        Operator op = (Operator)opList.remove(0);
                        if (op instanceof FileSinkOperator && (tempDir = (fdesc = (FileSinkDesc)((FileSinkOperator)op).getConf()).getDirName()) != null) {
                            Path tempPath = Utilities.toTempPath(new Path(tempDir));
                            LOG.info((Object)("Making Temp Directory: " + tempDir));
                            FileSystem fs = tempPath.getFileSystem((Configuration)this.job);
                            fs.mkdirs(tempPath);
                        }
                        if (op.getChildOperators() == null) continue;
                        opList.addAll(op.getChildOperators());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(DriverContext driverContext) {
        int returnVal;
        block44: {
            String mesg;
            String addedArchives;
            String addedFiles;
            String emptyScratchDirStr;
            IOPrepareCache ioPrepareCache = IOPrepareCache.get();
            ioPrepareCache.clear();
            boolean success = true;
            String invalidReason = ((MapredWork)this.work).isInvalid();
            if (invalidReason != null) {
                throw new RuntimeException("Plan invalid, Reason: " + invalidReason);
            }
            Context ctx = driverContext.getCtx();
            boolean ctxCreated = false;
            try {
                if (ctx == null) {
                    ctx = new Context((Configuration)this.job);
                    ctxCreated = true;
                }
                emptyScratchDirStr = ctx.getMRTmpFileURI();
                Path emptyScratchDir = new Path(emptyScratchDirStr);
                FileSystem fs = emptyScratchDir.getFileSystem((Configuration)this.job);
                fs.mkdirs(emptyScratchDir);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.console.printError("Error launching map-reduce job", "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                return 5;
            }
            ShimLoader.getHadoopShims().prepareJobOutput(this.job);
            this.job.setOutputFormat(HiveOutputFormatImpl.class);
            this.job.setMapperClass(ExecMapper.class);
            this.job.setMapOutputKeyClass(HiveKey.class);
            this.job.setMapOutputValueClass(BytesWritable.class);
            try {
                this.job.setPartitionerClass(Class.forName(HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVEPARTITIONER)));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage());
            }
            if (((MapredWork)this.work).getNumMapTasks() != null) {
                this.job.setNumMapTasks(((MapredWork)this.work).getNumMapTasks().intValue());
            }
            if (((MapredWork)this.work).getMaxSplitSize() != null) {
                HiveConf.setLongVar((Configuration)this.job, HiveConf.ConfVars.MAPREDMAXSPLITSIZE, ((MapredWork)this.work).getMaxSplitSize());
            }
            if (((MapredWork)this.work).getMinSplitSize() != null) {
                HiveConf.setLongVar((Configuration)this.job, HiveConf.ConfVars.MAPREDMINSPLITSIZE, ((MapredWork)this.work).getMinSplitSize());
            }
            if (((MapredWork)this.work).getMinSplitSizePerNode() != null) {
                HiveConf.setLongVar((Configuration)this.job, HiveConf.ConfVars.MAPREDMINSPLITSIZEPERNODE, ((MapredWork)this.work).getMinSplitSizePerNode());
            }
            if (((MapredWork)this.work).getMinSplitSizePerRack() != null) {
                HiveConf.setLongVar((Configuration)this.job, HiveConf.ConfVars.MAPREDMINSPLITSIZEPERRACK, ((MapredWork)this.work).getMinSplitSizePerRack());
            }
            this.job.setNumReduceTasks(((MapredWork)this.work).getNumReduceTasks().intValue());
            this.job.setReducerClass(ExecReducer.class);
            this.setInputAttributes((Configuration)this.job);
            boolean useSpeculativeExecReducers = HiveConf.getBoolVar((Configuration)this.job, HiveConf.ConfVars.HIVESPECULATIVEEXECREDUCERS);
            HiveConf.setBoolVar((Configuration)this.job, HiveConf.ConfVars.HADOOPSPECULATIVEEXECREDUCERS, useSpeculativeExecReducers);
            String inpFormat = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVEINPUTFORMAT);
            if (inpFormat == null || !StringUtils.isNotBlank(inpFormat)) {
                inpFormat = ShimLoader.getHadoopShims().getInputFormatClassName();
            }
            LOG.info((Object)("Using " + inpFormat));
            try {
                this.job.setInputFormat(Class.forName(inpFormat));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage());
            }
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            String auxJars = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVEAUXJARS);
            String addedJars = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVEADDEDJARS);
            if (StringUtils.isNotBlank(auxJars) || StringUtils.isNotBlank(addedJars)) {
                String allJars = StringUtils.isNotBlank(auxJars) ? (StringUtils.isNotBlank(addedJars) ? addedJars + "," + auxJars : auxJars) : addedJars;
                LOG.info((Object)("adding libjars: " + allJars));
                this.initializeFiles("tmpjars", allJars);
            }
            if (StringUtils.isNotBlank(addedFiles = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVEADDEDFILES))) {
                this.initializeFiles("tmpfiles", addedFiles);
            }
            returnVal = 0;
            RunningJob rj = null;
            boolean noName = StringUtils.isEmpty(HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HADOOPJOBNAME));
            if (noName) {
                HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HADOOPJOBNAME, "JOB" + Utilities.randGen.nextInt());
            }
            if (StringUtils.isNotBlank(addedArchives = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVEADDEDARCHIVES))) {
                this.initializeFiles("tmparchives", addedArchives);
            }
            try {
                String statsImplementationClass;
                boolean localMode;
                MapredLocalWork localwork = ((MapredWork)this.work).getMapLocalWork();
                if (localwork != null && !(localMode = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HADOOPJT).equals("local"))) {
                    Path localPath = new Path(localwork.getTmpFileURI());
                    Path hdfsPath = new Path(((MapredWork)this.work).getTmpHDFSFileURI());
                    FileSystem hdfs = hdfsPath.getFileSystem((Configuration)this.job);
                    FileSystem localFS = localPath.getFileSystem((Configuration)this.job);
                    FileStatus[] hashtableFiles = localFS.listStatus(localPath);
                    int fileNumber = hashtableFiles.length;
                    String[] fileNames = new String[fileNumber];
                    for (int i = 0; i < fileNumber; ++i) {
                        fileNames[i] = hashtableFiles[i].getPath().getName();
                    }
                    String parentDir = localPath.toUri().getPath();
                    String stageId = this.getId();
                    String archiveFileURI = Utilities.generateTarURI(parentDir, stageId);
                    String archiveFileName = Utilities.generateTarFileName(stageId);
                    localwork.setStageID(stageId);
                    FileUtils.tar(parentDir, fileNames, archiveFileName);
                    Path archivePath = new Path(archiveFileURI);
                    LOG.info((Object)("Archive " + hashtableFiles.length + " hash table files to " + archiveFileURI));
                    String hdfsFile = Utilities.generateTarURI(hdfsPath, stageId);
                    Path hdfsFilePath = new Path(hdfsFile);
                    short replication = (short)this.job.getInt("mapred.submit.replication", 10);
                    hdfs.setReplication(hdfsFilePath, replication);
                    hdfs.copyFromLocalFile(archivePath, hdfsFilePath);
                    LOG.info((Object)("Upload 1 archive file  from" + archivePath + " to: " + hdfsFilePath));
                    DistributedCache.createSymlink((Configuration)this.job);
                    DistributedCache.addCacheArchive((URI)hdfsFilePath.toUri(), (Configuration)this.job);
                    LOG.info((Object)("Add 1 archive file to distributed cache. Archive file: " + hdfsFilePath.toUri()));
                }
                ExecDriver.addInputPaths(this.job, (MapredWork)this.work, emptyScratchDirStr, ctx);
                Utilities.setMapRedWork((Configuration)this.job, (MapredWork)this.work, ctx.getMRTmpFileURI());
                String pwd = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD);
                if (pwd != null) {
                    HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD, "HIVE");
                }
                JobClient jc = new JobClient(this.job);
                Throttle.checkJobTracker(this.job, LOG);
                if (((MapredWork)this.work).isGatheringStats() && StatsFactory.setImplementation(statsImplementationClass = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVESTATSDBCLASS), (Configuration)this.job)) {
                    StatsPublisher statsPublisher = StatsFactory.getStatsPublisher();
                    statsPublisher.init((Configuration)this.job);
                }
                this.createTmpDirs();
                rj = jc.submitJob(this.job);
                if (pwd != null) {
                    HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD, pwd);
                }
                success = (returnVal = this.jobExecHelper.progress(rj, jc)) == 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                mesg = " with exception '" + Utilities.getNameMessage(e) + "'";
                mesg = rj != null ? "Ended Job = " + rj.getJobID() + mesg : "Job Submission failed" + mesg;
                this.console.printError(mesg, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                success = false;
                returnVal = 1;
            }
            finally {
                Utilities.clearMapRedWork((Configuration)this.job);
                try {
                    if (ctxCreated) {
                        ctx.clear();
                    }
                    if (rj != null) {
                        if (returnVal != 0) {
                            rj.killJob();
                        }
                        HadoopJobExecHelper.runningJobKillURIs.remove(rj.getJobID());
                        this.jobID = rj.getID().toString();
                    }
                }
                catch (Exception e) {}
            }
            try {
                if (rj != null) {
                    JobCloseFeedBack feedBack = new JobCloseFeedBack();
                    if (((MapredWork)this.work).getAliasToWork() != null) {
                        for (Operator<? extends Serializable> op : ((MapredWork)this.work).getAliasToWork().values()) {
                            op.jobClose((Configuration)this.job, success, feedBack);
                        }
                    }
                    if (((MapredWork)this.work).getReducer() != null) {
                        ((MapredWork)this.work).getReducer().jobClose((Configuration)this.job, success, feedBack);
                    }
                }
            }
            catch (Exception e) {
                if (!success) break block44;
                success = false;
                returnVal = 3;
                mesg = "Job Commit failed with exception '" + Utilities.getNameMessage(e) + "'";
                this.console.printError(mesg, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            }
        }
        return returnVal;
    }

    protected void setInputAttributes(Configuration conf) {
        if (((MapredWork)this.work).getInputformat() != null) {
            HiveConf.setVar(conf, HiveConf.ConfVars.HIVEINPUTFORMAT, ((MapredWork)this.work).getInputformat());
        }
        if (((MapredWork)this.work).getIndexIntermediateFile() != null) {
            conf.set("hive.index.compact.file", ((MapredWork)this.work).getIndexIntermediateFile());
            conf.set("hive.index.blockfilter.file", ((MapredWork)this.work).getIndexIntermediateFile());
        }
        conf.setBoolean("hive.input.format.sorted", ((MapredWork)this.work).isInputFormatSorted());
    }

    public boolean mapStarted() {
        return this.jobExecHelper.mapStarted();
    }

    public boolean reduceStarted() {
        return this.jobExecHelper.reduceStarted();
    }

    public boolean mapDone() {
        return this.jobExecHelper.mapDone();
    }

    public boolean reduceDone() {
        return this.jobExecHelper.reduceDone();
    }

    private static void printUsage() {
        System.err.println("ExecDriver -plan <plan-file> [-jobconf k1=v1 [-jobconf k2=v2] ...] [-files <file1>[,<file2>] ...]");
        System.exit(1);
    }

    private static void setupChildLog4j(Configuration conf) {
        URL hive_l4j = ExecDriver.class.getClassLoader().getResource("hive-exec-log4j.properties");
        if (hive_l4j == null) {
            hive_l4j = ExecDriver.class.getClassLoader().getResource("hive-log4j.properties");
        }
        if (hive_l4j != null) {
            System.setProperty(HiveConf.ConfVars.HIVEQUERYID.toString(), HiveConf.getVar(conf, HiveConf.ConfVars.HIVEQUERYID));
            LogManager.resetConfiguration();
            PropertyConfigurator.configure((URL)hive_l4j);
        }
    }

    public static void main(String[] args) throws IOException, HiveException {
        int ret;
        String planFileName = null;
        ArrayList<String> jobConfArgs = new ArrayList<String>();
        boolean noLog = false;
        String files = null;
        boolean localtask = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-plan")) {
                    planFileName = args[++i];
                    continue;
                }
                if (args[i].equals("-jobconf")) {
                    jobConfArgs.add(args[++i]);
                    continue;
                }
                if (args[i].equals("-nolog")) {
                    noLog = true;
                    continue;
                }
                if (args[i].equals("-files")) {
                    files = args[++i];
                    continue;
                }
                if (!args[i].equals("-localtask")) continue;
                localtask = true;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Missing argument to option");
            ExecDriver.printUsage();
        }
        JobConf conf = localtask ? new JobConf(MapredLocalTask.class) : new JobConf(ExecDriver.class);
        StringBuilder sb = new StringBuilder("JobConf:\n");
        for (String one : jobConfArgs) {
            int eqIndex = one.indexOf(61);
            if (eqIndex == -1) continue;
            try {
                String key = one.substring(0, eqIndex);
                String value = URLDecoder.decode(one.substring(eqIndex + 1), "UTF-8");
                conf.set(key, value);
                sb.append(key).append("=").append(value).append("\n");
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Unexpected error " + e.getMessage() + " while encoding " + one.substring(eqIndex + 1));
                System.exit(3);
            }
        }
        if (files != null) {
            conf.set("tmpfiles", files);
        }
        boolean isSilent = HiveConf.getBoolVar((Configuration)conf, HiveConf.ConfVars.HIVESESSIONSILENT);
        if (noLog) {
            BasicConfigurator.resetConfiguration();
            BasicConfigurator.configure((Appender)new NullAppender());
        } else {
            ExecDriver.setupChildLog4j((Configuration)conf);
        }
        Log LOG = LogFactory.getLog((String)ExecDriver.class.getName());
        SessionState.LogHelper console = new SessionState.LogHelper(LOG, isSilent);
        if (planFileName == null) {
            console.printError("Must specify Plan File Name");
            ExecDriver.printUsage();
        }
        for (Appender appender : Collections.list(LogManager.getRootLogger().getAllAppenders())) {
            if (!(appender instanceof FileAppender)) continue;
            console.printInfo("Execution log at: " + ((FileAppender)appender).getFile());
        }
        LOG.info((Object)sb.toString());
        Path p = new Path(planFileName);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        FSDataInputStream pathData = fs.open(p);
        String auxJars = HiveConf.getVar((Configuration)conf, HiveConf.ConfVars.HIVEAUXJARS);
        String addedJars = HiveConf.getVar((Configuration)conf, HiveConf.ConfVars.HIVEADDEDJARS);
        try {
            ClassLoader loader = conf.getClassLoader();
            if (StringUtils.isNotBlank(auxJars)) {
                loader = Utilities.addToClassPath(loader, StringUtils.split(auxJars, ","));
            }
            if (StringUtils.isNotBlank(addedJars)) {
                loader = Utilities.addToClassPath(loader, StringUtils.split(addedJars, ","));
            }
            conf.setClassLoader(loader);
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), e);
        }
        if (localtask) {
            memoryMXBean = ManagementFactory.getMemoryMXBean();
            MapredLocalWork plan = Utilities.deserializeMapRedLocalWork((InputStream)pathData, (Configuration)conf);
            MapredLocalTask ed = new MapredLocalTask(plan, conf, isSilent);
            ret = ed.executeFromChildJVM(new DriverContext());
        } else {
            MapredWork plan = Utilities.deserializeMapRedWork((InputStream)pathData, (Configuration)conf);
            ExecDriver ed = new ExecDriver(plan, conf, isSilent);
            ret = ed.execute(new DriverContext());
        }
        if (ret != 0) {
            System.exit(2);
        }
    }

    public static String generateCmdLine(HiveConf hconf) {
        try {
            StringBuilder sb = new StringBuilder();
            Properties deltaP = hconf.getChangedProperties();
            boolean hadoopLocalMode = hconf.getVar(HiveConf.ConfVars.HADOOPJT).equals("local");
            String hadoopSysDir = "mapred.system.dir";
            String hadoopWorkDir = "mapred.local.dir";
            for (Object one : deltaP.keySet()) {
                String oneProp = (String)one;
                if (hadoopLocalMode && (oneProp.equals(hadoopSysDir) || oneProp.equals(hadoopWorkDir))) continue;
                String oneValue = deltaP.getProperty(oneProp);
                sb.append("-jobconf ");
                sb.append(oneProp);
                sb.append("=");
                sb.append(URLEncoder.encode(oneValue, "UTF-8"));
                sb.append(" ");
            }
            if (hadoopLocalMode) {
                sb.append("-jobconf ");
                sb.append(hadoopSysDir);
                sb.append("=");
                sb.append(URLEncoder.encode(hconf.get(hadoopSysDir) + "/" + Utilities.randGen.nextInt(), "UTF-8"));
                sb.append(" ");
                sb.append("-jobconf ");
                sb.append(hadoopWorkDir);
                sb.append("=");
                sb.append(URLEncoder.encode(hconf.get(hadoopWorkDir) + "/" + Utilities.randGen.nextInt(), "UTF-8"));
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isMapRedTask() {
        return true;
    }

    @Override
    public Collection<Operator<? extends Serializable>> getTopOperators() {
        return ((MapredWork)this.getWork()).getAliasToWork().values();
    }

    @Override
    public boolean hasReduce() {
        MapredWork w = (MapredWork)this.getWork();
        return w.getReducer() != null;
    }

    private static int addInputPath(String path, JobConf job, MapredWork work, String hiveScratchDir, int numEmptyPaths, boolean isEmptyPath, String alias) throws Exception {
        Properties props;
        assert (path == null || isEmptyPath);
        Class<? extends HiveOutputFormat> outFileFormat = null;
        boolean nonNative = true;
        if (isEmptyPath) {
            PartitionDesc partDesc = work.getPathToPartitionInfo().get(path);
            props = partDesc.getProperties();
            outFileFormat = partDesc.getOutputFileFormatClass();
            nonNative = partDesc.getTableDesc().isNonNative();
        } else {
            TableDesc tableDesc = work.getAliasToPartnInfo().get(alias).getTableDesc();
            props = tableDesc.getProperties();
            outFileFormat = tableDesc.getOutputFileFormatClass();
            nonNative = tableDesc.isNonNative();
        }
        if (nonNative) {
            FileInputFormat.addInputPaths((JobConf)job, (String)path);
            LOG.info((Object)("Add a non-native table " + path));
            return numEmptyPaths;
        }
        String newDir = hiveScratchDir + File.separator + ++numEmptyPaths;
        Path newPath = new Path(newDir);
        FileSystem fs = newPath.getFileSystem((Configuration)job);
        fs.mkdirs(newPath);
        newPath = fs.makeQualified(newPath);
        String newFile = newDir + File.separator + "emptyFile";
        Path newFilePath = new Path(newFile);
        LOG.info((Object)("Changed input file to " + newPath.toString()));
        LinkedHashMap<String, ArrayList<String>> pathToAliases = work.getPathToAliases();
        if (isEmptyPath) {
            assert (path != null);
            pathToAliases.put(newPath.toUri().toString(), pathToAliases.get(path));
            pathToAliases.remove(path);
        } else {
            assert (path == null);
            ArrayList<String> newList = new ArrayList<String>();
            newList.add(alias);
            pathToAliases.put(newPath.toUri().toString(), newList);
        }
        work.setPathToAliases(pathToAliases);
        LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = work.getPathToPartitionInfo();
        if (isEmptyPath) {
            pathToPartitionInfo.put(newPath.toUri().toString(), pathToPartitionInfo.get(path));
            pathToPartitionInfo.remove(path);
        } else {
            PartitionDesc pDesc = work.getAliasToPartnInfo().get(alias).clone();
            pathToPartitionInfo.put(newPath.toUri().toString(), pDesc);
        }
        work.setPathToPartitionInfo(pathToPartitionInfo);
        String onefile = newPath.toString();
        FileSinkOperator.RecordWriter recWriter = outFileFormat.newInstance().getHiveRecordWriter(job, newFilePath, Text.class, false, props, null);
        recWriter.close(false);
        FileInputFormat.addInputPaths((JobConf)job, (String)onefile);
        return numEmptyPaths;
    }

    public static void addInputPaths(JobConf job, MapredWork work, String hiveScratchDir, Context ctx) throws Exception {
        int numEmptyPaths = 0;
        HashSet<String> pathsProcessed = new HashSet<String>();
        LinkedList<String> pathsToAdd = new LinkedList<String>();
        for (String oneAlias : work.getAliasToWork().keySet()) {
            LOG.info((Object)("Processing alias " + oneAlias));
            ArrayList<String> emptyPaths = new ArrayList<String>();
            String path = null;
            for (String onefile : work.getPathToAliases().keySet()) {
                List aliases = work.getPathToAliases().get(onefile);
                if (!aliases.contains(oneAlias) || pathsProcessed.contains(path = onefile)) continue;
                pathsProcessed.add(path);
                LOG.info((Object)("Adding input file " + path));
                if (Utilities.isEmptyPath(job, path, ctx)) {
                    emptyPaths.add(path);
                    continue;
                }
                pathsToAdd.add(path);
            }
            for (String emptyPath : emptyPaths) {
                numEmptyPaths = ExecDriver.addInputPath(emptyPath, job, work, hiveScratchDir, numEmptyPaths, true, oneAlias);
            }
            if (path != null) continue;
            numEmptyPaths = ExecDriver.addInputPath(null, job, work, hiveScratchDir, numEmptyPaths, false, oneAlias);
        }
        ExecDriver.setInputPaths(job, pathsToAdd);
    }

    private static void setInputPaths(JobConf job, List<String> pathsToAdd) {
        Path[] addedPaths = FileInputFormat.getInputPaths((JobConf)job);
        ArrayList<Path> toAddPathList = new ArrayList<Path>();
        if (addedPaths != null) {
            for (Path added : addedPaths) {
                toAddPathList.add(added);
            }
        }
        for (String toAdd : pathsToAdd) {
            toAddPathList.add(new Path(toAdd));
        }
        FileInputFormat.setInputPaths((JobConf)job, (Path[])toAddPathList.toArray(new Path[0]));
    }

    @Override
    public StageType getType() {
        return StageType.MAPRED;
    }

    @Override
    public String getName() {
        return "MAPRED";
    }

    @Override
    protected void localizeMRTmpFilesImpl(Context ctx) {
        LinkedHashMap<String, ArrayList<String>> pa;
        LinkedHashMap<String, FetchWork> m;
        ctx.localizeKeys((Map<String, Object>)((MapredWork)this.work).getPathToAliases());
        ctx.localizeKeys((Map<String, Object>)((MapredWork)this.work).getPathToPartitionInfo());
        MapredLocalWork l = ((MapredWork)this.work).getMapLocalWork();
        if (l != null && (m = l.getAliasToFetchWork()) != null) {
            for (FetchWork fw : m.values()) {
                String s = fw.getTblDir();
                if (s == null || !ctx.isMRTmpFileURI(s)) continue;
                fw.setTblDir(ctx.localizeMRTmpFileURI(s));
            }
        }
        if ((pa = ((MapredWork)this.work).getPathToAliases()) != null) {
            for (ArrayList ls : pa.values()) {
                for (String a : ls) {
                    ArrayList<Operator<? extends Serializable>> opList = new ArrayList<Operator<? extends Serializable>>();
                    opList.add(((MapredWork)this.work).getAliasToWork().get(a));
                    while (!opList.isEmpty()) {
                        Operator op = (Operator)opList.remove(0);
                        if (op instanceof FileSinkOperator) {
                            FileSinkDesc fdesc = (FileSinkDesc)((FileSinkOperator)op).getConf();
                            String s = fdesc.getDirName();
                            if (s != null && ctx.isMRTmpFileURI(s)) {
                                fdesc.setDirName(ctx.localizeMRTmpFileURI(s));
                            }
                            ((FileSinkOperator)op).setConf(fdesc);
                        }
                        if (op.getChildOperators() == null) continue;
                        opList.addAll(op.getChildOperators());
                    }
                }
            }
        }
    }

    @Override
    public void updateCounters(Counters ctrs, RunningJob rj) throws IOException {
        for (Operator<? extends Serializable> op : ((MapredWork)this.work).getAliasToWork().values()) {
            op.updateCounters(ctrs);
        }
        if (((MapredWork)this.work).getReducer() != null) {
            ((MapredWork)this.work).getReducer().updateCounters(ctrs);
        }
    }

    @Override
    public void logPlanProgress(SessionState ss) throws IOException {
        ss.getHiveHistory().logPlanProgress(this.queryPlan);
    }

    static {
        LOG = LogFactory.getLog(ExecDriver.class);
    }
}

