/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.JobTrackerURLResolver;
import org.apache.hadoop.hive.ql.exec.errors.ErrorAndSolution;
import org.apache.hadoop.hive.ql.exec.errors.TaskLogProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;

public class JobDebugger
implements Runnable {
    private final JobConf conf;
    private final RunningJob rj;
    private final SessionState.LogHelper console;
    private final Map<String, List<List<String>>> stackTraces;
    private final Map<String, Integer> failures = new HashMap<String, Integer>();
    private final Set<String> successes = new HashSet<String>();
    private final Map<String, TaskInfo> taskIdToInfo = new HashMap<String, TaskInfo>();

    public JobDebugger(JobConf conf, RunningJob rj, SessionState.LogHelper console) {
        this.conf = conf;
        this.rj = rj;
        this.console = console;
        this.stackTraces = null;
    }

    public JobDebugger(JobConf conf, RunningJob rj, SessionState.LogHelper console, Map<String, List<List<String>>> stackTraces) {
        this.conf = conf;
        this.rj = rj;
        this.console = console;
        this.stackTraces = stackTraces;
    }

    @Override
    public void run() {
        try {
            this.showJobFailDebugInfo();
        }
        catch (IOException e) {
            this.console.printError(e.getMessage());
        }
    }

    private String getTaskAttemptLogUrl(String taskTrackerHttpAddress, String taskAttemptId) {
        return taskTrackerHttpAddress + "/tasklog?taskid=" + taskAttemptId + "&start=-8193";
    }

    private void showJobFailDebugInfo() throws IOException {
        this.console.printError("Error during job, obtaining debugging information...");
        TaskLogGrabber tlg = new TaskLogGrabber();
        Thread t = new Thread(tlg);
        try {
            t.start();
            t.join(HiveConf.getIntVar((Configuration)this.conf, HiveConf.ConfVars.TASKLOG_DEBUG_TIMEOUT));
        }
        catch (InterruptedException e) {
            this.console.printError("Timed out trying to finish grabbing task log URLs, some task info may be missing");
        }
        for (String task : this.successes) {
            this.failures.remove(task);
        }
        if (this.failures.keySet().size() == 0) {
            return;
        }
        int maxFailures = 0;
        for (Integer failCount : this.failures.values()) {
            if (maxFailures >= failCount) continue;
            maxFailures = failCount;
        }
        String jtUrl = JobTrackerURLResolver.getURL(this.conf);
        for (String task : this.failures.keySet()) {
            if (this.failures.get(task) != maxFailures) continue;
            TaskInfo ti = this.taskIdToInfo.get(task);
            String jobId = ti.getJobId();
            String taskUrl = jtUrl + "/taskdetails.jsp?jobid=" + jobId + "&tipid=" + task.toString();
            TaskLogProcessor tlp = new TaskLogProcessor(this.conf);
            for (String logUrl : ti.getLogUrls()) {
                tlp.addTaskAttemptLogUrl(logUrl);
            }
            if (HiveConf.getBoolVar((Configuration)this.conf, HiveConf.ConfVars.JOB_DEBUG_CAPTURE_STACKTRACES) && this.stackTraces != null) {
                if (!this.stackTraces.containsKey(jobId)) {
                    this.stackTraces.put(jobId, new ArrayList());
                }
                this.stackTraces.get(jobId).addAll(tlp.getStackTraces());
            }
            if (!HiveConf.getBoolVar((Configuration)this.conf, HiveConf.ConfVars.SHOW_JOB_FAIL_DEBUG_INFO)) break;
            List<ErrorAndSolution> errors = tlp.getErrors();
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append("Task with the most failures(" + maxFailures + "): \n");
            sb.append("-----\n");
            sb.append("Task ID:\n  " + task + "\n\n");
            sb.append("URL:\n  " + taskUrl + "\n");
            for (ErrorAndSolution e : errors) {
                sb.append("\n");
                sb.append("Possible error:\n  " + e.getError() + "\n\n");
                sb.append("Solution:\n  " + e.getSolution() + "\n");
            }
            sb.append("-----\n");
            this.console.printError(sb.toString());
            break;
        }
    }

    class TaskLogGrabber
    implements Runnable {
        TaskLogGrabber() {
        }

        @Override
        public void run() {
            try {
                this.getTaskLogs();
            }
            catch (IOException e) {
                JobDebugger.this.console.printError(e.getMessage());
            }
        }

        private void getTaskLogs() throws IOException {
            TaskCompletionEvent[] taskCompletions;
            int startIndex = 0;
            while ((taskCompletions = JobDebugger.this.rj.getTaskCompletionEvents(startIndex)) != null && taskCompletions.length != 0) {
                boolean more = true;
                boolean firstError = true;
                for (TaskCompletionEvent t : taskCompletions) {
                    TaskInfo ti;
                    String[] taskJobIds = ShimLoader.getHadoopShims().getTaskJobIDs(t);
                    if (taskJobIds == null) {
                        JobDebugger.this.console.printError("Task attempt info is unavailable in this Hadoop version");
                        more = false;
                        break;
                    }
                    String taskId = taskJobIds[0];
                    String jobId = taskJobIds[1];
                    if (firstError) {
                        JobDebugger.this.console.printError("Examining task ID: " + taskId + " (and more) from job " + jobId);
                        firstError = false;
                    }
                    if ((ti = (TaskInfo)JobDebugger.this.taskIdToInfo.get(taskId)) == null) {
                        ti = new TaskInfo(jobId);
                        JobDebugger.this.taskIdToInfo.put(taskId, ti);
                    }
                    assert (ti.getJobId() != null && ti.getJobId().equals(jobId));
                    ti.getLogUrls().add(JobDebugger.this.getTaskAttemptLogUrl(t.getTaskTrackerHttp(), t.getTaskId()));
                    if (t.getTaskStatus() != TaskCompletionEvent.Status.SUCCEEDED) {
                        Integer failAttempts = (Integer)JobDebugger.this.failures.get(taskId);
                        if (failAttempts == null) {
                            failAttempts = 0;
                        }
                        failAttempts = failAttempts + 1;
                        JobDebugger.this.failures.put(taskId, failAttempts);
                        continue;
                    }
                    JobDebugger.this.successes.add(taskId);
                }
                if (!more) break;
                startIndex += taskCompletions.length;
            }
        }
    }

    private static class TaskInfo {
        String jobId;
        Set<String> logUrls;

        public TaskInfo(String jobId) {
            this.jobId = jobId;
            this.logUrls = new HashSet<String>();
        }

        public void addLogUrl(String logUrl) {
            this.logUrls.add(logUrl);
        }

        public Set<String> getLogUrls() {
            return this.logUrls;
        }

        public String getJobId() {
            return this.jobId;
        }
    }
}

