/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.BucketMatcher;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;

public class SMBMapJoinOperator
extends AbstractMapJoinOperator<SMBJoinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)SMBMapJoinOperator.class.getName());
    private MapredLocalWork localWork = null;
    private Map<String, FetchOperator> fetchOperators;
    transient ArrayList<Object>[] keyWritables;
    transient ArrayList<Object>[] nextKeyWritables;
    RowContainer<ArrayList<Object>>[] nextGroupStorage;
    RowContainer<ArrayList<Object>>[] candidateStorage;
    transient Map<Byte, String> tagToAlias;
    private transient boolean[] fetchOpDone;
    private transient boolean[] foundNextKeyGroup;
    transient boolean firstFetchHappened = false;
    private transient boolean inputFileChanged = false;
    transient boolean localWorkInited = false;
    transient boolean closeCalled = false;

    public SMBMapJoinOperator() {
    }

    public SMBMapJoinOperator(AbstractMapJoinOperator<? extends MapJoinDesc> mapJoinOp) {
        super(mapJoinOp);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.firstRow = true;
        this.closeCalled = false;
        this.firstFetchHappened = false;
        this.inputFileChanged = false;
        byte maxAlias = 0;
        for (Byte alias : this.order) {
            if (alias <= maxAlias) continue;
            maxAlias = alias;
        }
        this.nextGroupStorage = new RowContainer[++maxAlias];
        this.candidateStorage = new RowContainer[maxAlias];
        this.keyWritables = new ArrayList[maxAlias];
        this.nextKeyWritables = new ArrayList[maxAlias];
        this.fetchOpDone = new boolean[maxAlias];
        this.foundNextKeyGroup = new boolean[maxAlias];
        int bucketSize = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEMAPJOINBUCKETCACHESIZE);
        byte storePos = 0;
        for (Byte alias : this.order) {
            RowContainer candidateRC;
            RowContainer rc;
            this.nextGroupStorage[storePos] = rc = JoinUtil.getRowContainer(hconf, (List)this.rowContainerStandardObjectInspectors.get(storePos), alias, bucketSize, this.spillTableDesc, (JoinDesc)this.conf, this.noOuterJoin);
            this.candidateStorage[alias.byteValue()] = candidateRC = JoinUtil.getRowContainer(hconf, (List)this.rowContainerStandardObjectInspectors.get(storePos), alias, bucketSize, this.spillTableDesc, (JoinDesc)this.conf, this.noOuterJoin);
            storePos = (byte)(storePos + 1);
        }
        this.tagToAlias = ((SMBJoinDesc)this.conf).getTagToAlias();
        for (Byte alias : this.order) {
            if (alias != (byte)this.posBigTable) {
                this.fetchOpDone[alias.byteValue()] = false;
            }
            this.foundNextKeyGroup[alias.byteValue()] = false;
        }
    }

    @Override
    public void initializeLocalWork(Configuration hconf) throws HiveException {
        this.initializeMapredLocalWork((MapJoinDesc)this.getConf(), hconf, ((SMBJoinDesc)this.getConf()).getLocalWork(), LOG);
        super.initializeLocalWork(hconf);
    }

    public void initializeMapredLocalWork(MapJoinDesc conf, Configuration hconf, MapredLocalWork localWork, Log l4j) throws HiveException {
        if (localWork == null || this.localWorkInited) {
            return;
        }
        this.localWorkInited = true;
        this.localWork = localWork;
        this.fetchOperators = new HashMap<String, FetchOperator>();
        HashMap<FetchOperator, JobConf> fetchOpJobConfMap = new HashMap<FetchOperator, JobConf>();
        for (Map.Entry<String, FetchWork> entry : localWork.getAliasToFetchWork().entrySet()) {
            JobConf jobClone = new JobConf(hconf);
            Operator<? extends Serializable> tableScan = localWork.getAliasToWork().get(entry.getKey());
            if (tableScan instanceof TableScanOperator) {
                ArrayList<Integer> list = ((TableScanOperator)tableScan).getNeededColumnIDs();
                if (list != null) {
                    ColumnProjectionUtils.appendReadColumnIDs((Configuration)jobClone, list);
                }
            } else {
                ColumnProjectionUtils.setFullyReadColumns((Configuration)jobClone);
            }
            FetchOperator fetchOp = new FetchOperator(entry.getValue(), jobClone);
            fetchOpJobConfMap.put(fetchOp, jobClone);
            this.fetchOperators.put(entry.getKey(), fetchOp);
            l4j.info((Object)("fetchoperator for " + entry.getKey() + " created"));
        }
        for (Map.Entry<String, Serializable> entry : this.fetchOperators.entrySet()) {
            Operator<? extends Serializable> forwardOp = localWork.getAliasToWork().get(entry.getKey());
            forwardOp.setExecContext(this.getExecContext());
            FetchOperator fetchOp = (FetchOperator)entry.getValue();
            JobConf jobConf = (JobConf)fetchOpJobConfMap.get(fetchOp);
            if (jobConf == null) {
                jobConf = this.getExecContext().getJc();
            }
            forwardOp.initialize((Configuration)jobConf, new ObjectInspector[]{fetchOp.getOutputObjectInspector()});
            l4j.info((Object)("fetchoperator for " + entry.getKey() + " initialized"));
        }
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        this.inputFileChanged = true;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (tag == this.posBigTable && this.inputFileChanged) {
            if (this.firstFetchHappened) {
                this.joinFinalLeftData();
            }
            for (Map.Entry<String, FetchOperator> entry : this.fetchOperators.entrySet()) {
                String alias = entry.getKey();
                FetchOperator fetchOp = entry.getValue();
                fetchOp.clearFetchContext();
                this.setUpFetchOpContext(fetchOp, alias);
            }
            this.firstFetchHappened = false;
            this.inputFileChanged = false;
        }
        if (!this.firstFetchHappened) {
            this.firstFetchHappened = true;
            for (Byte t : this.order) {
                if (t == (byte)this.posBigTable) continue;
                this.fetchNextGroup(t);
            }
        }
        byte alias = (byte)tag;
        ArrayList<Object> key = JoinUtil.computeKeys(row, (List)this.joinKeys.get(alias), (List)this.joinKeysObjectInspectors.get(alias));
        ArrayList<Object> value = JoinUtil.computeValues(row, (List)this.joinValues.get(alias), (List)this.joinValuesObjectInspectors.get(alias), (List)this.joinFilters.get(alias), (List)this.joinFilterObjectInspectors.get(alias), this.noOuterJoin);
        boolean nextKeyGroup = this.processKey(alias, key);
        if (nextKeyGroup) {
            this.nextGroupStorage[alias].add(value);
            this.foundNextKeyGroup[tag] = true;
            if (tag != this.posBigTable) {
                return;
            }
        }
        this.reportProgress();
        ++this.numMapRowsRead;
        if (nextKeyGroup) {
            assert (tag == (byte)this.posBigTable);
            List<Byte> smallestPos = null;
            while ((smallestPos = this.joinOneGroup()) != null && smallestPos.size() > 0 && !smallestPos.contains((byte)this.posBigTable)) {
            }
            return;
        }
        assert (!nextKeyGroup);
        this.candidateStorage[tag].add(value);
    }

    private void joinFinalLeftData() throws HiveException {
        List<Byte> ret;
        RowContainer<ArrayList<Object>> bigTblRowContainer = this.candidateStorage[this.posBigTable];
        boolean allFetchOpDone = this.allFetchOpDone();
        while (bigTblRowContainer != null && bigTblRowContainer.size() > 0 && !allFetchOpDone) {
            this.joinOneGroup();
            bigTblRowContainer = this.candidateStorage[this.posBigTable];
            allFetchOpDone = this.allFetchOpDone();
        }
        while (!allFetchOpDone && (ret = this.joinOneGroup()) != null && ret.size() != 0) {
            this.reportProgress();
            ++this.numMapRowsRead;
            allFetchOpDone = this.allFetchOpDone();
        }
        boolean dataInCache = true;
        block2: while (dataInCache) {
            int i$;
            Byte[] arr$ = this.order;
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                byte t = arr$[i$];
                if (!this.foundNextKeyGroup[t] || this.nextKeyWritables[t] == null) continue;
                this.promoteNextGroupToCandidate(t);
            }
            this.joinOneGroup();
            dataInCache = false;
            arr$ = this.order;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                byte r = arr$[i$];
                if (this.candidateStorage[r].size() <= 0) continue;
                dataInCache = true;
                continue block2;
            }
        }
    }

    private boolean allFetchOpDone() {
        boolean allFetchOpDone = true;
        for (Byte tag : this.order) {
            if (tag == (byte)this.posBigTable) continue;
            allFetchOpDone = allFetchOpDone && this.fetchOpDone[tag];
        }
        return allFetchOpDone;
    }

    private List<Byte> joinOneGroup() throws HiveException {
        int[] smallestPos = this.findSmallestKey();
        List<Byte> listOfNeedFetchNext = null;
        if (smallestPos != null && (listOfNeedFetchNext = this.joinObject(smallestPos)).size() > 0) {
            for (Byte b : listOfNeedFetchNext) {
                this.fetchNextGroup(b);
            }
        }
        return listOfNeedFetchNext;
    }

    private List<Byte> joinObject(int[] smallestPos) throws HiveException {
        byte index;
        ArrayList<Byte> needFetchList = new ArrayList<Byte>();
        for (index = (byte)(smallestPos.length - 1); index >= 0; index = (byte)(index - 1)) {
            if (smallestPos[index] > 0 || this.keyWritables[index] == null) {
                this.putDummyOrEmpty(index);
                continue;
            }
            this.storage.put(index, this.candidateStorage[index]);
            needFetchList.add(index);
            if (smallestPos[index] < 0) break;
        }
        for (index = (byte)(index - 1); index >= 0; index = (byte)(index - 1)) {
            this.putDummyOrEmpty(index);
        }
        this.checkAndGenObject();
        for (Byte pos : needFetchList) {
            this.candidateStorage[pos].clear();
            this.keyWritables[pos.byteValue()] = null;
        }
        return needFetchList;
    }

    private void fetchNextGroup(Byte t) throws HiveException {
        if (this.foundNextKeyGroup[t]) {
            if (this.nextKeyWritables[t] != null) {
                this.promoteNextGroupToCandidate(t);
            } else {
                this.keyWritables[t.byteValue()] = null;
                this.candidateStorage[t.byteValue()] = null;
                this.nextGroupStorage[t.byteValue()] = null;
            }
            this.foundNextKeyGroup[t.byteValue()] = false;
        }
        if (t == (byte)this.posBigTable) {
            return;
        }
        while (!this.foundNextKeyGroup[t] && !this.fetchOpDone[t]) {
            this.fetchOneRow(t);
        }
        if (!this.foundNextKeyGroup[t] && this.fetchOpDone[t]) {
            this.nextKeyWritables[t.byteValue()] = null;
        }
    }

    private void promoteNextGroupToCandidate(Byte t) throws HiveException {
        this.keyWritables[t.byteValue()] = this.nextKeyWritables[t];
        this.nextKeyWritables[t.byteValue()] = null;
        RowContainer<ArrayList<Object>> oldRowContainer = this.candidateStorage[t];
        oldRowContainer.clear();
        this.candidateStorage[t.byteValue()] = this.nextGroupStorage[t];
        this.nextGroupStorage[t.byteValue()] = oldRowContainer;
    }

    private int compareKeys(ArrayList<Object> k1, ArrayList<Object> k2) {
        int ret = 0;
        ret = k1.size() - k2.size();
        if (ret != 0) {
            return ret;
        }
        for (int i = 0; i < k1.size(); ++i) {
            WritableComparable key_1 = (WritableComparable)k1.get(i);
            WritableComparable key_2 = (WritableComparable)k2.get(i);
            if (key_1 == null && key_2 == null) {
                return this.nullsafes != null && this.nullsafes[i] ? 0 : -1;
            }
            if (key_1 == null) {
                return -1;
            }
            if (key_2 == null) {
                return 1;
            }
            ret = WritableComparator.get(key_1.getClass()).compare(key_1, key_2);
            if (ret == 0) continue;
            return ret;
        }
        return ret;
    }

    private void putDummyOrEmpty(Byte i) {
        if (this.noOuterJoin) {
            this.storage.put(i, this.emptyList);
        } else {
            this.storage.put(i, this.dummyObjVectors[i.intValue()]);
        }
    }

    private int[] findSmallestKey() {
        int[] result = new int[this.order.length];
        ArrayList<Object> smallestOne = null;
        Byte[] arr$ = this.order;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte i = arr$[i$];
            ArrayList<Object> key = this.keyWritables[i];
            if (key == null) continue;
            if (smallestOne == null) {
                smallestOne = key;
                result[i] = -1;
                continue;
            }
            result[i] = this.compareKeys(key, smallestOne);
            if (result[i] >= 0) continue;
            smallestOne = key;
        }
        return smallestOne == null ? null : result;
    }

    private boolean processKey(byte alias, ArrayList<Object> key) throws HiveException {
        ArrayList<Object> keyWritable = this.keyWritables[alias];
        if (keyWritable == null) {
            this.keyWritables[alias] = key;
            return false;
        }
        int cmp = this.compareKeys(key, keyWritable);
        if (cmp != 0) {
            this.nextKeyWritables[alias] = key;
            return true;
        }
        return false;
    }

    private void setUpFetchOpContext(FetchOperator fetchOp, String alias) {
        String currentInputFile = this.getExecContext().getCurrentInputFile();
        MapredLocalWork.BucketMapJoinContext bucketMatcherCxt = this.localWork.getBucketMapjoinContext();
        Class<? extends BucketMatcher> bucketMatcherCls = bucketMatcherCxt.getBucketMatcherClass();
        BucketMatcher bucketMatcher = (BucketMatcher)ReflectionUtils.newInstance(bucketMatcherCls, null);
        this.getExecContext().setFileId(bucketMatcherCxt.getBucketFileNameMapping().get(currentInputFile));
        LOG.info((Object)("set task id: " + this.getExecContext().getFileId()));
        bucketMatcher.setAliasBucketFileNameMapping(bucketMatcherCxt.getAliasBucketFileNameMapping());
        List<Path> aliasFiles = bucketMatcher.getAliasBucketFiles(currentInputFile, bucketMatcherCxt.getMapJoinBigTableAlias(), alias);
        Iterator<Path> iter = aliasFiles.iterator();
        fetchOp.setupContext(iter, null);
    }

    private void fetchOneRow(byte tag) {
        if (this.fetchOperators != null) {
            String tble = this.tagToAlias.get(tag);
            FetchOperator fetchOp = this.fetchOperators.get(tble);
            Operator<? extends Serializable> forwardOp = this.localWork.getAliasToWork().get(tble);
            try {
                InspectableObject row = fetchOp.getNextRow();
                if (row == null) {
                    this.fetchOpDone[tag] = true;
                    return;
                }
                forwardOp.process(row.o, 0);
                if (forwardOp.getDone()) {
                    this.fetchOpDone[tag] = true;
                }
            }
            catch (Throwable e) {
                if (e instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)e;
                }
                throw new RuntimeException("Map local work failed", e);
            }
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.closeCalled) {
            return;
        }
        this.closeCalled = true;
        if (this.inputFileChanged || !this.firstFetchHappened) {
            for (Map.Entry<String, FetchOperator> entry : this.fetchOperators.entrySet()) {
                String alias = entry.getKey();
                FetchOperator fetchOp = entry.getValue();
                fetchOp.clearFetchContext();
                this.setUpFetchOpContext(fetchOp, alias);
            }
            this.firstFetchHappened = true;
            for (Byte t : this.order) {
                if (t == (byte)this.posBigTable) continue;
                this.fetchNextGroup(t);
            }
            this.inputFileChanged = false;
        }
        this.joinFinalLeftData();
        for (Byte alias : this.order) {
            if (alias != (byte)this.posBigTable) {
                this.fetchOpDone[alias.byteValue()] = false;
            }
            this.foundNextKeyGroup[alias.byteValue()] = false;
        }
        this.localWorkInited = false;
        super.closeOp(abort);
        if (this.fetchOperators != null) {
            for (Map.Entry<String, FetchOperator> entry : this.fetchOperators.entrySet()) {
                Operator<? extends Serializable> forwardOp = this.localWork.getAliasToWork().get(entry.getKey());
                forwardOp.close(abort);
            }
        }
    }

    @Override
    protected boolean allInitializedParentsAreClosed() {
        return true;
    }

    @Override
    public String getName() {
        return "MAPJOIN";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }
}

