/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.index.HiveIndexHandler;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.security.HadoopDefaultAuthenticator;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.util.ReflectionUtils;

public final class HiveUtils {
    public static final char QUOTE = '\"';
    public static final char COLON = ':';
    public static final String LBRACKET = "[";
    public static final String RBRACKET = "]";
    public static final String LBRACE = "{";
    public static final String RBRACE = "}";
    public static final String LINE_SEP = System.getProperty("line.separator");

    public static String escapeString(String str) {
        int length = str.length();
        StringBuilder escape = new StringBuilder(length + 16);
        block8: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    escape.append('\\');
                    escape.append(c);
                    continue block8;
                }
                case '\b': {
                    escape.append('\\');
                    escape.append('b');
                    continue block8;
                }
                case '\f': {
                    escape.append('\\');
                    escape.append('f');
                    continue block8;
                }
                case '\n': {
                    escape.append('\\');
                    escape.append('n');
                    continue block8;
                }
                case '\r': {
                    escape.append('\\');
                    escape.append('r');
                    continue block8;
                }
                case '\t': {
                    escape.append('\\');
                    escape.append('t');
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String hex = Integer.toHexString(c);
                        escape.append('\\');
                        escape.append('u');
                        for (int j = 4; j > hex.length(); --j) {
                            escape.append('0');
                        }
                        escape.append(hex);
                        continue block8;
                    }
                    escape.append(c);
                }
            }
        }
        return escape.toString();
    }

    public static String lightEscapeString(String str) {
        int length = str.length();
        StringBuilder escape = new StringBuilder(length + 16);
        block5: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    escape.append('\\');
                    escape.append('n');
                    continue block5;
                }
                case '\r': {
                    escape.append('\\');
                    escape.append('r');
                    continue block5;
                }
                case '\t': {
                    escape.append('\\');
                    escape.append('t');
                    continue block5;
                }
                default: {
                    escape.append(c);
                }
            }
        }
        return escape.toString();
    }

    public static String unparseIdentifier(String identifier) {
        return "`" + identifier + "`";
    }

    public static HiveStorageHandler getStorageHandler(Configuration conf, String className) throws HiveException {
        if (className == null) {
            return null;
        }
        try {
            Class<?> handlerClass = Class.forName(className, true, JavaUtils.getClassLoader());
            HiveStorageHandler storageHandler = (HiveStorageHandler)ReflectionUtils.newInstance(handlerClass, (Configuration)conf);
            return storageHandler;
        }
        catch (ClassNotFoundException e) {
            throw new HiveException("Error in loading storage handler." + e.getMessage(), e);
        }
    }

    private HiveUtils() {
    }

    public static HiveIndexHandler getIndexHandler(HiveConf conf, String indexHandlerClass) throws HiveException {
        if (indexHandlerClass == null) {
            return null;
        }
        try {
            Class<?> handlerClass = Class.forName(indexHandlerClass, true, JavaUtils.getClassLoader());
            HiveIndexHandler indexHandler = (HiveIndexHandler)ReflectionUtils.newInstance(handlerClass, (Configuration)conf);
            return indexHandler;
        }
        catch (ClassNotFoundException e) {
            throw new HiveException("Error in loading index handler." + e.getMessage(), e);
        }
    }

    public static HiveAuthorizationProvider getAuthorizeProviderManager(Configuration conf, HiveAuthenticationProvider authenticator) throws HiveException {
        String clsStr = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER);
        HiveAuthorizationProvider ret = null;
        try {
            Class cls = null;
            cls = clsStr == null || clsStr.trim().equals("") ? DefaultHiveAuthorizationProvider.class : Class.forName(clsStr, true, JavaUtils.getClassLoader());
            if (cls != null) {
                ret = (HiveAuthorizationProvider)ReflectionUtils.newInstance(cls, (Configuration)conf);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        ret.setAuthenticator(authenticator);
        return ret;
    }

    public static HiveAuthenticationProvider getAuthenticator(Configuration conf) throws HiveException {
        String clsStr = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_AUTHENTICATOR_MANAGER);
        HiveAuthenticationProvider ret = null;
        try {
            Class cls = null;
            cls = clsStr == null || clsStr.trim().equals("") ? HadoopDefaultAuthenticator.class : Class.forName(clsStr, true, JavaUtils.getClassLoader());
            if (cls != null) {
                ret = (HiveAuthenticationProvider)ReflectionUtils.newInstance(cls, (Configuration)conf);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return ret;
    }

    public static String getUnparsedColumnNamesFromFieldSchema(List<FieldSchema> fieldSchemas) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(HiveUtils.unparseIdentifier(fieldSchemas.get(i).getName()));
        }
        return sb.toString();
    }
}

