/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.PartitionSpec;

@Explain(displayName="Drop Table")
public class DropTableDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    String tableName;
    ArrayList<PartitionSpec> partSpecs;
    boolean expectView;
    boolean ifExists;

    public DropTableDesc() {
    }

    public DropTableDesc(String tableName, boolean expectView, boolean ifExists) {
        this.tableName = tableName;
        this.partSpecs = null;
        this.expectView = expectView;
        this.ifExists = ifExists;
    }

    public DropTableDesc(String tableName, List<PartitionSpec> partSpecs, boolean expectView) {
        this.tableName = tableName;
        this.partSpecs = new ArrayList(partSpecs.size());
        for (int i = 0; i < partSpecs.size(); ++i) {
            this.partSpecs.add(partSpecs.get(i));
        }
        this.expectView = expectView;
    }

    @Explain(displayName="table")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ArrayList<PartitionSpec> getPartSpecs() {
        return this.partSpecs;
    }

    public void setPartSpecs(ArrayList<PartitionSpec> partSpecs) {
        this.partSpecs = partSpecs;
    }

    public boolean getExpectView() {
        return this.expectView;
    }

    public void setExpectView(boolean expectView) {
        this.expectView = expectView;
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }
}

