/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class VectorReduceSinkOperator
extends ReduceSinkOperator {
    private static final long serialVersionUID = 1L;
    private VectorExpressionWriter[] rowWriters;
    protected transient Object[] singleRow;

    public VectorReduceSinkOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        this();
        ReduceSinkDesc desc = (ReduceSinkDesc)conf;
        this.conf = desc;
    }

    public VectorReduceSinkOperator() {
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        VectorExpressionWriterFactory.processVectorInspector((StructObjectInspector)this.inputObjInspectors[0], new VectorExpressionWriterFactory.SingleOIDClosure(){

            @Override
            public void assign(VectorExpressionWriter[] writers, ObjectInspector objectInspector) {
                VectorReduceSinkOperator.access$002(VectorReduceSinkOperator.this, writers);
                ((VectorReduceSinkOperator)VectorReduceSinkOperator.this).inputObjInspectors[0] = objectInspector;
            }
        });
        this.singleRow = new Object[this.rowWriters.length];
        super.initializeOp(hconf);
    }

    @Override
    public void processOp(Object data, int tag) throws HiveException {
        VectorizedRowBatch vrg = (VectorizedRowBatch)data;
        for (int batchIndex = 0; batchIndex < vrg.size; ++batchIndex) {
            Object[] row = this.getRowObject(vrg, batchIndex);
            super.processOp(row, tag);
        }
    }

    private Object[] getRowObject(VectorizedRowBatch vrg, int rowIndex) throws HiveException {
        int batchIndex = rowIndex;
        if (vrg.selectedInUse) {
            batchIndex = vrg.selected[rowIndex];
        }
        for (int i = 0; i < vrg.projectionSize; ++i) {
            ColumnVector vectorColumn = vrg.cols[vrg.projectedColumns[i]];
            this.singleRow[i] = vectorColumn != null ? this.rowWriters[i].writeValue(vectorColumn, batchIndex) : null;
        }
        return this.singleRow;
    }

    static /* synthetic */ VectorExpressionWriter[] access$002(VectorReduceSinkOperator x0, VectorExpressionWriter[] x1) {
        x0.rowWriters = x1;
        return x1;
    }
}

