/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.timestamp;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import jodd.datetime.JDateTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;

public class NanoTimeUtils {
    static final long NANOS_PER_SECOND = 1000000000L;
    static final long SECONDS_PER_MINUTE = 60L;
    static final long MINUTES_PER_HOUR = 60L;
    private static final ThreadLocal<Calendar> parquetTsCalendar = new ThreadLocal();

    private static Calendar getCalendar() {
        if (parquetTsCalendar.get() == null) {
            parquetTsCalendar.set(Calendar.getInstance(TimeZone.getTimeZone("GMT")));
        }
        return parquetTsCalendar.get();
    }

    public static NanoTime getNanoTime(Timestamp ts) {
        Calendar calendar = NanoTimeUtils.getCalendar();
        calendar.setTime(ts);
        JDateTime jDateTime = new JDateTime(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        int days = jDateTime.getJulianDayNumber();
        long hour = calendar.get(11);
        long minute = calendar.get(12);
        long second = calendar.get(13);
        long nanos = ts.getNanos();
        long nanosOfDay = nanos + 1000000000L * second + 60000000000L * minute + 3600000000000L * hour;
        return new NanoTime(days, nanosOfDay);
    }

    public static Timestamp getTimestamp(NanoTime nt) {
        int julianDay = nt.getJulianDay();
        long nanosOfDay = nt.getTimeOfDayNanos();
        JDateTime jDateTime = new JDateTime((double)julianDay);
        Calendar calendar = NanoTimeUtils.getCalendar();
        calendar.set(1, jDateTime.getYear());
        calendar.set(2, jDateTime.getMonth() - 1);
        calendar.set(5, jDateTime.getDay());
        long remainder = nanosOfDay;
        int hour = (int)(remainder / 3600000000000L);
        int minutes = (int)((remainder %= 3600000000000L) / 60000000000L);
        int seconds = (int)((remainder %= 60000000000L) / 1000000000L);
        long nanos = remainder % 1000000000L;
        calendar.set(11, hour);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        Timestamp ts = new Timestamp(calendar.getTimeInMillis());
        ts.setNanos((int)nanos);
        return ts;
    }
}

