/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred.tether;

import java.nio.ByteBuffer;
import org.apache.avro.Protocol;
import org.apache.avro.specific.AvroGenerated;

@AvroGenerated
public interface OutputProtocol {
    public static final Protocol PROTOCOL = Protocol.parse("{\"protocol\":\"OutputProtocol\",\"namespace\":\"org.apache.avro.mapred.tether\",\"doc\":\"Transmit outputs from a map or reduce task to parent.\",\"types\":[],\"messages\":{\"configure\":{\"doc\":\"Configure task.  Sent before any other message.\",\"request\":[{\"name\":\"port\",\"type\":\"int\"}],\"response\":\"null\",\"one-way\":true},\"output\":{\"doc\":\"Send an output datum.\",\"request\":[{\"name\":\"datum\",\"type\":\"bytes\"}],\"response\":\"null\",\"one-way\":true},\"outputPartitioned\":{\"doc\":\"Send map output datum explicitly naming its partition.\",\"request\":[{\"name\":\"partition\",\"type\":\"int\"},{\"name\":\"datum\",\"type\":\"bytes\"}],\"response\":\"null\",\"one-way\":true},\"status\":{\"doc\":\"Update the task's status message.  Also acts as keepalive.\",\"request\":[{\"name\":\"message\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"response\":\"null\",\"one-way\":true},\"count\":{\"doc\":\"Increment a task/job counter.\",\"request\":[{\"name\":\"group\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"amount\",\"type\":\"long\"}],\"response\":\"null\",\"one-way\":true},\"fail\":{\"doc\":\"Called by a failing task to abort.\",\"request\":[{\"name\":\"message\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"response\":\"null\",\"one-way\":true},\"complete\":{\"doc\":\"Called when a task's output has completed without error.\",\"request\":[],\"response\":\"null\",\"one-way\":true}}}");

    public void configure(int var1);

    public void output(ByteBuffer var1);

    public void outputPartitioned(int var1, ByteBuffer var2);

    public void status(String var1);

    public void count(String var1, String var2, long var3);

    public void fail(String var1);

    public void complete();

    public static interface Callback
    extends OutputProtocol {
        public static final Protocol PROTOCOL = PROTOCOL;
    }
}

