/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.spark;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.DefaultBucketMatcher;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.GenSparkProcContext;
import org.apache.hadoop.hive.ql.plan.BucketMapJoinContext;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;

public final class SparkSortMergeJoinFactory {
    private SparkSortMergeJoinFactory() {
    }

    public static int getPositionParent(SMBMapJoinOperator op, Stack<Node> stack) {
        int size = stack.size();
        assert (size >= 2 && stack.get(size - 1) == op);
        Operator parent = (Operator)stack.get(size - 2);
        List<Operator<OperatorDesc>> parOp = op.getParentOperators();
        int pos = parOp.indexOf(parent);
        return pos;
    }

    public static NodeProcessor getTableScanMapJoin() {
        return new SortMergeJoinProcessor();
    }

    private static class SortMergeJoinProcessor
    implements NodeProcessor {
        private SortMergeJoinProcessor() {
        }

        public static void setupBucketMapJoinInfo(MapWork plan, SMBMapJoinOperator currMapJoinOp) {
            Map<String, Map<String, List<String>>> aliasBucketFileNameMapping;
            if (currMapJoinOp != null && (aliasBucketFileNameMapping = ((SMBJoinDesc)currMapJoinOp.getConf()).getAliasBucketFileNameMapping()) != null) {
                MapredLocalWork localPlan = plan.getMapRedLocalWork();
                if (localPlan == null) {
                    localPlan = ((SMBJoinDesc)currMapJoinOp.getConf()).getLocalWork();
                } else {
                    MapredLocalWork smbLocalWork = ((SMBJoinDesc)currMapJoinOp.getConf()).getLocalWork();
                    if (smbLocalWork != null) {
                        localPlan.getAliasToFetchWork().putAll(smbLocalWork.getAliasToFetchWork());
                        localPlan.getAliasToWork().putAll(smbLocalWork.getAliasToWork());
                    }
                }
                if (localPlan == null) {
                    return;
                }
                plan.setMapRedLocalWork(null);
                ((SMBJoinDesc)currMapJoinOp.getConf()).setLocalWork(localPlan);
                BucketMapJoinContext bucketMJCxt = new BucketMapJoinContext();
                localPlan.setBucketMapjoinContext(bucketMJCxt);
                bucketMJCxt.setAliasBucketFileNameMapping(aliasBucketFileNameMapping);
                bucketMJCxt.setBucketFileNameMapping(((SMBJoinDesc)currMapJoinOp.getConf()).getBigTableBucketNumMapping());
                localPlan.setInputFileChangeSensitive(true);
                bucketMJCxt.setMapJoinBigTableAlias(((SMBJoinDesc)currMapJoinOp.getConf()).getBigTableAlias());
                bucketMJCxt.setBucketMatcherClass(DefaultBucketMatcher.class);
                bucketMJCxt.setBigTablePartSpecToFileMapping(((SMBJoinDesc)currMapJoinOp.getConf()).getBigTablePartSpecToFileMapping());
                plan.setUseBucketizedHiveInputFormat(true);
            }
        }

        private static void initSMBJoinPlan(MapWork mapWork, GenSparkProcContext opProcCtx, boolean local) throws SemanticException {
            TableScanOperator ts = (TableScanOperator)opProcCtx.currentRootOperator;
            String currAliasId = SortMergeJoinProcessor.findAliasId(opProcCtx, ts);
            GenMapRedUtils.setMapWork(mapWork, opProcCtx.parseContext, opProcCtx.inputs, null, ts, currAliasId, opProcCtx.conf, local);
        }

        private static String findAliasId(GenSparkProcContext opProcCtx, TableScanOperator ts) {
            for (String alias : opProcCtx.topOps.keySet()) {
                if (opProcCtx.topOps.get(alias) != ts) continue;
                return alias;
            }
            return null;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            SMBMapJoinOperator mapJoin = (SMBMapJoinOperator)nd;
            GenSparkProcContext ctx = (GenSparkProcContext)procCtx;
            int pos = SparkSortMergeJoinFactory.getPositionParent(mapJoin, stack);
            boolean local = pos != ((SMBJoinDesc)mapJoin.getConf()).getPosBigTable();
            MapWork mapWork = ctx.smbJoinWorkMap.get(mapJoin);
            SortMergeJoinProcessor.initSMBJoinPlan(mapWork, ctx, local);
            SortMergeJoinProcessor.setupBucketMapJoinInfo(mapWork, mapJoin);
            return false;
        }
    }
}

