/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManagerImpl;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.util.ReflectionUtils;

public class TxnManagerFactory {
    private static TxnManagerFactory self;

    public static synchronized TxnManagerFactory getTxnManagerFactory() {
        if (self == null) {
            self = new TxnManagerFactory();
        }
        return self;
    }

    public HiveTxnManager getTxnManager(HiveConf conf) throws LockException {
        HiveTxnManagerImpl txnMgr = null;
        String txnMgrName = conf.getVar(HiveConf.ConfVars.HIVE_TXN_MANAGER);
        if (txnMgrName == null || txnMgrName.isEmpty()) {
            throw new LockException(ErrorMsg.TXNMGR_NOT_SPECIFIED.getMsg());
        }
        try {
            HiveTxnManagerImpl impl = (HiveTxnManagerImpl)ReflectionUtils.newInstance((Class)conf.getClassByName(txnMgrName), (Configuration)conf);
            impl.setHiveConf(conf);
            txnMgr = impl;
        }
        catch (ClassNotFoundException e) {
            throw new LockException(ErrorMsg.TXNMGR_NOT_INSTANTIATED.getMsg());
        }
        return txnMgr;
    }

    private TxnManagerFactory() {
    }
}

