/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CuckooSetLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ILongInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class FilterLongColumnInList
extends VectorExpression
implements ILongInExpr {
    private static final long serialVersionUID = 1L;
    private int inputCol;
    private long[] inListValues;
    private transient CuckooSetLong inSet;

    public FilterLongColumnInList() {
        this.inSet = null;
    }

    public FilterLongColumnInList(int colNum) {
        this.inputCol = colNum;
        this.inSet = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        if (this.inSet == null) {
            this.inSet = new CuckooSetLong(this.inListValues.length);
            this.inSet.load(this.inListValues);
        }
        LongColumnVector inputColVector = (LongColumnVector)batch.cols[this.inputCol];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        int n = batch.size;
        long[] vector = inputColVector.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (!this.inSet.lookup(vector[0])) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!this.inSet.lookup(vector[i])) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (!this.inSet.lookup(vector[i])) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                if (!this.inSet.lookup(vector[0])) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos[i] || !this.inSet.lookup(vector[i])) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos[i] || !this.inSet.lookup(vector[i])) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }

    public long[] getInListValues() {
        return this.inListValues;
    }

    @Override
    public void setInListValues(long[] a) {
        this.inListValues = a;
    }
}

