/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Dimension;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Sample;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TMemoryBuffer;

public class Partition
implements Serializable {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.metadata.Partition");
    private Table table;
    private org.apache.hadoop.hive.metastore.api.Partition tPartition;
    private Deserializer deserializer;
    private Class<? extends OutputFormat> outputFormatClass;
    private Class<? extends InputFormat> inputFormatClass;

    public List<String> getValues() {
        return this.tPartition.getValues();
    }

    public Partition() {
    }

    public Partition(Table tbl) throws HiveException {
        org.apache.hadoop.hive.metastore.api.Partition tPart = new org.apache.hadoop.hive.metastore.api.Partition();
        if (!tbl.isView()) {
            tPart.setSd(tbl.getTTable().getSd());
        }
        this.initialize(tbl, tPart);
    }

    public Partition(Table tbl, org.apache.hadoop.hive.metastore.api.Partition tp) throws HiveException {
        this.initialize(tbl, tp);
    }

    public Partition(Table tbl, Map<String, String> partSpec, Path location) throws HiveException {
        this.initialize(tbl, Partition.createMetaPartitionObject(tbl, partSpec, location));
    }

    public static org.apache.hadoop.hive.metastore.api.Partition createMetaPartitionObject(Table tbl, Map<String, String> partSpec, Path location) throws HiveException {
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : tbl.getPartCols()) {
            String val = partSpec.get(field.getName());
            if (val == null || val.isEmpty()) {
                throw new HiveException("partition spec is invalid; field " + field.getName() + " does not exist or is empty");
            }
            pvals.add(val);
        }
        org.apache.hadoop.hive.metastore.api.Partition tpart = new org.apache.hadoop.hive.metastore.api.Partition();
        tpart.setDbName(tbl.getDbName());
        tpart.setTableName(tbl.getTableName());
        tpart.setValues(pvals);
        if (!tbl.isView()) {
            tpart.setSd(Partition.cloneSd(tbl));
            tpart.getSd().setLocation(location != null ? location.toString() : null);
        }
        return tpart;
    }

    public static StorageDescriptor cloneSd(Table tbl) throws HiveException {
        StorageDescriptor sd = new StorageDescriptor();
        try {
            TMemoryBuffer buffer = new TMemoryBuffer(1024);
            TBinaryProtocol prot = new TBinaryProtocol(buffer);
            tbl.getTTable().getSd().write((TProtocol)prot);
            sd.read((TProtocol)prot);
        }
        catch (TException e) {
            LOG.error((Object)"Could not create a copy of StorageDescription");
            throw new HiveException("Could not create a copy of StorageDescription", e);
        }
        return sd;
    }

    protected void initialize(Table table, org.apache.hadoop.hive.metastore.api.Partition tPartition) throws HiveException {
        this.table = table;
        this.tPartition = tPartition;
        if (table.isView()) {
            return;
        }
        if (table.isPartitioned()) {
            try {
                String partName = Warehouse.makePartName(table.getPartCols(), (List)tPartition.getValues());
                if (tPartition.getSd().getLocation() == null && table.getDataLocation() != null) {
                    Path partPath = new Path(table.getDataLocation(), partName);
                    tPartition.getSd().setLocation(partPath.toString());
                }
                if (tPartition.getSd().getCols() == null && table.getCols() != null) {
                    tPartition.getSd().setCols(table.getCols());
                }
            }
            catch (MetaException e) {
                throw new HiveException("Invalid partition for table " + table.getTableName(), e);
            }
        }
    }

    public String getName() {
        try {
            return Warehouse.makePartName(this.table.getPartCols(), (List)this.tPartition.getValues());
        }
        catch (MetaException e) {
            throw new RuntimeException(e);
        }
    }

    public Path[] getPath() {
        Path[] ret = new Path[]{this.getDataLocation()};
        return ret;
    }

    public Path getPartitionPath() {
        return this.getDataLocation();
    }

    public Path getDataLocation() {
        if (this.table.isPartitioned()) {
            return new Path(this.tPartition.getSd().getLocation());
        }
        return new Path(this.table.getTTable().getSd().getLocation());
    }

    public final Deserializer getDeserializer() {
        if (this.deserializer == null) {
            try {
                this.deserializer = MetaStoreUtils.getDeserializer((Configuration)SessionState.getSessionConf(), (org.apache.hadoop.hive.metastore.api.Partition)this.tPartition, (org.apache.hadoop.hive.metastore.api.Table)this.table.getTTable());
            }
            catch (MetaException e) {
                throw new RuntimeException(e);
            }
        }
        return this.deserializer;
    }

    public Properties getSchema() {
        return MetaStoreUtils.getSchema((org.apache.hadoop.hive.metastore.api.Partition)this.tPartition, (org.apache.hadoop.hive.metastore.api.Table)this.table.getTTable());
    }

    public Properties getMetadataFromPartitionSchema() {
        return MetaStoreUtils.getPartitionMetadata((org.apache.hadoop.hive.metastore.api.Partition)this.tPartition, (org.apache.hadoop.hive.metastore.api.Table)this.table.getTTable());
    }

    public Properties getSchemaFromTableSchema(Properties tblSchema) {
        return MetaStoreUtils.getPartSchemaFromTableSchema((StorageDescriptor)this.tPartition.getSd(), (StorageDescriptor)this.table.getTTable().getSd(), (Map)this.tPartition.getParameters(), (String)this.table.getDbName(), (String)this.table.getTableName(), this.table.getPartitionKeys(), (Properties)tblSchema);
    }

    public void setInputFormatClass(Class<? extends InputFormat> inputFormatClass) {
        this.inputFormatClass = inputFormatClass;
        this.tPartition.getSd().setInputFormat(inputFormatClass.getName());
    }

    public void setOutputFormatClass(Class<? extends HiveOutputFormat> outputFormatClass) {
        this.outputFormatClass = outputFormatClass;
        this.tPartition.getSd().setOutputFormat(HiveFileFormatUtils.getOutputFormatSubstitute(outputFormatClass).toString());
    }

    public final Class<? extends InputFormat> getInputFormatClass() throws HiveException {
        if (this.inputFormatClass == null) {
            String clsName;
            String string = clsName = this.tPartition.getSd() == null ? null : this.tPartition.getSd().getInputFormat();
            if (clsName == null) {
                this.inputFormatClass = this.table.getInputFormatClass();
                return this.inputFormatClass;
            }
            try {
                this.inputFormatClass = Class.forName(clsName, true, Utilities.getSessionSpecifiedClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new HiveException("Class not found: " + clsName, e);
            }
        }
        return this.inputFormatClass;
    }

    public final Class<? extends OutputFormat> getOutputFormatClass() throws HiveException {
        if (this.outputFormatClass == null) {
            String clsName;
            String string = clsName = this.tPartition.getSd() == null ? null : this.tPartition.getSd().getOutputFormat();
            if (clsName == null) {
                this.outputFormatClass = this.table.getOutputFormatClass();
                return this.outputFormatClass;
            }
            try {
                Class<?> c = Class.forName(clsName, true, Utilities.getSessionSpecifiedClassLoader());
                this.outputFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(c);
            }
            catch (ClassNotFoundException e) {
                throw new HiveException("Class not found: " + clsName, e);
            }
        }
        return this.outputFormatClass;
    }

    public int getBucketCount() {
        return this.tPartition.getSd().getNumBuckets();
    }

    public void setBucketCount(int newBucketNum) {
        this.tPartition.getSd().setNumBuckets(newBucketNum);
    }

    public List<String> getBucketCols() {
        return this.tPartition.getSd().getBucketCols();
    }

    public List<Order> getSortCols() {
        return this.tPartition.getSd().getSortCols();
    }

    public List<String> getSortColNames() {
        return Utilities.getColumnNamesFromSortCols(this.getSortCols());
    }

    public FileStatus[] getSortedPaths() {
        try {
            FileSystem fs = this.getDataLocation().getFileSystem((Configuration)SessionState.getSessionConf());
            String pathPattern = this.getDataLocation().toString();
            if (this.getBucketCount() > 0) {
                pathPattern = pathPattern + "/*";
            }
            LOG.info((Object)("Path pattern = " + pathPattern));
            Object[] srcs = fs.globStatus(new Path(pathPattern), FileUtils.HIDDEN_FILES_PATH_FILTER);
            Arrays.sort(srcs);
            for (Object src : srcs) {
                LOG.info((Object)("Got file: " + src.getPath()));
            }
            if (srcs.length == 0) {
                return null;
            }
            return srcs;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get path ", e);
        }
    }

    public Path getBucketPath(int bucketNum) {
        FileStatus[] srcs = this.getSortedPaths();
        if (srcs == null) {
            return null;
        }
        return srcs[bucketNum].getPath();
    }

    public Path[] getPath(Sample s) throws HiveException {
        if (s == null) {
            return this.getPath();
        }
        int bcount = this.getBucketCount();
        if (bcount == 0) {
            return this.getPath();
        }
        Dimension d = s.getSampleDimension();
        if (!d.getDimensionId().equals(this.table.getBucketingDimensionId())) {
            return this.getPath();
        }
        int scount = s.getSampleFraction();
        ArrayList<Path> ret = new ArrayList<Path>();
        if (bcount == scount) {
            ret.add(this.getBucketPath(s.getSampleNum() - 1));
        } else if (bcount < scount) {
            if (scount / bcount * bcount != scount) {
                throw new HiveException("Sample Count" + scount + " is not a multiple of bucket count " + bcount + " for table " + this.table.getTableName());
            }
            ret.add(this.getBucketPath((s.getSampleNum() - 1) % bcount));
        } else if (bcount > scount) {
            if (bcount / scount * scount != bcount) {
                throw new HiveException("Sample Count" + scount + " is not a divisor of bucket count " + bcount + " for table " + this.table.getTableName());
            }
            for (int i = 0; i < bcount / scount; ++i) {
                ret.add(this.getBucketPath(i * scount + (s.getSampleNum() - 1)));
            }
        }
        return ret.toArray(new Path[ret.size()]);
    }

    public LinkedHashMap<String, String> getSpec() {
        return this.table.createSpec(this.tPartition);
    }

    public String toString() {
        String pn = "Invalid Partition";
        try {
            pn = Warehouse.makePartName(this.getSpec(), (boolean)false);
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        return this.table.toString() + "(" + pn + ")";
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public org.apache.hadoop.hive.metastore.api.Partition getTPartition() {
        return this.tPartition;
    }

    public void setTPartition(org.apache.hadoop.hive.metastore.api.Partition partition) {
        this.tPartition = partition;
    }

    public Map<String, String> getParameters() {
        return this.tPartition.getParameters();
    }

    public List<FieldSchema> getCols() {
        try {
            if (Table.hasMetastoreBasedSchema(SessionState.getSessionConf(), this.tPartition.getSd())) {
                return this.tPartition.getSd().getCols();
            }
            return MetaStoreUtils.getFieldsFromDeserializer((String)this.table.getTableName(), (Deserializer)this.getDeserializer());
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to get cols from serde: " + this.tPartition.getSd().getSerdeInfo().getSerializationLib()), (Throwable)e);
            return new ArrayList<FieldSchema>();
        }
    }

    public String getLocation() {
        if (this.tPartition.getSd() == null) {
            return null;
        }
        return this.tPartition.getSd().getLocation();
    }

    public void setLocation(String location) {
        this.tPartition.getSd().setLocation(location);
    }

    public void setValues(Map<String, String> partSpec) throws HiveException {
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : this.table.getPartCols()) {
            String val = partSpec.get(field.getName());
            if (val == null) {
                throw new HiveException("partition spec is invalid. field.getName() does not exist in input.");
            }
            pvals.add(val);
        }
        this.tPartition.setValues(pvals);
    }

    public void setProtectMode(ProtectMode protectMode) {
        Map parameters = this.tPartition.getParameters();
        String pm = protectMode.toString();
        if (pm != null) {
            parameters.put(ProtectMode.PARAMETER_NAME, pm);
        } else {
            parameters.remove(ProtectMode.PARAMETER_NAME);
        }
        this.tPartition.setParameters(parameters);
    }

    public ProtectMode getProtectMode() {
        return MetaStoreUtils.getProtectMode((org.apache.hadoop.hive.metastore.api.Partition)this.tPartition);
    }

    public boolean isOffline() {
        ProtectMode pm = this.getProtectMode();
        if (pm == null) {
            return false;
        }
        return pm.offline;
    }

    public boolean canDrop() {
        return MetaStoreUtils.canDropPartition((org.apache.hadoop.hive.metastore.api.Table)this.table.getTTable(), (org.apache.hadoop.hive.metastore.api.Partition)this.tPartition);
    }

    public boolean canWrite() {
        ProtectMode mode = this.getProtectMode();
        return !mode.offline && !mode.readOnly;
    }

    public String getCompleteName() {
        return this.getTable().getCompleteName() + "@" + this.getName();
    }

    public int getLastAccessTime() {
        return this.tPartition.getLastAccessTime();
    }

    public void setLastAccessTime(int lastAccessTime) {
        this.tPartition.setLastAccessTime(lastAccessTime);
    }

    public boolean isStoredAsSubDirectories() {
        return this.tPartition.getSd().isStoredAsSubDirectories();
    }

    public List<List<String>> getSkewedColValues() {
        return this.tPartition.getSd().getSkewedInfo().getSkewedColValues();
    }

    public List<String> getSkewedColNames() {
        return this.tPartition.getSd().getSkewedInfo().getSkewedColNames();
    }

    public void setSkewedValueLocationMap(List<String> valList, String dirName) throws HiveException {
        HashMap<List<String>, String> mappings = this.tPartition.getSd().getSkewedInfo().getSkewedColValueLocationMaps();
        if (null == mappings) {
            mappings = new HashMap<List<String>, String>();
            this.tPartition.getSd().getSkewedInfo().setSkewedColValueLocationMaps(mappings);
        }
        mappings.put(valList, dirName);
    }

    public Map<List<String>, String> getSkewedColValueLocationMaps() {
        return this.tPartition.getSd().getSkewedInfo().getSkewedColValueLocationMaps();
    }

    public void checkValidity() throws HiveException {
        if (!this.tPartition.getSd().equals(this.table.getSd())) {
            Table.validateColumns(this.getCols(), this.table.getPartCols());
        }
    }
}

