// $ANTLR 3.4 org/apache/hadoop/hive/ql/parse/HiveParser.g 2017-03-31 15:43:31

package org.apache.hadoop.hive.ql.parse;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

import org.antlr.runtime.tree.*;


/**
   Licensed to the Apache Software Foundation (ASF) under one or more 
   contributor license agreements.  See the NOTICE file distributed with 
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with 
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
@SuppressWarnings({"all", "warnings", "unchecked"})
public class HiveParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "AMPERSAND", "BITWISEOR", "BITWISEXOR", "BigintLiteral", "ByteLengthLiteral", "COLON", "COMMA", "COMMENT", "CharSetLiteral", "CharSetName", "DIV", "DIVIDE", "DOLLAR", "DOT", "DecimalLiteral", "Digit", "EQUAL", "EQUAL_NS", "Exponent", "GREATERTHAN", "GREATERTHANOREQUALTO", "HexDigit", "Identifier", "KW_ADD", "KW_ADMIN", "KW_AFTER", "KW_ALL", "KW_ALTER", "KW_ANALYZE", "KW_AND", "KW_ARCHIVE", "KW_ARRAY", "KW_AS", "KW_ASC", "KW_AUTHORIZATION", "KW_BEFORE", "KW_BETWEEN", "KW_BIGINT", "KW_BINARY", "KW_BOOLEAN", "KW_BOTH", "KW_BUCKET", "KW_BUCKETS", "KW_BY", "KW_CASCADE", "KW_CASE", "KW_CAST", "KW_CHANGE", "KW_CHAR", "KW_CLUSTER", "KW_CLUSTERED", "KW_CLUSTERSTATUS", "KW_COLLECTION", "KW_COLUMN", "KW_COLUMNS", "KW_COMMENT", "KW_COMPACT", "KW_COMPACTIONS", "KW_COMPUTE", "KW_CONCATENATE", "KW_CONF", "KW_CONTINUE", "KW_CREATE", "KW_CROSS", "KW_CUBE", "KW_CURRENT", "KW_CURRENT_DATE", "KW_CURRENT_TIMESTAMP", "KW_CURSOR", "KW_DATA", "KW_DATABASE", "KW_DATABASES", "KW_DATE", "KW_DATETIME", "KW_DAY", "KW_DBPROPERTIES", "KW_DECIMAL", "KW_DEFERRED", "KW_DEFINED", "KW_DELETE", "KW_DELIMITED", "KW_DEPENDENCY", "KW_DESC", "KW_DESCRIBE", "KW_DIRECTORIES", "KW_DIRECTORY", "KW_DISABLE", "KW_DISTINCT", "KW_DISTRIBUTE", "KW_DOUBLE", "KW_DROP", "KW_ELEM_TYPE", "KW_ELSE", "KW_ENABLE", "KW_END", "KW_ESCAPED", "KW_EXCHANGE", "KW_EXCLUSIVE", "KW_EXISTS", "KW_EXPLAIN", "KW_EXPORT", "KW_EXTENDED", "KW_EXTERNAL", "KW_FALSE", "KW_FETCH", "KW_FIELDS", "KW_FILE", "KW_FILEFORMAT", "KW_FIRST", "KW_FLOAT", "KW_FOLLOWING", "KW_FOR", "KW_FORMAT", "KW_FORMATTED", "KW_FROM", "KW_FULL", "KW_FUNCTION", "KW_FUNCTIONS", "KW_GRANT", "KW_GROUP", "KW_GROUPING", "KW_HAVING", "KW_HOLD_DDLTIME", "KW_HOUR", "KW_IDXPROPERTIES", "KW_IF", "KW_IGNORE", "KW_IMPORT", "KW_IN", "KW_INDEX", "KW_INDEXES", "KW_INNER", "KW_INPATH", "KW_INPUTDRIVER", "KW_INPUTFORMAT", "KW_INSERT", "KW_INT", "KW_INTERSECT", "KW_INTERVAL", "KW_INTO", "KW_IS", "KW_ITEMS", "KW_JAR", "KW_JOIN", "KW_KEYS", "KW_KEY_TYPE", "KW_LATERAL", "KW_LEFT", "KW_LESS", "KW_LIKE", "KW_LIMIT", "KW_LINES", "KW_LOAD", "KW_LOCAL", "KW_LOCATION", "KW_LOCK", "KW_LOCKS", "KW_LOGICAL", "KW_LONG", "KW_MACRO", "KW_MAP", "KW_MAPJOIN", "KW_MATERIALIZED", "KW_METADATA", "KW_MINUS", "KW_MINUTE", "KW_MONTH", "KW_MORE", "KW_MSCK", "KW_NONE", "KW_NOSCAN", "KW_NOT", "KW_NO_DROP", "KW_NULL", "KW_OF", "KW_OFFLINE", "KW_ON", "KW_OPTION", "KW_OR", "KW_ORDER", "KW_OUT", "KW_OUTER", "KW_OUTPUTDRIVER", "KW_OUTPUTFORMAT", "KW_OVER", "KW_OVERWRITE", "KW_OWNER", "KW_PARTIALSCAN", "KW_PARTITION", "KW_PARTITIONED", "KW_PARTITIONS", "KW_PERCENT", "KW_PLUS", "KW_PRECEDING", "KW_PRESERVE", "KW_PRETTY", "KW_PRINCIPALS", "KW_PROCEDURE", "KW_PROTECTION", "KW_PURGE", "KW_RANGE", "KW_READ", "KW_READONLY", "KW_READS", "KW_REBUILD", "KW_RECORDREADER", "KW_RECORDWRITER", "KW_REDUCE", "KW_REGEXP", "KW_RELOAD", "KW_RENAME", "KW_REPAIR", "KW_REPLACE", "KW_REPLICATION", "KW_RESTRICT", "KW_REVOKE", "KW_REWRITE", "KW_RIGHT", "KW_RLIKE", "KW_ROLE", "KW_ROLES", "KW_ROLLUP", "KW_ROW", "KW_ROWS", "KW_SCHEMA", "KW_SCHEMAS", "KW_SECOND", "KW_SELECT", "KW_SEMI", "KW_SERDE", "KW_SERDEPROPERTIES", "KW_SERVER", "KW_SET", "KW_SETS", "KW_SHARED", "KW_SHOW", "KW_SHOW_DATABASE", "KW_SKEWED", "KW_SMALLINT", "KW_SORT", "KW_SORTED", "KW_SSL", "KW_STATISTICS", "KW_STORED", "KW_STREAMTABLE", "KW_STRING", "KW_STRUCT", "KW_TABLE", "KW_TABLES", "KW_TABLESAMPLE", "KW_TBLPROPERTIES", "KW_TEMPORARY", "KW_TERMINATED", "KW_THEN", "KW_TIMESTAMP", "KW_TINYINT", "KW_TO", "KW_TOUCH", "KW_TRANSACTIONS", "KW_TRANSFORM", "KW_TRIGGER", "KW_TRUE", "KW_TRUNCATE", "KW_UNARCHIVE", "KW_UNBOUNDED", "KW_UNDO", "KW_UNION", "KW_UNIONTYPE", "KW_UNIQUEJOIN", "KW_UNLOCK", "KW_UNSET", "KW_UNSIGNED", "KW_UPDATE", "KW_URI", "KW_USE", "KW_USER", "KW_USING", "KW_UTC", "KW_UTCTIMESTAMP", "KW_VALUES", "KW_VALUE_TYPE", "KW_VARCHAR", "KW_VIEW", "KW_WHEN", "KW_WHERE", "KW_WHILE", "KW_WINDOW", "KW_WITH", "KW_YEAR", "LCURLY", "LESSTHAN", "LESSTHANOREQUALTO", "LPAREN", "LSQUARE", "Letter", "MINUS", "MOD", "NOTEQUAL", "Number", "PLUS", "QUESTION", "QuotedIdentifier", "RCURLY", "RPAREN", "RSQUARE", "RegexComponent", "SEMICOLON", "STAR", "SmallintLiteral", "StringLiteral", "TILDE", "TinyintLiteral", "WS", "TOK_ADMIN_OPTION_FOR", "TOK_ALIASLIST", "TOK_ALLCOLREF", "TOK_ALTERDATABASE_OWNER", "TOK_ALTERDATABASE_PROPERTIES", "TOK_ALTERINDEX_PROPERTIES", "TOK_ALTERINDEX_REBUILD", "TOK_ALTERTABLE", "TOK_ALTERTABLE_ADDCOLS", "TOK_ALTERTABLE_ADDPARTS", "TOK_ALTERTABLE_ARCHIVE", "TOK_ALTERTABLE_BUCKETS", "TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION", "TOK_ALTERTABLE_CLUSTER_SORT", "TOK_ALTERTABLE_COMPACT", "TOK_ALTERTABLE_DROPPARTS", "TOK_ALTERTABLE_DROPPROPERTIES", "TOK_ALTERTABLE_EXCHANGEPARTITION", "TOK_ALTERTABLE_FILEFORMAT", "TOK_ALTERTABLE_LOCATION", "TOK_ALTERTABLE_MERGEFILES", "TOK_ALTERTABLE_PARTCOLTYPE", "TOK_ALTERTABLE_PROPERTIES", "TOK_ALTERTABLE_PROTECTMODE", "TOK_ALTERTABLE_RENAME", "TOK_ALTERTABLE_RENAMECOL", "TOK_ALTERTABLE_RENAMEPART", "TOK_ALTERTABLE_REPLACECOLS", "TOK_ALTERTABLE_SERDEPROPERTIES", "TOK_ALTERTABLE_SERIALIZER", "TOK_ALTERTABLE_SKEWED", "TOK_ALTERTABLE_SKEWED_LOCATION", "TOK_ALTERTABLE_TOUCH", "TOK_ALTERTABLE_UNARCHIVE", "TOK_ALTERTABLE_UPDATECOLSTATS", "TOK_ALTERVIEW", "TOK_ALTERVIEW_ADDPARTS", "TOK_ALTERVIEW_DROPPARTS", "TOK_ALTERVIEW_DROPPROPERTIES", "TOK_ALTERVIEW_PROPERTIES", "TOK_ALTERVIEW_RENAME", "TOK_ANALYZE", "TOK_ANONYMOUS", "TOK_ARCHIVE", "TOK_BIGINT", "TOK_BINARY", "TOK_BOOLEAN", "TOK_CASCADE", "TOK_CHAR", "TOK_CHARSETLITERAL", "TOK_CLUSTERBY", "TOK_COLTYPELIST", "TOK_COL_NAME", "TOK_CREATEDATABASE", "TOK_CREATEFUNCTION", "TOK_CREATEINDEX", "TOK_CREATEINDEX_INDEXTBLNAME", "TOK_CREATEMACRO", "TOK_CREATEROLE", "TOK_CREATETABLE", "TOK_CREATEVIEW", "TOK_CROSSJOIN", "TOK_CTE", "TOK_CUBE_GROUPBY", "TOK_DATABASECOMMENT", "TOK_DATABASELOCATION", "TOK_DATABASEPROPERTIES", "TOK_DATE", "TOK_DATELITERAL", "TOK_DATETIME", "TOK_DBPROPLIST", "TOK_DB_TYPE", "TOK_DECIMAL", "TOK_DEFERRED_REBUILDINDEX", "TOK_DELETE_FROM", "TOK_DESCDATABASE", "TOK_DESCFUNCTION", "TOK_DESCTABLE", "TOK_DESTINATION", "TOK_DIR", "TOK_DISABLE", "TOK_DISTRIBUTEBY", "TOK_DOUBLE", "TOK_DROPDATABASE", "TOK_DROPFUNCTION", "TOK_DROPINDEX", "TOK_DROPMACRO", "TOK_DROPROLE", "TOK_DROPTABLE", "TOK_DROPVIEW", "TOK_ENABLE", "TOK_EXPLAIN", "TOK_EXPLAIN_SQ_REWRITE", "TOK_EXPLIST", "TOK_EXPORT", "TOK_FALSE", "TOK_FILE", "TOK_FILEFORMAT_GENERIC", "TOK_FLOAT", "TOK_FROM", "TOK_FULLOUTERJOIN", "TOK_FUNCTION", "TOK_FUNCTIONDI", "TOK_FUNCTIONSTAR", "TOK_GRANT", "TOK_GRANT_OPTION_FOR", "TOK_GRANT_ROLE", "TOK_GRANT_WITH_ADMIN_OPTION", "TOK_GRANT_WITH_OPTION", "TOK_GROUP", "TOK_GROUPBY", "TOK_GROUPING_SETS", "TOK_GROUPING_SETS_EXPRESSION", "TOK_HAVING", "TOK_HINT", "TOK_HINTARGLIST", "TOK_HINTLIST", "TOK_HOLD_DDLTIME", "TOK_IFEXISTS", "TOK_IFNOTEXISTS", "TOK_IGNOREPROTECTION", "TOK_IMPORT", "TOK_INDEXCOMMENT", "TOK_INDEXPROPERTIES", "TOK_INDEXPROPLIST", "TOK_INSERT", "TOK_INSERT_INTO", "TOK_INT", "TOK_INTERVAL_DAY_LITERAL", "TOK_INTERVAL_DAY_TIME", "TOK_INTERVAL_DAY_TIME_LITERAL", "TOK_INTERVAL_HOUR_LITERAL", "TOK_INTERVAL_MINUTE_LITERAL", "TOK_INTERVAL_MONTH_LITERAL", "TOK_INTERVAL_SECOND_LITERAL", "TOK_INTERVAL_YEAR_LITERAL", "TOK_INTERVAL_YEAR_MONTH", "TOK_INTERVAL_YEAR_MONTH_LITERAL", "TOK_ISNOTNULL", "TOK_ISNULL", "TOK_JAR", "TOK_JOIN", "TOK_LATERAL_VIEW", "TOK_LATERAL_VIEW_OUTER", "TOK_LEFTOUTERJOIN", "TOK_LEFTSEMIJOIN", "TOK_LENGTH", "TOK_LIKETABLE", "TOK_LIMIT", "TOK_LIST", "TOK_LOAD", "TOK_LOCKDB", "TOK_LOCKTABLE", "TOK_MAP", "TOK_MAPJOIN", "TOK_METADATA", "TOK_MSCK", "TOK_NOT_CLUSTERED", "TOK_NOT_SORTED", "TOK_NO_DROP", "TOK_NULL", "TOK_OFFLINE", "TOK_OP_ADD", "TOK_OP_AND", "TOK_OP_BITAND", "TOK_OP_BITNOT", "TOK_OP_BITOR", "TOK_OP_BITXOR", "TOK_OP_DIV", "TOK_OP_EQ", "TOK_OP_GE", "TOK_OP_GT", "TOK_OP_LE", "TOK_OP_LIKE", "TOK_OP_LT", "TOK_OP_MOD", "TOK_OP_MUL", "TOK_OP_NE", "TOK_OP_NOT", "TOK_OP_OR", "TOK_OP_SUB", "TOK_ORDERBY", "TOK_ORREPLACE", "TOK_PARTITIONINGSPEC", "TOK_PARTITIONLOCATION", "TOK_PARTSPEC", "TOK_PARTVAL", "TOK_PERCENT", "TOK_PRINCIPAL_NAME", "TOK_PRIVILEGE", "TOK_PRIVILEGE_LIST", "TOK_PRIV_ALL", "TOK_PRIV_ALTER_DATA", "TOK_PRIV_ALTER_METADATA", "TOK_PRIV_CREATE", "TOK_PRIV_DELETE", "TOK_PRIV_DROP", "TOK_PRIV_INDEX", "TOK_PRIV_INSERT", "TOK_PRIV_LOCK", "TOK_PRIV_OBJECT", "TOK_PRIV_OBJECT_COL", "TOK_PRIV_SELECT", "TOK_PRIV_SHOW_DATABASE", "TOK_PTBLFUNCTION", "TOK_QUERY", "TOK_READONLY", "TOK_RECORDREADER", "TOK_RECORDWRITER", "TOK_RELOADFUNCTION", "TOK_REPLICATION", "TOK_RESOURCE_ALL", "TOK_RESOURCE_LIST", "TOK_RESOURCE_URI", "TOK_RESTRICT", "TOK_REVOKE", "TOK_REVOKE_ROLE", "TOK_RIGHTOUTERJOIN", "TOK_ROLE", "TOK_ROLLUP_GROUPBY", "TOK_ROWCOUNT", "TOK_SELECT", "TOK_SELECTDI", "TOK_SELEXPR", "TOK_SERDE", "TOK_SERDENAME", "TOK_SERDEPROPS", "TOK_SERVER_TYPE", "TOK_SET_COLUMNS_CLAUSE", "TOK_SHOWCOLUMNS", "TOK_SHOWCONF", "TOK_SHOWDATABASES", "TOK_SHOWDBLOCKS", "TOK_SHOWFUNCTIONS", "TOK_SHOWINDEXES", "TOK_SHOWLOCKS", "TOK_SHOWPARTITIONS", "TOK_SHOWTABLES", "TOK_SHOW_COMPACTIONS", "TOK_SHOW_CREATETABLE", "TOK_SHOW_GRANT", "TOK_SHOW_ROLES", "TOK_SHOW_ROLE_GRANT", "TOK_SHOW_ROLE_PRINCIPALS", "TOK_SHOW_SET_ROLE", "TOK_SHOW_TABLESTATUS", "TOK_SHOW_TBLPROPERTIES", "TOK_SHOW_TRANSACTIONS", "TOK_SKEWED_LOCATIONS", "TOK_SKEWED_LOCATION_LIST", "TOK_SKEWED_LOCATION_MAP", "TOK_SMALLINT", "TOK_SORTBY", "TOK_STORAGEHANDLER", "TOK_STOREDASDIRS", "TOK_STREAMTABLE", "TOK_STRING", "TOK_STRINGLITERALSEQUENCE", "TOK_STRUCT", "TOK_SUBQUERY", "TOK_SUBQUERY_EXPR", "TOK_SUBQUERY_OP", "TOK_SUBQUERY_OP_NOTEXISTS", "TOK_SUBQUERY_OP_NOTIN", "TOK_SWITCHDATABASE", "TOK_TAB", "TOK_TABALIAS", "TOK_TABCOL", "TOK_TABCOLLIST", "TOK_TABCOLNAME", "TOK_TABCOLVALUE", "TOK_TABCOLVALUES", "TOK_TABCOLVALUE_PAIR", "TOK_TABLEBUCKETSAMPLE", "TOK_TABLECOMMENT", "TOK_TABLEFILEFORMAT", "TOK_TABLELOCATION", "TOK_TABLEPARTCOLS", "TOK_TABLEPROPERTIES", "TOK_TABLEPROPERTY", "TOK_TABLEPROPLIST", "TOK_TABLEROWFORMAT", "TOK_TABLEROWFORMATCOLLITEMS", "TOK_TABLEROWFORMATFIELD", "TOK_TABLEROWFORMATLINES", "TOK_TABLEROWFORMATMAPKEYS", "TOK_TABLEROWFORMATNULL", "TOK_TABLESERIALIZER", "TOK_TABLESKEWED", "TOK_TABLESPLITSAMPLE", "TOK_TABLE_OR_COL", "TOK_TABLE_PARTITION", "TOK_TABLE_TYPE", "TOK_TABNAME", "TOK_TABREF", "TOK_TABSORTCOLNAMEASC", "TOK_TABSORTCOLNAMEDESC", "TOK_TABSRC", "TOK_TABTYPE", "TOK_TEMPORARY", "TOK_TIMESTAMP", "TOK_TIMESTAMPLITERAL", "TOK_TINYINT", "TOK_TMP_FILE", "TOK_TRANSFORM", "TOK_TRUE", "TOK_TRUNCATETABLE", "TOK_UNIONALL", "TOK_UNIONDISTINCT", "TOK_UNIONTYPE", "TOK_UNIQUEJOIN", "TOK_UNLOCKDB", "TOK_UNLOCKTABLE", "TOK_UPDATE_TABLE", "TOK_URI_TYPE", "TOK_USER", "TOK_USERSCRIPTCOLNAMES", "TOK_USERSCRIPTCOLSCHEMA", "TOK_VALUES_TABLE", "TOK_VALUE_ROW", "TOK_VARCHAR", "TOK_VIEWPARTCOLS", "TOK_VIRTUAL_TABLE", "TOK_VIRTUAL_TABREF", "TOK_WHERE", "TOK_WINDOWDEF", "TOK_WINDOWRANGE", "TOK_WINDOWSPEC", "TOK_WINDOWVALUES", "933"
    };

    public static final int EOF=-1;
    public static final int AMPERSAND=4;
    public static final int BITWISEOR=5;
    public static final int BITWISEXOR=6;
    public static final int BigintLiteral=7;
    public static final int ByteLengthLiteral=8;
    public static final int COLON=9;
    public static final int COMMA=10;
    public static final int COMMENT=11;
    public static final int CharSetLiteral=12;
    public static final int CharSetName=13;
    public static final int DIV=14;
    public static final int DIVIDE=15;
    public static final int DOLLAR=16;
    public static final int DOT=17;
    public static final int DecimalLiteral=18;
    public static final int Digit=19;
    public static final int EQUAL=20;
    public static final int EQUAL_NS=21;
    public static final int Exponent=22;
    public static final int GREATERTHAN=23;
    public static final int GREATERTHANOREQUALTO=24;
    public static final int HexDigit=25;
    public static final int Identifier=26;
    public static final int KW_ADD=27;
    public static final int KW_ADMIN=28;
    public static final int KW_AFTER=29;
    public static final int KW_ALL=30;
    public static final int KW_ALTER=31;
    public static final int KW_ANALYZE=32;
    public static final int KW_AND=33;
    public static final int KW_ARCHIVE=34;
    public static final int KW_ARRAY=35;
    public static final int KW_AS=36;
    public static final int KW_ASC=37;
    public static final int KW_AUTHORIZATION=38;
    public static final int KW_BEFORE=39;
    public static final int KW_BETWEEN=40;
    public static final int KW_BIGINT=41;
    public static final int KW_BINARY=42;
    public static final int KW_BOOLEAN=43;
    public static final int KW_BOTH=44;
    public static final int KW_BUCKET=45;
    public static final int KW_BUCKETS=46;
    public static final int KW_BY=47;
    public static final int KW_CASCADE=48;
    public static final int KW_CASE=49;
    public static final int KW_CAST=50;
    public static final int KW_CHANGE=51;
    public static final int KW_CHAR=52;
    public static final int KW_CLUSTER=53;
    public static final int KW_CLUSTERED=54;
    public static final int KW_CLUSTERSTATUS=55;
    public static final int KW_COLLECTION=56;
    public static final int KW_COLUMN=57;
    public static final int KW_COLUMNS=58;
    public static final int KW_COMMENT=59;
    public static final int KW_COMPACT=60;
    public static final int KW_COMPACTIONS=61;
    public static final int KW_COMPUTE=62;
    public static final int KW_CONCATENATE=63;
    public static final int KW_CONF=64;
    public static final int KW_CONTINUE=65;
    public static final int KW_CREATE=66;
    public static final int KW_CROSS=67;
    public static final int KW_CUBE=68;
    public static final int KW_CURRENT=69;
    public static final int KW_CURRENT_DATE=70;
    public static final int KW_CURRENT_TIMESTAMP=71;
    public static final int KW_CURSOR=72;
    public static final int KW_DATA=73;
    public static final int KW_DATABASE=74;
    public static final int KW_DATABASES=75;
    public static final int KW_DATE=76;
    public static final int KW_DATETIME=77;
    public static final int KW_DAY=78;
    public static final int KW_DBPROPERTIES=79;
    public static final int KW_DECIMAL=80;
    public static final int KW_DEFERRED=81;
    public static final int KW_DEFINED=82;
    public static final int KW_DELETE=83;
    public static final int KW_DELIMITED=84;
    public static final int KW_DEPENDENCY=85;
    public static final int KW_DESC=86;
    public static final int KW_DESCRIBE=87;
    public static final int KW_DIRECTORIES=88;
    public static final int KW_DIRECTORY=89;
    public static final int KW_DISABLE=90;
    public static final int KW_DISTINCT=91;
    public static final int KW_DISTRIBUTE=92;
    public static final int KW_DOUBLE=93;
    public static final int KW_DROP=94;
    public static final int KW_ELEM_TYPE=95;
    public static final int KW_ELSE=96;
    public static final int KW_ENABLE=97;
    public static final int KW_END=98;
    public static final int KW_ESCAPED=99;
    public static final int KW_EXCHANGE=100;
    public static final int KW_EXCLUSIVE=101;
    public static final int KW_EXISTS=102;
    public static final int KW_EXPLAIN=103;
    public static final int KW_EXPORT=104;
    public static final int KW_EXTENDED=105;
    public static final int KW_EXTERNAL=106;
    public static final int KW_FALSE=107;
    public static final int KW_FETCH=108;
    public static final int KW_FIELDS=109;
    public static final int KW_FILE=110;
    public static final int KW_FILEFORMAT=111;
    public static final int KW_FIRST=112;
    public static final int KW_FLOAT=113;
    public static final int KW_FOLLOWING=114;
    public static final int KW_FOR=115;
    public static final int KW_FORMAT=116;
    public static final int KW_FORMATTED=117;
    public static final int KW_FROM=118;
    public static final int KW_FULL=119;
    public static final int KW_FUNCTION=120;
    public static final int KW_FUNCTIONS=121;
    public static final int KW_GRANT=122;
    public static final int KW_GROUP=123;
    public static final int KW_GROUPING=124;
    public static final int KW_HAVING=125;
    public static final int KW_HOLD_DDLTIME=126;
    public static final int KW_HOUR=127;
    public static final int KW_IDXPROPERTIES=128;
    public static final int KW_IF=129;
    public static final int KW_IGNORE=130;
    public static final int KW_IMPORT=131;
    public static final int KW_IN=132;
    public static final int KW_INDEX=133;
    public static final int KW_INDEXES=134;
    public static final int KW_INNER=135;
    public static final int KW_INPATH=136;
    public static final int KW_INPUTDRIVER=137;
    public static final int KW_INPUTFORMAT=138;
    public static final int KW_INSERT=139;
    public static final int KW_INT=140;
    public static final int KW_INTERSECT=141;
    public static final int KW_INTERVAL=142;
    public static final int KW_INTO=143;
    public static final int KW_IS=144;
    public static final int KW_ITEMS=145;
    public static final int KW_JAR=146;
    public static final int KW_JOIN=147;
    public static final int KW_KEYS=148;
    public static final int KW_KEY_TYPE=149;
    public static final int KW_LATERAL=150;
    public static final int KW_LEFT=151;
    public static final int KW_LESS=152;
    public static final int KW_LIKE=153;
    public static final int KW_LIMIT=154;
    public static final int KW_LINES=155;
    public static final int KW_LOAD=156;
    public static final int KW_LOCAL=157;
    public static final int KW_LOCATION=158;
    public static final int KW_LOCK=159;
    public static final int KW_LOCKS=160;
    public static final int KW_LOGICAL=161;
    public static final int KW_LONG=162;
    public static final int KW_MACRO=163;
    public static final int KW_MAP=164;
    public static final int KW_MAPJOIN=165;
    public static final int KW_MATERIALIZED=166;
    public static final int KW_METADATA=167;
    public static final int KW_MINUS=168;
    public static final int KW_MINUTE=169;
    public static final int KW_MONTH=170;
    public static final int KW_MORE=171;
    public static final int KW_MSCK=172;
    public static final int KW_NONE=173;
    public static final int KW_NOSCAN=174;
    public static final int KW_NOT=175;
    public static final int KW_NO_DROP=176;
    public static final int KW_NULL=177;
    public static final int KW_OF=178;
    public static final int KW_OFFLINE=179;
    public static final int KW_ON=180;
    public static final int KW_OPTION=181;
    public static final int KW_OR=182;
    public static final int KW_ORDER=183;
    public static final int KW_OUT=184;
    public static final int KW_OUTER=185;
    public static final int KW_OUTPUTDRIVER=186;
    public static final int KW_OUTPUTFORMAT=187;
    public static final int KW_OVER=188;
    public static final int KW_OVERWRITE=189;
    public static final int KW_OWNER=190;
    public static final int KW_PARTIALSCAN=191;
    public static final int KW_PARTITION=192;
    public static final int KW_PARTITIONED=193;
    public static final int KW_PARTITIONS=194;
    public static final int KW_PERCENT=195;
    public static final int KW_PLUS=196;
    public static final int KW_PRECEDING=197;
    public static final int KW_PRESERVE=198;
    public static final int KW_PRETTY=199;
    public static final int KW_PRINCIPALS=200;
    public static final int KW_PROCEDURE=201;
    public static final int KW_PROTECTION=202;
    public static final int KW_PURGE=203;
    public static final int KW_RANGE=204;
    public static final int KW_READ=205;
    public static final int KW_READONLY=206;
    public static final int KW_READS=207;
    public static final int KW_REBUILD=208;
    public static final int KW_RECORDREADER=209;
    public static final int KW_RECORDWRITER=210;
    public static final int KW_REDUCE=211;
    public static final int KW_REGEXP=212;
    public static final int KW_RELOAD=213;
    public static final int KW_RENAME=214;
    public static final int KW_REPAIR=215;
    public static final int KW_REPLACE=216;
    public static final int KW_REPLICATION=217;
    public static final int KW_RESTRICT=218;
    public static final int KW_REVOKE=219;
    public static final int KW_REWRITE=220;
    public static final int KW_RIGHT=221;
    public static final int KW_RLIKE=222;
    public static final int KW_ROLE=223;
    public static final int KW_ROLES=224;
    public static final int KW_ROLLUP=225;
    public static final int KW_ROW=226;
    public static final int KW_ROWS=227;
    public static final int KW_SCHEMA=228;
    public static final int KW_SCHEMAS=229;
    public static final int KW_SECOND=230;
    public static final int KW_SELECT=231;
    public static final int KW_SEMI=232;
    public static final int KW_SERDE=233;
    public static final int KW_SERDEPROPERTIES=234;
    public static final int KW_SERVER=235;
    public static final int KW_SET=236;
    public static final int KW_SETS=237;
    public static final int KW_SHARED=238;
    public static final int KW_SHOW=239;
    public static final int KW_SHOW_DATABASE=240;
    public static final int KW_SKEWED=241;
    public static final int KW_SMALLINT=242;
    public static final int KW_SORT=243;
    public static final int KW_SORTED=244;
    public static final int KW_SSL=245;
    public static final int KW_STATISTICS=246;
    public static final int KW_STORED=247;
    public static final int KW_STREAMTABLE=248;
    public static final int KW_STRING=249;
    public static final int KW_STRUCT=250;
    public static final int KW_TABLE=251;
    public static final int KW_TABLES=252;
    public static final int KW_TABLESAMPLE=253;
    public static final int KW_TBLPROPERTIES=254;
    public static final int KW_TEMPORARY=255;
    public static final int KW_TERMINATED=256;
    public static final int KW_THEN=257;
    public static final int KW_TIMESTAMP=258;
    public static final int KW_TINYINT=259;
    public static final int KW_TO=260;
    public static final int KW_TOUCH=261;
    public static final int KW_TRANSACTIONS=262;
    public static final int KW_TRANSFORM=263;
    public static final int KW_TRIGGER=264;
    public static final int KW_TRUE=265;
    public static final int KW_TRUNCATE=266;
    public static final int KW_UNARCHIVE=267;
    public static final int KW_UNBOUNDED=268;
    public static final int KW_UNDO=269;
    public static final int KW_UNION=270;
    public static final int KW_UNIONTYPE=271;
    public static final int KW_UNIQUEJOIN=272;
    public static final int KW_UNLOCK=273;
    public static final int KW_UNSET=274;
    public static final int KW_UNSIGNED=275;
    public static final int KW_UPDATE=276;
    public static final int KW_URI=277;
    public static final int KW_USE=278;
    public static final int KW_USER=279;
    public static final int KW_USING=280;
    public static final int KW_UTC=281;
    public static final int KW_UTCTIMESTAMP=282;
    public static final int KW_VALUES=283;
    public static final int KW_VALUE_TYPE=284;
    public static final int KW_VARCHAR=285;
    public static final int KW_VIEW=286;
    public static final int KW_WHEN=287;
    public static final int KW_WHERE=288;
    public static final int KW_WHILE=289;
    public static final int KW_WINDOW=290;
    public static final int KW_WITH=291;
    public static final int KW_YEAR=292;
    public static final int LCURLY=293;
    public static final int LESSTHAN=294;
    public static final int LESSTHANOREQUALTO=295;
    public static final int LPAREN=296;
    public static final int LSQUARE=297;
    public static final int Letter=298;
    public static final int MINUS=299;
    public static final int MOD=300;
    public static final int NOTEQUAL=301;
    public static final int Number=302;
    public static final int PLUS=303;
    public static final int QUESTION=304;
    public static final int QuotedIdentifier=305;
    public static final int RCURLY=306;
    public static final int RPAREN=307;
    public static final int RSQUARE=308;
    public static final int RegexComponent=309;
    public static final int SEMICOLON=310;
    public static final int STAR=311;
    public static final int SmallintLiteral=312;
    public static final int StringLiteral=313;
    public static final int TILDE=314;
    public static final int TinyintLiteral=315;
    public static final int WS=316;
    public static final int TOK_ADMIN_OPTION_FOR=604;
    public static final int TOK_ALIASLIST=605;
    public static final int TOK_ALLCOLREF=606;
    public static final int TOK_ALTERDATABASE_OWNER=607;
    public static final int TOK_ALTERDATABASE_PROPERTIES=608;
    public static final int TOK_ALTERINDEX_PROPERTIES=609;
    public static final int TOK_ALTERINDEX_REBUILD=610;
    public static final int TOK_ALTERTABLE=611;
    public static final int TOK_ALTERTABLE_ADDCOLS=612;
    public static final int TOK_ALTERTABLE_ADDPARTS=613;
    public static final int TOK_ALTERTABLE_ARCHIVE=614;
    public static final int TOK_ALTERTABLE_BUCKETS=615;
    public static final int TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION=616;
    public static final int TOK_ALTERTABLE_CLUSTER_SORT=617;
    public static final int TOK_ALTERTABLE_COMPACT=618;
    public static final int TOK_ALTERTABLE_DROPPARTS=619;
    public static final int TOK_ALTERTABLE_DROPPROPERTIES=620;
    public static final int TOK_ALTERTABLE_EXCHANGEPARTITION=621;
    public static final int TOK_ALTERTABLE_FILEFORMAT=622;
    public static final int TOK_ALTERTABLE_LOCATION=623;
    public static final int TOK_ALTERTABLE_MERGEFILES=624;
    public static final int TOK_ALTERTABLE_PARTCOLTYPE=625;
    public static final int TOK_ALTERTABLE_PROPERTIES=626;
    public static final int TOK_ALTERTABLE_PROTECTMODE=627;
    public static final int TOK_ALTERTABLE_RENAME=628;
    public static final int TOK_ALTERTABLE_RENAMECOL=629;
    public static final int TOK_ALTERTABLE_RENAMEPART=630;
    public static final int TOK_ALTERTABLE_REPLACECOLS=631;
    public static final int TOK_ALTERTABLE_SERDEPROPERTIES=632;
    public static final int TOK_ALTERTABLE_SERIALIZER=633;
    public static final int TOK_ALTERTABLE_SKEWED=634;
    public static final int TOK_ALTERTABLE_SKEWED_LOCATION=635;
    public static final int TOK_ALTERTABLE_TOUCH=636;
    public static final int TOK_ALTERTABLE_UNARCHIVE=637;
    public static final int TOK_ALTERTABLE_UPDATECOLSTATS=638;
    public static final int TOK_ALTERVIEW=639;
    public static final int TOK_ALTERVIEW_ADDPARTS=640;
    public static final int TOK_ALTERVIEW_DROPPARTS=641;
    public static final int TOK_ALTERVIEW_DROPPROPERTIES=642;
    public static final int TOK_ALTERVIEW_PROPERTIES=643;
    public static final int TOK_ALTERVIEW_RENAME=644;
    public static final int TOK_ANALYZE=645;
    public static final int TOK_ANONYMOUS=646;
    public static final int TOK_ARCHIVE=647;
    public static final int TOK_BIGINT=648;
    public static final int TOK_BINARY=649;
    public static final int TOK_BOOLEAN=650;
    public static final int TOK_CASCADE=651;
    public static final int TOK_CHAR=652;
    public static final int TOK_CHARSETLITERAL=653;
    public static final int TOK_CLUSTERBY=654;
    public static final int TOK_COLTYPELIST=655;
    public static final int TOK_COL_NAME=656;
    public static final int TOK_CREATEDATABASE=657;
    public static final int TOK_CREATEFUNCTION=658;
    public static final int TOK_CREATEINDEX=659;
    public static final int TOK_CREATEINDEX_INDEXTBLNAME=660;
    public static final int TOK_CREATEMACRO=661;
    public static final int TOK_CREATEROLE=662;
    public static final int TOK_CREATETABLE=663;
    public static final int TOK_CREATEVIEW=664;
    public static final int TOK_CROSSJOIN=665;
    public static final int TOK_CTE=666;
    public static final int TOK_CUBE_GROUPBY=667;
    public static final int TOK_DATABASECOMMENT=668;
    public static final int TOK_DATABASELOCATION=669;
    public static final int TOK_DATABASEPROPERTIES=670;
    public static final int TOK_DATE=671;
    public static final int TOK_DATELITERAL=672;
    public static final int TOK_DATETIME=673;
    public static final int TOK_DBPROPLIST=674;
    public static final int TOK_DB_TYPE=675;
    public static final int TOK_DECIMAL=676;
    public static final int TOK_DEFERRED_REBUILDINDEX=677;
    public static final int TOK_DELETE_FROM=678;
    public static final int TOK_DESCDATABASE=679;
    public static final int TOK_DESCFUNCTION=680;
    public static final int TOK_DESCTABLE=681;
    public static final int TOK_DESTINATION=682;
    public static final int TOK_DIR=683;
    public static final int TOK_DISABLE=684;
    public static final int TOK_DISTRIBUTEBY=685;
    public static final int TOK_DOUBLE=686;
    public static final int TOK_DROPDATABASE=687;
    public static final int TOK_DROPFUNCTION=688;
    public static final int TOK_DROPINDEX=689;
    public static final int TOK_DROPMACRO=690;
    public static final int TOK_DROPROLE=691;
    public static final int TOK_DROPTABLE=692;
    public static final int TOK_DROPVIEW=693;
    public static final int TOK_ENABLE=694;
    public static final int TOK_EXPLAIN=695;
    public static final int TOK_EXPLAIN_SQ_REWRITE=696;
    public static final int TOK_EXPLIST=697;
    public static final int TOK_EXPORT=698;
    public static final int TOK_FALSE=699;
    public static final int TOK_FILE=700;
    public static final int TOK_FILEFORMAT_GENERIC=701;
    public static final int TOK_FLOAT=702;
    public static final int TOK_FROM=703;
    public static final int TOK_FULLOUTERJOIN=704;
    public static final int TOK_FUNCTION=705;
    public static final int TOK_FUNCTIONDI=706;
    public static final int TOK_FUNCTIONSTAR=707;
    public static final int TOK_GRANT=708;
    public static final int TOK_GRANT_OPTION_FOR=709;
    public static final int TOK_GRANT_ROLE=710;
    public static final int TOK_GRANT_WITH_ADMIN_OPTION=711;
    public static final int TOK_GRANT_WITH_OPTION=712;
    public static final int TOK_GROUP=713;
    public static final int TOK_GROUPBY=714;
    public static final int TOK_GROUPING_SETS=715;
    public static final int TOK_GROUPING_SETS_EXPRESSION=716;
    public static final int TOK_HAVING=717;
    public static final int TOK_HINT=718;
    public static final int TOK_HINTARGLIST=719;
    public static final int TOK_HINTLIST=720;
    public static final int TOK_HOLD_DDLTIME=721;
    public static final int TOK_IFEXISTS=722;
    public static final int TOK_IFNOTEXISTS=723;
    public static final int TOK_IGNOREPROTECTION=724;
    public static final int TOK_IMPORT=725;
    public static final int TOK_INDEXCOMMENT=726;
    public static final int TOK_INDEXPROPERTIES=727;
    public static final int TOK_INDEXPROPLIST=728;
    public static final int TOK_INSERT=729;
    public static final int TOK_INSERT_INTO=730;
    public static final int TOK_INT=731;
    public static final int TOK_INTERVAL_DAY_LITERAL=732;
    public static final int TOK_INTERVAL_DAY_TIME=733;
    public static final int TOK_INTERVAL_DAY_TIME_LITERAL=734;
    public static final int TOK_INTERVAL_HOUR_LITERAL=735;
    public static final int TOK_INTERVAL_MINUTE_LITERAL=736;
    public static final int TOK_INTERVAL_MONTH_LITERAL=737;
    public static final int TOK_INTERVAL_SECOND_LITERAL=738;
    public static final int TOK_INTERVAL_YEAR_LITERAL=739;
    public static final int TOK_INTERVAL_YEAR_MONTH=740;
    public static final int TOK_INTERVAL_YEAR_MONTH_LITERAL=741;
    public static final int TOK_ISNOTNULL=742;
    public static final int TOK_ISNULL=743;
    public static final int TOK_JAR=744;
    public static final int TOK_JOIN=745;
    public static final int TOK_LATERAL_VIEW=746;
    public static final int TOK_LATERAL_VIEW_OUTER=747;
    public static final int TOK_LEFTOUTERJOIN=748;
    public static final int TOK_LEFTSEMIJOIN=749;
    public static final int TOK_LENGTH=750;
    public static final int TOK_LIKETABLE=751;
    public static final int TOK_LIMIT=752;
    public static final int TOK_LIST=753;
    public static final int TOK_LOAD=754;
    public static final int TOK_LOCKDB=755;
    public static final int TOK_LOCKTABLE=756;
    public static final int TOK_MAP=757;
    public static final int TOK_MAPJOIN=758;
    public static final int TOK_METADATA=759;
    public static final int TOK_MSCK=760;
    public static final int TOK_NOT_CLUSTERED=761;
    public static final int TOK_NOT_SORTED=762;
    public static final int TOK_NO_DROP=763;
    public static final int TOK_NULL=764;
    public static final int TOK_OFFLINE=765;
    public static final int TOK_OP_ADD=766;
    public static final int TOK_OP_AND=767;
    public static final int TOK_OP_BITAND=768;
    public static final int TOK_OP_BITNOT=769;
    public static final int TOK_OP_BITOR=770;
    public static final int TOK_OP_BITXOR=771;
    public static final int TOK_OP_DIV=772;
    public static final int TOK_OP_EQ=773;
    public static final int TOK_OP_GE=774;
    public static final int TOK_OP_GT=775;
    public static final int TOK_OP_LE=776;
    public static final int TOK_OP_LIKE=777;
    public static final int TOK_OP_LT=778;
    public static final int TOK_OP_MOD=779;
    public static final int TOK_OP_MUL=780;
    public static final int TOK_OP_NE=781;
    public static final int TOK_OP_NOT=782;
    public static final int TOK_OP_OR=783;
    public static final int TOK_OP_SUB=784;
    public static final int TOK_ORDERBY=785;
    public static final int TOK_ORREPLACE=786;
    public static final int TOK_PARTITIONINGSPEC=787;
    public static final int TOK_PARTITIONLOCATION=788;
    public static final int TOK_PARTSPEC=789;
    public static final int TOK_PARTVAL=790;
    public static final int TOK_PERCENT=791;
    public static final int TOK_PRINCIPAL_NAME=792;
    public static final int TOK_PRIVILEGE=793;
    public static final int TOK_PRIVILEGE_LIST=794;
    public static final int TOK_PRIV_ALL=795;
    public static final int TOK_PRIV_ALTER_DATA=796;
    public static final int TOK_PRIV_ALTER_METADATA=797;
    public static final int TOK_PRIV_CREATE=798;
    public static final int TOK_PRIV_DELETE=799;
    public static final int TOK_PRIV_DROP=800;
    public static final int TOK_PRIV_INDEX=801;
    public static final int TOK_PRIV_INSERT=802;
    public static final int TOK_PRIV_LOCK=803;
    public static final int TOK_PRIV_OBJECT=804;
    public static final int TOK_PRIV_OBJECT_COL=805;
    public static final int TOK_PRIV_SELECT=806;
    public static final int TOK_PRIV_SHOW_DATABASE=807;
    public static final int TOK_PTBLFUNCTION=808;
    public static final int TOK_QUERY=809;
    public static final int TOK_READONLY=810;
    public static final int TOK_RECORDREADER=811;
    public static final int TOK_RECORDWRITER=812;
    public static final int TOK_RELOADFUNCTION=813;
    public static final int TOK_REPLICATION=814;
    public static final int TOK_RESOURCE_ALL=815;
    public static final int TOK_RESOURCE_LIST=816;
    public static final int TOK_RESOURCE_URI=817;
    public static final int TOK_RESTRICT=818;
    public static final int TOK_REVOKE=819;
    public static final int TOK_REVOKE_ROLE=820;
    public static final int TOK_RIGHTOUTERJOIN=821;
    public static final int TOK_ROLE=822;
    public static final int TOK_ROLLUP_GROUPBY=823;
    public static final int TOK_ROWCOUNT=824;
    public static final int TOK_SELECT=825;
    public static final int TOK_SELECTDI=826;
    public static final int TOK_SELEXPR=827;
    public static final int TOK_SERDE=828;
    public static final int TOK_SERDENAME=829;
    public static final int TOK_SERDEPROPS=830;
    public static final int TOK_SERVER_TYPE=831;
    public static final int TOK_SET_COLUMNS_CLAUSE=832;
    public static final int TOK_SHOWCOLUMNS=833;
    public static final int TOK_SHOWCONF=834;
    public static final int TOK_SHOWDATABASES=835;
    public static final int TOK_SHOWDBLOCKS=836;
    public static final int TOK_SHOWFUNCTIONS=837;
    public static final int TOK_SHOWINDEXES=838;
    public static final int TOK_SHOWLOCKS=839;
    public static final int TOK_SHOWPARTITIONS=840;
    public static final int TOK_SHOWTABLES=841;
    public static final int TOK_SHOW_COMPACTIONS=842;
    public static final int TOK_SHOW_CREATETABLE=843;
    public static final int TOK_SHOW_GRANT=844;
    public static final int TOK_SHOW_ROLES=845;
    public static final int TOK_SHOW_ROLE_GRANT=846;
    public static final int TOK_SHOW_ROLE_PRINCIPALS=847;
    public static final int TOK_SHOW_SET_ROLE=848;
    public static final int TOK_SHOW_TABLESTATUS=849;
    public static final int TOK_SHOW_TBLPROPERTIES=850;
    public static final int TOK_SHOW_TRANSACTIONS=851;
    public static final int TOK_SKEWED_LOCATIONS=852;
    public static final int TOK_SKEWED_LOCATION_LIST=853;
    public static final int TOK_SKEWED_LOCATION_MAP=854;
    public static final int TOK_SMALLINT=855;
    public static final int TOK_SORTBY=856;
    public static final int TOK_STORAGEHANDLER=857;
    public static final int TOK_STOREDASDIRS=858;
    public static final int TOK_STREAMTABLE=859;
    public static final int TOK_STRING=860;
    public static final int TOK_STRINGLITERALSEQUENCE=861;
    public static final int TOK_STRUCT=862;
    public static final int TOK_SUBQUERY=863;
    public static final int TOK_SUBQUERY_EXPR=864;
    public static final int TOK_SUBQUERY_OP=865;
    public static final int TOK_SUBQUERY_OP_NOTEXISTS=866;
    public static final int TOK_SUBQUERY_OP_NOTIN=867;
    public static final int TOK_SWITCHDATABASE=868;
    public static final int TOK_TAB=869;
    public static final int TOK_TABALIAS=870;
    public static final int TOK_TABCOL=871;
    public static final int TOK_TABCOLLIST=872;
    public static final int TOK_TABCOLNAME=873;
    public static final int TOK_TABCOLVALUE=874;
    public static final int TOK_TABCOLVALUES=875;
    public static final int TOK_TABCOLVALUE_PAIR=876;
    public static final int TOK_TABLEBUCKETSAMPLE=877;
    public static final int TOK_TABLECOMMENT=878;
    public static final int TOK_TABLEFILEFORMAT=879;
    public static final int TOK_TABLELOCATION=880;
    public static final int TOK_TABLEPARTCOLS=881;
    public static final int TOK_TABLEPROPERTIES=882;
    public static final int TOK_TABLEPROPERTY=883;
    public static final int TOK_TABLEPROPLIST=884;
    public static final int TOK_TABLEROWFORMAT=885;
    public static final int TOK_TABLEROWFORMATCOLLITEMS=886;
    public static final int TOK_TABLEROWFORMATFIELD=887;
    public static final int TOK_TABLEROWFORMATLINES=888;
    public static final int TOK_TABLEROWFORMATMAPKEYS=889;
    public static final int TOK_TABLEROWFORMATNULL=890;
    public static final int TOK_TABLESERIALIZER=891;
    public static final int TOK_TABLESKEWED=892;
    public static final int TOK_TABLESPLITSAMPLE=893;
    public static final int TOK_TABLE_OR_COL=894;
    public static final int TOK_TABLE_PARTITION=895;
    public static final int TOK_TABLE_TYPE=896;
    public static final int TOK_TABNAME=897;
    public static final int TOK_TABREF=898;
    public static final int TOK_TABSORTCOLNAMEASC=899;
    public static final int TOK_TABSORTCOLNAMEDESC=900;
    public static final int TOK_TABSRC=901;
    public static final int TOK_TABTYPE=902;
    public static final int TOK_TEMPORARY=903;
    public static final int TOK_TIMESTAMP=904;
    public static final int TOK_TIMESTAMPLITERAL=905;
    public static final int TOK_TINYINT=906;
    public static final int TOK_TMP_FILE=907;
    public static final int TOK_TRANSFORM=908;
    public static final int TOK_TRUE=909;
    public static final int TOK_TRUNCATETABLE=910;
    public static final int TOK_UNIONALL=911;
    public static final int TOK_UNIONDISTINCT=912;
    public static final int TOK_UNIONTYPE=913;
    public static final int TOK_UNIQUEJOIN=914;
    public static final int TOK_UNLOCKDB=915;
    public static final int TOK_UNLOCKTABLE=916;
    public static final int TOK_UPDATE_TABLE=917;
    public static final int TOK_URI_TYPE=918;
    public static final int TOK_USER=919;
    public static final int TOK_USERSCRIPTCOLNAMES=920;
    public static final int TOK_USERSCRIPTCOLSCHEMA=921;
    public static final int TOK_VALUES_TABLE=922;
    public static final int TOK_VALUE_ROW=923;
    public static final int TOK_VARCHAR=924;
    public static final int TOK_VIEWPARTCOLS=925;
    public static final int TOK_VIRTUAL_TABLE=926;
    public static final int TOK_VIRTUAL_TABREF=927;
    public static final int TOK_WHERE=928;
    public static final int TOK_WINDOWDEF=929;
    public static final int TOK_WINDOWRANGE=930;
    public static final int TOK_WINDOWSPEC=931;
    public static final int TOK_WINDOWVALUES=932;

    // delegates
    public HiveParser_SelectClauseParser gSelectClauseParser;
    public HiveParser_FromClauseParser gFromClauseParser;
    public HiveParser_IdentifiersParser gIdentifiersParser;
    public Parser[] getDelegates() {
        return new Parser[] {gSelectClauseParser, gFromClauseParser, gIdentifiersParser};
    }

    // delegators


    public HiveParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }
    public HiveParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
        gSelectClauseParser = new HiveParser_SelectClauseParser(input, state, this);
        gFromClauseParser = new HiveParser_FromClauseParser(input, state, this);
        gIdentifiersParser = new HiveParser_IdentifiersParser(input, state, this);
    }

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
    this.adaptor = adaptor;
    gSelectClauseParser.setTreeAdaptor(this.adaptor);gFromClauseParser.setTreeAdaptor(this.adaptor);gIdentifiersParser.setTreeAdaptor(this.adaptor);
}
public TreeAdaptor getTreeAdaptor() {
    return adaptor;
}
    public String[] getTokenNames() { return HiveParser.tokenNames; }
    public String getGrammarFileName() { return "org/apache/hadoop/hive/ql/parse/HiveParser.g"; }


      ArrayList<ParseError> errors = new ArrayList<ParseError>();
      Stack msgs = new Stack<String>();

      private static HashMap<String, String> xlateMap;
      static {
        xlateMap = new HashMap<String, String>();

        // Keywords
        xlateMap.put("KW_TRUE", "TRUE");
        xlateMap.put("KW_FALSE", "FALSE");
        xlateMap.put("KW_ALL", "ALL");
        xlateMap.put("KW_NONE", "NONE");
        xlateMap.put("KW_AND", "AND");
        xlateMap.put("KW_OR", "OR");
        xlateMap.put("KW_NOT", "NOT");
        xlateMap.put("KW_LIKE", "LIKE");

        xlateMap.put("KW_ASC", "ASC");
        xlateMap.put("KW_DESC", "DESC");
        xlateMap.put("KW_ORDER", "ORDER");
        xlateMap.put("KW_BY", "BY");
        xlateMap.put("KW_GROUP", "GROUP");
        xlateMap.put("KW_WHERE", "WHERE");
        xlateMap.put("KW_FROM", "FROM");
        xlateMap.put("KW_AS", "AS");
        xlateMap.put("KW_SELECT", "SELECT");
        xlateMap.put("KW_DISTINCT", "DISTINCT");
        xlateMap.put("KW_INSERT", "INSERT");
        xlateMap.put("KW_OVERWRITE", "OVERWRITE");
        xlateMap.put("KW_OUTER", "OUTER");
        xlateMap.put("KW_JOIN", "JOIN");
        xlateMap.put("KW_LEFT", "LEFT");
        xlateMap.put("KW_RIGHT", "RIGHT");
        xlateMap.put("KW_FULL", "FULL");
        xlateMap.put("KW_ON", "ON");
        xlateMap.put("KW_PARTITION", "PARTITION");
        xlateMap.put("KW_PARTITIONS", "PARTITIONS");
        xlateMap.put("KW_TABLE", "TABLE");
        xlateMap.put("KW_TABLES", "TABLES");
        xlateMap.put("KW_TBLPROPERTIES", "TBLPROPERTIES");
        xlateMap.put("KW_SHOW", "SHOW");
        xlateMap.put("KW_MSCK", "MSCK");
        xlateMap.put("KW_DIRECTORY", "DIRECTORY");
        xlateMap.put("KW_LOCAL", "LOCAL");
        xlateMap.put("KW_TRANSFORM", "TRANSFORM");
        xlateMap.put("KW_USING", "USING");
        xlateMap.put("KW_CLUSTER", "CLUSTER");
        xlateMap.put("KW_DISTRIBUTE", "DISTRIBUTE");
        xlateMap.put("KW_SORT", "SORT");
        xlateMap.put("KW_UNION", "UNION");
        xlateMap.put("KW_LOAD", "LOAD");
        xlateMap.put("KW_DATA", "DATA");
        xlateMap.put("KW_INPATH", "INPATH");
        xlateMap.put("KW_IS", "IS");
        xlateMap.put("KW_NULL", "NULL");
        xlateMap.put("KW_CREATE", "CREATE");
        xlateMap.put("KW_EXTERNAL", "EXTERNAL");
        xlateMap.put("KW_ALTER", "ALTER");
        xlateMap.put("KW_DESCRIBE", "DESCRIBE");
        xlateMap.put("KW_DROP", "DROP");
        xlateMap.put("KW_RENAME", "RENAME");
        xlateMap.put("KW_TO", "TO");
        xlateMap.put("KW_COMMENT", "COMMENT");
        xlateMap.put("KW_BOOLEAN", "BOOLEAN");
        xlateMap.put("KW_TINYINT", "TINYINT");
        xlateMap.put("KW_SMALLINT", "SMALLINT");
        xlateMap.put("KW_INT", "INT");
        xlateMap.put("KW_BIGINT", "BIGINT");
        xlateMap.put("KW_FLOAT", "FLOAT");
        xlateMap.put("KW_DOUBLE", "DOUBLE");
        xlateMap.put("KW_DATE", "DATE");
        xlateMap.put("KW_DATETIME", "DATETIME");
        xlateMap.put("KW_TIMESTAMP", "TIMESTAMP");
        xlateMap.put("KW_STRING", "STRING");
        xlateMap.put("KW_BINARY", "BINARY");
        xlateMap.put("KW_ARRAY", "ARRAY");
        xlateMap.put("KW_MAP", "MAP");
        xlateMap.put("KW_REDUCE", "REDUCE");
        xlateMap.put("KW_PARTITIONED", "PARTITIONED");
        xlateMap.put("KW_CLUSTERED", "CLUSTERED");
        xlateMap.put("KW_SORTED", "SORTED");
        xlateMap.put("KW_INTO", "INTO");
        xlateMap.put("KW_BUCKETS", "BUCKETS");
        xlateMap.put("KW_ROW", "ROW");
        xlateMap.put("KW_FORMAT", "FORMAT");
        xlateMap.put("KW_DELIMITED", "DELIMITED");
        xlateMap.put("KW_FIELDS", "FIELDS");
        xlateMap.put("KW_TERMINATED", "TERMINATED");
        xlateMap.put("KW_COLLECTION", "COLLECTION");
        xlateMap.put("KW_ITEMS", "ITEMS");
        xlateMap.put("KW_KEYS", "KEYS");
        xlateMap.put("KW_KEY_TYPE", "$KEY$");
        xlateMap.put("KW_LINES", "LINES");
        xlateMap.put("KW_STORED", "STORED");
        xlateMap.put("KW_SEQUENCEFILE", "SEQUENCEFILE");
        xlateMap.put("KW_TEXTFILE", "TEXTFILE");
        xlateMap.put("KW_INPUTFORMAT", "INPUTFORMAT");
        xlateMap.put("KW_OUTPUTFORMAT", "OUTPUTFORMAT");
        xlateMap.put("KW_LOCATION", "LOCATION");
        xlateMap.put("KW_TABLESAMPLE", "TABLESAMPLE");
        xlateMap.put("KW_BUCKET", "BUCKET");
        xlateMap.put("KW_OUT", "OUT");
        xlateMap.put("KW_OF", "OF");
        xlateMap.put("KW_CAST", "CAST");
        xlateMap.put("KW_ADD", "ADD");
        xlateMap.put("KW_REPLACE", "REPLACE");
        xlateMap.put("KW_COLUMNS", "COLUMNS");
        xlateMap.put("KW_RLIKE", "RLIKE");
        xlateMap.put("KW_REGEXP", "REGEXP");
        xlateMap.put("KW_TEMPORARY", "TEMPORARY");
        xlateMap.put("KW_FUNCTION", "FUNCTION");
        xlateMap.put("KW_EXPLAIN", "EXPLAIN");
        xlateMap.put("KW_EXTENDED", "EXTENDED");
        xlateMap.put("KW_SERDE", "SERDE");
        xlateMap.put("KW_WITH", "WITH");
        xlateMap.put("KW_SERDEPROPERTIES", "SERDEPROPERTIES");
        xlateMap.put("KW_LIMIT", "LIMIT");
        xlateMap.put("KW_SET", "SET");
        xlateMap.put("KW_PROPERTIES", "TBLPROPERTIES");
        xlateMap.put("KW_VALUE_TYPE", "$VALUE$");
        xlateMap.put("KW_ELEM_TYPE", "$ELEM$");
        xlateMap.put("KW_DEFINED", "DEFINED");
        xlateMap.put("KW_SUBQUERY", "SUBQUERY");
        xlateMap.put("KW_REWRITE", "REWRITE");
        xlateMap.put("KW_UPDATE", "UPDATE");
        xlateMap.put("KW_VALUES", "VALUES");
        xlateMap.put("KW_PURGE", "PURGE");


        // Operators
        xlateMap.put("DOT", ".");
        xlateMap.put("COLON", ":");
        xlateMap.put("COMMA", ",");
        xlateMap.put("SEMICOLON", ");");

        xlateMap.put("LPAREN", "(");
        xlateMap.put("RPAREN", ")");
        xlateMap.put("LSQUARE", "[");
        xlateMap.put("RSQUARE", "]");

        xlateMap.put("EQUAL", "=");
        xlateMap.put("NOTEQUAL", "<>");
        xlateMap.put("EQUAL_NS", "<=>");
        xlateMap.put("LESSTHANOREQUALTO", "<=");
        xlateMap.put("LESSTHAN", "<");
        xlateMap.put("GREATERTHANOREQUALTO", ">=");
        xlateMap.put("GREATERTHAN", ">");

        xlateMap.put("DIVIDE", "/");
        xlateMap.put("PLUS", "+");
        xlateMap.put("MINUS", "-");
        xlateMap.put("STAR", "*");
        xlateMap.put("MOD", "%");

        xlateMap.put("AMPERSAND", "&");
        xlateMap.put("TILDE", "~");
        xlateMap.put("BITWISEOR", "|");
        xlateMap.put("BITWISEXOR", "^");
        xlateMap.put("CharSetLiteral", "\\'");
      }

      public static Collection<String> getKeywords() {
        return xlateMap.values();
      }

      private static String xlate(String name) {

        String ret = xlateMap.get(name);
        if (ret == null) {
          ret = name;
        }

        return ret;
      }

      @Override
      public Object recoverFromMismatchedSet(IntStream input,
          RecognitionException re, BitSet follow) throws RecognitionException {
        throw re;
      }

      @Override
      public void displayRecognitionError(String[] tokenNames,
          RecognitionException e) {
        errors.add(new ParseError(this, e, tokenNames));
      }

      @Override
      public String getErrorHeader(RecognitionException e) {
        String header = null;
        if (e.charPositionInLine < 0 && input.LT(-1) != null) {
          Token t = input.LT(-1);
          header = "line " + t.getLine() + ":" + t.getCharPositionInLine();
        } else {
          header = super.getErrorHeader(e);
        }

        return header;
      }
      
      @Override
      public String getErrorMessage(RecognitionException e, String[] tokenNames) {
        String msg = null;

        // Translate the token names to something that the user can understand
        String[] xlateNames = new String[tokenNames.length];
        for (int i = 0; i < tokenNames.length; ++i) {
          xlateNames[i] = HiveParser.xlate(tokenNames[i]);
        }

        if (e instanceof NoViableAltException) {
          @SuppressWarnings("unused")
          NoViableAltException nvae = (NoViableAltException) e;
          // for development, can add
          // "decision=<<"+nvae.grammarDecisionDescription+">>"
          // and "(decision="+nvae.decisionNumber+") and
          // "state "+nvae.stateNumber
          msg = "cannot recognize input near"
                  + (input.LT(1) != null ? " " + getTokenErrorDisplay(input.LT(1)) : "")
                  + (input.LT(2) != null ? " " + getTokenErrorDisplay(input.LT(2)) : "")
                  + (input.LT(3) != null ? " " + getTokenErrorDisplay(input.LT(3)) : "");
        } else if (e instanceof MismatchedTokenException) {
          MismatchedTokenException mte = (MismatchedTokenException) e;
          msg = super.getErrorMessage(e, xlateNames) + (input.LT(-1) == null ? "":" near '" + input.LT(-1).getText()) + "'";
        } else if (e instanceof FailedPredicateException) {
          FailedPredicateException fpe = (FailedPredicateException) e;
          msg = "Failed to recognize predicate '" + fpe.token.getText() + "'. Failed rule: '" + fpe.ruleName + "'";
        } else {
          msg = super.getErrorMessage(e, xlateNames);
        }

        if (msgs.size() > 0) {
          msg = msg + " in " + msgs.peek();
        }
        return msg;
      }
      
      public void pushMsg(String msg, RecognizerSharedState state) {
        // ANTLR generated code does not wrap the @init code wit this backtracking check,
        //  even if the matching @after has it. If we have parser rules with that are doing
        // some lookahead with syntactic predicates this can cause the push() and pop() calls
        // to become unbalanced, so make sure both push/pop check the backtracking state.
        if (state.backtracking == 0) {
          msgs.push(msg);
        }
      }

      public void popMsg(RecognizerSharedState state) {
        if (state.backtracking == 0) {
          msgs.pop();
        }
      }

      // counter to generate unique union aliases
      private int aliasCounter;
      private String generateUnionAlias() {
        return "_u" + (++aliasCounter);
      }
      private char [] excludedCharForColumnName = {'.', ':'};
      private boolean containExcludedCharForCreateTableColumnName(String input) {
        for(char c : excludedCharForColumnName) {
          if(input.indexOf(c)>-1) {
            return true;
          }
        }
        return false;
      }
      private CommonTree throwSetOpException() throws RecognitionException {
        throw new FailedPredicateException(input, "orderByClause clusterByClause distributeByClause sortByClause limitClause can only be applied to the whole union.", "");
      }
      private CommonTree throwColumnNameException() throws RecognitionException {
        throw new FailedPredicateException(input, Arrays.toString(excludedCharForColumnName) + " can not be used in column name in create table statement.", "");
      }
      private Configuration hiveConf;
      public void setHiveConf(Configuration hiveConf) {
        this.hiveConf = hiveConf;
      }
      protected boolean useSQL11ReservedKeywordsForIdentifier() {
        if(hiveConf==null){
          return false;
        }
        return !HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVE_SUPPORT_SQL11_RESERVED_KEYWORDS);
      }


    public static class statement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:668:1: statement : ( explainStatement EOF | execStatement EOF );
    public final HiveParser.statement_return statement() throws RecognitionException {
        HiveParser.statement_return retval = new HiveParser.statement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token EOF2=null;
        Token EOF4=null;
        HiveParser.explainStatement_return explainStatement1 =null;

        HiveParser.execStatement_return execStatement3 =null;


        CommonTree EOF2_tree=null;
        CommonTree EOF4_tree=null;

        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:669:2: ( explainStatement EOF | execStatement EOF )
            int alt1=2;
            switch ( input.LA(1) ) {
            case KW_EXPLAIN:
                {
                alt1=1;
                }
                break;
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_CREATE:
            case KW_DELETE:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DROP:
            case KW_EXPORT:
            case KW_FROM:
            case KW_GRANT:
            case KW_IMPORT:
            case KW_INSERT:
            case KW_LOAD:
            case KW_LOCK:
            case KW_MAP:
            case KW_MSCK:
            case KW_REDUCE:
            case KW_RELOAD:
            case KW_REVOKE:
            case KW_SELECT:
            case KW_SET:
            case KW_SHOW:
            case KW_TRUNCATE:
            case KW_UNLOCK:
            case KW_UPDATE:
            case KW_USE:
            case KW_WITH:
                {
                alt1=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 1, 0, input);

                throw nvae;

            }

            switch (alt1) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:669:4: explainStatement EOF
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_explainStatement_in_statement1070);
                    explainStatement1=explainStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, explainStatement1.getTree());

                    EOF2=(Token)match(input,EOF,FOLLOW_EOF_in_statement1072); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    EOF2_tree = 
                    (CommonTree)adaptor.create(EOF2)
                    ;
                    adaptor.addChild(root_0, EOF2_tree);
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:670:4: execStatement EOF
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_execStatement_in_statement1077);
                    execStatement3=execStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, execStatement3.getTree());

                    EOF4=(Token)match(input,EOF,FOLLOW_EOF_in_statement1079); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    EOF4_tree = 
                    (CommonTree)adaptor.create(EOF4)
                    ;
                    adaptor.addChild(root_0, EOF4_tree);
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statement"


    public static class explainStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "explainStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:673:1: explainStatement : KW_EXPLAIN ( ( explainOption )* execStatement -> ^( TOK_EXPLAIN execStatement ( explainOption )* ) | KW_REWRITE queryStatementExpression[true] -> ^( TOK_EXPLAIN_SQ_REWRITE queryStatementExpression ) ) ;
    public final HiveParser.explainStatement_return explainStatement() throws RecognitionException {
        HiveParser.explainStatement_return retval = new HiveParser.explainStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_EXPLAIN5=null;
        Token KW_REWRITE8=null;
        HiveParser.explainOption_return explainOption6 =null;

        HiveParser.execStatement_return execStatement7 =null;

        HiveParser.queryStatementExpression_return queryStatementExpression9 =null;


        CommonTree KW_EXPLAIN5_tree=null;
        CommonTree KW_REWRITE8_tree=null;
        RewriteRuleTokenStream stream_KW_REWRITE=new RewriteRuleTokenStream(adaptor,"token KW_REWRITE");
        RewriteRuleTokenStream stream_KW_EXPLAIN=new RewriteRuleTokenStream(adaptor,"token KW_EXPLAIN");
        RewriteRuleSubtreeStream stream_queryStatementExpression=new RewriteRuleSubtreeStream(adaptor,"rule queryStatementExpression");
        RewriteRuleSubtreeStream stream_explainOption=new RewriteRuleSubtreeStream(adaptor,"rule explainOption");
        RewriteRuleSubtreeStream stream_execStatement=new RewriteRuleSubtreeStream(adaptor,"rule execStatement");
         pushMsg("explain statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:676:2: ( KW_EXPLAIN ( ( explainOption )* execStatement -> ^( TOK_EXPLAIN execStatement ( explainOption )* ) | KW_REWRITE queryStatementExpression[true] -> ^( TOK_EXPLAIN_SQ_REWRITE queryStatementExpression ) ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:676:4: KW_EXPLAIN ( ( explainOption )* execStatement -> ^( TOK_EXPLAIN execStatement ( explainOption )* ) | KW_REWRITE queryStatementExpression[true] -> ^( TOK_EXPLAIN_SQ_REWRITE queryStatementExpression ) )
            {
            KW_EXPLAIN5=(Token)match(input,KW_EXPLAIN,FOLLOW_KW_EXPLAIN_in_explainStatement1100); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_EXPLAIN.add(KW_EXPLAIN5);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:676:15: ( ( explainOption )* execStatement -> ^( TOK_EXPLAIN execStatement ( explainOption )* ) | KW_REWRITE queryStatementExpression[true] -> ^( TOK_EXPLAIN_SQ_REWRITE queryStatementExpression ) )
            int alt3=2;
            switch ( input.LA(1) ) {
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_AUTHORIZATION:
            case KW_CREATE:
            case KW_DELETE:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DROP:
            case KW_EXPORT:
            case KW_EXTENDED:
            case KW_FORMATTED:
            case KW_FROM:
            case KW_GRANT:
            case KW_IMPORT:
            case KW_INSERT:
            case KW_LOAD:
            case KW_LOCK:
            case KW_LOGICAL:
            case KW_MAP:
            case KW_MSCK:
            case KW_REDUCE:
            case KW_RELOAD:
            case KW_REVOKE:
            case KW_SELECT:
            case KW_SET:
            case KW_SHOW:
            case KW_TRUNCATE:
            case KW_UNLOCK:
            case KW_UPDATE:
            case KW_USE:
            case KW_WITH:
                {
                alt3=1;
                }
                break;
            case KW_REWRITE:
                {
                alt3=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;

            }

            switch (alt3) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:677:6: ( explainOption )* execStatement
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:677:6: ( explainOption )*
                    loop2:
                    do {
                        int alt2=2;
                        switch ( input.LA(1) ) {
                        case KW_AUTHORIZATION:
                        case KW_DEPENDENCY:
                        case KW_EXTENDED:
                        case KW_FORMATTED:
                        case KW_LOGICAL:
                            {
                            alt2=1;
                            }
                            break;

                        }

                        switch (alt2) {
                    	case 1 :
                    	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:677:6: explainOption
                    	    {
                    	    pushFollow(FOLLOW_explainOption_in_explainStatement1109);
                    	    explainOption6=explainOption();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) stream_explainOption.add(explainOption6.getTree());

                    	    }
                    	    break;

                    	default :
                    	    break loop2;
                        }
                    } while (true);


                    pushFollow(FOLLOW_execStatement_in_explainStatement1112);
                    execStatement7=execStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_execStatement.add(execStatement7.getTree());

                    // AST REWRITE
                    // elements: execStatement, explainOption
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 677:35: -> ^( TOK_EXPLAIN execStatement ( explainOption )* )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:677:38: ^( TOK_EXPLAIN execStatement ( explainOption )* )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_EXPLAIN, "TOK_EXPLAIN")
                        , root_1);

                        adaptor.addChild(root_1, stream_execStatement.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:677:66: ( explainOption )*
                        while ( stream_explainOption.hasNext() ) {
                            adaptor.addChild(root_1, stream_explainOption.nextTree());

                        }
                        stream_explainOption.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:679:9: KW_REWRITE queryStatementExpression[true]
                    {
                    KW_REWRITE8=(Token)match(input,KW_REWRITE,FOLLOW_KW_REWRITE_in_explainStatement1143); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_REWRITE.add(KW_REWRITE8);


                    pushFollow(FOLLOW_queryStatementExpression_in_explainStatement1145);
                    queryStatementExpression9=queryStatementExpression(true);

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_queryStatementExpression.add(queryStatementExpression9.getTree());

                    // AST REWRITE
                    // elements: queryStatementExpression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 679:51: -> ^( TOK_EXPLAIN_SQ_REWRITE queryStatementExpression )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:679:54: ^( TOK_EXPLAIN_SQ_REWRITE queryStatementExpression )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_EXPLAIN_SQ_REWRITE, "TOK_EXPLAIN_SQ_REWRITE")
                        , root_1);

                        adaptor.addChild(root_1, stream_queryStatementExpression.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "explainStatement"


    public static class explainOption_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "explainOption"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:682:1: explainOption : ( KW_EXTENDED | KW_FORMATTED | KW_DEPENDENCY | KW_LOGICAL | KW_AUTHORIZATION );
    public final HiveParser.explainOption_return explainOption() throws RecognitionException {
        HiveParser.explainOption_return retval = new HiveParser.explainOption_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token set10=null;

        CommonTree set10_tree=null;

         msgs.push("explain option"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:685:5: ( KW_EXTENDED | KW_FORMATTED | KW_DEPENDENCY | KW_LOGICAL | KW_AUTHORIZATION )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:
            {
            root_0 = (CommonTree)adaptor.nil();


            set10=(Token)input.LT(1);

            if ( input.LA(1)==KW_AUTHORIZATION||input.LA(1)==KW_DEPENDENCY||input.LA(1)==KW_EXTENDED||input.LA(1)==KW_FORMATTED||input.LA(1)==KW_LOGICAL ) {
                input.consume();
                if ( state.backtracking==0 ) adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(set10)
                );
                state.errorRecovery=false;
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { msgs.pop(); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "explainOption"


    public static class execStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "execStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:688:1: execStatement : ( queryStatementExpression[true] | loadStatement | exportStatement | importStatement | ddlStatement | deleteStatement | updateStatement );
    public final HiveParser.execStatement_return execStatement() throws RecognitionException {
        HiveParser.execStatement_return retval = new HiveParser.execStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.queryStatementExpression_return queryStatementExpression11 =null;

        HiveParser.loadStatement_return loadStatement12 =null;

        HiveParser.exportStatement_return exportStatement13 =null;

        HiveParser.importStatement_return importStatement14 =null;

        HiveParser.ddlStatement_return ddlStatement15 =null;

        HiveParser.deleteStatement_return deleteStatement16 =null;

        HiveParser.updateStatement_return updateStatement17 =null;



         pushMsg("statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:691:5: ( queryStatementExpression[true] | loadStatement | exportStatement | importStatement | ddlStatement | deleteStatement | updateStatement )
            int alt4=7;
            switch ( input.LA(1) ) {
            case KW_FROM:
            case KW_INSERT:
            case KW_MAP:
            case KW_REDUCE:
            case KW_SELECT:
            case KW_WITH:
                {
                alt4=1;
                }
                break;
            case KW_LOAD:
                {
                alt4=2;
                }
                break;
            case KW_EXPORT:
                {
                alt4=3;
                }
                break;
            case KW_IMPORT:
                {
                alt4=4;
                }
                break;
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_CREATE:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DROP:
            case KW_GRANT:
            case KW_LOCK:
            case KW_MSCK:
            case KW_RELOAD:
            case KW_REVOKE:
            case KW_SET:
            case KW_SHOW:
            case KW_TRUNCATE:
            case KW_UNLOCK:
            case KW_USE:
                {
                alt4=5;
                }
                break;
            case KW_DELETE:
                {
                alt4=6;
                }
                break;
            case KW_UPDATE:
                {
                alt4=7;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;

            }

            switch (alt4) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:691:7: queryStatementExpression[true]
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_queryStatementExpression_in_execStatement1214);
                    queryStatementExpression11=queryStatementExpression(true);

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, queryStatementExpression11.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:692:7: loadStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_loadStatement_in_execStatement1223);
                    loadStatement12=loadStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, loadStatement12.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:693:7: exportStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_exportStatement_in_execStatement1231);
                    exportStatement13=exportStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, exportStatement13.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:694:7: importStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_importStatement_in_execStatement1239);
                    importStatement14=importStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, importStatement14.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:695:7: ddlStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_ddlStatement_in_execStatement1247);
                    ddlStatement15=ddlStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, ddlStatement15.getTree());

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:696:7: deleteStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_deleteStatement_in_execStatement1255);
                    deleteStatement16=deleteStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, deleteStatement16.getTree());

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:697:7: updateStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_updateStatement_in_execStatement1263);
                    updateStatement17=updateStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, updateStatement17.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "execStatement"


    public static class loadStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "loadStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:700:1: loadStatement : KW_LOAD KW_DATA (islocal= KW_LOCAL )? KW_INPATH (path= StringLiteral ) (isoverwrite= KW_OVERWRITE )? KW_INTO KW_TABLE (tab= tableOrPartition ) -> ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? ) ;
    public final HiveParser.loadStatement_return loadStatement() throws RecognitionException {
        HiveParser.loadStatement_return retval = new HiveParser.loadStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token islocal=null;
        Token path=null;
        Token isoverwrite=null;
        Token KW_LOAD18=null;
        Token KW_DATA19=null;
        Token KW_INPATH20=null;
        Token KW_INTO21=null;
        Token KW_TABLE22=null;
        HiveParser_IdentifiersParser.tableOrPartition_return tab =null;


        CommonTree islocal_tree=null;
        CommonTree path_tree=null;
        CommonTree isoverwrite_tree=null;
        CommonTree KW_LOAD18_tree=null;
        CommonTree KW_DATA19_tree=null;
        CommonTree KW_INPATH20_tree=null;
        CommonTree KW_INTO21_tree=null;
        CommonTree KW_TABLE22_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_INTO=new RewriteRuleTokenStream(adaptor,"token KW_INTO");
        RewriteRuleTokenStream stream_KW_INPATH=new RewriteRuleTokenStream(adaptor,"token KW_INPATH");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_OVERWRITE=new RewriteRuleTokenStream(adaptor,"token KW_OVERWRITE");
        RewriteRuleTokenStream stream_KW_LOAD=new RewriteRuleTokenStream(adaptor,"token KW_LOAD");
        RewriteRuleTokenStream stream_KW_DATA=new RewriteRuleTokenStream(adaptor,"token KW_DATA");
        RewriteRuleTokenStream stream_KW_LOCAL=new RewriteRuleTokenStream(adaptor,"token KW_LOCAL");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
         pushMsg("load statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:703:5: ( KW_LOAD KW_DATA (islocal= KW_LOCAL )? KW_INPATH (path= StringLiteral ) (isoverwrite= KW_OVERWRITE )? KW_INTO KW_TABLE (tab= tableOrPartition ) -> ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:703:7: KW_LOAD KW_DATA (islocal= KW_LOCAL )? KW_INPATH (path= StringLiteral ) (isoverwrite= KW_OVERWRITE )? KW_INTO KW_TABLE (tab= tableOrPartition )
            {
            KW_LOAD18=(Token)match(input,KW_LOAD,FOLLOW_KW_LOAD_in_loadStatement1290); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_LOAD.add(KW_LOAD18);


            KW_DATA19=(Token)match(input,KW_DATA,FOLLOW_KW_DATA_in_loadStatement1292); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_DATA.add(KW_DATA19);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:703:23: (islocal= KW_LOCAL )?
            int alt5=2;
            switch ( input.LA(1) ) {
                case KW_LOCAL:
                    {
                    alt5=1;
                    }
                    break;
            }

            switch (alt5) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:703:24: islocal= KW_LOCAL
                    {
                    islocal=(Token)match(input,KW_LOCAL,FOLLOW_KW_LOCAL_in_loadStatement1297); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_LOCAL.add(islocal);


                    }
                    break;

            }


            KW_INPATH20=(Token)match(input,KW_INPATH,FOLLOW_KW_INPATH_in_loadStatement1301); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_INPATH.add(KW_INPATH20);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:703:53: (path= StringLiteral )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:703:54: path= StringLiteral
            {
            path=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_loadStatement1306); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_StringLiteral.add(path);


            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:703:74: (isoverwrite= KW_OVERWRITE )?
            int alt6=2;
            switch ( input.LA(1) ) {
                case KW_OVERWRITE:
                    {
                    alt6=1;
                    }
                    break;
            }

            switch (alt6) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:703:75: isoverwrite= KW_OVERWRITE
                    {
                    isoverwrite=(Token)match(input,KW_OVERWRITE,FOLLOW_KW_OVERWRITE_in_loadStatement1312); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_OVERWRITE.add(isoverwrite);


                    }
                    break;

            }


            KW_INTO21=(Token)match(input,KW_INTO,FOLLOW_KW_INTO_in_loadStatement1316); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_INTO.add(KW_INTO21);


            KW_TABLE22=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_loadStatement1318); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TABLE.add(KW_TABLE22);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:703:119: (tab= tableOrPartition )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:703:120: tab= tableOrPartition
            {
            pushFollow(FOLLOW_tableOrPartition_in_loadStatement1323);
            tab=tableOrPartition();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableOrPartition.add(tab.getTree());

            }


            // AST REWRITE
            // elements: tab, isoverwrite, path, islocal
            // token labels: islocal, path, isoverwrite
            // rule labels: tab, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_islocal=new RewriteRuleTokenStream(adaptor,"token islocal",islocal);
            RewriteRuleTokenStream stream_path=new RewriteRuleTokenStream(adaptor,"token path",path);
            RewriteRuleTokenStream stream_isoverwrite=new RewriteRuleTokenStream(adaptor,"token isoverwrite",isoverwrite);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 704:5: -> ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:704:8: ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_LOAD, "TOK_LOAD")
                , root_1);

                adaptor.addChild(root_1, stream_path.nextNode());

                adaptor.addChild(root_1, stream_tab.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:704:31: ( $islocal)?
                if ( stream_islocal.hasNext() ) {
                    adaptor.addChild(root_1, stream_islocal.nextNode());

                }
                stream_islocal.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:704:41: ( $isoverwrite)?
                if ( stream_isoverwrite.hasNext() ) {
                    adaptor.addChild(root_1, stream_isoverwrite.nextNode());

                }
                stream_isoverwrite.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "loadStatement"


    public static class replicationClause_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "replicationClause"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:707:1: replicationClause : KW_FOR (isMetadataOnly= KW_METADATA )? KW_REPLICATION LPAREN (replId= StringLiteral ) RPAREN -> ^( TOK_REPLICATION $replId ( $isMetadataOnly)? ) ;
    public final HiveParser.replicationClause_return replicationClause() throws RecognitionException {
        HiveParser.replicationClause_return retval = new HiveParser.replicationClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token isMetadataOnly=null;
        Token replId=null;
        Token KW_FOR23=null;
        Token KW_REPLICATION24=null;
        Token LPAREN25=null;
        Token RPAREN26=null;

        CommonTree isMetadataOnly_tree=null;
        CommonTree replId_tree=null;
        CommonTree KW_FOR23_tree=null;
        CommonTree KW_REPLICATION24_tree=null;
        CommonTree LPAREN25_tree=null;
        CommonTree RPAREN26_tree=null;
        RewriteRuleTokenStream stream_KW_REPLICATION=new RewriteRuleTokenStream(adaptor,"token KW_REPLICATION");
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_FOR=new RewriteRuleTokenStream(adaptor,"token KW_FOR");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_METADATA=new RewriteRuleTokenStream(adaptor,"token KW_METADATA");

         pushMsg("replication clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:710:5: ( KW_FOR (isMetadataOnly= KW_METADATA )? KW_REPLICATION LPAREN (replId= StringLiteral ) RPAREN -> ^( TOK_REPLICATION $replId ( $isMetadataOnly)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:710:7: KW_FOR (isMetadataOnly= KW_METADATA )? KW_REPLICATION LPAREN (replId= StringLiteral ) RPAREN
            {
            KW_FOR23=(Token)match(input,KW_FOR,FOLLOW_KW_FOR_in_replicationClause1375); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_FOR.add(KW_FOR23);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:710:14: (isMetadataOnly= KW_METADATA )?
            int alt7=2;
            switch ( input.LA(1) ) {
                case KW_METADATA:
                    {
                    alt7=1;
                    }
                    break;
            }

            switch (alt7) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:710:15: isMetadataOnly= KW_METADATA
                    {
                    isMetadataOnly=(Token)match(input,KW_METADATA,FOLLOW_KW_METADATA_in_replicationClause1380); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_METADATA.add(isMetadataOnly);


                    }
                    break;

            }


            KW_REPLICATION24=(Token)match(input,KW_REPLICATION,FOLLOW_KW_REPLICATION_in_replicationClause1384); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_REPLICATION.add(KW_REPLICATION24);


            LPAREN25=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_replicationClause1386); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LPAREN.add(LPAREN25);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:710:66: (replId= StringLiteral )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:710:67: replId= StringLiteral
            {
            replId=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_replicationClause1391); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_StringLiteral.add(replId);


            }


            RPAREN26=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_replicationClause1394); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RPAREN.add(RPAREN26);


            // AST REWRITE
            // elements: replId, isMetadataOnly
            // token labels: replId, isMetadataOnly
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_replId=new RewriteRuleTokenStream(adaptor,"token replId",replId);
            RewriteRuleTokenStream stream_isMetadataOnly=new RewriteRuleTokenStream(adaptor,"token isMetadataOnly",isMetadataOnly);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 711:5: -> ^( TOK_REPLICATION $replId ( $isMetadataOnly)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:711:8: ^( TOK_REPLICATION $replId ( $isMetadataOnly)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_REPLICATION, "TOK_REPLICATION")
                , root_1);

                adaptor.addChild(root_1, stream_replId.nextNode());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:711:35: ( $isMetadataOnly)?
                if ( stream_isMetadataOnly.hasNext() ) {
                    adaptor.addChild(root_1, stream_isMetadataOnly.nextNode());

                }
                stream_isMetadataOnly.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "replicationClause"


    public static class exportStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "exportStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:714:1: exportStatement : KW_EXPORT KW_TABLE (tab= tableOrPartition ) KW_TO (path= StringLiteral ) ( replicationClause )? -> ^( TOK_EXPORT $tab $path ( replicationClause )? ) ;
    public final HiveParser.exportStatement_return exportStatement() throws RecognitionException {
        HiveParser.exportStatement_return retval = new HiveParser.exportStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token path=null;
        Token KW_EXPORT27=null;
        Token KW_TABLE28=null;
        Token KW_TO29=null;
        HiveParser_IdentifiersParser.tableOrPartition_return tab =null;

        HiveParser.replicationClause_return replicationClause30 =null;


        CommonTree path_tree=null;
        CommonTree KW_EXPORT27_tree=null;
        CommonTree KW_TABLE28_tree=null;
        CommonTree KW_TO29_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleTokenStream stream_KW_EXPORT=new RewriteRuleTokenStream(adaptor,"token KW_EXPORT");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
        RewriteRuleSubtreeStream stream_replicationClause=new RewriteRuleSubtreeStream(adaptor,"rule replicationClause");
         pushMsg("export statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:717:5: ( KW_EXPORT KW_TABLE (tab= tableOrPartition ) KW_TO (path= StringLiteral ) ( replicationClause )? -> ^( TOK_EXPORT $tab $path ( replicationClause )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:717:7: KW_EXPORT KW_TABLE (tab= tableOrPartition ) KW_TO (path= StringLiteral ) ( replicationClause )?
            {
            KW_EXPORT27=(Token)match(input,KW_EXPORT,FOLLOW_KW_EXPORT_in_exportStatement1438); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_EXPORT.add(KW_EXPORT27);


            KW_TABLE28=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_exportStatement1446); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TABLE.add(KW_TABLE28);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:718:16: (tab= tableOrPartition )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:718:17: tab= tableOrPartition
            {
            pushFollow(FOLLOW_tableOrPartition_in_exportStatement1451);
            tab=tableOrPartition();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableOrPartition.add(tab.getTree());

            }


            KW_TO29=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_exportStatement1460); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TO.add(KW_TO29);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:719:13: (path= StringLiteral )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:719:14: path= StringLiteral
            {
            path=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_exportStatement1465); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_StringLiteral.add(path);


            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:720:7: ( replicationClause )?
            int alt8=2;
            switch ( input.LA(1) ) {
                case KW_FOR:
                    {
                    alt8=1;
                    }
                    break;
            }

            switch (alt8) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:720:7: replicationClause
                    {
                    pushFollow(FOLLOW_replicationClause_in_exportStatement1474);
                    replicationClause30=replicationClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_replicationClause.add(replicationClause30.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: tab, path, replicationClause
            // token labels: path
            // rule labels: tab, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_path=new RewriteRuleTokenStream(adaptor,"token path",path);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 721:5: -> ^( TOK_EXPORT $tab $path ( replicationClause )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:721:8: ^( TOK_EXPORT $tab $path ( replicationClause )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_EXPORT, "TOK_EXPORT")
                , root_1);

                adaptor.addChild(root_1, stream_tab.nextTree());

                adaptor.addChild(root_1, stream_path.nextNode());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:721:32: ( replicationClause )?
                if ( stream_replicationClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_replicationClause.nextTree());

                }
                stream_replicationClause.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "exportStatement"


    public static class importStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "importStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:724:1: importStatement : KW_IMPORT ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )? KW_FROM (path= StringLiteral ) ( tableLocation )? -> ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? ) ;
    public final HiveParser.importStatement_return importStatement() throws RecognitionException {
        HiveParser.importStatement_return retval = new HiveParser.importStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token ext=null;
        Token path=null;
        Token KW_IMPORT31=null;
        Token KW_TABLE32=null;
        Token KW_FROM33=null;
        HiveParser_IdentifiersParser.tableOrPartition_return tab =null;

        HiveParser.tableLocation_return tableLocation34 =null;


        CommonTree ext_tree=null;
        CommonTree path_tree=null;
        CommonTree KW_IMPORT31_tree=null;
        CommonTree KW_TABLE32_tree=null;
        CommonTree KW_FROM33_tree=null;
        RewriteRuleTokenStream stream_KW_EXTERNAL=new RewriteRuleTokenStream(adaptor,"token KW_EXTERNAL");
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_IMPORT=new RewriteRuleTokenStream(adaptor,"token KW_IMPORT");
        RewriteRuleSubtreeStream stream_tableLocation=new RewriteRuleSubtreeStream(adaptor,"rule tableLocation");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
         pushMsg("import statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:727:8: ( KW_IMPORT ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )? KW_FROM (path= StringLiteral ) ( tableLocation )? -> ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:727:10: KW_IMPORT ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )? KW_FROM (path= StringLiteral ) ( tableLocation )?
            {
            KW_IMPORT31=(Token)match(input,KW_IMPORT,FOLLOW_KW_IMPORT_in_importStatement1524); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_IMPORT.add(KW_IMPORT31);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:728:10: ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )?
            int alt10=2;
            switch ( input.LA(1) ) {
                case KW_EXTERNAL:
                case KW_TABLE:
                    {
                    alt10=1;
                    }
                    break;
            }

            switch (alt10) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:728:11: (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:728:11: (ext= KW_EXTERNAL )?
                    int alt9=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTERNAL:
                            {
                            alt9=1;
                            }
                            break;
                    }

                    switch (alt9) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:728:12: ext= KW_EXTERNAL
                            {
                            ext=(Token)match(input,KW_EXTERNAL,FOLLOW_KW_EXTERNAL_in_importStatement1539); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_EXTERNAL.add(ext);


                            }
                            break;

                    }


                    KW_TABLE32=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_importStatement1543); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_TABLE.add(KW_TABLE32);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:728:39: (tab= tableOrPartition )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:728:40: tab= tableOrPartition
                    {
                    pushFollow(FOLLOW_tableOrPartition_in_importStatement1548);
                    tab=tableOrPartition();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableOrPartition.add(tab.getTree());

                    }


                    }
                    break;

            }


            KW_FROM33=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_importStatement1562); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_FROM.add(KW_FROM33);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:729:18: (path= StringLiteral )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:729:19: path= StringLiteral
            {
            path=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_importStatement1567); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_StringLiteral.add(path);


            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:730:10: ( tableLocation )?
            int alt11=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt11=1;
                    }
                    break;
            }

            switch (alt11) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:730:10: tableLocation
                    {
                    pushFollow(FOLLOW_tableLocation_in_importStatement1579);
                    tableLocation34=tableLocation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableLocation.add(tableLocation34.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: ext, tableLocation, tab, path
            // token labels: ext, path
            // rule labels: tab, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_ext=new RewriteRuleTokenStream(adaptor,"token ext",ext);
            RewriteRuleTokenStream stream_path=new RewriteRuleTokenStream(adaptor,"token path",path);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 731:5: -> ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:731:8: ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IMPORT, "TOK_IMPORT")
                , root_1);

                adaptor.addChild(root_1, stream_path.nextNode());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:731:28: ( $tab)?
                if ( stream_tab.hasNext() ) {
                    adaptor.addChild(root_1, stream_tab.nextTree());

                }
                stream_tab.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:731:34: ( $ext)?
                if ( stream_ext.hasNext() ) {
                    adaptor.addChild(root_1, stream_ext.nextNode());

                }
                stream_ext.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:731:39: ( tableLocation )?
                if ( stream_tableLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableLocation.nextTree());

                }
                stream_tableLocation.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "importStatement"


    public static class ddlStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ddlStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:734:1: ddlStatement : ( createDatabaseStatement | switchDatabaseStatement | dropDatabaseStatement | createTableStatement | dropTableStatement | truncateTableStatement | alterStatement | descStatement | showStatement | metastoreCheck | createViewStatement | dropViewStatement | createFunctionStatement | createMacroStatement | createIndexStatement | dropIndexStatement | dropFunctionStatement | reloadFunctionStatement | dropMacroStatement | analyzeStatement | lockStatement | unlockStatement | lockDatabase | unlockDatabase | createRoleStatement | dropRoleStatement | ( grantPrivileges )=> grantPrivileges | ( revokePrivileges )=> revokePrivileges | showGrants | showRoleGrants | showRolePrincipals | showRoles | grantRole | revokeRole | setRole | showCurrentRole );
    public final HiveParser.ddlStatement_return ddlStatement() throws RecognitionException {
        HiveParser.ddlStatement_return retval = new HiveParser.ddlStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.createDatabaseStatement_return createDatabaseStatement35 =null;

        HiveParser.switchDatabaseStatement_return switchDatabaseStatement36 =null;

        HiveParser.dropDatabaseStatement_return dropDatabaseStatement37 =null;

        HiveParser.createTableStatement_return createTableStatement38 =null;

        HiveParser.dropTableStatement_return dropTableStatement39 =null;

        HiveParser.truncateTableStatement_return truncateTableStatement40 =null;

        HiveParser.alterStatement_return alterStatement41 =null;

        HiveParser.descStatement_return descStatement42 =null;

        HiveParser.showStatement_return showStatement43 =null;

        HiveParser.metastoreCheck_return metastoreCheck44 =null;

        HiveParser.createViewStatement_return createViewStatement45 =null;

        HiveParser.dropViewStatement_return dropViewStatement46 =null;

        HiveParser.createFunctionStatement_return createFunctionStatement47 =null;

        HiveParser.createMacroStatement_return createMacroStatement48 =null;

        HiveParser.createIndexStatement_return createIndexStatement49 =null;

        HiveParser.dropIndexStatement_return dropIndexStatement50 =null;

        HiveParser.dropFunctionStatement_return dropFunctionStatement51 =null;

        HiveParser.reloadFunctionStatement_return reloadFunctionStatement52 =null;

        HiveParser.dropMacroStatement_return dropMacroStatement53 =null;

        HiveParser.analyzeStatement_return analyzeStatement54 =null;

        HiveParser.lockStatement_return lockStatement55 =null;

        HiveParser.unlockStatement_return unlockStatement56 =null;

        HiveParser.lockDatabase_return lockDatabase57 =null;

        HiveParser.unlockDatabase_return unlockDatabase58 =null;

        HiveParser.createRoleStatement_return createRoleStatement59 =null;

        HiveParser.dropRoleStatement_return dropRoleStatement60 =null;

        HiveParser.grantPrivileges_return grantPrivileges61 =null;

        HiveParser.revokePrivileges_return revokePrivileges62 =null;

        HiveParser.showGrants_return showGrants63 =null;

        HiveParser.showRoleGrants_return showRoleGrants64 =null;

        HiveParser.showRolePrincipals_return showRolePrincipals65 =null;

        HiveParser.showRoles_return showRoles66 =null;

        HiveParser.grantRole_return grantRole67 =null;

        HiveParser.revokeRole_return revokeRole68 =null;

        HiveParser.setRole_return setRole69 =null;

        HiveParser.showCurrentRole_return showCurrentRole70 =null;



         pushMsg("ddl statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:737:5: ( createDatabaseStatement | switchDatabaseStatement | dropDatabaseStatement | createTableStatement | dropTableStatement | truncateTableStatement | alterStatement | descStatement | showStatement | metastoreCheck | createViewStatement | dropViewStatement | createFunctionStatement | createMacroStatement | createIndexStatement | dropIndexStatement | dropFunctionStatement | reloadFunctionStatement | dropMacroStatement | analyzeStatement | lockStatement | unlockStatement | lockDatabase | unlockDatabase | createRoleStatement | dropRoleStatement | ( grantPrivileges )=> grantPrivileges | ( revokePrivileges )=> revokePrivileges | showGrants | showRoleGrants | showRolePrincipals | showRoles | grantRole | revokeRole | setRole | showCurrentRole )
            int alt12=36;
            alt12 = dfa12.predict(input);
            switch (alt12) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:737:7: createDatabaseStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createDatabaseStatement_in_ddlStatement1631);
                    createDatabaseStatement35=createDatabaseStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, createDatabaseStatement35.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:738:7: switchDatabaseStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_switchDatabaseStatement_in_ddlStatement1639);
                    switchDatabaseStatement36=switchDatabaseStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, switchDatabaseStatement36.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:739:7: dropDatabaseStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropDatabaseStatement_in_ddlStatement1647);
                    dropDatabaseStatement37=dropDatabaseStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, dropDatabaseStatement37.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:740:7: createTableStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createTableStatement_in_ddlStatement1655);
                    createTableStatement38=createTableStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, createTableStatement38.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:741:7: dropTableStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropTableStatement_in_ddlStatement1663);
                    dropTableStatement39=dropTableStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, dropTableStatement39.getTree());

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:742:7: truncateTableStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_truncateTableStatement_in_ddlStatement1671);
                    truncateTableStatement40=truncateTableStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, truncateTableStatement40.getTree());

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:743:7: alterStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatement_in_ddlStatement1679);
                    alterStatement41=alterStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatement41.getTree());

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:744:7: descStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_descStatement_in_ddlStatement1687);
                    descStatement42=descStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, descStatement42.getTree());

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:745:7: showStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showStatement_in_ddlStatement1695);
                    showStatement43=showStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, showStatement43.getTree());

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:746:7: metastoreCheck
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_metastoreCheck_in_ddlStatement1703);
                    metastoreCheck44=metastoreCheck();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, metastoreCheck44.getTree());

                    }
                    break;
                case 11 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:747:7: createViewStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createViewStatement_in_ddlStatement1711);
                    createViewStatement45=createViewStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, createViewStatement45.getTree());

                    }
                    break;
                case 12 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:748:7: dropViewStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropViewStatement_in_ddlStatement1719);
                    dropViewStatement46=dropViewStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, dropViewStatement46.getTree());

                    }
                    break;
                case 13 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:749:7: createFunctionStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createFunctionStatement_in_ddlStatement1727);
                    createFunctionStatement47=createFunctionStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, createFunctionStatement47.getTree());

                    }
                    break;
                case 14 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:750:7: createMacroStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createMacroStatement_in_ddlStatement1735);
                    createMacroStatement48=createMacroStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, createMacroStatement48.getTree());

                    }
                    break;
                case 15 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:751:7: createIndexStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createIndexStatement_in_ddlStatement1743);
                    createIndexStatement49=createIndexStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, createIndexStatement49.getTree());

                    }
                    break;
                case 16 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:752:7: dropIndexStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropIndexStatement_in_ddlStatement1751);
                    dropIndexStatement50=dropIndexStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, dropIndexStatement50.getTree());

                    }
                    break;
                case 17 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:753:7: dropFunctionStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropFunctionStatement_in_ddlStatement1759);
                    dropFunctionStatement51=dropFunctionStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, dropFunctionStatement51.getTree());

                    }
                    break;
                case 18 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:754:7: reloadFunctionStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_reloadFunctionStatement_in_ddlStatement1767);
                    reloadFunctionStatement52=reloadFunctionStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, reloadFunctionStatement52.getTree());

                    }
                    break;
                case 19 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:755:7: dropMacroStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropMacroStatement_in_ddlStatement1775);
                    dropMacroStatement53=dropMacroStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, dropMacroStatement53.getTree());

                    }
                    break;
                case 20 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:756:7: analyzeStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_analyzeStatement_in_ddlStatement1783);
                    analyzeStatement54=analyzeStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, analyzeStatement54.getTree());

                    }
                    break;
                case 21 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:757:7: lockStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_lockStatement_in_ddlStatement1791);
                    lockStatement55=lockStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, lockStatement55.getTree());

                    }
                    break;
                case 22 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:758:7: unlockStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_unlockStatement_in_ddlStatement1799);
                    unlockStatement56=unlockStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, unlockStatement56.getTree());

                    }
                    break;
                case 23 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:759:7: lockDatabase
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_lockDatabase_in_ddlStatement1807);
                    lockDatabase57=lockDatabase();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, lockDatabase57.getTree());

                    }
                    break;
                case 24 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:760:7: unlockDatabase
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_unlockDatabase_in_ddlStatement1815);
                    unlockDatabase58=unlockDatabase();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, unlockDatabase58.getTree());

                    }
                    break;
                case 25 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:761:7: createRoleStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createRoleStatement_in_ddlStatement1823);
                    createRoleStatement59=createRoleStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, createRoleStatement59.getTree());

                    }
                    break;
                case 26 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:762:7: dropRoleStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropRoleStatement_in_ddlStatement1831);
                    dropRoleStatement60=dropRoleStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, dropRoleStatement60.getTree());

                    }
                    break;
                case 27 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:763:7: ( grantPrivileges )=> grantPrivileges
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_grantPrivileges_in_ddlStatement1845);
                    grantPrivileges61=grantPrivileges();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, grantPrivileges61.getTree());

                    }
                    break;
                case 28 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:764:7: ( revokePrivileges )=> revokePrivileges
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_revokePrivileges_in_ddlStatement1859);
                    revokePrivileges62=revokePrivileges();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, revokePrivileges62.getTree());

                    }
                    break;
                case 29 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:765:7: showGrants
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showGrants_in_ddlStatement1867);
                    showGrants63=showGrants();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, showGrants63.getTree());

                    }
                    break;
                case 30 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:766:7: showRoleGrants
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showRoleGrants_in_ddlStatement1875);
                    showRoleGrants64=showRoleGrants();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, showRoleGrants64.getTree());

                    }
                    break;
                case 31 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:767:7: showRolePrincipals
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showRolePrincipals_in_ddlStatement1883);
                    showRolePrincipals65=showRolePrincipals();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, showRolePrincipals65.getTree());

                    }
                    break;
                case 32 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:768:7: showRoles
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showRoles_in_ddlStatement1891);
                    showRoles66=showRoles();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, showRoles66.getTree());

                    }
                    break;
                case 33 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:769:7: grantRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_grantRole_in_ddlStatement1899);
                    grantRole67=grantRole();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, grantRole67.getTree());

                    }
                    break;
                case 34 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:770:7: revokeRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_revokeRole_in_ddlStatement1907);
                    revokeRole68=revokeRole();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, revokeRole68.getTree());

                    }
                    break;
                case 35 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:771:7: setRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_setRole_in_ddlStatement1915);
                    setRole69=setRole();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, setRole69.getTree());

                    }
                    break;
                case 36 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:772:7: showCurrentRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showCurrentRole_in_ddlStatement1923);
                    showCurrentRole70=showCurrentRole();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, showCurrentRole70.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ddlStatement"


    public static class ifExists_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ifExists"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:775:1: ifExists : KW_IF KW_EXISTS -> ^( TOK_IFEXISTS ) ;
    public final HiveParser.ifExists_return ifExists() throws RecognitionException {
        HiveParser.ifExists_return retval = new HiveParser.ifExists_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IF71=null;
        Token KW_EXISTS72=null;

        CommonTree KW_IF71_tree=null;
        CommonTree KW_EXISTS72_tree=null;
        RewriteRuleTokenStream stream_KW_EXISTS=new RewriteRuleTokenStream(adaptor,"token KW_EXISTS");
        RewriteRuleTokenStream stream_KW_IF=new RewriteRuleTokenStream(adaptor,"token KW_IF");

         pushMsg("if exists clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:778:5: ( KW_IF KW_EXISTS -> ^( TOK_IFEXISTS ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:778:7: KW_IF KW_EXISTS
            {
            KW_IF71=(Token)match(input,KW_IF,FOLLOW_KW_IF_in_ifExists1950); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_IF.add(KW_IF71);


            KW_EXISTS72=(Token)match(input,KW_EXISTS,FOLLOW_KW_EXISTS_in_ifExists1952); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_EXISTS.add(KW_EXISTS72);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 779:5: -> ^( TOK_IFEXISTS )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:779:8: ^( TOK_IFEXISTS )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IFEXISTS, "TOK_IFEXISTS")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ifExists"


    public static class restrictOrCascade_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "restrictOrCascade"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:782:1: restrictOrCascade : ( KW_RESTRICT -> ^( TOK_RESTRICT ) | KW_CASCADE -> ^( TOK_CASCADE ) );
    public final HiveParser.restrictOrCascade_return restrictOrCascade() throws RecognitionException {
        HiveParser.restrictOrCascade_return retval = new HiveParser.restrictOrCascade_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_RESTRICT73=null;
        Token KW_CASCADE74=null;

        CommonTree KW_RESTRICT73_tree=null;
        CommonTree KW_CASCADE74_tree=null;
        RewriteRuleTokenStream stream_KW_CASCADE=new RewriteRuleTokenStream(adaptor,"token KW_CASCADE");
        RewriteRuleTokenStream stream_KW_RESTRICT=new RewriteRuleTokenStream(adaptor,"token KW_RESTRICT");

         pushMsg("restrict or cascade clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:785:5: ( KW_RESTRICT -> ^( TOK_RESTRICT ) | KW_CASCADE -> ^( TOK_CASCADE ) )
            int alt13=2;
            switch ( input.LA(1) ) {
            case KW_RESTRICT:
                {
                alt13=1;
                }
                break;
            case KW_CASCADE:
                {
                alt13=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 13, 0, input);

                throw nvae;

            }

            switch (alt13) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:785:7: KW_RESTRICT
                    {
                    KW_RESTRICT73=(Token)match(input,KW_RESTRICT,FOLLOW_KW_RESTRICT_in_restrictOrCascade1989); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_RESTRICT.add(KW_RESTRICT73);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 786:5: -> ^( TOK_RESTRICT )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:786:8: ^( TOK_RESTRICT )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_RESTRICT, "TOK_RESTRICT")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:787:7: KW_CASCADE
                    {
                    KW_CASCADE74=(Token)match(input,KW_CASCADE,FOLLOW_KW_CASCADE_in_restrictOrCascade2007); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_CASCADE.add(KW_CASCADE74);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 788:5: -> ^( TOK_CASCADE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:788:8: ^( TOK_CASCADE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_CASCADE, "TOK_CASCADE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "restrictOrCascade"


    public static class ifNotExists_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ifNotExists"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:791:1: ifNotExists : KW_IF KW_NOT KW_EXISTS -> ^( TOK_IFNOTEXISTS ) ;
    public final HiveParser.ifNotExists_return ifNotExists() throws RecognitionException {
        HiveParser.ifNotExists_return retval = new HiveParser.ifNotExists_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IF75=null;
        Token KW_NOT76=null;
        Token KW_EXISTS77=null;

        CommonTree KW_IF75_tree=null;
        CommonTree KW_NOT76_tree=null;
        CommonTree KW_EXISTS77_tree=null;
        RewriteRuleTokenStream stream_KW_NOT=new RewriteRuleTokenStream(adaptor,"token KW_NOT");
        RewriteRuleTokenStream stream_KW_EXISTS=new RewriteRuleTokenStream(adaptor,"token KW_EXISTS");
        RewriteRuleTokenStream stream_KW_IF=new RewriteRuleTokenStream(adaptor,"token KW_IF");

         pushMsg("if not exists clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:794:5: ( KW_IF KW_NOT KW_EXISTS -> ^( TOK_IFNOTEXISTS ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:794:7: KW_IF KW_NOT KW_EXISTS
            {
            KW_IF75=(Token)match(input,KW_IF,FOLLOW_KW_IF_in_ifNotExists2044); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_IF.add(KW_IF75);


            KW_NOT76=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_ifNotExists2046); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_NOT.add(KW_NOT76);


            KW_EXISTS77=(Token)match(input,KW_EXISTS,FOLLOW_KW_EXISTS_in_ifNotExists2048); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_EXISTS.add(KW_EXISTS77);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 795:5: -> ^( TOK_IFNOTEXISTS )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:795:8: ^( TOK_IFNOTEXISTS )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IFNOTEXISTS, "TOK_IFNOTEXISTS")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ifNotExists"


    public static class storedAsDirs_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "storedAsDirs"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:798:1: storedAsDirs : KW_STORED KW_AS KW_DIRECTORIES -> ^( TOK_STOREDASDIRS ) ;
    public final HiveParser.storedAsDirs_return storedAsDirs() throws RecognitionException {
        HiveParser.storedAsDirs_return retval = new HiveParser.storedAsDirs_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_STORED78=null;
        Token KW_AS79=null;
        Token KW_DIRECTORIES80=null;

        CommonTree KW_STORED78_tree=null;
        CommonTree KW_AS79_tree=null;
        CommonTree KW_DIRECTORIES80_tree=null;
        RewriteRuleTokenStream stream_KW_DIRECTORIES=new RewriteRuleTokenStream(adaptor,"token KW_DIRECTORIES");
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleTokenStream stream_KW_STORED=new RewriteRuleTokenStream(adaptor,"token KW_STORED");

         pushMsg("stored as directories", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:801:5: ( KW_STORED KW_AS KW_DIRECTORIES -> ^( TOK_STOREDASDIRS ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:801:7: KW_STORED KW_AS KW_DIRECTORIES
            {
            KW_STORED78=(Token)match(input,KW_STORED,FOLLOW_KW_STORED_in_storedAsDirs2085); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_STORED.add(KW_STORED78);


            KW_AS79=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_storedAsDirs2087); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_AS.add(KW_AS79);


            KW_DIRECTORIES80=(Token)match(input,KW_DIRECTORIES,FOLLOW_KW_DIRECTORIES_in_storedAsDirs2089); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_DIRECTORIES.add(KW_DIRECTORIES80);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 802:5: -> ^( TOK_STOREDASDIRS )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:802:8: ^( TOK_STOREDASDIRS )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_STOREDASDIRS, "TOK_STOREDASDIRS")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "storedAsDirs"


    public static class orReplace_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "orReplace"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:805:1: orReplace : KW_OR KW_REPLACE -> ^( TOK_ORREPLACE ) ;
    public final HiveParser.orReplace_return orReplace() throws RecognitionException {
        HiveParser.orReplace_return retval = new HiveParser.orReplace_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_OR81=null;
        Token KW_REPLACE82=null;

        CommonTree KW_OR81_tree=null;
        CommonTree KW_REPLACE82_tree=null;
        RewriteRuleTokenStream stream_KW_REPLACE=new RewriteRuleTokenStream(adaptor,"token KW_REPLACE");
        RewriteRuleTokenStream stream_KW_OR=new RewriteRuleTokenStream(adaptor,"token KW_OR");

         pushMsg("or replace clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:808:5: ( KW_OR KW_REPLACE -> ^( TOK_ORREPLACE ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:808:7: KW_OR KW_REPLACE
            {
            KW_OR81=(Token)match(input,KW_OR,FOLLOW_KW_OR_in_orReplace2126); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_OR.add(KW_OR81);


            KW_REPLACE82=(Token)match(input,KW_REPLACE,FOLLOW_KW_REPLACE_in_orReplace2128); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_REPLACE.add(KW_REPLACE82);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 809:5: -> ^( TOK_ORREPLACE )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:809:8: ^( TOK_ORREPLACE )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ORREPLACE, "TOK_ORREPLACE")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "orReplace"


    public static class ignoreProtection_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ignoreProtection"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:812:1: ignoreProtection : KW_IGNORE KW_PROTECTION -> ^( TOK_IGNOREPROTECTION ) ;
    public final HiveParser.ignoreProtection_return ignoreProtection() throws RecognitionException {
        HiveParser.ignoreProtection_return retval = new HiveParser.ignoreProtection_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IGNORE83=null;
        Token KW_PROTECTION84=null;

        CommonTree KW_IGNORE83_tree=null;
        CommonTree KW_PROTECTION84_tree=null;
        RewriteRuleTokenStream stream_KW_PROTECTION=new RewriteRuleTokenStream(adaptor,"token KW_PROTECTION");
        RewriteRuleTokenStream stream_KW_IGNORE=new RewriteRuleTokenStream(adaptor,"token KW_IGNORE");

         pushMsg("ignore protection clause", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:815:9: ( KW_IGNORE KW_PROTECTION -> ^( TOK_IGNOREPROTECTION ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:815:11: KW_IGNORE KW_PROTECTION
            {
            KW_IGNORE83=(Token)match(input,KW_IGNORE,FOLLOW_KW_IGNORE_in_ignoreProtection2169); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_IGNORE.add(KW_IGNORE83);


            KW_PROTECTION84=(Token)match(input,KW_PROTECTION,FOLLOW_KW_PROTECTION_in_ignoreProtection2171); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_PROTECTION.add(KW_PROTECTION84);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 816:9: -> ^( TOK_IGNOREPROTECTION )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:816:12: ^( TOK_IGNOREPROTECTION )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IGNOREPROTECTION, "TOK_IGNOREPROTECTION")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ignoreProtection"


    public static class createDatabaseStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createDatabaseStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:819:1: createDatabaseStatement : KW_CREATE ( KW_DATABASE | KW_SCHEMA ) ( ifNotExists )? name= identifier ( databaseComment )? ( dbLocation )? ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )? -> ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? ) ;
    public final HiveParser.createDatabaseStatement_return createDatabaseStatement() throws RecognitionException {
        HiveParser.createDatabaseStatement_return retval = new HiveParser.createDatabaseStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_CREATE85=null;
        Token KW_DATABASE86=null;
        Token KW_SCHEMA87=null;
        Token KW_WITH91=null;
        Token KW_DBPROPERTIES92=null;
        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser.dbProperties_return dbprops =null;

        HiveParser.ifNotExists_return ifNotExists88 =null;

        HiveParser.databaseComment_return databaseComment89 =null;

        HiveParser.dbLocation_return dbLocation90 =null;


        CommonTree KW_CREATE85_tree=null;
        CommonTree KW_DATABASE86_tree=null;
        CommonTree KW_SCHEMA87_tree=null;
        CommonTree KW_WITH91_tree=null;
        CommonTree KW_DBPROPERTIES92_tree=null;
        RewriteRuleTokenStream stream_KW_DBPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_DBPROPERTIES");
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_dbProperties=new RewriteRuleSubtreeStream(adaptor,"rule dbProperties");
        RewriteRuleSubtreeStream stream_databaseComment=new RewriteRuleSubtreeStream(adaptor,"rule databaseComment");
        RewriteRuleSubtreeStream stream_ifNotExists=new RewriteRuleSubtreeStream(adaptor,"rule ifNotExists");
        RewriteRuleSubtreeStream stream_dbLocation=new RewriteRuleSubtreeStream(adaptor,"rule dbLocation");
         pushMsg("create database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:822:5: ( KW_CREATE ( KW_DATABASE | KW_SCHEMA ) ( ifNotExists )? name= identifier ( databaseComment )? ( dbLocation )? ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )? -> ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:822:7: KW_CREATE ( KW_DATABASE | KW_SCHEMA ) ( ifNotExists )? name= identifier ( databaseComment )? ( dbLocation )? ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )?
            {
            KW_CREATE85=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createDatabaseStatement2216); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_CREATE.add(KW_CREATE85);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:822:17: ( KW_DATABASE | KW_SCHEMA )
            int alt14=2;
            switch ( input.LA(1) ) {
            case KW_DATABASE:
                {
                alt14=1;
                }
                break;
            case KW_SCHEMA:
                {
                alt14=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 14, 0, input);

                throw nvae;

            }

            switch (alt14) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:822:18: KW_DATABASE
                    {
                    KW_DATABASE86=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_createDatabaseStatement2219); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_DATABASE.add(KW_DATABASE86);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:822:30: KW_SCHEMA
                    {
                    KW_SCHEMA87=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_createDatabaseStatement2221); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SCHEMA.add(KW_SCHEMA87);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:823:9: ( ifNotExists )?
            int alt15=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt15=1;
                    }
                    break;
            }

            switch (alt15) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:823:9: ifNotExists
                    {
                    pushFollow(FOLLOW_ifNotExists_in_createDatabaseStatement2232);
                    ifNotExists88=ifNotExists();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_ifNotExists.add(ifNotExists88.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_createDatabaseStatement2245);
            name=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(name.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:825:9: ( databaseComment )?
            int alt16=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt16=1;
                    }
                    break;
            }

            switch (alt16) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:825:9: databaseComment
                    {
                    pushFollow(FOLLOW_databaseComment_in_createDatabaseStatement2255);
                    databaseComment89=databaseComment();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_databaseComment.add(databaseComment89.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:826:9: ( dbLocation )?
            int alt17=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt17=1;
                    }
                    break;
            }

            switch (alt17) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:826:9: dbLocation
                    {
                    pushFollow(FOLLOW_dbLocation_in_createDatabaseStatement2266);
                    dbLocation90=dbLocation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_dbLocation.add(dbLocation90.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:827:9: ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )?
            int alt18=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt18=1;
                    }
                    break;
            }

            switch (alt18) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:827:10: KW_WITH KW_DBPROPERTIES dbprops= dbProperties
                    {
                    KW_WITH91=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_createDatabaseStatement2278); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_WITH.add(KW_WITH91);


                    KW_DBPROPERTIES92=(Token)match(input,KW_DBPROPERTIES,FOLLOW_KW_DBPROPERTIES_in_createDatabaseStatement2280); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_DBPROPERTIES.add(KW_DBPROPERTIES92);


                    pushFollow(FOLLOW_dbProperties_in_createDatabaseStatement2284);
                    dbprops=dbProperties();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_dbProperties.add(dbprops.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: ifNotExists, databaseComment, dbprops, dbLocation, name
            // token labels: 
            // rule labels: name, dbprops, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);
            RewriteRuleSubtreeStream stream_dbprops=new RewriteRuleSubtreeStream(adaptor,"rule dbprops",dbprops!=null?dbprops.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 828:5: -> ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:828:8: ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEDATABASE, "TOK_CREATEDATABASE")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:828:35: ( ifNotExists )?
                if ( stream_ifNotExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifNotExists.nextTree());

                }
                stream_ifNotExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:828:48: ( dbLocation )?
                if ( stream_dbLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_dbLocation.nextTree());

                }
                stream_dbLocation.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:828:60: ( databaseComment )?
                if ( stream_databaseComment.hasNext() ) {
                    adaptor.addChild(root_1, stream_databaseComment.nextTree());

                }
                stream_databaseComment.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:828:78: ( $dbprops)?
                if ( stream_dbprops.hasNext() ) {
                    adaptor.addChild(root_1, stream_dbprops.nextTree());

                }
                stream_dbprops.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createDatabaseStatement"


    public static class dbLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dbLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:831:1: dbLocation : KW_LOCATION locn= StringLiteral -> ^( TOK_DATABASELOCATION $locn) ;
    public final HiveParser.dbLocation_return dbLocation() throws RecognitionException {
        HiveParser.dbLocation_return retval = new HiveParser.dbLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token locn=null;
        Token KW_LOCATION93=null;

        CommonTree locn_tree=null;
        CommonTree KW_LOCATION93_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");

         pushMsg("database location specification", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:834:5: ( KW_LOCATION locn= StringLiteral -> ^( TOK_DATABASELOCATION $locn) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:835:7: KW_LOCATION locn= StringLiteral
            {
            KW_LOCATION93=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_dbLocation2345); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_LOCATION.add(KW_LOCATION93);


            locn=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_dbLocation2349); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_StringLiteral.add(locn);


            // AST REWRITE
            // elements: locn
            // token labels: locn
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_locn=new RewriteRuleTokenStream(adaptor,"token locn",locn);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 835:38: -> ^( TOK_DATABASELOCATION $locn)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:835:41: ^( TOK_DATABASELOCATION $locn)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DATABASELOCATION, "TOK_DATABASELOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_locn.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dbLocation"


    public static class dbProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dbProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:838:1: dbProperties : LPAREN dbPropertiesList RPAREN -> ^( TOK_DATABASEPROPERTIES dbPropertiesList ) ;
    public final HiveParser.dbProperties_return dbProperties() throws RecognitionException {
        HiveParser.dbProperties_return retval = new HiveParser.dbProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token LPAREN94=null;
        Token RPAREN96=null;
        HiveParser.dbPropertiesList_return dbPropertiesList95 =null;


        CommonTree LPAREN94_tree=null;
        CommonTree RPAREN96_tree=null;
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleSubtreeStream stream_dbPropertiesList=new RewriteRuleSubtreeStream(adaptor,"rule dbPropertiesList");
         pushMsg("dbproperties", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:841:5: ( LPAREN dbPropertiesList RPAREN -> ^( TOK_DATABASEPROPERTIES dbPropertiesList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:842:7: LPAREN dbPropertiesList RPAREN
            {
            LPAREN94=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_dbProperties2391); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LPAREN.add(LPAREN94);


            pushFollow(FOLLOW_dbPropertiesList_in_dbProperties2393);
            dbPropertiesList95=dbPropertiesList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_dbPropertiesList.add(dbPropertiesList95.getTree());

            RPAREN96=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_dbProperties2395); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RPAREN.add(RPAREN96);


            // AST REWRITE
            // elements: dbPropertiesList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 842:38: -> ^( TOK_DATABASEPROPERTIES dbPropertiesList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:842:41: ^( TOK_DATABASEPROPERTIES dbPropertiesList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DATABASEPROPERTIES, "TOK_DATABASEPROPERTIES")
                , root_1);

                adaptor.addChild(root_1, stream_dbPropertiesList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dbProperties"


    public static class dbPropertiesList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dbPropertiesList"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:845:1: dbPropertiesList : keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_DBPROPLIST ( keyValueProperty )+ ) ;
    public final HiveParser.dbPropertiesList_return dbPropertiesList() throws RecognitionException {
        HiveParser.dbPropertiesList_return retval = new HiveParser.dbPropertiesList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA98=null;
        HiveParser.keyValueProperty_return keyValueProperty97 =null;

        HiveParser.keyValueProperty_return keyValueProperty99 =null;


        CommonTree COMMA98_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_keyValueProperty=new RewriteRuleSubtreeStream(adaptor,"rule keyValueProperty");
         pushMsg("database properties list", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:848:5: ( keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_DBPROPLIST ( keyValueProperty )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:849:7: keyValueProperty ( COMMA keyValueProperty )*
            {
            pushFollow(FOLLOW_keyValueProperty_in_dbPropertiesList2436);
            keyValueProperty97=keyValueProperty();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_keyValueProperty.add(keyValueProperty97.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:849:24: ( COMMA keyValueProperty )*
            loop19:
            do {
                int alt19=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt19=1;
                    }
                    break;

                }

                switch (alt19) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:849:25: COMMA keyValueProperty
            	    {
            	    COMMA98=(Token)match(input,COMMA,FOLLOW_COMMA_in_dbPropertiesList2439); if (state.failed) return retval; 
            	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA98);


            	    pushFollow(FOLLOW_keyValueProperty_in_dbPropertiesList2441);
            	    keyValueProperty99=keyValueProperty();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_keyValueProperty.add(keyValueProperty99.getTree());

            	    }
            	    break;

            	default :
            	    break loop19;
                }
            } while (true);


            // AST REWRITE
            // elements: keyValueProperty
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 849:50: -> ^( TOK_DBPROPLIST ( keyValueProperty )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:849:53: ^( TOK_DBPROPLIST ( keyValueProperty )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DBPROPLIST, "TOK_DBPROPLIST")
                , root_1);

                if ( !(stream_keyValueProperty.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_keyValueProperty.hasNext() ) {
                    adaptor.addChild(root_1, stream_keyValueProperty.nextTree());

                }
                stream_keyValueProperty.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dbPropertiesList"


    public static class switchDatabaseStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "switchDatabaseStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:853:1: switchDatabaseStatement : KW_USE identifier -> ^( TOK_SWITCHDATABASE identifier ) ;
    public final HiveParser.switchDatabaseStatement_return switchDatabaseStatement() throws RecognitionException {
        HiveParser.switchDatabaseStatement_return retval = new HiveParser.switchDatabaseStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_USE100=null;
        HiveParser_IdentifiersParser.identifier_return identifier101 =null;


        CommonTree KW_USE100_tree=null;
        RewriteRuleTokenStream stream_KW_USE=new RewriteRuleTokenStream(adaptor,"token KW_USE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("switch database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:856:5: ( KW_USE identifier -> ^( TOK_SWITCHDATABASE identifier ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:856:7: KW_USE identifier
            {
            KW_USE100=(Token)match(input,KW_USE,FOLLOW_KW_USE_in_switchDatabaseStatement2480); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_USE.add(KW_USE100);


            pushFollow(FOLLOW_identifier_in_switchDatabaseStatement2482);
            identifier101=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(identifier101.getTree());

            // AST REWRITE
            // elements: identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 857:5: -> ^( TOK_SWITCHDATABASE identifier )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:857:8: ^( TOK_SWITCHDATABASE identifier )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SWITCHDATABASE, "TOK_SWITCHDATABASE")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "switchDatabaseStatement"


    public static class dropDatabaseStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropDatabaseStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:860:1: dropDatabaseStatement : KW_DROP ( KW_DATABASE | KW_SCHEMA ) ( ifExists )? identifier ( restrictOrCascade )? -> ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? ) ;
    public final HiveParser.dropDatabaseStatement_return dropDatabaseStatement() throws RecognitionException {
        HiveParser.dropDatabaseStatement_return retval = new HiveParser.dropDatabaseStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP102=null;
        Token KW_DATABASE103=null;
        Token KW_SCHEMA104=null;
        HiveParser.ifExists_return ifExists105 =null;

        HiveParser_IdentifiersParser.identifier_return identifier106 =null;

        HiveParser.restrictOrCascade_return restrictOrCascade107 =null;


        CommonTree KW_DROP102_tree=null;
        CommonTree KW_DATABASE103_tree=null;
        CommonTree KW_SCHEMA104_tree=null;
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_restrictOrCascade=new RewriteRuleSubtreeStream(adaptor,"rule restrictOrCascade");
         pushMsg("drop database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:863:5: ( KW_DROP ( KW_DATABASE | KW_SCHEMA ) ( ifExists )? identifier ( restrictOrCascade )? -> ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:863:7: KW_DROP ( KW_DATABASE | KW_SCHEMA ) ( ifExists )? identifier ( restrictOrCascade )?
            {
            KW_DROP102=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropDatabaseStatement2521); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_DROP.add(KW_DROP102);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:863:15: ( KW_DATABASE | KW_SCHEMA )
            int alt20=2;
            switch ( input.LA(1) ) {
            case KW_DATABASE:
                {
                alt20=1;
                }
                break;
            case KW_SCHEMA:
                {
                alt20=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 20, 0, input);

                throw nvae;

            }

            switch (alt20) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:863:16: KW_DATABASE
                    {
                    KW_DATABASE103=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_dropDatabaseStatement2524); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_DATABASE.add(KW_DATABASE103);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:863:28: KW_SCHEMA
                    {
                    KW_SCHEMA104=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_dropDatabaseStatement2526); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SCHEMA.add(KW_SCHEMA104);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:863:39: ( ifExists )?
            int alt21=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt21=1;
                    }
                    break;
            }

            switch (alt21) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:863:39: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_dropDatabaseStatement2529);
                    ifExists105=ifExists();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_ifExists.add(ifExists105.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_dropDatabaseStatement2532);
            identifier106=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(identifier106.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:863:60: ( restrictOrCascade )?
            int alt22=2;
            switch ( input.LA(1) ) {
                case KW_CASCADE:
                case KW_RESTRICT:
                    {
                    alt22=1;
                    }
                    break;
            }

            switch (alt22) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:863:60: restrictOrCascade
                    {
                    pushFollow(FOLLOW_restrictOrCascade_in_dropDatabaseStatement2534);
                    restrictOrCascade107=restrictOrCascade();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_restrictOrCascade.add(restrictOrCascade107.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: identifier, restrictOrCascade, ifExists
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 864:5: -> ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:864:8: ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPDATABASE, "TOK_DROPDATABASE")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:864:38: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:864:48: ( restrictOrCascade )?
                if ( stream_restrictOrCascade.hasNext() ) {
                    adaptor.addChild(root_1, stream_restrictOrCascade.nextTree());

                }
                stream_restrictOrCascade.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropDatabaseStatement"


    public static class databaseComment_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "databaseComment"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:867:1: databaseComment : KW_COMMENT comment= StringLiteral -> ^( TOK_DATABASECOMMENT $comment) ;
    public final HiveParser.databaseComment_return databaseComment() throws RecognitionException {
        HiveParser.databaseComment_return retval = new HiveParser.databaseComment_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_COMMENT108=null;

        CommonTree comment_tree=null;
        CommonTree KW_COMMENT108_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");

         pushMsg("database's comment", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:870:5: ( KW_COMMENT comment= StringLiteral -> ^( TOK_DATABASECOMMENT $comment) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:870:7: KW_COMMENT comment= StringLiteral
            {
            KW_COMMENT108=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_databaseComment2580); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_COMMENT.add(KW_COMMENT108);


            comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_databaseComment2584); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_StringLiteral.add(comment);


            // AST REWRITE
            // elements: comment
            // token labels: comment
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 871:5: -> ^( TOK_DATABASECOMMENT $comment)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:871:8: ^( TOK_DATABASECOMMENT $comment)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DATABASECOMMENT, "TOK_DATABASECOMMENT")
                , root_1);

                adaptor.addChild(root_1, stream_comment.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "databaseComment"


    public static class createTableStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createTableStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:874:1: createTableStatement : KW_CREATE (temp= KW_TEMPORARY )? (ext= KW_EXTERNAL )? KW_TABLE ( ifNotExists )? name= tableName (like= KW_LIKE likeName= tableName ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatementWithCTE )? ) -> ^( TOK_CREATETABLE $name ( $temp)? ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatementWithCTE )? ) ;
    public final HiveParser.createTableStatement_return createTableStatement() throws RecognitionException {
        HiveParser.createTableStatement_return retval = new HiveParser.createTableStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token temp=null;
        Token ext=null;
        Token like=null;
        Token KW_CREATE109=null;
        Token KW_TABLE110=null;
        Token LPAREN116=null;
        Token RPAREN118=null;
        Token KW_AS127=null;
        HiveParser_FromClauseParser.tableName_return name =null;

        HiveParser_FromClauseParser.tableName_return likeName =null;

        HiveParser.ifNotExists_return ifNotExists111 =null;

        HiveParser.tableRowFormat_return tableRowFormat112 =null;

        HiveParser.tableFileFormat_return tableFileFormat113 =null;

        HiveParser.tableLocation_return tableLocation114 =null;

        HiveParser.tablePropertiesPrefixed_return tablePropertiesPrefixed115 =null;

        HiveParser.columnNameTypeList_return columnNameTypeList117 =null;

        HiveParser.tableComment_return tableComment119 =null;

        HiveParser.tablePartition_return tablePartition120 =null;

        HiveParser.tableBuckets_return tableBuckets121 =null;

        HiveParser.tableSkewed_return tableSkewed122 =null;

        HiveParser.tableRowFormat_return tableRowFormat123 =null;

        HiveParser.tableFileFormat_return tableFileFormat124 =null;

        HiveParser.tableLocation_return tableLocation125 =null;

        HiveParser.tablePropertiesPrefixed_return tablePropertiesPrefixed126 =null;

        HiveParser.selectStatementWithCTE_return selectStatementWithCTE128 =null;


        CommonTree temp_tree=null;
        CommonTree ext_tree=null;
        CommonTree like_tree=null;
        CommonTree KW_CREATE109_tree=null;
        CommonTree KW_TABLE110_tree=null;
        CommonTree LPAREN116_tree=null;
        CommonTree RPAREN118_tree=null;
        CommonTree KW_AS127_tree=null;
        RewriteRuleTokenStream stream_KW_TEMPORARY=new RewriteRuleTokenStream(adaptor,"token KW_TEMPORARY");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_EXTERNAL=new RewriteRuleTokenStream(adaptor,"token KW_EXTERNAL");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleTokenStream stream_KW_LIKE=new RewriteRuleTokenStream(adaptor,"token KW_LIKE");
        RewriteRuleSubtreeStream stream_tableRowFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableRowFormat");
        RewriteRuleSubtreeStream stream_selectStatementWithCTE=new RewriteRuleSubtreeStream(adaptor,"rule selectStatementWithCTE");
        RewriteRuleSubtreeStream stream_tableLocation=new RewriteRuleSubtreeStream(adaptor,"rule tableLocation");
        RewriteRuleSubtreeStream stream_tableSkewed=new RewriteRuleSubtreeStream(adaptor,"rule tableSkewed");
        RewriteRuleSubtreeStream stream_tablePropertiesPrefixed=new RewriteRuleSubtreeStream(adaptor,"rule tablePropertiesPrefixed");
        RewriteRuleSubtreeStream stream_ifNotExists=new RewriteRuleSubtreeStream(adaptor,"rule ifNotExists");
        RewriteRuleSubtreeStream stream_tableFileFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableFileFormat");
        RewriteRuleSubtreeStream stream_tableComment=new RewriteRuleSubtreeStream(adaptor,"rule tableComment");
        RewriteRuleSubtreeStream stream_tablePartition=new RewriteRuleSubtreeStream(adaptor,"rule tablePartition");
        RewriteRuleSubtreeStream stream_tableBuckets=new RewriteRuleSubtreeStream(adaptor,"rule tableBuckets");
        RewriteRuleSubtreeStream stream_columnNameTypeList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameTypeList");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
         pushMsg("create table statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:877:5: ( KW_CREATE (temp= KW_TEMPORARY )? (ext= KW_EXTERNAL )? KW_TABLE ( ifNotExists )? name= tableName (like= KW_LIKE likeName= tableName ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatementWithCTE )? ) -> ^( TOK_CREATETABLE $name ( $temp)? ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatementWithCTE )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:877:7: KW_CREATE (temp= KW_TEMPORARY )? (ext= KW_EXTERNAL )? KW_TABLE ( ifNotExists )? name= tableName (like= KW_LIKE likeName= tableName ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatementWithCTE )? )
            {
            KW_CREATE109=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createTableStatement2624); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_CREATE.add(KW_CREATE109);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:877:17: (temp= KW_TEMPORARY )?
            int alt23=2;
            switch ( input.LA(1) ) {
                case KW_TEMPORARY:
                    {
                    alt23=1;
                    }
                    break;
            }

            switch (alt23) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:877:18: temp= KW_TEMPORARY
                    {
                    temp=(Token)match(input,KW_TEMPORARY,FOLLOW_KW_TEMPORARY_in_createTableStatement2629); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_TEMPORARY.add(temp);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:877:38: (ext= KW_EXTERNAL )?
            int alt24=2;
            switch ( input.LA(1) ) {
                case KW_EXTERNAL:
                    {
                    alt24=1;
                    }
                    break;
            }

            switch (alt24) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:877:39: ext= KW_EXTERNAL
                    {
                    ext=(Token)match(input,KW_EXTERNAL,FOLLOW_KW_EXTERNAL_in_createTableStatement2636); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_EXTERNAL.add(ext);


                    }
                    break;

            }


            KW_TABLE110=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_createTableStatement2640); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TABLE.add(KW_TABLE110);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:877:66: ( ifNotExists )?
            int alt25=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt25=1;
                    }
                    break;
            }

            switch (alt25) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:877:66: ifNotExists
                    {
                    pushFollow(FOLLOW_ifNotExists_in_createTableStatement2642);
                    ifNotExists111=ifNotExists();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_ifNotExists.add(ifNotExists111.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_tableName_in_createTableStatement2647);
            name=tableName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableName.add(name.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:878:7: (like= KW_LIKE likeName= tableName ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatementWithCTE )? )
            int alt40=2;
            switch ( input.LA(1) ) {
            case KW_LIKE:
                {
                alt40=1;
                }
                break;
            case EOF:
            case KW_AS:
            case KW_CLUSTERED:
            case KW_COMMENT:
            case KW_LOCATION:
            case KW_PARTITIONED:
            case KW_ROW:
            case KW_SKEWED:
            case KW_STORED:
            case KW_TBLPROPERTIES:
            case LPAREN:
                {
                alt40=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 40, 0, input);

                throw nvae;

            }

            switch (alt40) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:878:10: like= KW_LIKE likeName= tableName ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )?
                    {
                    like=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_createTableStatement2660); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_LIKE.add(like);


                    pushFollow(FOLLOW_tableName_in_createTableStatement2664);
                    likeName=tableName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableName.add(likeName.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:879:10: ( tableRowFormat )?
                    int alt26=2;
                    switch ( input.LA(1) ) {
                        case KW_ROW:
                            {
                            alt26=1;
                            }
                            break;
                    }

                    switch (alt26) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:879:10: tableRowFormat
                            {
                            pushFollow(FOLLOW_tableRowFormat_in_createTableStatement2675);
                            tableRowFormat112=tableRowFormat();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_tableRowFormat.add(tableRowFormat112.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:880:10: ( tableFileFormat )?
                    int alt27=2;
                    switch ( input.LA(1) ) {
                        case KW_STORED:
                            {
                            alt27=1;
                            }
                            break;
                    }

                    switch (alt27) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:880:10: tableFileFormat
                            {
                            pushFollow(FOLLOW_tableFileFormat_in_createTableStatement2687);
                            tableFileFormat113=tableFileFormat();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_tableFileFormat.add(tableFileFormat113.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:881:10: ( tableLocation )?
                    int alt28=2;
                    switch ( input.LA(1) ) {
                        case KW_LOCATION:
                            {
                            alt28=1;
                            }
                            break;
                    }

                    switch (alt28) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:881:10: tableLocation
                            {
                            pushFollow(FOLLOW_tableLocation_in_createTableStatement2699);
                            tableLocation114=tableLocation();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_tableLocation.add(tableLocation114.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:882:10: ( tablePropertiesPrefixed )?
                    int alt29=2;
                    switch ( input.LA(1) ) {
                        case KW_TBLPROPERTIES:
                            {
                            alt29=1;
                            }
                            break;
                    }

                    switch (alt29) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:882:10: tablePropertiesPrefixed
                            {
                            pushFollow(FOLLOW_tablePropertiesPrefixed_in_createTableStatement2711);
                            tablePropertiesPrefixed115=tablePropertiesPrefixed();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_tablePropertiesPrefixed.add(tablePropertiesPrefixed115.getTree());

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:883:10: ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatementWithCTE )?
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:883:10: ( LPAREN columnNameTypeList RPAREN )?
                    int alt30=2;
                    switch ( input.LA(1) ) {
                        case LPAREN:
                            {
                            alt30=1;
                            }
                            break;
                    }

                    switch (alt30) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:883:11: LPAREN columnNameTypeList RPAREN
                            {
                            LPAREN116=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_createTableStatement2724); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_LPAREN.add(LPAREN116);


                            pushFollow(FOLLOW_columnNameTypeList_in_createTableStatement2726);
                            columnNameTypeList117=columnNameTypeList();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_columnNameTypeList.add(columnNameTypeList117.getTree());

                            RPAREN118=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_createTableStatement2728); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_RPAREN.add(RPAREN118);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:884:10: ( tableComment )?
                    int alt31=2;
                    switch ( input.LA(1) ) {
                        case KW_COMMENT:
                            {
                            alt31=1;
                            }
                            break;
                    }

                    switch (alt31) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:884:10: tableComment
                            {
                            pushFollow(FOLLOW_tableComment_in_createTableStatement2741);
                            tableComment119=tableComment();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_tableComment.add(tableComment119.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:885:10: ( tablePartition )?
                    int alt32=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITIONED:
                            {
                            alt32=1;
                            }
                            break;
                    }

                    switch (alt32) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:885:10: tablePartition
                            {
                            pushFollow(FOLLOW_tablePartition_in_createTableStatement2753);
                            tablePartition120=tablePartition();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_tablePartition.add(tablePartition120.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:886:10: ( tableBuckets )?
                    int alt33=2;
                    switch ( input.LA(1) ) {
                        case KW_CLUSTERED:
                            {
                            alt33=1;
                            }
                            break;
                    }

                    switch (alt33) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:886:10: tableBuckets
                            {
                            pushFollow(FOLLOW_tableBuckets_in_createTableStatement2765);
                            tableBuckets121=tableBuckets();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_tableBuckets.add(tableBuckets121.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:887:10: ( tableSkewed )?
                    int alt34=2;
                    switch ( input.LA(1) ) {
                        case KW_SKEWED:
                            {
                            alt34=1;
                            }
                            break;
                    }

                    switch (alt34) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:887:10: tableSkewed
                            {
                            pushFollow(FOLLOW_tableSkewed_in_createTableStatement2777);
                            tableSkewed122=tableSkewed();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_tableSkewed.add(tableSkewed122.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:888:10: ( tableRowFormat )?
                    int alt35=2;
                    switch ( input.LA(1) ) {
                        case KW_ROW:
                            {
                            alt35=1;
                            }
                            break;
                    }

                    switch (alt35) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:888:10: tableRowFormat
                            {
                            pushFollow(FOLLOW_tableRowFormat_in_createTableStatement2789);
                            tableRowFormat123=tableRowFormat();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_tableRowFormat.add(tableRowFormat123.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:889:10: ( tableFileFormat )?
                    int alt36=2;
                    switch ( input.LA(1) ) {
                        case KW_STORED:
                            {
                            alt36=1;
                            }
                            break;
                    }

                    switch (alt36) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:889:10: tableFileFormat
                            {
                            pushFollow(FOLLOW_tableFileFormat_in_createTableStatement2801);
                            tableFileFormat124=tableFileFormat();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_tableFileFormat.add(tableFileFormat124.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:890:10: ( tableLocation )?
                    int alt37=2;
                    switch ( input.LA(1) ) {
                        case KW_LOCATION:
                            {
                            alt37=1;
                            }
                            break;
                    }

                    switch (alt37) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:890:10: tableLocation
                            {
                            pushFollow(FOLLOW_tableLocation_in_createTableStatement2813);
                            tableLocation125=tableLocation();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_tableLocation.add(tableLocation125.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:891:10: ( tablePropertiesPrefixed )?
                    int alt38=2;
                    switch ( input.LA(1) ) {
                        case KW_TBLPROPERTIES:
                            {
                            alt38=1;
                            }
                            break;
                    }

                    switch (alt38) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:891:10: tablePropertiesPrefixed
                            {
                            pushFollow(FOLLOW_tablePropertiesPrefixed_in_createTableStatement2825);
                            tablePropertiesPrefixed126=tablePropertiesPrefixed();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_tablePropertiesPrefixed.add(tablePropertiesPrefixed126.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:892:10: ( KW_AS selectStatementWithCTE )?
                    int alt39=2;
                    switch ( input.LA(1) ) {
                        case KW_AS:
                            {
                            alt39=1;
                            }
                            break;
                    }

                    switch (alt39) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:892:11: KW_AS selectStatementWithCTE
                            {
                            KW_AS127=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_createTableStatement2838); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_AS.add(KW_AS127);


                            pushFollow(FOLLOW_selectStatementWithCTE_in_createTableStatement2840);
                            selectStatementWithCTE128=selectStatementWithCTE();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_selectStatementWithCTE.add(selectStatementWithCTE128.getTree());

                            }
                            break;

                    }


                    }
                    break;

            }


            // AST REWRITE
            // elements: tableFileFormat, tableRowFormat, selectStatementWithCTE, ext, likeName, columnNameTypeList, tableLocation, tableComment, name, ifNotExists, temp, tableBuckets, tablePropertiesPrefixed, tablePartition, tableSkewed
            // token labels: ext, temp
            // rule labels: likeName, name, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_ext=new RewriteRuleTokenStream(adaptor,"token ext",ext);
            RewriteRuleTokenStream stream_temp=new RewriteRuleTokenStream(adaptor,"token temp",temp);
            RewriteRuleSubtreeStream stream_likeName=new RewriteRuleSubtreeStream(adaptor,"rule likeName",likeName!=null?likeName.tree:null);
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 894:5: -> ^( TOK_CREATETABLE $name ( $temp)? ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatementWithCTE )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:894:8: ^( TOK_CREATETABLE $name ( $temp)? ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatementWithCTE )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATETABLE, "TOK_CREATETABLE")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:894:33: ( $temp)?
                if ( stream_temp.hasNext() ) {
                    adaptor.addChild(root_1, stream_temp.nextNode());

                }
                stream_temp.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:894:40: ( $ext)?
                if ( stream_ext.hasNext() ) {
                    adaptor.addChild(root_1, stream_ext.nextNode());

                }
                stream_ext.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:894:45: ( ifNotExists )?
                if ( stream_ifNotExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifNotExists.nextTree());

                }
                stream_ifNotExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:895:10: ^( TOK_LIKETABLE ( $likeName)? )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_LIKETABLE, "TOK_LIKETABLE")
                , root_2);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:895:27: ( $likeName)?
                if ( stream_likeName.hasNext() ) {
                    adaptor.addChild(root_2, stream_likeName.nextTree());

                }
                stream_likeName.reset();

                adaptor.addChild(root_1, root_2);
                }

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:896:10: ( columnNameTypeList )?
                if ( stream_columnNameTypeList.hasNext() ) {
                    adaptor.addChild(root_1, stream_columnNameTypeList.nextTree());

                }
                stream_columnNameTypeList.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:897:10: ( tableComment )?
                if ( stream_tableComment.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableComment.nextTree());

                }
                stream_tableComment.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:898:10: ( tablePartition )?
                if ( stream_tablePartition.hasNext() ) {
                    adaptor.addChild(root_1, stream_tablePartition.nextTree());

                }
                stream_tablePartition.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:899:10: ( tableBuckets )?
                if ( stream_tableBuckets.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableBuckets.nextTree());

                }
                stream_tableBuckets.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:900:10: ( tableSkewed )?
                if ( stream_tableSkewed.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableSkewed.nextTree());

                }
                stream_tableSkewed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:901:10: ( tableRowFormat )?
                if ( stream_tableRowFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableRowFormat.nextTree());

                }
                stream_tableRowFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:902:10: ( tableFileFormat )?
                if ( stream_tableFileFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableFileFormat.nextTree());

                }
                stream_tableFileFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:903:10: ( tableLocation )?
                if ( stream_tableLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableLocation.nextTree());

                }
                stream_tableLocation.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:904:10: ( tablePropertiesPrefixed )?
                if ( stream_tablePropertiesPrefixed.hasNext() ) {
                    adaptor.addChild(root_1, stream_tablePropertiesPrefixed.nextTree());

                }
                stream_tablePropertiesPrefixed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:905:10: ( selectStatementWithCTE )?
                if ( stream_selectStatementWithCTE.hasNext() ) {
                    adaptor.addChild(root_1, stream_selectStatementWithCTE.nextTree());

                }
                stream_selectStatementWithCTE.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createTableStatement"


    public static class truncateTableStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "truncateTableStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:909:1: truncateTableStatement : KW_TRUNCATE KW_TABLE tablePartitionPrefix ( KW_COLUMNS LPAREN columnNameList RPAREN )? -> ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? ) ;
    public final HiveParser.truncateTableStatement_return truncateTableStatement() throws RecognitionException {
        HiveParser.truncateTableStatement_return retval = new HiveParser.truncateTableStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_TRUNCATE129=null;
        Token KW_TABLE130=null;
        Token KW_COLUMNS132=null;
        Token LPAREN133=null;
        Token RPAREN135=null;
        HiveParser.tablePartitionPrefix_return tablePartitionPrefix131 =null;

        HiveParser.columnNameList_return columnNameList134 =null;


        CommonTree KW_TRUNCATE129_tree=null;
        CommonTree KW_TABLE130_tree=null;
        CommonTree KW_COLUMNS132_tree=null;
        CommonTree LPAREN133_tree=null;
        CommonTree RPAREN135_tree=null;
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_TRUNCATE=new RewriteRuleTokenStream(adaptor,"token KW_TRUNCATE");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleSubtreeStream stream_tablePartitionPrefix=new RewriteRuleSubtreeStream(adaptor,"rule tablePartitionPrefix");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
         pushMsg("truncate table statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:912:5: ( KW_TRUNCATE KW_TABLE tablePartitionPrefix ( KW_COLUMNS LPAREN columnNameList RPAREN )? -> ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:912:7: KW_TRUNCATE KW_TABLE tablePartitionPrefix ( KW_COLUMNS LPAREN columnNameList RPAREN )?
            {
            KW_TRUNCATE129=(Token)match(input,KW_TRUNCATE,FOLLOW_KW_TRUNCATE_in_truncateTableStatement3047); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TRUNCATE.add(KW_TRUNCATE129);


            KW_TABLE130=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_truncateTableStatement3049); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TABLE.add(KW_TABLE130);


            pushFollow(FOLLOW_tablePartitionPrefix_in_truncateTableStatement3051);
            tablePartitionPrefix131=tablePartitionPrefix();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tablePartitionPrefix.add(tablePartitionPrefix131.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:912:49: ( KW_COLUMNS LPAREN columnNameList RPAREN )?
            int alt41=2;
            switch ( input.LA(1) ) {
                case KW_COLUMNS:
                    {
                    alt41=1;
                    }
                    break;
            }

            switch (alt41) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:912:50: KW_COLUMNS LPAREN columnNameList RPAREN
                    {
                    KW_COLUMNS132=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_truncateTableStatement3054); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_COLUMNS.add(KW_COLUMNS132);


                    LPAREN133=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_truncateTableStatement3056); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_LPAREN.add(LPAREN133);


                    pushFollow(FOLLOW_columnNameList_in_truncateTableStatement3058);
                    columnNameList134=columnNameList();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_columnNameList.add(columnNameList134.getTree());

                    RPAREN135=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_truncateTableStatement3060); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_RPAREN.add(RPAREN135);


                    }
                    break;

            }


            // AST REWRITE
            // elements: columnNameList, tablePartitionPrefix
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 912:92: -> ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:912:95: ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TRUNCATETABLE, "TOK_TRUNCATETABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tablePartitionPrefix.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:912:136: ( columnNameList )?
                if ( stream_columnNameList.hasNext() ) {
                    adaptor.addChild(root_1, stream_columnNameList.nextTree());

                }
                stream_columnNameList.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "truncateTableStatement"


    public static class createIndexStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createIndexStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:914:1: createIndexStatement : KW_CREATE KW_INDEX indexName= identifier KW_ON KW_TABLE tab= tableName LPAREN indexedCols= columnNameList RPAREN KW_AS typeName= StringLiteral ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? -> ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? ) ;
    public final HiveParser.createIndexStatement_return createIndexStatement() throws RecognitionException {
        HiveParser.createIndexStatement_return retval = new HiveParser.createIndexStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token typeName=null;
        Token KW_CREATE136=null;
        Token KW_INDEX137=null;
        Token KW_ON138=null;
        Token KW_TABLE139=null;
        Token LPAREN140=null;
        Token RPAREN141=null;
        Token KW_AS142=null;
        HiveParser_IdentifiersParser.identifier_return indexName =null;

        HiveParser_FromClauseParser.tableName_return tab =null;

        HiveParser.columnNameList_return indexedCols =null;

        HiveParser.autoRebuild_return autoRebuild143 =null;

        HiveParser.indexPropertiesPrefixed_return indexPropertiesPrefixed144 =null;

        HiveParser.indexTblName_return indexTblName145 =null;

        HiveParser.tableRowFormat_return tableRowFormat146 =null;

        HiveParser.tableFileFormat_return tableFileFormat147 =null;

        HiveParser.tableLocation_return tableLocation148 =null;

        HiveParser.tablePropertiesPrefixed_return tablePropertiesPrefixed149 =null;

        HiveParser.indexComment_return indexComment150 =null;


        CommonTree typeName_tree=null;
        CommonTree KW_CREATE136_tree=null;
        CommonTree KW_INDEX137_tree=null;
        CommonTree KW_ON138_tree=null;
        CommonTree KW_TABLE139_tree=null;
        CommonTree LPAREN140_tree=null;
        CommonTree RPAREN141_tree=null;
        CommonTree KW_AS142_tree=null;
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleSubtreeStream stream_tableRowFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableRowFormat");
        RewriteRuleSubtreeStream stream_indexComment=new RewriteRuleSubtreeStream(adaptor,"rule indexComment");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_tableLocation=new RewriteRuleSubtreeStream(adaptor,"rule tableLocation");
        RewriteRuleSubtreeStream stream_tablePropertiesPrefixed=new RewriteRuleSubtreeStream(adaptor,"rule tablePropertiesPrefixed");
        RewriteRuleSubtreeStream stream_tableFileFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableFileFormat");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
        RewriteRuleSubtreeStream stream_indexTblName=new RewriteRuleSubtreeStream(adaptor,"rule indexTblName");
        RewriteRuleSubtreeStream stream_autoRebuild=new RewriteRuleSubtreeStream(adaptor,"rule autoRebuild");
        RewriteRuleSubtreeStream stream_indexPropertiesPrefixed=new RewriteRuleSubtreeStream(adaptor,"rule indexPropertiesPrefixed");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
         pushMsg("create index statement", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:917:5: ( KW_CREATE KW_INDEX indexName= identifier KW_ON KW_TABLE tab= tableName LPAREN indexedCols= columnNameList RPAREN KW_AS typeName= StringLiteral ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? -> ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:917:7: KW_CREATE KW_INDEX indexName= identifier KW_ON KW_TABLE tab= tableName LPAREN indexedCols= columnNameList RPAREN KW_AS typeName= StringLiteral ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )?
            {
            KW_CREATE136=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createIndexStatement3095); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_CREATE.add(KW_CREATE136);


            KW_INDEX137=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_createIndexStatement3097); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_INDEX.add(KW_INDEX137);


            pushFollow(FOLLOW_identifier_in_createIndexStatement3101);
            indexName=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(indexName.getTree());

            KW_ON138=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_createIndexStatement3109); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_ON.add(KW_ON138);


            KW_TABLE139=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_createIndexStatement3111); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TABLE.add(KW_TABLE139);


            pushFollow(FOLLOW_tableName_in_createIndexStatement3115);
            tab=tableName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableName.add(tab.getTree());

            LPAREN140=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_createIndexStatement3117); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LPAREN.add(LPAREN140);


            pushFollow(FOLLOW_columnNameList_in_createIndexStatement3121);
            indexedCols=columnNameList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_columnNameList.add(indexedCols.getTree());

            RPAREN141=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_createIndexStatement3123); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RPAREN.add(RPAREN141);


            KW_AS142=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_createIndexStatement3131); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_AS.add(KW_AS142);


            typeName=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_createIndexStatement3135); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_StringLiteral.add(typeName);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:920:7: ( autoRebuild )?
            int alt42=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt42=1;
                    }
                    break;
            }

            switch (alt42) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:920:7: autoRebuild
                    {
                    pushFollow(FOLLOW_autoRebuild_in_createIndexStatement3143);
                    autoRebuild143=autoRebuild();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_autoRebuild.add(autoRebuild143.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:921:7: ( indexPropertiesPrefixed )?
            int alt43=2;
            switch ( input.LA(1) ) {
                case KW_IDXPROPERTIES:
                    {
                    alt43=1;
                    }
                    break;
            }

            switch (alt43) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:921:7: indexPropertiesPrefixed
                    {
                    pushFollow(FOLLOW_indexPropertiesPrefixed_in_createIndexStatement3152);
                    indexPropertiesPrefixed144=indexPropertiesPrefixed();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_indexPropertiesPrefixed.add(indexPropertiesPrefixed144.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:922:7: ( indexTblName )?
            int alt44=2;
            switch ( input.LA(1) ) {
                case KW_IN:
                    {
                    alt44=1;
                    }
                    break;
            }

            switch (alt44) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:922:7: indexTblName
                    {
                    pushFollow(FOLLOW_indexTblName_in_createIndexStatement3161);
                    indexTblName145=indexTblName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_indexTblName.add(indexTblName145.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:923:7: ( tableRowFormat )?
            int alt45=2;
            switch ( input.LA(1) ) {
                case KW_ROW:
                    {
                    alt45=1;
                    }
                    break;
            }

            switch (alt45) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:923:7: tableRowFormat
                    {
                    pushFollow(FOLLOW_tableRowFormat_in_createIndexStatement3170);
                    tableRowFormat146=tableRowFormat();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableRowFormat.add(tableRowFormat146.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:924:7: ( tableFileFormat )?
            int alt46=2;
            switch ( input.LA(1) ) {
                case KW_STORED:
                    {
                    alt46=1;
                    }
                    break;
            }

            switch (alt46) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:924:7: tableFileFormat
                    {
                    pushFollow(FOLLOW_tableFileFormat_in_createIndexStatement3179);
                    tableFileFormat147=tableFileFormat();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableFileFormat.add(tableFileFormat147.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:925:7: ( tableLocation )?
            int alt47=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt47=1;
                    }
                    break;
            }

            switch (alt47) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:925:7: tableLocation
                    {
                    pushFollow(FOLLOW_tableLocation_in_createIndexStatement3188);
                    tableLocation148=tableLocation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableLocation.add(tableLocation148.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:926:7: ( tablePropertiesPrefixed )?
            int alt48=2;
            switch ( input.LA(1) ) {
                case KW_TBLPROPERTIES:
                    {
                    alt48=1;
                    }
                    break;
            }

            switch (alt48) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:926:7: tablePropertiesPrefixed
                    {
                    pushFollow(FOLLOW_tablePropertiesPrefixed_in_createIndexStatement3197);
                    tablePropertiesPrefixed149=tablePropertiesPrefixed();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tablePropertiesPrefixed.add(tablePropertiesPrefixed149.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:927:7: ( indexComment )?
            int alt49=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt49=1;
                    }
                    break;
            }

            switch (alt49) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:927:7: indexComment
                    {
                    pushFollow(FOLLOW_indexComment_in_createIndexStatement3206);
                    indexComment150=indexComment();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_indexComment.add(indexComment150.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: indexName, tab, autoRebuild, tableRowFormat, indexPropertiesPrefixed, indexTblName, tableLocation, tablePropertiesPrefixed, indexComment, indexedCols, typeName, tableFileFormat
            // token labels: typeName
            // rule labels: indexedCols, tab, indexName, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_typeName=new RewriteRuleTokenStream(adaptor,"token typeName",typeName);
            RewriteRuleSubtreeStream stream_indexedCols=new RewriteRuleSubtreeStream(adaptor,"rule indexedCols",indexedCols!=null?indexedCols.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);
            RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 928:5: -> ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:928:7: ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEINDEX, "TOK_CREATEINDEX")
                , root_1);

                adaptor.addChild(root_1, stream_indexName.nextTree());

                adaptor.addChild(root_1, stream_typeName.nextNode());

                adaptor.addChild(root_1, stream_tab.nextTree());

                adaptor.addChild(root_1, stream_indexedCols.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:929:9: ( autoRebuild )?
                if ( stream_autoRebuild.hasNext() ) {
                    adaptor.addChild(root_1, stream_autoRebuild.nextTree());

                }
                stream_autoRebuild.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:930:9: ( indexPropertiesPrefixed )?
                if ( stream_indexPropertiesPrefixed.hasNext() ) {
                    adaptor.addChild(root_1, stream_indexPropertiesPrefixed.nextTree());

                }
                stream_indexPropertiesPrefixed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:931:9: ( indexTblName )?
                if ( stream_indexTblName.hasNext() ) {
                    adaptor.addChild(root_1, stream_indexTblName.nextTree());

                }
                stream_indexTblName.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:932:9: ( tableRowFormat )?
                if ( stream_tableRowFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableRowFormat.nextTree());

                }
                stream_tableRowFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:933:9: ( tableFileFormat )?
                if ( stream_tableFileFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableFileFormat.nextTree());

                }
                stream_tableFileFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:934:9: ( tableLocation )?
                if ( stream_tableLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableLocation.nextTree());

                }
                stream_tableLocation.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:935:9: ( tablePropertiesPrefixed )?
                if ( stream_tablePropertiesPrefixed.hasNext() ) {
                    adaptor.addChild(root_1, stream_tablePropertiesPrefixed.nextTree());

                }
                stream_tablePropertiesPrefixed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:936:9: ( indexComment )?
                if ( stream_indexComment.hasNext() ) {
                    adaptor.addChild(root_1, stream_indexComment.nextTree());

                }
                stream_indexComment.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createIndexStatement"


    public static class indexComment_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexComment"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:939:1: indexComment : KW_COMMENT comment= StringLiteral -> ^( TOK_INDEXCOMMENT $comment) ;
    public final HiveParser.indexComment_return indexComment() throws RecognitionException {
        HiveParser.indexComment_return retval = new HiveParser.indexComment_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_COMMENT151=null;

        CommonTree comment_tree=null;
        CommonTree KW_COMMENT151_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");

         pushMsg("comment on an index", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:942:9: ( KW_COMMENT comment= StringLiteral -> ^( TOK_INDEXCOMMENT $comment) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:943:17: KW_COMMENT comment= StringLiteral
            {
            KW_COMMENT151=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_indexComment3363); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_COMMENT.add(KW_COMMENT151);


            comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_indexComment3367); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_StringLiteral.add(comment);


            // AST REWRITE
            // elements: comment
            // token labels: comment
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 943:51: -> ^( TOK_INDEXCOMMENT $comment)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:943:54: ^( TOK_INDEXCOMMENT $comment)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_INDEXCOMMENT, "TOK_INDEXCOMMENT")
                , root_1);

                adaptor.addChild(root_1, stream_comment.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexComment"


    public static class autoRebuild_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "autoRebuild"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:946:1: autoRebuild : KW_WITH KW_DEFERRED KW_REBUILD -> ^( TOK_DEFERRED_REBUILDINDEX ) ;
    public final HiveParser.autoRebuild_return autoRebuild() throws RecognitionException {
        HiveParser.autoRebuild_return retval = new HiveParser.autoRebuild_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_WITH152=null;
        Token KW_DEFERRED153=null;
        Token KW_REBUILD154=null;

        CommonTree KW_WITH152_tree=null;
        CommonTree KW_DEFERRED153_tree=null;
        CommonTree KW_REBUILD154_tree=null;
        RewriteRuleTokenStream stream_KW_REBUILD=new RewriteRuleTokenStream(adaptor,"token KW_REBUILD");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleTokenStream stream_KW_DEFERRED=new RewriteRuleTokenStream(adaptor,"token KW_DEFERRED");

         pushMsg("auto rebuild index", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:949:5: ( KW_WITH KW_DEFERRED KW_REBUILD -> ^( TOK_DEFERRED_REBUILDINDEX ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:949:7: KW_WITH KW_DEFERRED KW_REBUILD
            {
            KW_WITH152=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_autoRebuild3408); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_WITH.add(KW_WITH152);


            KW_DEFERRED153=(Token)match(input,KW_DEFERRED,FOLLOW_KW_DEFERRED_in_autoRebuild3410); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_DEFERRED.add(KW_DEFERRED153);


            KW_REBUILD154=(Token)match(input,KW_REBUILD,FOLLOW_KW_REBUILD_in_autoRebuild3412); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_REBUILD.add(KW_REBUILD154);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 950:5: -> ^( TOK_DEFERRED_REBUILDINDEX )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:950:7: ^( TOK_DEFERRED_REBUILDINDEX )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DEFERRED_REBUILDINDEX, "TOK_DEFERRED_REBUILDINDEX")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "autoRebuild"


    public static class indexTblName_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexTblName"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:953:1: indexTblName : KW_IN KW_TABLE indexTbl= tableName -> ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl) ;
    public final HiveParser.indexTblName_return indexTblName() throws RecognitionException {
        HiveParser.indexTblName_return retval = new HiveParser.indexTblName_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IN155=null;
        Token KW_TABLE156=null;
        HiveParser_FromClauseParser.tableName_return indexTbl =null;


        CommonTree KW_IN155_tree=null;
        CommonTree KW_TABLE156_tree=null;
        RewriteRuleTokenStream stream_KW_IN=new RewriteRuleTokenStream(adaptor,"token KW_IN");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
         pushMsg("index table name", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:956:5: ( KW_IN KW_TABLE indexTbl= tableName -> ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:956:7: KW_IN KW_TABLE indexTbl= tableName
            {
            KW_IN155=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_indexTblName3448); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_IN.add(KW_IN155);


            KW_TABLE156=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_indexTblName3450); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TABLE.add(KW_TABLE156);


            pushFollow(FOLLOW_tableName_in_indexTblName3454);
            indexTbl=tableName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableName.add(indexTbl.getTree());

            // AST REWRITE
            // elements: indexTbl
            // token labels: 
            // rule labels: indexTbl, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_indexTbl=new RewriteRuleSubtreeStream(adaptor,"rule indexTbl",indexTbl!=null?indexTbl.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 957:5: -> ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:957:7: ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEINDEX_INDEXTBLNAME, "TOK_CREATEINDEX_INDEXTBLNAME")
                , root_1);

                adaptor.addChild(root_1, stream_indexTbl.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexTblName"


    public static class indexPropertiesPrefixed_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexPropertiesPrefixed"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:960:1: indexPropertiesPrefixed : KW_IDXPROPERTIES ! indexProperties ;
    public final HiveParser.indexPropertiesPrefixed_return indexPropertiesPrefixed() throws RecognitionException {
        HiveParser.indexPropertiesPrefixed_return retval = new HiveParser.indexPropertiesPrefixed_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IDXPROPERTIES157=null;
        HiveParser.indexProperties_return indexProperties158 =null;


        CommonTree KW_IDXPROPERTIES157_tree=null;

         pushMsg("table properties with prefix", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:963:5: ( KW_IDXPROPERTIES ! indexProperties )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:964:9: KW_IDXPROPERTIES ! indexProperties
            {
            root_0 = (CommonTree)adaptor.nil();


            KW_IDXPROPERTIES157=(Token)match(input,KW_IDXPROPERTIES,FOLLOW_KW_IDXPROPERTIES_in_indexPropertiesPrefixed3501); if (state.failed) return retval;

            pushFollow(FOLLOW_indexProperties_in_indexPropertiesPrefixed3504);
            indexProperties158=indexProperties();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, indexProperties158.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexPropertiesPrefixed"


    public static class indexProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:967:1: indexProperties : LPAREN indexPropertiesList RPAREN -> ^( TOK_INDEXPROPERTIES indexPropertiesList ) ;
    public final HiveParser.indexProperties_return indexProperties() throws RecognitionException {
        HiveParser.indexProperties_return retval = new HiveParser.indexProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token LPAREN159=null;
        Token RPAREN161=null;
        HiveParser.indexPropertiesList_return indexPropertiesList160 =null;


        CommonTree LPAREN159_tree=null;
        CommonTree RPAREN161_tree=null;
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleSubtreeStream stream_indexPropertiesList=new RewriteRuleSubtreeStream(adaptor,"rule indexPropertiesList");
         pushMsg("index properties", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:970:5: ( LPAREN indexPropertiesList RPAREN -> ^( TOK_INDEXPROPERTIES indexPropertiesList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:971:7: LPAREN indexPropertiesList RPAREN
            {
            LPAREN159=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_indexProperties3537); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LPAREN.add(LPAREN159);


            pushFollow(FOLLOW_indexPropertiesList_in_indexProperties3539);
            indexPropertiesList160=indexPropertiesList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_indexPropertiesList.add(indexPropertiesList160.getTree());

            RPAREN161=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_indexProperties3541); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RPAREN.add(RPAREN161);


            // AST REWRITE
            // elements: indexPropertiesList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 971:41: -> ^( TOK_INDEXPROPERTIES indexPropertiesList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:971:44: ^( TOK_INDEXPROPERTIES indexPropertiesList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_INDEXPROPERTIES, "TOK_INDEXPROPERTIES")
                , root_1);

                adaptor.addChild(root_1, stream_indexPropertiesList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexProperties"


    public static class indexPropertiesList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexPropertiesList"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:974:1: indexPropertiesList : keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_INDEXPROPLIST ( keyValueProperty )+ ) ;
    public final HiveParser.indexPropertiesList_return indexPropertiesList() throws RecognitionException {
        HiveParser.indexPropertiesList_return retval = new HiveParser.indexPropertiesList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA163=null;
        HiveParser.keyValueProperty_return keyValueProperty162 =null;

        HiveParser.keyValueProperty_return keyValueProperty164 =null;


        CommonTree COMMA163_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_keyValueProperty=new RewriteRuleSubtreeStream(adaptor,"rule keyValueProperty");
         pushMsg("index properties list", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:977:5: ( keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_INDEXPROPLIST ( keyValueProperty )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:978:7: keyValueProperty ( COMMA keyValueProperty )*
            {
            pushFollow(FOLLOW_keyValueProperty_in_indexPropertiesList3582);
            keyValueProperty162=keyValueProperty();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_keyValueProperty.add(keyValueProperty162.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:978:24: ( COMMA keyValueProperty )*
            loop50:
            do {
                int alt50=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt50=1;
                    }
                    break;

                }

                switch (alt50) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:978:25: COMMA keyValueProperty
            	    {
            	    COMMA163=(Token)match(input,COMMA,FOLLOW_COMMA_in_indexPropertiesList3585); if (state.failed) return retval; 
            	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA163);


            	    pushFollow(FOLLOW_keyValueProperty_in_indexPropertiesList3587);
            	    keyValueProperty164=keyValueProperty();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_keyValueProperty.add(keyValueProperty164.getTree());

            	    }
            	    break;

            	default :
            	    break loop50;
                }
            } while (true);


            // AST REWRITE
            // elements: keyValueProperty
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 978:50: -> ^( TOK_INDEXPROPLIST ( keyValueProperty )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:978:53: ^( TOK_INDEXPROPLIST ( keyValueProperty )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_INDEXPROPLIST, "TOK_INDEXPROPLIST")
                , root_1);

                if ( !(stream_keyValueProperty.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_keyValueProperty.hasNext() ) {
                    adaptor.addChild(root_1, stream_keyValueProperty.nextTree());

                }
                stream_keyValueProperty.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexPropertiesList"


    public static class dropIndexStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropIndexStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:981:1: dropIndexStatement : KW_DROP KW_INDEX ( ifExists )? indexName= identifier KW_ON tab= tableName -> ^( TOK_DROPINDEX $indexName $tab ( ifExists )? ) ;
    public final HiveParser.dropIndexStatement_return dropIndexStatement() throws RecognitionException {
        HiveParser.dropIndexStatement_return retval = new HiveParser.dropIndexStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP165=null;
        Token KW_INDEX166=null;
        Token KW_ON168=null;
        HiveParser_IdentifiersParser.identifier_return indexName =null;

        HiveParser_FromClauseParser.tableName_return tab =null;

        HiveParser.ifExists_return ifExists167 =null;


        CommonTree KW_DROP165_tree=null;
        CommonTree KW_INDEX166_tree=null;
        CommonTree KW_ON168_tree=null;
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
         pushMsg("drop index statement", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:984:5: ( KW_DROP KW_INDEX ( ifExists )? indexName= identifier KW_ON tab= tableName -> ^( TOK_DROPINDEX $indexName $tab ( ifExists )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:984:7: KW_DROP KW_INDEX ( ifExists )? indexName= identifier KW_ON tab= tableName
            {
            KW_DROP165=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropIndexStatement3625); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_DROP.add(KW_DROP165);


            KW_INDEX166=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_dropIndexStatement3627); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_INDEX.add(KW_INDEX166);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:984:24: ( ifExists )?
            int alt51=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt51=1;
                    }
                    break;
            }

            switch (alt51) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:984:24: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_dropIndexStatement3629);
                    ifExists167=ifExists();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_ifExists.add(ifExists167.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_dropIndexStatement3634);
            indexName=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(indexName.getTree());

            KW_ON168=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_dropIndexStatement3636); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_ON.add(KW_ON168);


            pushFollow(FOLLOW_tableName_in_dropIndexStatement3640);
            tab=tableName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableName.add(tab.getTree());

            // AST REWRITE
            // elements: indexName, tab, ifExists
            // token labels: 
            // rule labels: tab, indexName, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);
            RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 985:5: -> ^( TOK_DROPINDEX $indexName $tab ( ifExists )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:985:7: ^( TOK_DROPINDEX $indexName $tab ( ifExists )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPINDEX, "TOK_DROPINDEX")
                , root_1);

                adaptor.addChild(root_1, stream_indexName.nextTree());

                adaptor.addChild(root_1, stream_tab.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:985:39: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropIndexStatement"


    public static class dropTableStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropTableStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:988:1: dropTableStatement : KW_DROP KW_TABLE ( ifExists )? tableName ( KW_PURGE )? ( replicationClause )? -> ^( TOK_DROPTABLE tableName ( ifExists )? ( KW_PURGE )? ( replicationClause )? ) ;
    public final HiveParser.dropTableStatement_return dropTableStatement() throws RecognitionException {
        HiveParser.dropTableStatement_return retval = new HiveParser.dropTableStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP169=null;
        Token KW_TABLE170=null;
        Token KW_PURGE173=null;
        HiveParser.ifExists_return ifExists171 =null;

        HiveParser_FromClauseParser.tableName_return tableName172 =null;

        HiveParser.replicationClause_return replicationClause174 =null;


        CommonTree KW_DROP169_tree=null;
        CommonTree KW_TABLE170_tree=null;
        CommonTree KW_PURGE173_tree=null;
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_PURGE=new RewriteRuleTokenStream(adaptor,"token KW_PURGE");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_replicationClause=new RewriteRuleSubtreeStream(adaptor,"rule replicationClause");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
         pushMsg("drop statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:991:5: ( KW_DROP KW_TABLE ( ifExists )? tableName ( KW_PURGE )? ( replicationClause )? -> ^( TOK_DROPTABLE tableName ( ifExists )? ( KW_PURGE )? ( replicationClause )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:991:7: KW_DROP KW_TABLE ( ifExists )? tableName ( KW_PURGE )? ( replicationClause )?
            {
            KW_DROP169=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropTableStatement3685); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_DROP.add(KW_DROP169);


            KW_TABLE170=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_dropTableStatement3687); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TABLE.add(KW_TABLE170);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:991:24: ( ifExists )?
            int alt52=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt52=1;
                    }
                    break;
            }

            switch (alt52) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:991:24: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_dropTableStatement3689);
                    ifExists171=ifExists();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_ifExists.add(ifExists171.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_tableName_in_dropTableStatement3692);
            tableName172=tableName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableName.add(tableName172.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:991:44: ( KW_PURGE )?
            int alt53=2;
            switch ( input.LA(1) ) {
                case KW_PURGE:
                    {
                    alt53=1;
                    }
                    break;
            }

            switch (alt53) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:991:44: KW_PURGE
                    {
                    KW_PURGE173=(Token)match(input,KW_PURGE,FOLLOW_KW_PURGE_in_dropTableStatement3694); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_PURGE.add(KW_PURGE173);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:991:54: ( replicationClause )?
            int alt54=2;
            switch ( input.LA(1) ) {
                case KW_FOR:
                    {
                    alt54=1;
                    }
                    break;
            }

            switch (alt54) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:991:54: replicationClause
                    {
                    pushFollow(FOLLOW_replicationClause_in_dropTableStatement3697);
                    replicationClause174=replicationClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_replicationClause.add(replicationClause174.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: replicationClause, ifExists, KW_PURGE, tableName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 992:5: -> ^( TOK_DROPTABLE tableName ( ifExists )? ( KW_PURGE )? ( replicationClause )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:992:8: ^( TOK_DROPTABLE tableName ( ifExists )? ( KW_PURGE )? ( replicationClause )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPTABLE, "TOK_DROPTABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:992:34: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:992:44: ( KW_PURGE )?
                if ( stream_KW_PURGE.hasNext() ) {
                    adaptor.addChild(root_1, 
                    stream_KW_PURGE.nextNode()
                    );

                }
                stream_KW_PURGE.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:992:54: ( replicationClause )?
                if ( stream_replicationClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_replicationClause.nextTree());

                }
                stream_replicationClause.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropTableStatement"


    public static class alterStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:995:1: alterStatement : ( KW_ALTER KW_TABLE tableName alterTableStatementSuffix -> ^( TOK_ALTERTABLE tableName alterTableStatementSuffix ) | KW_ALTER KW_VIEW tableName ( KW_AS )? alterViewStatementSuffix -> ^( TOK_ALTERVIEW tableName alterViewStatementSuffix ) | KW_ALTER KW_INDEX alterIndexStatementSuffix -> alterIndexStatementSuffix | KW_ALTER ( KW_DATABASE | KW_SCHEMA ) alterDatabaseStatementSuffix -> alterDatabaseStatementSuffix );
    public final HiveParser.alterStatement_return alterStatement() throws RecognitionException {
        HiveParser.alterStatement_return retval = new HiveParser.alterStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ALTER175=null;
        Token KW_TABLE176=null;
        Token KW_ALTER179=null;
        Token KW_VIEW180=null;
        Token KW_AS182=null;
        Token KW_ALTER184=null;
        Token KW_INDEX185=null;
        Token KW_ALTER187=null;
        Token KW_DATABASE188=null;
        Token KW_SCHEMA189=null;
        HiveParser_FromClauseParser.tableName_return tableName177 =null;

        HiveParser.alterTableStatementSuffix_return alterTableStatementSuffix178 =null;

        HiveParser_FromClauseParser.tableName_return tableName181 =null;

        HiveParser.alterViewStatementSuffix_return alterViewStatementSuffix183 =null;

        HiveParser.alterIndexStatementSuffix_return alterIndexStatementSuffix186 =null;

        HiveParser.alterDatabaseStatementSuffix_return alterDatabaseStatementSuffix190 =null;


        CommonTree KW_ALTER175_tree=null;
        CommonTree KW_TABLE176_tree=null;
        CommonTree KW_ALTER179_tree=null;
        CommonTree KW_VIEW180_tree=null;
        CommonTree KW_AS182_tree=null;
        CommonTree KW_ALTER184_tree=null;
        CommonTree KW_INDEX185_tree=null;
        CommonTree KW_ALTER187_tree=null;
        CommonTree KW_DATABASE188_tree=null;
        CommonTree KW_SCHEMA189_tree=null;
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_VIEW=new RewriteRuleTokenStream(adaptor,"token KW_VIEW");
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_ALTER=new RewriteRuleTokenStream(adaptor,"token KW_ALTER");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleSubtreeStream stream_alterTableStatementSuffix=new RewriteRuleSubtreeStream(adaptor,"rule alterTableStatementSuffix");
        RewriteRuleSubtreeStream stream_alterViewStatementSuffix=new RewriteRuleSubtreeStream(adaptor,"rule alterViewStatementSuffix");
        RewriteRuleSubtreeStream stream_alterDatabaseStatementSuffix=new RewriteRuleSubtreeStream(adaptor,"rule alterDatabaseStatementSuffix");
        RewriteRuleSubtreeStream stream_alterIndexStatementSuffix=new RewriteRuleSubtreeStream(adaptor,"rule alterIndexStatementSuffix");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
         pushMsg("alter statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:998:5: ( KW_ALTER KW_TABLE tableName alterTableStatementSuffix -> ^( TOK_ALTERTABLE tableName alterTableStatementSuffix ) | KW_ALTER KW_VIEW tableName ( KW_AS )? alterViewStatementSuffix -> ^( TOK_ALTERVIEW tableName alterViewStatementSuffix ) | KW_ALTER KW_INDEX alterIndexStatementSuffix -> alterIndexStatementSuffix | KW_ALTER ( KW_DATABASE | KW_SCHEMA ) alterDatabaseStatementSuffix -> alterDatabaseStatementSuffix )
            int alt57=4;
            switch ( input.LA(1) ) {
            case KW_ALTER:
                {
                switch ( input.LA(2) ) {
                case KW_TABLE:
                    {
                    alt57=1;
                    }
                    break;
                case KW_VIEW:
                    {
                    alt57=2;
                    }
                    break;
                case KW_INDEX:
                    {
                    alt57=3;
                    }
                    break;
                case KW_DATABASE:
                case KW_SCHEMA:
                    {
                    alt57=4;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 57, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 57, 0, input);

                throw nvae;

            }

            switch (alt57) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:998:7: KW_ALTER KW_TABLE tableName alterTableStatementSuffix
                    {
                    KW_ALTER175=(Token)match(input,KW_ALTER,FOLLOW_KW_ALTER_in_alterStatement3746); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_ALTER.add(KW_ALTER175);


                    KW_TABLE176=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_alterStatement3748); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_TABLE.add(KW_TABLE176);


                    pushFollow(FOLLOW_tableName_in_alterStatement3750);
                    tableName177=tableName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableName.add(tableName177.getTree());

                    pushFollow(FOLLOW_alterTableStatementSuffix_in_alterStatement3752);
                    alterTableStatementSuffix178=alterTableStatementSuffix();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_alterTableStatementSuffix.add(alterTableStatementSuffix178.getTree());

                    // AST REWRITE
                    // elements: alterTableStatementSuffix, tableName
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 998:61: -> ^( TOK_ALTERTABLE tableName alterTableStatementSuffix )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:998:64: ^( TOK_ALTERTABLE tableName alterTableStatementSuffix )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE, "TOK_ALTERTABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableName.nextTree());

                        adaptor.addChild(root_1, stream_alterTableStatementSuffix.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:999:7: KW_ALTER KW_VIEW tableName ( KW_AS )? alterViewStatementSuffix
                    {
                    KW_ALTER179=(Token)match(input,KW_ALTER,FOLLOW_KW_ALTER_in_alterStatement3770); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_ALTER.add(KW_ALTER179);


                    KW_VIEW180=(Token)match(input,KW_VIEW,FOLLOW_KW_VIEW_in_alterStatement3772); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_VIEW.add(KW_VIEW180);


                    pushFollow(FOLLOW_tableName_in_alterStatement3774);
                    tableName181=tableName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableName.add(tableName181.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:999:34: ( KW_AS )?
                    int alt55=2;
                    switch ( input.LA(1) ) {
                        case KW_AS:
                            {
                            alt55=1;
                            }
                            break;
                    }

                    switch (alt55) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:999:34: KW_AS
                            {
                            KW_AS182=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_alterStatement3776); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_AS.add(KW_AS182);


                            }
                            break;

                    }


                    pushFollow(FOLLOW_alterViewStatementSuffix_in_alterStatement3779);
                    alterViewStatementSuffix183=alterViewStatementSuffix();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_alterViewStatementSuffix.add(alterViewStatementSuffix183.getTree());

                    // AST REWRITE
                    // elements: alterViewStatementSuffix, tableName
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 999:66: -> ^( TOK_ALTERVIEW tableName alterViewStatementSuffix )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:999:69: ^( TOK_ALTERVIEW tableName alterViewStatementSuffix )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW, "TOK_ALTERVIEW")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableName.nextTree());

                        adaptor.addChild(root_1, stream_alterViewStatementSuffix.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1000:7: KW_ALTER KW_INDEX alterIndexStatementSuffix
                    {
                    KW_ALTER184=(Token)match(input,KW_ALTER,FOLLOW_KW_ALTER_in_alterStatement3797); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_ALTER.add(KW_ALTER184);


                    KW_INDEX185=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_alterStatement3799); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_INDEX.add(KW_INDEX185);


                    pushFollow(FOLLOW_alterIndexStatementSuffix_in_alterStatement3801);
                    alterIndexStatementSuffix186=alterIndexStatementSuffix();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_alterIndexStatementSuffix.add(alterIndexStatementSuffix186.getTree());

                    // AST REWRITE
                    // elements: alterIndexStatementSuffix
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1000:51: -> alterIndexStatementSuffix
                    {
                        adaptor.addChild(root_0, stream_alterIndexStatementSuffix.nextTree());

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1001:7: KW_ALTER ( KW_DATABASE | KW_SCHEMA ) alterDatabaseStatementSuffix
                    {
                    KW_ALTER187=(Token)match(input,KW_ALTER,FOLLOW_KW_ALTER_in_alterStatement3813); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_ALTER.add(KW_ALTER187);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1001:16: ( KW_DATABASE | KW_SCHEMA )
                    int alt56=2;
                    switch ( input.LA(1) ) {
                    case KW_DATABASE:
                        {
                        alt56=1;
                        }
                        break;
                    case KW_SCHEMA:
                        {
                        alt56=2;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 56, 0, input);

                        throw nvae;

                    }

                    switch (alt56) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1001:17: KW_DATABASE
                            {
                            KW_DATABASE188=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_alterStatement3816); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_DATABASE.add(KW_DATABASE188);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1001:29: KW_SCHEMA
                            {
                            KW_SCHEMA189=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_alterStatement3818); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_SCHEMA.add(KW_SCHEMA189);


                            }
                            break;

                    }


                    pushFollow(FOLLOW_alterDatabaseStatementSuffix_in_alterStatement3821);
                    alterDatabaseStatementSuffix190=alterDatabaseStatementSuffix();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_alterDatabaseStatementSuffix.add(alterDatabaseStatementSuffix190.getTree());

                    // AST REWRITE
                    // elements: alterDatabaseStatementSuffix
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1001:69: -> alterDatabaseStatementSuffix
                    {
                        adaptor.addChild(root_0, stream_alterDatabaseStatementSuffix.nextTree());

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatement"


    public static class alterTableStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterTableStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1004:1: alterTableStatementSuffix : ( ( alterStatementSuffixRename[true] )=> alterStatementSuffixRename[true] | alterStatementSuffixDropPartitions[true] | alterStatementSuffixAddPartitions[true] | alterStatementSuffixTouch | alterStatementSuffixArchive | alterStatementSuffixUnArchive | alterStatementSuffixProperties | alterStatementSuffixSkewedby | alterStatementSuffixExchangePartition | alterStatementPartitionKeyType | ( partitionSpec )? alterTblPartitionStatementSuffix -> alterTblPartitionStatementSuffix ( partitionSpec )? );
    public final HiveParser.alterTableStatementSuffix_return alterTableStatementSuffix() throws RecognitionException {
        HiveParser.alterTableStatementSuffix_return retval = new HiveParser.alterTableStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterStatementSuffixRename_return alterStatementSuffixRename191 =null;

        HiveParser.alterStatementSuffixDropPartitions_return alterStatementSuffixDropPartitions192 =null;

        HiveParser.alterStatementSuffixAddPartitions_return alterStatementSuffixAddPartitions193 =null;

        HiveParser.alterStatementSuffixTouch_return alterStatementSuffixTouch194 =null;

        HiveParser.alterStatementSuffixArchive_return alterStatementSuffixArchive195 =null;

        HiveParser.alterStatementSuffixUnArchive_return alterStatementSuffixUnArchive196 =null;

        HiveParser.alterStatementSuffixProperties_return alterStatementSuffixProperties197 =null;

        HiveParser.alterStatementSuffixSkewedby_return alterStatementSuffixSkewedby198 =null;

        HiveParser.alterStatementSuffixExchangePartition_return alterStatementSuffixExchangePartition199 =null;

        HiveParser.alterStatementPartitionKeyType_return alterStatementPartitionKeyType200 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec201 =null;

        HiveParser.alterTblPartitionStatementSuffix_return alterTblPartitionStatementSuffix202 =null;


        RewriteRuleSubtreeStream stream_alterTblPartitionStatementSuffix=new RewriteRuleSubtreeStream(adaptor,"rule alterTblPartitionStatementSuffix");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("alter table statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1007:5: ( ( alterStatementSuffixRename[true] )=> alterStatementSuffixRename[true] | alterStatementSuffixDropPartitions[true] | alterStatementSuffixAddPartitions[true] | alterStatementSuffixTouch | alterStatementSuffixArchive | alterStatementSuffixUnArchive | alterStatementSuffixProperties | alterStatementSuffixSkewedby | alterStatementSuffixExchangePartition | alterStatementPartitionKeyType | ( partitionSpec )? alterTblPartitionStatementSuffix -> alterTblPartitionStatementSuffix ( partitionSpec )? )
            int alt59=11;
            switch ( input.LA(1) ) {
            case KW_RENAME:
                {
                switch ( input.LA(2) ) {
                case KW_TO:
                    {
                    int LA59_22 = input.LA(3);

                    if ( (LA59_22==Identifier) && (synpred3_HiveParser())) {
                        alt59=1;
                    }
                    else if ( ((LA59_22 >= KW_ADD && LA59_22 <= KW_AFTER)||LA59_22==KW_ANALYZE||LA59_22==KW_ARCHIVE||LA59_22==KW_ASC||LA59_22==KW_BEFORE||(LA59_22 >= KW_BUCKET && LA59_22 <= KW_BUCKETS)||LA59_22==KW_CASCADE||LA59_22==KW_CHANGE||(LA59_22 >= KW_CLUSTER && LA59_22 <= KW_COLLECTION)||(LA59_22 >= KW_COLUMNS && LA59_22 <= KW_CONCATENATE)||LA59_22==KW_CONTINUE||LA59_22==KW_DATA||LA59_22==KW_DATABASES||(LA59_22 >= KW_DATETIME && LA59_22 <= KW_DBPROPERTIES)||(LA59_22 >= KW_DEFERRED && LA59_22 <= KW_DEFINED)||(LA59_22 >= KW_DELIMITED && LA59_22 <= KW_DESC)||(LA59_22 >= KW_DIRECTORIES && LA59_22 <= KW_DISABLE)||LA59_22==KW_DISTRIBUTE||LA59_22==KW_ELEM_TYPE||LA59_22==KW_ENABLE||LA59_22==KW_ESCAPED||LA59_22==KW_EXCLUSIVE||(LA59_22 >= KW_EXPLAIN && LA59_22 <= KW_EXPORT)||(LA59_22 >= KW_FIELDS && LA59_22 <= KW_FIRST)||(LA59_22 >= KW_FORMAT && LA59_22 <= KW_FORMATTED)||LA59_22==KW_FUNCTIONS||(LA59_22 >= KW_HOLD_DDLTIME && LA59_22 <= KW_IDXPROPERTIES)||LA59_22==KW_IGNORE||(LA59_22 >= KW_INDEX && LA59_22 <= KW_INDEXES)||(LA59_22 >= KW_INPATH && LA59_22 <= KW_INPUTFORMAT)||(LA59_22 >= KW_ITEMS && LA59_22 <= KW_JAR)||(LA59_22 >= KW_KEYS && LA59_22 <= KW_KEY_TYPE)||(LA59_22 >= KW_LIMIT && LA59_22 <= KW_LOAD)||(LA59_22 >= KW_LOCATION && LA59_22 <= KW_LONG)||(LA59_22 >= KW_MAPJOIN && LA59_22 <= KW_MONTH)||LA59_22==KW_MSCK||LA59_22==KW_NOSCAN||LA59_22==KW_NO_DROP||LA59_22==KW_OFFLINE||LA59_22==KW_OPTION||(LA59_22 >= KW_OUTPUTDRIVER && LA59_22 <= KW_OUTPUTFORMAT)||(LA59_22 >= KW_OVERWRITE && LA59_22 <= KW_OWNER)||(LA59_22 >= KW_PARTITIONED && LA59_22 <= KW_PARTITIONS)||LA59_22==KW_PLUS||(LA59_22 >= KW_PRETTY && LA59_22 <= KW_PRINCIPALS)||(LA59_22 >= KW_PROTECTION && LA59_22 <= KW_PURGE)||(LA59_22 >= KW_READ && LA59_22 <= KW_READONLY)||(LA59_22 >= KW_REBUILD && LA59_22 <= KW_RECORDWRITER)||(LA59_22 >= KW_REGEXP && LA59_22 <= KW_RESTRICT)||LA59_22==KW_REWRITE||(LA59_22 >= KW_RLIKE && LA59_22 <= KW_ROLES)||(LA59_22 >= KW_SCHEMA && LA59_22 <= KW_SECOND)||(LA59_22 >= KW_SEMI && LA59_22 <= KW_SERVER)||(LA59_22 >= KW_SETS && LA59_22 <= KW_SKEWED)||(LA59_22 >= KW_SORT && LA59_22 <= KW_STRUCT)||LA59_22==KW_TABLES||(LA59_22 >= KW_TBLPROPERTIES && LA59_22 <= KW_TERMINATED)||LA59_22==KW_TINYINT||(LA59_22 >= KW_TOUCH && LA59_22 <= KW_TRANSACTIONS)||LA59_22==KW_UNARCHIVE||LA59_22==KW_UNDO||LA59_22==KW_UNIONTYPE||(LA59_22 >= KW_UNLOCK && LA59_22 <= KW_UNSIGNED)||(LA59_22 >= KW_URI && LA59_22 <= KW_USE)||(LA59_22 >= KW_UTC && LA59_22 <= KW_UTCTIMESTAMP)||LA59_22==KW_VALUE_TYPE||LA59_22==KW_VIEW||LA59_22==KW_WHILE||LA59_22==KW_YEAR) && (synpred3_HiveParser())) {
                        alt59=1;
                    }
                    else if ( (LA59_22==KW_PARTITION) ) {
                        int LA59_40 = input.LA(4);

                        if ( (synpred3_HiveParser()) ) {
                            alt59=1;
                        }
                        else if ( (true) ) {
                            alt59=11;
                        }
                        else {
                            if (state.backtracking>0) {state.failed=true; return retval;}
                            NoViableAltException nvae =
                                new NoViableAltException("", 59, 40, input);

                            throw nvae;

                        }
                    }
                    else if ( ((LA59_22 >= KW_ALL && LA59_22 <= KW_ALTER)||(LA59_22 >= KW_ARRAY && LA59_22 <= KW_AS)||LA59_22==KW_AUTHORIZATION||(LA59_22 >= KW_BETWEEN && LA59_22 <= KW_BOTH)||LA59_22==KW_BY||LA59_22==KW_CREATE||LA59_22==KW_CUBE||(LA59_22 >= KW_CURRENT_DATE && LA59_22 <= KW_CURSOR)||LA59_22==KW_DATE||LA59_22==KW_DECIMAL||LA59_22==KW_DELETE||LA59_22==KW_DESCRIBE||(LA59_22 >= KW_DOUBLE && LA59_22 <= KW_DROP)||LA59_22==KW_EXISTS||(LA59_22 >= KW_EXTERNAL && LA59_22 <= KW_FETCH)||LA59_22==KW_FLOAT||LA59_22==KW_FOR||LA59_22==KW_FULL||(LA59_22 >= KW_GRANT && LA59_22 <= KW_GROUPING)||(LA59_22 >= KW_IMPORT && LA59_22 <= KW_IN)||LA59_22==KW_INNER||(LA59_22 >= KW_INSERT && LA59_22 <= KW_INTERSECT)||(LA59_22 >= KW_INTO && LA59_22 <= KW_IS)||(LA59_22 >= KW_LATERAL && LA59_22 <= KW_LEFT)||LA59_22==KW_LIKE||LA59_22==KW_LOCAL||LA59_22==KW_NONE||(LA59_22 >= KW_NULL && LA59_22 <= KW_OF)||(LA59_22 >= KW_ORDER && LA59_22 <= KW_OUTER)||LA59_22==KW_PERCENT||LA59_22==KW_PROCEDURE||LA59_22==KW_RANGE||LA59_22==KW_READS||LA59_22==KW_REVOKE||LA59_22==KW_RIGHT||(LA59_22 >= KW_ROLLUP && LA59_22 <= KW_ROWS)||LA59_22==KW_SET||LA59_22==KW_SMALLINT||LA59_22==KW_TABLE||LA59_22==KW_TIMESTAMP||LA59_22==KW_TO||(LA59_22 >= KW_TRIGGER && LA59_22 <= KW_TRUNCATE)||LA59_22==KW_UNION||LA59_22==KW_UPDATE||(LA59_22 >= KW_USER && LA59_22 <= KW_USING)||LA59_22==KW_VALUES||LA59_22==KW_WITH) && (synpred3_HiveParser())) {
                        alt59=1;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 59, 22, input);

                        throw nvae;

                    }
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 59, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_DROP:
                {
                alt59=2;
                }
                break;
            case KW_ADD:
                {
                switch ( input.LA(2) ) {
                case KW_IF:
                case KW_PARTITION:
                    {
                    alt59=3;
                    }
                    break;
                case KW_COLUMNS:
                    {
                    alt59=11;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 59, 3, input);

                    throw nvae;

                }

                }
                break;
            case KW_TOUCH:
                {
                alt59=4;
                }
                break;
            case KW_ARCHIVE:
                {
                alt59=5;
                }
                break;
            case KW_UNARCHIVE:
                {
                alt59=6;
                }
                break;
            case KW_SET:
                {
                switch ( input.LA(2) ) {
                case KW_TBLPROPERTIES:
                    {
                    alt59=7;
                    }
                    break;
                case KW_FILEFORMAT:
                case KW_LOCATION:
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                case KW_SKEWED:
                    {
                    alt59=11;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 59, 7, input);

                    throw nvae;

                }

                }
                break;
            case KW_UNSET:
                {
                alt59=7;
                }
                break;
            case KW_SKEWED:
                {
                alt59=8;
                }
                break;
            case KW_NOT:
                {
                switch ( input.LA(2) ) {
                case KW_SKEWED:
                case KW_STORED:
                    {
                    alt59=8;
                    }
                    break;
                case KW_CLUSTERED:
                case KW_SORTED:
                    {
                    alt59=11;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 59, 10, input);

                    throw nvae;

                }

                }
                break;
            case KW_EXCHANGE:
                {
                alt59=9;
                }
                break;
            case KW_PARTITION:
                {
                switch ( input.LA(2) ) {
                case KW_COLUMN:
                    {
                    alt59=10;
                    }
                    break;
                case LPAREN:
                    {
                    alt59=11;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 59, 12, input);

                    throw nvae;

                }

                }
                break;
            case KW_CHANGE:
            case KW_CLUSTERED:
            case KW_COMPACT:
            case KW_CONCATENATE:
            case KW_DISABLE:
            case KW_ENABLE:
            case KW_INTO:
            case KW_REPLACE:
            case KW_UPDATE:
                {
                alt59=11;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 59, 0, input);

                throw nvae;

            }

            switch (alt59) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1007:7: ( alterStatementSuffixRename[true] )=> alterStatementSuffixRename[true]
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixRename_in_alterTableStatementSuffix3859);
                    alterStatementSuffixRename191=alterStatementSuffixRename(true);

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixRename191.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1008:7: alterStatementSuffixDropPartitions[true]
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixDropPartitions_in_alterTableStatementSuffix3868);
                    alterStatementSuffixDropPartitions192=alterStatementSuffixDropPartitions(true);

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixDropPartitions192.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1009:7: alterStatementSuffixAddPartitions[true]
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixAddPartitions_in_alterTableStatementSuffix3877);
                    alterStatementSuffixAddPartitions193=alterStatementSuffixAddPartitions(true);

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixAddPartitions193.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1010:7: alterStatementSuffixTouch
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixTouch_in_alterTableStatementSuffix3886);
                    alterStatementSuffixTouch194=alterStatementSuffixTouch();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixTouch194.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1011:7: alterStatementSuffixArchive
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixArchive_in_alterTableStatementSuffix3894);
                    alterStatementSuffixArchive195=alterStatementSuffixArchive();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixArchive195.getTree());

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1012:7: alterStatementSuffixUnArchive
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixUnArchive_in_alterTableStatementSuffix3902);
                    alterStatementSuffixUnArchive196=alterStatementSuffixUnArchive();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixUnArchive196.getTree());

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1013:7: alterStatementSuffixProperties
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixProperties_in_alterTableStatementSuffix3910);
                    alterStatementSuffixProperties197=alterStatementSuffixProperties();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixProperties197.getTree());

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1014:7: alterStatementSuffixSkewedby
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixSkewedby_in_alterTableStatementSuffix3918);
                    alterStatementSuffixSkewedby198=alterStatementSuffixSkewedby();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixSkewedby198.getTree());

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1015:7: alterStatementSuffixExchangePartition
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixExchangePartition_in_alterTableStatementSuffix3926);
                    alterStatementSuffixExchangePartition199=alterStatementSuffixExchangePartition();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixExchangePartition199.getTree());

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1016:7: alterStatementPartitionKeyType
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementPartitionKeyType_in_alterTableStatementSuffix3934);
                    alterStatementPartitionKeyType200=alterStatementPartitionKeyType();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementPartitionKeyType200.getTree());

                    }
                    break;
                case 11 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1017:7: ( partitionSpec )? alterTblPartitionStatementSuffix
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1017:7: ( partitionSpec )?
                    int alt58=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITION:
                            {
                            alt58=1;
                            }
                            break;
                    }

                    switch (alt58) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1017:7: partitionSpec
                            {
                            pushFollow(FOLLOW_partitionSpec_in_alterTableStatementSuffix3942);
                            partitionSpec201=partitionSpec();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_partitionSpec.add(partitionSpec201.getTree());

                            }
                            break;

                    }


                    pushFollow(FOLLOW_alterTblPartitionStatementSuffix_in_alterTableStatementSuffix3945);
                    alterTblPartitionStatementSuffix202=alterTblPartitionStatementSuffix();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_alterTblPartitionStatementSuffix.add(alterTblPartitionStatementSuffix202.getTree());

                    // AST REWRITE
                    // elements: alterTblPartitionStatementSuffix, partitionSpec
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1017:55: -> alterTblPartitionStatementSuffix ( partitionSpec )?
                    {
                        adaptor.addChild(root_0, stream_alterTblPartitionStatementSuffix.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1017:91: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_0, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterTableStatementSuffix"


    public static class alterTblPartitionStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterTblPartitionStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1020:1: alterTblPartitionStatementSuffix : ( alterStatementSuffixFileFormat | alterStatementSuffixLocation | alterStatementSuffixProtectMode | alterStatementSuffixMergeFiles | alterStatementSuffixSerdeProperties | alterStatementSuffixRenamePart | alterStatementSuffixBucketNum | alterTblPartitionStatementSuffixSkewedLocation | alterStatementSuffixClusterbySortby | alterStatementSuffixCompact | alterStatementSuffixUpdateStatsCol | alterStatementSuffixRenameCol | alterStatementSuffixAddCol );
    public final HiveParser.alterTblPartitionStatementSuffix_return alterTblPartitionStatementSuffix() throws RecognitionException {
        HiveParser.alterTblPartitionStatementSuffix_return retval = new HiveParser.alterTblPartitionStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterStatementSuffixFileFormat_return alterStatementSuffixFileFormat203 =null;

        HiveParser.alterStatementSuffixLocation_return alterStatementSuffixLocation204 =null;

        HiveParser.alterStatementSuffixProtectMode_return alterStatementSuffixProtectMode205 =null;

        HiveParser.alterStatementSuffixMergeFiles_return alterStatementSuffixMergeFiles206 =null;

        HiveParser.alterStatementSuffixSerdeProperties_return alterStatementSuffixSerdeProperties207 =null;

        HiveParser.alterStatementSuffixRenamePart_return alterStatementSuffixRenamePart208 =null;

        HiveParser.alterStatementSuffixBucketNum_return alterStatementSuffixBucketNum209 =null;

        HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return alterTblPartitionStatementSuffixSkewedLocation210 =null;

        HiveParser.alterStatementSuffixClusterbySortby_return alterStatementSuffixClusterbySortby211 =null;

        HiveParser.alterStatementSuffixCompact_return alterStatementSuffixCompact212 =null;

        HiveParser.alterStatementSuffixUpdateStatsCol_return alterStatementSuffixUpdateStatsCol213 =null;

        HiveParser.alterStatementSuffixRenameCol_return alterStatementSuffixRenameCol214 =null;

        HiveParser.alterStatementSuffixAddCol_return alterStatementSuffixAddCol215 =null;



        pushMsg("alter table partition statement suffix", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1023:3: ( alterStatementSuffixFileFormat | alterStatementSuffixLocation | alterStatementSuffixProtectMode | alterStatementSuffixMergeFiles | alterStatementSuffixSerdeProperties | alterStatementSuffixRenamePart | alterStatementSuffixBucketNum | alterTblPartitionStatementSuffixSkewedLocation | alterStatementSuffixClusterbySortby | alterStatementSuffixCompact | alterStatementSuffixUpdateStatsCol | alterStatementSuffixRenameCol | alterStatementSuffixAddCol )
            int alt60=13;
            switch ( input.LA(1) ) {
            case KW_SET:
                {
                switch ( input.LA(2) ) {
                case KW_FILEFORMAT:
                    {
                    alt60=1;
                    }
                    break;
                case KW_LOCATION:
                    {
                    alt60=2;
                    }
                    break;
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                    {
                    alt60=5;
                    }
                    break;
                case KW_SKEWED:
                    {
                    alt60=8;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 60, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_DISABLE:
            case KW_ENABLE:
                {
                alt60=3;
                }
                break;
            case KW_CONCATENATE:
                {
                alt60=4;
                }
                break;
            case KW_RENAME:
                {
                alt60=6;
                }
                break;
            case KW_INTO:
                {
                alt60=7;
                }
                break;
            case KW_CLUSTERED:
            case KW_NOT:
                {
                alt60=9;
                }
                break;
            case KW_COMPACT:
                {
                alt60=10;
                }
                break;
            case KW_UPDATE:
                {
                alt60=11;
                }
                break;
            case KW_CHANGE:
                {
                alt60=12;
                }
                break;
            case KW_ADD:
            case KW_REPLACE:
                {
                alt60=13;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 60, 0, input);

                throw nvae;

            }

            switch (alt60) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1023:5: alterStatementSuffixFileFormat
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixFileFormat_in_alterTblPartitionStatementSuffix3977);
                    alterStatementSuffixFileFormat203=alterStatementSuffixFileFormat();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixFileFormat203.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1024:5: alterStatementSuffixLocation
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixLocation_in_alterTblPartitionStatementSuffix3983);
                    alterStatementSuffixLocation204=alterStatementSuffixLocation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixLocation204.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1025:5: alterStatementSuffixProtectMode
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixProtectMode_in_alterTblPartitionStatementSuffix3989);
                    alterStatementSuffixProtectMode205=alterStatementSuffixProtectMode();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixProtectMode205.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1026:5: alterStatementSuffixMergeFiles
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixMergeFiles_in_alterTblPartitionStatementSuffix3995);
                    alterStatementSuffixMergeFiles206=alterStatementSuffixMergeFiles();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixMergeFiles206.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1027:5: alterStatementSuffixSerdeProperties
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixSerdeProperties_in_alterTblPartitionStatementSuffix4001);
                    alterStatementSuffixSerdeProperties207=alterStatementSuffixSerdeProperties();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixSerdeProperties207.getTree());

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1028:5: alterStatementSuffixRenamePart
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixRenamePart_in_alterTblPartitionStatementSuffix4007);
                    alterStatementSuffixRenamePart208=alterStatementSuffixRenamePart();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixRenamePart208.getTree());

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1029:5: alterStatementSuffixBucketNum
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixBucketNum_in_alterTblPartitionStatementSuffix4013);
                    alterStatementSuffixBucketNum209=alterStatementSuffixBucketNum();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixBucketNum209.getTree());

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1030:5: alterTblPartitionStatementSuffixSkewedLocation
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterTblPartitionStatementSuffixSkewedLocation_in_alterTblPartitionStatementSuffix4019);
                    alterTblPartitionStatementSuffixSkewedLocation210=alterTblPartitionStatementSuffixSkewedLocation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterTblPartitionStatementSuffixSkewedLocation210.getTree());

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1031:5: alterStatementSuffixClusterbySortby
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixClusterbySortby_in_alterTblPartitionStatementSuffix4025);
                    alterStatementSuffixClusterbySortby211=alterStatementSuffixClusterbySortby();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixClusterbySortby211.getTree());

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1032:5: alterStatementSuffixCompact
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixCompact_in_alterTblPartitionStatementSuffix4031);
                    alterStatementSuffixCompact212=alterStatementSuffixCompact();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixCompact212.getTree());

                    }
                    break;
                case 11 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1033:5: alterStatementSuffixUpdateStatsCol
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixUpdateStatsCol_in_alterTblPartitionStatementSuffix4037);
                    alterStatementSuffixUpdateStatsCol213=alterStatementSuffixUpdateStatsCol();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixUpdateStatsCol213.getTree());

                    }
                    break;
                case 12 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1034:5: alterStatementSuffixRenameCol
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixRenameCol_in_alterTblPartitionStatementSuffix4043);
                    alterStatementSuffixRenameCol214=alterStatementSuffixRenameCol();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixRenameCol214.getTree());

                    }
                    break;
                case 13 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1035:5: alterStatementSuffixAddCol
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixAddCol_in_alterTblPartitionStatementSuffix4049);
                    alterStatementSuffixAddCol215=alterStatementSuffixAddCol();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixAddCol215.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterTblPartitionStatementSuffix"


    public static class alterStatementPartitionKeyType_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementPartitionKeyType"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1038:1: alterStatementPartitionKeyType : KW_PARTITION KW_COLUMN LPAREN columnNameType RPAREN -> ^( TOK_ALTERTABLE_PARTCOLTYPE columnNameType ) ;
    public final HiveParser.alterStatementPartitionKeyType_return alterStatementPartitionKeyType() throws RecognitionException {
        HiveParser.alterStatementPartitionKeyType_return retval = new HiveParser.alterStatementPartitionKeyType_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_PARTITION216=null;
        Token KW_COLUMN217=null;
        Token LPAREN218=null;
        Token RPAREN220=null;
        HiveParser.columnNameType_return columnNameType219 =null;


        CommonTree KW_PARTITION216_tree=null;
        CommonTree KW_COLUMN217_tree=null;
        CommonTree LPAREN218_tree=null;
        CommonTree RPAREN220_tree=null;
        RewriteRuleTokenStream stream_KW_PARTITION=new RewriteRuleTokenStream(adaptor,"token KW_PARTITION");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_COLUMN=new RewriteRuleTokenStream(adaptor,"token KW_COLUMN");
        RewriteRuleSubtreeStream stream_columnNameType=new RewriteRuleSubtreeStream(adaptor,"rule columnNameType");
        msgs.push("alter partition key type"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1041:2: ( KW_PARTITION KW_COLUMN LPAREN columnNameType RPAREN -> ^( TOK_ALTERTABLE_PARTCOLTYPE columnNameType ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1041:4: KW_PARTITION KW_COLUMN LPAREN columnNameType RPAREN
            {
            KW_PARTITION216=(Token)match(input,KW_PARTITION,FOLLOW_KW_PARTITION_in_alterStatementPartitionKeyType4071); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_PARTITION.add(KW_PARTITION216);


            KW_COLUMN217=(Token)match(input,KW_COLUMN,FOLLOW_KW_COLUMN_in_alterStatementPartitionKeyType4073); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_COLUMN.add(KW_COLUMN217);


            LPAREN218=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_alterStatementPartitionKeyType4075); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LPAREN.add(LPAREN218);


            pushFollow(FOLLOW_columnNameType_in_alterStatementPartitionKeyType4077);
            columnNameType219=columnNameType();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_columnNameType.add(columnNameType219.getTree());

            RPAREN220=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_alterStatementPartitionKeyType4079); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RPAREN.add(RPAREN220);


            // AST REWRITE
            // elements: columnNameType
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1042:2: -> ^( TOK_ALTERTABLE_PARTCOLTYPE columnNameType )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1042:5: ^( TOK_ALTERTABLE_PARTCOLTYPE columnNameType )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_PARTCOLTYPE, "TOK_ALTERTABLE_PARTCOLTYPE")
                , root_1);

                adaptor.addChild(root_1, stream_columnNameType.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {msgs.pop();}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementPartitionKeyType"


    public static class alterViewStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterViewStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1045:1: alterViewStatementSuffix : ( alterViewSuffixProperties | alterStatementSuffixRename[false] | alterStatementSuffixAddPartitions[false] | alterStatementSuffixDropPartitions[false] | selectStatementWithCTE );
    public final HiveParser.alterViewStatementSuffix_return alterViewStatementSuffix() throws RecognitionException {
        HiveParser.alterViewStatementSuffix_return retval = new HiveParser.alterViewStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterViewSuffixProperties_return alterViewSuffixProperties221 =null;

        HiveParser.alterStatementSuffixRename_return alterStatementSuffixRename222 =null;

        HiveParser.alterStatementSuffixAddPartitions_return alterStatementSuffixAddPartitions223 =null;

        HiveParser.alterStatementSuffixDropPartitions_return alterStatementSuffixDropPartitions224 =null;

        HiveParser.selectStatementWithCTE_return selectStatementWithCTE225 =null;



         pushMsg("alter view statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1048:5: ( alterViewSuffixProperties | alterStatementSuffixRename[false] | alterStatementSuffixAddPartitions[false] | alterStatementSuffixDropPartitions[false] | selectStatementWithCTE )
            int alt61=5;
            switch ( input.LA(1) ) {
            case KW_SET:
            case KW_UNSET:
                {
                alt61=1;
                }
                break;
            case KW_RENAME:
                {
                alt61=2;
                }
                break;
            case KW_ADD:
                {
                alt61=3;
                }
                break;
            case KW_DROP:
                {
                alt61=4;
                }
                break;
            case KW_MAP:
            case KW_REDUCE:
            case KW_SELECT:
            case KW_WITH:
                {
                alt61=5;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 61, 0, input);

                throw nvae;

            }

            switch (alt61) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1048:7: alterViewSuffixProperties
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterViewSuffixProperties_in_alterViewStatementSuffix4112);
                    alterViewSuffixProperties221=alterViewSuffixProperties();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterViewSuffixProperties221.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1049:7: alterStatementSuffixRename[false]
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixRename_in_alterViewStatementSuffix4120);
                    alterStatementSuffixRename222=alterStatementSuffixRename(false);

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixRename222.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1050:7: alterStatementSuffixAddPartitions[false]
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixAddPartitions_in_alterViewStatementSuffix4129);
                    alterStatementSuffixAddPartitions223=alterStatementSuffixAddPartitions(false);

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixAddPartitions223.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1051:7: alterStatementSuffixDropPartitions[false]
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixDropPartitions_in_alterViewStatementSuffix4138);
                    alterStatementSuffixDropPartitions224=alterStatementSuffixDropPartitions(false);

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterStatementSuffixDropPartitions224.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1052:7: selectStatementWithCTE
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_selectStatementWithCTE_in_alterViewStatementSuffix4147);
                    selectStatementWithCTE225=selectStatementWithCTE();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, selectStatementWithCTE225.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterViewStatementSuffix"


    public static class alterIndexStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterIndexStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1055:1: alterIndexStatementSuffix : indexName= identifier KW_ON tableName ( partitionSpec )? ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD tableName $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES tableName $indexName indexProperties ) ) ;
    public final HiveParser.alterIndexStatementSuffix_return alterIndexStatementSuffix() throws RecognitionException {
        HiveParser.alterIndexStatementSuffix_return retval = new HiveParser.alterIndexStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ON226=null;
        Token KW_REBUILD229=null;
        Token KW_SET230=null;
        Token KW_IDXPROPERTIES231=null;
        HiveParser_IdentifiersParser.identifier_return indexName =null;

        HiveParser_FromClauseParser.tableName_return tableName227 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec228 =null;

        HiveParser.indexProperties_return indexProperties232 =null;


        CommonTree KW_ON226_tree=null;
        CommonTree KW_REBUILD229_tree=null;
        CommonTree KW_SET230_tree=null;
        CommonTree KW_IDXPROPERTIES231_tree=null;
        RewriteRuleTokenStream stream_KW_IDXPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_IDXPROPERTIES");
        RewriteRuleTokenStream stream_KW_REBUILD=new RewriteRuleTokenStream(adaptor,"token KW_REBUILD");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_indexProperties=new RewriteRuleSubtreeStream(adaptor,"rule indexProperties");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
         pushMsg("alter index statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1058:5: (indexName= identifier KW_ON tableName ( partitionSpec )? ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD tableName $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES tableName $indexName indexProperties ) ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1058:7: indexName= identifier KW_ON tableName ( partitionSpec )? ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD tableName $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES tableName $indexName indexProperties ) )
            {
            pushFollow(FOLLOW_identifier_in_alterIndexStatementSuffix4176);
            indexName=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(indexName.getTree());

            KW_ON226=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_alterIndexStatementSuffix4178); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_ON.add(KW_ON226);


            pushFollow(FOLLOW_tableName_in_alterIndexStatementSuffix4180);
            tableName227=tableName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableName.add(tableName227.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1058:44: ( partitionSpec )?
            int alt62=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt62=1;
                    }
                    break;
            }

            switch (alt62) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1058:44: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_alterIndexStatementSuffix4182);
                    partitionSpec228=partitionSpec();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_partitionSpec.add(partitionSpec228.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1059:5: ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD tableName $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES tableName $indexName indexProperties ) )
            int alt63=2;
            switch ( input.LA(1) ) {
            case KW_REBUILD:
                {
                alt63=1;
                }
                break;
            case KW_SET:
                {
                alt63=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 63, 0, input);

                throw nvae;

            }

            switch (alt63) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1060:7: KW_REBUILD
                    {
                    KW_REBUILD229=(Token)match(input,KW_REBUILD,FOLLOW_KW_REBUILD_in_alterIndexStatementSuffix4197); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_REBUILD.add(KW_REBUILD229);


                    // AST REWRITE
                    // elements: tableName, partitionSpec, indexName
                    // token labels: 
                    // rule labels: indexName, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1061:7: -> ^( TOK_ALTERINDEX_REBUILD tableName $indexName ( partitionSpec )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1061:9: ^( TOK_ALTERINDEX_REBUILD tableName $indexName ( partitionSpec )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERINDEX_REBUILD, "TOK_ALTERINDEX_REBUILD")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableName.nextTree());

                        adaptor.addChild(root_1, stream_indexName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1061:55: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1063:7: KW_SET KW_IDXPROPERTIES indexProperties
                    {
                    KW_SET230=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterIndexStatementSuffix4230); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SET.add(KW_SET230);


                    KW_IDXPROPERTIES231=(Token)match(input,KW_IDXPROPERTIES,FOLLOW_KW_IDXPROPERTIES_in_alterIndexStatementSuffix4232); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_IDXPROPERTIES.add(KW_IDXPROPERTIES231);


                    pushFollow(FOLLOW_indexProperties_in_alterIndexStatementSuffix4240);
                    indexProperties232=indexProperties();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_indexProperties.add(indexProperties232.getTree());

                    // AST REWRITE
                    // elements: indexProperties, indexName, tableName
                    // token labels: 
                    // rule labels: indexName, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1065:7: -> ^( TOK_ALTERINDEX_PROPERTIES tableName $indexName indexProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1065:9: ^( TOK_ALTERINDEX_PROPERTIES tableName $indexName indexProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERINDEX_PROPERTIES, "TOK_ALTERINDEX_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableName.nextTree());

                        adaptor.addChild(root_1, stream_indexName.nextTree());

                        adaptor.addChild(root_1, stream_indexProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterIndexStatementSuffix"


    public static class alterDatabaseStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterDatabaseStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1069:1: alterDatabaseStatementSuffix : ( alterDatabaseSuffixProperties | alterDatabaseSuffixSetOwner );
    public final HiveParser.alterDatabaseStatementSuffix_return alterDatabaseStatementSuffix() throws RecognitionException {
        HiveParser.alterDatabaseStatementSuffix_return retval = new HiveParser.alterDatabaseStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterDatabaseSuffixProperties_return alterDatabaseSuffixProperties233 =null;

        HiveParser.alterDatabaseSuffixSetOwner_return alterDatabaseSuffixSetOwner234 =null;



         pushMsg("alter database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1072:5: ( alterDatabaseSuffixProperties | alterDatabaseSuffixSetOwner )
            int alt64=2;
            switch ( input.LA(1) ) {
            case Identifier:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                    {
                    switch ( input.LA(3) ) {
                    case KW_DBPROPERTIES:
                        {
                        alt64=1;
                        }
                        break;
                    case KW_OWNER:
                        {
                        alt64=2;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 64, 4, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 64, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATETIME:
            case KW_DAY:
            case KW_DBPROPERTIES:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_FIELDS:
            case KW_FILE:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FUNCTIONS:
            case KW_HOLD_DDLTIME:
            case KW_HOUR:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_ITEMS:
            case KW_JAR:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_METADATA:
            case KW_MINUS:
            case KW_MINUTE:
            case KW_MONTH:
            case KW_MSCK:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_OWNER:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PRINCIPALS:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_READ:
            case KW_READONLY:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RELOAD:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_REPLICATION:
            case KW_RESTRICT:
            case KW_REWRITE:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SECOND:
            case KW_SEMI:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SERVER:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TINYINT:
            case KW_TOUCH:
            case KW_TRANSACTIONS:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_URI:
            case KW_USE:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_YEAR:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                    {
                    switch ( input.LA(3) ) {
                    case KW_DBPROPERTIES:
                        {
                        alt64=1;
                        }
                        break;
                    case KW_OWNER:
                        {
                        alt64=2;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 64, 5, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 64, 2, input);

                    throw nvae;

                }

                }
                break;
            case KW_ALL:
            case KW_ALTER:
            case KW_ARRAY:
            case KW_AS:
            case KW_AUTHORIZATION:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BY:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURRENT_DATE:
            case KW_CURRENT_TIMESTAMP:
            case KW_CURSOR:
            case KW_DATE:
            case KW_DECIMAL:
            case KW_DELETE:
            case KW_DESCRIBE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_EXISTS:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FULL:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_IMPORT:
            case KW_IN:
            case KW_INNER:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LOCAL:
            case KW_NONE:
            case KW_NULL:
            case KW_OF:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_PARTITION:
            case KW_PERCENT:
            case KW_PROCEDURE:
            case KW_RANGE:
            case KW_READS:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SET:
            case KW_SMALLINT:
            case KW_TABLE:
            case KW_TIMESTAMP:
            case KW_TO:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNION:
            case KW_UPDATE:
            case KW_USER:
            case KW_USING:
            case KW_VALUES:
            case KW_WITH:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                    {
                    switch ( input.LA(3) ) {
                    case KW_DBPROPERTIES:
                        {
                        alt64=1;
                        }
                        break;
                    case KW_OWNER:
                        {
                        alt64=2;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 64, 6, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 64, 3, input);

                    throw nvae;

                }

                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 64, 0, input);

                throw nvae;

            }

            switch (alt64) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1072:7: alterDatabaseSuffixProperties
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterDatabaseSuffixProperties_in_alterDatabaseStatementSuffix4291);
                    alterDatabaseSuffixProperties233=alterDatabaseSuffixProperties();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterDatabaseSuffixProperties233.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1073:7: alterDatabaseSuffixSetOwner
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterDatabaseSuffixSetOwner_in_alterDatabaseStatementSuffix4299);
                    alterDatabaseSuffixSetOwner234=alterDatabaseSuffixSetOwner();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, alterDatabaseSuffixSetOwner234.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterDatabaseStatementSuffix"


    public static class alterDatabaseSuffixProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterDatabaseSuffixProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1076:1: alterDatabaseSuffixProperties : name= identifier KW_SET KW_DBPROPERTIES dbProperties -> ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties ) ;
    public final HiveParser.alterDatabaseSuffixProperties_return alterDatabaseSuffixProperties() throws RecognitionException {
        HiveParser.alterDatabaseSuffixProperties_return retval = new HiveParser.alterDatabaseSuffixProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET235=null;
        Token KW_DBPROPERTIES236=null;
        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser.dbProperties_return dbProperties237 =null;


        CommonTree KW_SET235_tree=null;
        CommonTree KW_DBPROPERTIES236_tree=null;
        RewriteRuleTokenStream stream_KW_DBPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_DBPROPERTIES");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_dbProperties=new RewriteRuleSubtreeStream(adaptor,"rule dbProperties");
         pushMsg("alter database properties statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1079:5: (name= identifier KW_SET KW_DBPROPERTIES dbProperties -> ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1079:7: name= identifier KW_SET KW_DBPROPERTIES dbProperties
            {
            pushFollow(FOLLOW_identifier_in_alterDatabaseSuffixProperties4328);
            name=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(name.getTree());

            KW_SET235=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterDatabaseSuffixProperties4330); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_SET.add(KW_SET235);


            KW_DBPROPERTIES236=(Token)match(input,KW_DBPROPERTIES,FOLLOW_KW_DBPROPERTIES_in_alterDatabaseSuffixProperties4332); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_DBPROPERTIES.add(KW_DBPROPERTIES236);


            pushFollow(FOLLOW_dbProperties_in_alterDatabaseSuffixProperties4334);
            dbProperties237=dbProperties();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_dbProperties.add(dbProperties237.getTree());

            // AST REWRITE
            // elements: name, dbProperties
            // token labels: 
            // rule labels: name, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1080:5: -> ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1080:8: ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERDATABASE_PROPERTIES, "TOK_ALTERDATABASE_PROPERTIES")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                adaptor.addChild(root_1, stream_dbProperties.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterDatabaseSuffixProperties"


    public static class alterDatabaseSuffixSetOwner_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterDatabaseSuffixSetOwner"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1083:1: alterDatabaseSuffixSetOwner : dbName= identifier KW_SET KW_OWNER principalName -> ^( TOK_ALTERDATABASE_OWNER $dbName principalName ) ;
    public final HiveParser.alterDatabaseSuffixSetOwner_return alterDatabaseSuffixSetOwner() throws RecognitionException {
        HiveParser.alterDatabaseSuffixSetOwner_return retval = new HiveParser.alterDatabaseSuffixSetOwner_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET238=null;
        Token KW_OWNER239=null;
        HiveParser_IdentifiersParser.identifier_return dbName =null;

        HiveParser.principalName_return principalName240 =null;


        CommonTree KW_SET238_tree=null;
        CommonTree KW_OWNER239_tree=null;
        RewriteRuleTokenStream stream_KW_OWNER=new RewriteRuleTokenStream(adaptor,"token KW_OWNER");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_principalName=new RewriteRuleSubtreeStream(adaptor,"rule principalName");
         pushMsg("alter database set owner", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1086:5: (dbName= identifier KW_SET KW_OWNER principalName -> ^( TOK_ALTERDATABASE_OWNER $dbName principalName ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1086:7: dbName= identifier KW_SET KW_OWNER principalName
            {
            pushFollow(FOLLOW_identifier_in_alterDatabaseSuffixSetOwner4378);
            dbName=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(dbName.getTree());

            KW_SET238=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterDatabaseSuffixSetOwner4380); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_SET.add(KW_SET238);


            KW_OWNER239=(Token)match(input,KW_OWNER,FOLLOW_KW_OWNER_in_alterDatabaseSuffixSetOwner4382); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_OWNER.add(KW_OWNER239);


            pushFollow(FOLLOW_principalName_in_alterDatabaseSuffixSetOwner4384);
            principalName240=principalName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_principalName.add(principalName240.getTree());

            // AST REWRITE
            // elements: dbName, principalName
            // token labels: 
            // rule labels: dbName, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_dbName=new RewriteRuleSubtreeStream(adaptor,"rule dbName",dbName!=null?dbName.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1087:5: -> ^( TOK_ALTERDATABASE_OWNER $dbName principalName )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1087:8: ^( TOK_ALTERDATABASE_OWNER $dbName principalName )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERDATABASE_OWNER, "TOK_ALTERDATABASE_OWNER")
                , root_1);

                adaptor.addChild(root_1, stream_dbName.nextTree());

                adaptor.addChild(root_1, stream_principalName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterDatabaseSuffixSetOwner"


    public static class alterStatementSuffixRename_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixRename"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1090:1: alterStatementSuffixRename[boolean table] : KW_RENAME KW_TO tableName -> { table }? ^( TOK_ALTERTABLE_RENAME tableName ) -> ^( TOK_ALTERVIEW_RENAME tableName ) ;
    public final HiveParser.alterStatementSuffixRename_return alterStatementSuffixRename(boolean table) throws RecognitionException {
        HiveParser.alterStatementSuffixRename_return retval = new HiveParser.alterStatementSuffixRename_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_RENAME241=null;
        Token KW_TO242=null;
        HiveParser_FromClauseParser.tableName_return tableName243 =null;


        CommonTree KW_RENAME241_tree=null;
        CommonTree KW_TO242_tree=null;
        RewriteRuleTokenStream stream_KW_RENAME=new RewriteRuleTokenStream(adaptor,"token KW_RENAME");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
         pushMsg("rename statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1093:5: ( KW_RENAME KW_TO tableName -> { table }? ^( TOK_ALTERTABLE_RENAME tableName ) -> ^( TOK_ALTERVIEW_RENAME tableName ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1093:7: KW_RENAME KW_TO tableName
            {
            KW_RENAME241=(Token)match(input,KW_RENAME,FOLLOW_KW_RENAME_in_alterStatementSuffixRename4427); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_RENAME.add(KW_RENAME241);


            KW_TO242=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_alterStatementSuffixRename4429); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TO.add(KW_TO242);


            pushFollow(FOLLOW_tableName_in_alterStatementSuffixRename4431);
            tableName243=tableName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableName.add(tableName243.getTree());

            // AST REWRITE
            // elements: tableName, tableName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1094:5: -> { table }? ^( TOK_ALTERTABLE_RENAME tableName )
            if ( table ) {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1094:19: ^( TOK_ALTERTABLE_RENAME tableName )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_RENAME, "TOK_ALTERTABLE_RENAME")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            else // 1095:5: -> ^( TOK_ALTERVIEW_RENAME tableName )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1095:19: ^( TOK_ALTERVIEW_RENAME tableName )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERVIEW_RENAME, "TOK_ALTERVIEW_RENAME")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixRename"


    public static class alterStatementSuffixAddCol_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixAddCol"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1098:1: alterStatementSuffixAddCol : (add= KW_ADD |replace= KW_REPLACE ) KW_COLUMNS LPAREN columnNameTypeList RPAREN ( restrictOrCascade )? -> {$add != null}? ^( TOK_ALTERTABLE_ADDCOLS columnNameTypeList ( restrictOrCascade )? ) -> ^( TOK_ALTERTABLE_REPLACECOLS columnNameTypeList ( restrictOrCascade )? ) ;
    public final HiveParser.alterStatementSuffixAddCol_return alterStatementSuffixAddCol() throws RecognitionException {
        HiveParser.alterStatementSuffixAddCol_return retval = new HiveParser.alterStatementSuffixAddCol_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token add=null;
        Token replace=null;
        Token KW_COLUMNS244=null;
        Token LPAREN245=null;
        Token RPAREN247=null;
        HiveParser.columnNameTypeList_return columnNameTypeList246 =null;

        HiveParser.restrictOrCascade_return restrictOrCascade248 =null;


        CommonTree add_tree=null;
        CommonTree replace_tree=null;
        CommonTree KW_COLUMNS244_tree=null;
        CommonTree LPAREN245_tree=null;
        CommonTree RPAREN247_tree=null;
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_REPLACE=new RewriteRuleTokenStream(adaptor,"token KW_REPLACE");
        RewriteRuleTokenStream stream_KW_ADD=new RewriteRuleTokenStream(adaptor,"token KW_ADD");
        RewriteRuleSubtreeStream stream_columnNameTypeList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameTypeList");
        RewriteRuleSubtreeStream stream_restrictOrCascade=new RewriteRuleSubtreeStream(adaptor,"rule restrictOrCascade");
         pushMsg("add column statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1101:5: ( (add= KW_ADD |replace= KW_REPLACE ) KW_COLUMNS LPAREN columnNameTypeList RPAREN ( restrictOrCascade )? -> {$add != null}? ^( TOK_ALTERTABLE_ADDCOLS columnNameTypeList ( restrictOrCascade )? ) -> ^( TOK_ALTERTABLE_REPLACECOLS columnNameTypeList ( restrictOrCascade )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1101:7: (add= KW_ADD |replace= KW_REPLACE ) KW_COLUMNS LPAREN columnNameTypeList RPAREN ( restrictOrCascade )?
            {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1101:7: (add= KW_ADD |replace= KW_REPLACE )
            int alt65=2;
            switch ( input.LA(1) ) {
            case KW_ADD:
                {
                alt65=1;
                }
                break;
            case KW_REPLACE:
                {
                alt65=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 65, 0, input);

                throw nvae;

            }

            switch (alt65) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1101:8: add= KW_ADD
                    {
                    add=(Token)match(input,KW_ADD,FOLLOW_KW_ADD_in_alterStatementSuffixAddCol4498); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_ADD.add(add);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1101:21: replace= KW_REPLACE
                    {
                    replace=(Token)match(input,KW_REPLACE,FOLLOW_KW_REPLACE_in_alterStatementSuffixAddCol4504); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_REPLACE.add(replace);


                    }
                    break;

            }


            KW_COLUMNS244=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_alterStatementSuffixAddCol4507); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_COLUMNS.add(KW_COLUMNS244);


            LPAREN245=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_alterStatementSuffixAddCol4509); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LPAREN.add(LPAREN245);


            pushFollow(FOLLOW_columnNameTypeList_in_alterStatementSuffixAddCol4511);
            columnNameTypeList246=columnNameTypeList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_columnNameTypeList.add(columnNameTypeList246.getTree());

            RPAREN247=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_alterStatementSuffixAddCol4513); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RPAREN.add(RPAREN247);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1101:85: ( restrictOrCascade )?
            int alt66=2;
            switch ( input.LA(1) ) {
                case KW_CASCADE:
                case KW_RESTRICT:
                    {
                    alt66=1;
                    }
                    break;
            }

            switch (alt66) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1101:85: restrictOrCascade
                    {
                    pushFollow(FOLLOW_restrictOrCascade_in_alterStatementSuffixAddCol4515);
                    restrictOrCascade248=restrictOrCascade();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_restrictOrCascade.add(restrictOrCascade248.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: restrictOrCascade, columnNameTypeList, restrictOrCascade, columnNameTypeList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1102:5: -> {$add != null}? ^( TOK_ALTERTABLE_ADDCOLS columnNameTypeList ( restrictOrCascade )? )
            if (add != null) {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1102:24: ^( TOK_ALTERTABLE_ADDCOLS columnNameTypeList ( restrictOrCascade )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_ADDCOLS, "TOK_ALTERTABLE_ADDCOLS")
                , root_1);

                adaptor.addChild(root_1, stream_columnNameTypeList.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1102:68: ( restrictOrCascade )?
                if ( stream_restrictOrCascade.hasNext() ) {
                    adaptor.addChild(root_1, stream_restrictOrCascade.nextTree());

                }
                stream_restrictOrCascade.reset();

                adaptor.addChild(root_0, root_1);
                }

            }

            else // 1103:5: -> ^( TOK_ALTERTABLE_REPLACECOLS columnNameTypeList ( restrictOrCascade )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1103:24: ^( TOK_ALTERTABLE_REPLACECOLS columnNameTypeList ( restrictOrCascade )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_REPLACECOLS, "TOK_ALTERTABLE_REPLACECOLS")
                , root_1);

                adaptor.addChild(root_1, stream_columnNameTypeList.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1103:72: ( restrictOrCascade )?
                if ( stream_restrictOrCascade.hasNext() ) {
                    adaptor.addChild(root_1, stream_restrictOrCascade.nextTree());

                }
                stream_restrictOrCascade.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixAddCol"


    public static class alterStatementSuffixRenameCol_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixRenameCol"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1106:1: alterStatementSuffixRenameCol : KW_CHANGE ( KW_COLUMN )? oldName= identifier newName= identifier colType ( KW_COMMENT comment= StringLiteral )? ( alterStatementChangeColPosition )? ( restrictOrCascade )? -> ^( TOK_ALTERTABLE_RENAMECOL $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? ( restrictOrCascade )? ) ;
    public final HiveParser.alterStatementSuffixRenameCol_return alterStatementSuffixRenameCol() throws RecognitionException {
        HiveParser.alterStatementSuffixRenameCol_return retval = new HiveParser.alterStatementSuffixRenameCol_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_CHANGE249=null;
        Token KW_COLUMN250=null;
        Token KW_COMMENT252=null;
        HiveParser_IdentifiersParser.identifier_return oldName =null;

        HiveParser_IdentifiersParser.identifier_return newName =null;

        HiveParser.colType_return colType251 =null;

        HiveParser.alterStatementChangeColPosition_return alterStatementChangeColPosition253 =null;

        HiveParser.restrictOrCascade_return restrictOrCascade254 =null;


        CommonTree comment_tree=null;
        CommonTree KW_CHANGE249_tree=null;
        CommonTree KW_COLUMN250_tree=null;
        CommonTree KW_COMMENT252_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");
        RewriteRuleTokenStream stream_KW_COLUMN=new RewriteRuleTokenStream(adaptor,"token KW_COLUMN");
        RewriteRuleTokenStream stream_KW_CHANGE=new RewriteRuleTokenStream(adaptor,"token KW_CHANGE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_colType=new RewriteRuleSubtreeStream(adaptor,"rule colType");
        RewriteRuleSubtreeStream stream_alterStatementChangeColPosition=new RewriteRuleSubtreeStream(adaptor,"rule alterStatementChangeColPosition");
        RewriteRuleSubtreeStream stream_restrictOrCascade=new RewriteRuleSubtreeStream(adaptor,"rule restrictOrCascade");
         pushMsg("rename column name", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1109:5: ( KW_CHANGE ( KW_COLUMN )? oldName= identifier newName= identifier colType ( KW_COMMENT comment= StringLiteral )? ( alterStatementChangeColPosition )? ( restrictOrCascade )? -> ^( TOK_ALTERTABLE_RENAMECOL $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? ( restrictOrCascade )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1109:7: KW_CHANGE ( KW_COLUMN )? oldName= identifier newName= identifier colType ( KW_COMMENT comment= StringLiteral )? ( alterStatementChangeColPosition )? ( restrictOrCascade )?
            {
            KW_CHANGE249=(Token)match(input,KW_CHANGE,FOLLOW_KW_CHANGE_in_alterStatementSuffixRenameCol4591); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_CHANGE.add(KW_CHANGE249);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1109:17: ( KW_COLUMN )?
            int alt67=2;
            switch ( input.LA(1) ) {
                case KW_COLUMN:
                    {
                    alt67=1;
                    }
                    break;
            }

            switch (alt67) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1109:17: KW_COLUMN
                    {
                    KW_COLUMN250=(Token)match(input,KW_COLUMN,FOLLOW_KW_COLUMN_in_alterStatementSuffixRenameCol4593); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_COLUMN.add(KW_COLUMN250);


                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_alterStatementSuffixRenameCol4598);
            oldName=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(oldName.getTree());

            pushFollow(FOLLOW_identifier_in_alterStatementSuffixRenameCol4602);
            newName=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(newName.getTree());

            pushFollow(FOLLOW_colType_in_alterStatementSuffixRenameCol4604);
            colType251=colType();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_colType.add(colType251.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1109:74: ( KW_COMMENT comment= StringLiteral )?
            int alt68=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt68=1;
                    }
                    break;
            }

            switch (alt68) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1109:75: KW_COMMENT comment= StringLiteral
                    {
                    KW_COMMENT252=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_alterStatementSuffixRenameCol4607); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_COMMENT.add(KW_COMMENT252);


                    comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixRenameCol4611); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_StringLiteral.add(comment);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1109:110: ( alterStatementChangeColPosition )?
            int alt69=2;
            switch ( input.LA(1) ) {
                case KW_AFTER:
                case KW_FIRST:
                    {
                    alt69=1;
                    }
                    break;
            }

            switch (alt69) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1109:110: alterStatementChangeColPosition
                    {
                    pushFollow(FOLLOW_alterStatementChangeColPosition_in_alterStatementSuffixRenameCol4615);
                    alterStatementChangeColPosition253=alterStatementChangeColPosition();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_alterStatementChangeColPosition.add(alterStatementChangeColPosition253.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1109:143: ( restrictOrCascade )?
            int alt70=2;
            switch ( input.LA(1) ) {
                case KW_CASCADE:
                case KW_RESTRICT:
                    {
                    alt70=1;
                    }
                    break;
            }

            switch (alt70) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1109:143: restrictOrCascade
                    {
                    pushFollow(FOLLOW_restrictOrCascade_in_alterStatementSuffixRenameCol4618);
                    restrictOrCascade254=restrictOrCascade();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_restrictOrCascade.add(restrictOrCascade254.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: oldName, alterStatementChangeColPosition, newName, restrictOrCascade, colType, comment
            // token labels: comment
            // rule labels: newName, oldName, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_newName=new RewriteRuleSubtreeStream(adaptor,"rule newName",newName!=null?newName.tree:null);
            RewriteRuleSubtreeStream stream_oldName=new RewriteRuleSubtreeStream(adaptor,"rule oldName",oldName!=null?oldName.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1110:5: -> ^( TOK_ALTERTABLE_RENAMECOL $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? ( restrictOrCascade )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1110:7: ^( TOK_ALTERTABLE_RENAMECOL $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? ( restrictOrCascade )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_RENAMECOL, "TOK_ALTERTABLE_RENAMECOL")
                , root_1);

                adaptor.addChild(root_1, stream_oldName.nextTree());

                adaptor.addChild(root_1, stream_newName.nextTree());

                adaptor.addChild(root_1, stream_colType.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1110:61: ( $comment)?
                if ( stream_comment.hasNext() ) {
                    adaptor.addChild(root_1, stream_comment.nextNode());

                }
                stream_comment.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1110:70: ( alterStatementChangeColPosition )?
                if ( stream_alterStatementChangeColPosition.hasNext() ) {
                    adaptor.addChild(root_1, stream_alterStatementChangeColPosition.nextTree());

                }
                stream_alterStatementChangeColPosition.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1110:103: ( restrictOrCascade )?
                if ( stream_restrictOrCascade.hasNext() ) {
                    adaptor.addChild(root_1, stream_restrictOrCascade.nextTree());

                }
                stream_restrictOrCascade.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixRenameCol"


    public static class alterStatementSuffixUpdateStatsCol_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixUpdateStatsCol"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1113:1: alterStatementSuffixUpdateStatsCol : KW_UPDATE KW_STATISTICS KW_FOR ( KW_COLUMN )? colName= identifier KW_SET tableProperties ( KW_COMMENT comment= StringLiteral )? -> ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? ) ;
    public final HiveParser.alterStatementSuffixUpdateStatsCol_return alterStatementSuffixUpdateStatsCol() throws RecognitionException {
        HiveParser.alterStatementSuffixUpdateStatsCol_return retval = new HiveParser.alterStatementSuffixUpdateStatsCol_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_UPDATE255=null;
        Token KW_STATISTICS256=null;
        Token KW_FOR257=null;
        Token KW_COLUMN258=null;
        Token KW_SET259=null;
        Token KW_COMMENT261=null;
        HiveParser_IdentifiersParser.identifier_return colName =null;

        HiveParser.tableProperties_return tableProperties260 =null;


        CommonTree comment_tree=null;
        CommonTree KW_UPDATE255_tree=null;
        CommonTree KW_STATISTICS256_tree=null;
        CommonTree KW_FOR257_tree=null;
        CommonTree KW_COLUMN258_tree=null;
        CommonTree KW_SET259_tree=null;
        CommonTree KW_COMMENT261_tree=null;
        RewriteRuleTokenStream stream_KW_STATISTICS=new RewriteRuleTokenStream(adaptor,"token KW_STATISTICS");
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_FOR=new RewriteRuleTokenStream(adaptor,"token KW_FOR");
        RewriteRuleTokenStream stream_KW_UPDATE=new RewriteRuleTokenStream(adaptor,"token KW_UPDATE");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");
        RewriteRuleTokenStream stream_KW_COLUMN=new RewriteRuleTokenStream(adaptor,"token KW_COLUMN");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
         pushMsg("update column statistics", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1116:5: ( KW_UPDATE KW_STATISTICS KW_FOR ( KW_COLUMN )? colName= identifier KW_SET tableProperties ( KW_COMMENT comment= StringLiteral )? -> ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1116:7: KW_UPDATE KW_STATISTICS KW_FOR ( KW_COLUMN )? colName= identifier KW_SET tableProperties ( KW_COMMENT comment= StringLiteral )?
            {
            KW_UPDATE255=(Token)match(input,KW_UPDATE,FOLLOW_KW_UPDATE_in_alterStatementSuffixUpdateStatsCol4673); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_UPDATE.add(KW_UPDATE255);


            KW_STATISTICS256=(Token)match(input,KW_STATISTICS,FOLLOW_KW_STATISTICS_in_alterStatementSuffixUpdateStatsCol4675); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_STATISTICS.add(KW_STATISTICS256);


            KW_FOR257=(Token)match(input,KW_FOR,FOLLOW_KW_FOR_in_alterStatementSuffixUpdateStatsCol4677); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_FOR.add(KW_FOR257);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1116:38: ( KW_COLUMN )?
            int alt71=2;
            switch ( input.LA(1) ) {
                case KW_COLUMN:
                    {
                    alt71=1;
                    }
                    break;
            }

            switch (alt71) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1116:38: KW_COLUMN
                    {
                    KW_COLUMN258=(Token)match(input,KW_COLUMN,FOLLOW_KW_COLUMN_in_alterStatementSuffixUpdateStatsCol4679); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_COLUMN.add(KW_COLUMN258);


                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_alterStatementSuffixUpdateStatsCol4684);
            colName=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(colName.getTree());

            KW_SET259=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixUpdateStatsCol4686); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_SET.add(KW_SET259);


            pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixUpdateStatsCol4688);
            tableProperties260=tableProperties();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableProperties.add(tableProperties260.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1116:91: ( KW_COMMENT comment= StringLiteral )?
            int alt72=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt72=1;
                    }
                    break;
            }

            switch (alt72) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1116:92: KW_COMMENT comment= StringLiteral
                    {
                    KW_COMMENT261=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_alterStatementSuffixUpdateStatsCol4691); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_COMMENT.add(KW_COMMENT261);


                    comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixUpdateStatsCol4695); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_StringLiteral.add(comment);


                    }
                    break;

            }


            // AST REWRITE
            // elements: tableProperties, colName, comment
            // token labels: comment
            // rule labels: colName, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_colName=new RewriteRuleSubtreeStream(adaptor,"rule colName",colName!=null?colName.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1117:5: -> ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1117:7: ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_UPDATECOLSTATS, "TOK_ALTERTABLE_UPDATECOLSTATS")
                , root_1);

                adaptor.addChild(root_1, stream_colName.nextTree());

                adaptor.addChild(root_1, stream_tableProperties.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1117:65: ( $comment)?
                if ( stream_comment.hasNext() ) {
                    adaptor.addChild(root_1, stream_comment.nextNode());

                }
                stream_comment.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixUpdateStatsCol"


    public static class alterStatementChangeColPosition_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementChangeColPosition"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1120:1: alterStatementChangeColPosition : (first= KW_FIRST | KW_AFTER afterCol= identifier -> {$first != null}? ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION ) -> ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol) );
    public final HiveParser.alterStatementChangeColPosition_return alterStatementChangeColPosition() throws RecognitionException {
        HiveParser.alterStatementChangeColPosition_return retval = new HiveParser.alterStatementChangeColPosition_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token first=null;
        Token KW_AFTER262=null;
        HiveParser_IdentifiersParser.identifier_return afterCol =null;


        CommonTree first_tree=null;
        CommonTree KW_AFTER262_tree=null;
        RewriteRuleTokenStream stream_KW_AFTER=new RewriteRuleTokenStream(adaptor,"token KW_AFTER");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1121:5: (first= KW_FIRST | KW_AFTER afterCol= identifier -> {$first != null}? ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION ) -> ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol) )
            int alt73=2;
            switch ( input.LA(1) ) {
            case KW_FIRST:
                {
                alt73=1;
                }
                break;
            case KW_AFTER:
                {
                alt73=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 73, 0, input);

                throw nvae;

            }

            switch (alt73) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1121:7: first= KW_FIRST
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    first=(Token)match(input,KW_FIRST,FOLLOW_KW_FIRST_in_alterStatementChangeColPosition4734); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    first_tree = 
                    (CommonTree)adaptor.create(first)
                    ;
                    adaptor.addChild(root_0, first_tree);
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1121:22: KW_AFTER afterCol= identifier
                    {
                    KW_AFTER262=(Token)match(input,KW_AFTER,FOLLOW_KW_AFTER_in_alterStatementChangeColPosition4736); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_AFTER.add(KW_AFTER262);


                    pushFollow(FOLLOW_identifier_in_alterStatementChangeColPosition4740);
                    afterCol=identifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_identifier.add(afterCol.getTree());

                    // AST REWRITE
                    // elements: afterCol
                    // token labels: 
                    // rule labels: afterCol, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_afterCol=new RewriteRuleSubtreeStream(adaptor,"rule afterCol",afterCol!=null?afterCol.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1122:5: -> {$first != null}? ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION )
                    if (first != null) {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1122:25: ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION, "TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    else // 1123:5: -> ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1123:8: ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION, "TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION")
                        , root_1);

                        adaptor.addChild(root_1, stream_afterCol.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementChangeColPosition"


    public static class alterStatementSuffixAddPartitions_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixAddPartitions"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1126:1: alterStatementSuffixAddPartitions[boolean table] : KW_ADD ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ -> { table }? ^( TOK_ALTERTABLE_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ ) -> ^( TOK_ALTERVIEW_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ ) ;
    public final HiveParser.alterStatementSuffixAddPartitions_return alterStatementSuffixAddPartitions(boolean table) throws RecognitionException {
        HiveParser.alterStatementSuffixAddPartitions_return retval = new HiveParser.alterStatementSuffixAddPartitions_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ADD263=null;
        HiveParser.ifNotExists_return ifNotExists264 =null;

        HiveParser.alterStatementSuffixAddPartitionsElement_return alterStatementSuffixAddPartitionsElement265 =null;


        CommonTree KW_ADD263_tree=null;
        RewriteRuleTokenStream stream_KW_ADD=new RewriteRuleTokenStream(adaptor,"token KW_ADD");
        RewriteRuleSubtreeStream stream_ifNotExists=new RewriteRuleSubtreeStream(adaptor,"rule ifNotExists");
        RewriteRuleSubtreeStream stream_alterStatementSuffixAddPartitionsElement=new RewriteRuleSubtreeStream(adaptor,"rule alterStatementSuffixAddPartitionsElement");
         pushMsg("add partition statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1129:5: ( KW_ADD ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ -> { table }? ^( TOK_ALTERTABLE_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ ) -> ^( TOK_ALTERVIEW_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1129:7: KW_ADD ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+
            {
            KW_ADD263=(Token)match(input,KW_ADD,FOLLOW_KW_ADD_in_alterStatementSuffixAddPartitions4793); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_ADD.add(KW_ADD263);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1129:14: ( ifNotExists )?
            int alt74=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt74=1;
                    }
                    break;
            }

            switch (alt74) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1129:14: ifNotExists
                    {
                    pushFollow(FOLLOW_ifNotExists_in_alterStatementSuffixAddPartitions4795);
                    ifNotExists264=ifNotExists();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_ifNotExists.add(ifNotExists264.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1129:27: ( alterStatementSuffixAddPartitionsElement )+
            int cnt75=0;
            loop75:
            do {
                int alt75=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt75=1;
                    }
                    break;

                }

                switch (alt75) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1129:27: alterStatementSuffixAddPartitionsElement
            	    {
            	    pushFollow(FOLLOW_alterStatementSuffixAddPartitionsElement_in_alterStatementSuffixAddPartitions4798);
            	    alterStatementSuffixAddPartitionsElement265=alterStatementSuffixAddPartitionsElement();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_alterStatementSuffixAddPartitionsElement.add(alterStatementSuffixAddPartitionsElement265.getTree());

            	    }
            	    break;

            	default :
            	    if ( cnt75 >= 1 ) break loop75;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(75, input);
                        throw eee;
                }
                cnt75++;
            } while (true);


            // AST REWRITE
            // elements: alterStatementSuffixAddPartitionsElement, ifNotExists, ifNotExists, alterStatementSuffixAddPartitionsElement
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1130:5: -> { table }? ^( TOK_ALTERTABLE_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ )
            if ( table ) {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1130:19: ^( TOK_ALTERTABLE_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_ADDPARTS, "TOK_ALTERTABLE_ADDPARTS")
                , root_1);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1130:45: ( ifNotExists )?
                if ( stream_ifNotExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifNotExists.nextTree());

                }
                stream_ifNotExists.reset();

                if ( !(stream_alterStatementSuffixAddPartitionsElement.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_alterStatementSuffixAddPartitionsElement.hasNext() ) {
                    adaptor.addChild(root_1, stream_alterStatementSuffixAddPartitionsElement.nextTree());

                }
                stream_alterStatementSuffixAddPartitionsElement.reset();

                adaptor.addChild(root_0, root_1);
                }

            }

            else // 1131:5: -> ^( TOK_ALTERVIEW_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1131:19: ^( TOK_ALTERVIEW_ADDPARTS ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERVIEW_ADDPARTS, "TOK_ALTERVIEW_ADDPARTS")
                , root_1);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1131:44: ( ifNotExists )?
                if ( stream_ifNotExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifNotExists.nextTree());

                }
                stream_ifNotExists.reset();

                if ( !(stream_alterStatementSuffixAddPartitionsElement.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_alterStatementSuffixAddPartitionsElement.hasNext() ) {
                    adaptor.addChild(root_1, stream_alterStatementSuffixAddPartitionsElement.nextTree());

                }
                stream_alterStatementSuffixAddPartitionsElement.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixAddPartitions"


    public static class alterStatementSuffixAddPartitionsElement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixAddPartitionsElement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1134:1: alterStatementSuffixAddPartitionsElement : partitionSpec ( partitionLocation )? ;
    public final HiveParser.alterStatementSuffixAddPartitionsElement_return alterStatementSuffixAddPartitionsElement() throws RecognitionException {
        HiveParser.alterStatementSuffixAddPartitionsElement_return retval = new HiveParser.alterStatementSuffixAddPartitionsElement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec266 =null;

        HiveParser.partitionLocation_return partitionLocation267 =null;



        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1135:5: ( partitionSpec ( partitionLocation )? )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1135:7: partitionSpec ( partitionLocation )?
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixAddPartitionsElement4861);
            partitionSpec266=partitionSpec();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, partitionSpec266.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1135:21: ( partitionLocation )?
            int alt76=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt76=1;
                    }
                    break;
            }

            switch (alt76) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1135:21: partitionLocation
                    {
                    pushFollow(FOLLOW_partitionLocation_in_alterStatementSuffixAddPartitionsElement4863);
                    partitionLocation267=partitionLocation();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, partitionLocation267.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixAddPartitionsElement"


    public static class alterStatementSuffixTouch_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixTouch"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1138:1: alterStatementSuffixTouch : KW_TOUCH ( partitionSpec )* -> ^( TOK_ALTERTABLE_TOUCH ( partitionSpec )* ) ;
    public final HiveParser.alterStatementSuffixTouch_return alterStatementSuffixTouch() throws RecognitionException {
        HiveParser.alterStatementSuffixTouch_return retval = new HiveParser.alterStatementSuffixTouch_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_TOUCH268=null;
        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec269 =null;


        CommonTree KW_TOUCH268_tree=null;
        RewriteRuleTokenStream stream_KW_TOUCH=new RewriteRuleTokenStream(adaptor,"token KW_TOUCH");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("touch statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1141:5: ( KW_TOUCH ( partitionSpec )* -> ^( TOK_ALTERTABLE_TOUCH ( partitionSpec )* ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1141:7: KW_TOUCH ( partitionSpec )*
            {
            KW_TOUCH268=(Token)match(input,KW_TOUCH,FOLLOW_KW_TOUCH_in_alterStatementSuffixTouch4891); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TOUCH.add(KW_TOUCH268);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1141:16: ( partitionSpec )*
            loop77:
            do {
                int alt77=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt77=1;
                    }
                    break;

                }

                switch (alt77) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1141:17: partitionSpec
            	    {
            	    pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixTouch4894);
            	    partitionSpec269=partitionSpec();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_partitionSpec.add(partitionSpec269.getTree());

            	    }
            	    break;

            	default :
            	    break loop77;
                }
            } while (true);


            // AST REWRITE
            // elements: partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1142:5: -> ^( TOK_ALTERTABLE_TOUCH ( partitionSpec )* )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1142:8: ^( TOK_ALTERTABLE_TOUCH ( partitionSpec )* )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_TOUCH, "TOK_ALTERTABLE_TOUCH")
                , root_1);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1142:31: ( partitionSpec )*
                while ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixTouch"


    public static class alterStatementSuffixArchive_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixArchive"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1145:1: alterStatementSuffixArchive : KW_ARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_ARCHIVE ( partitionSpec )* ) ;
    public final HiveParser.alterStatementSuffixArchive_return alterStatementSuffixArchive() throws RecognitionException {
        HiveParser.alterStatementSuffixArchive_return retval = new HiveParser.alterStatementSuffixArchive_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ARCHIVE270=null;
        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec271 =null;


        CommonTree KW_ARCHIVE270_tree=null;
        RewriteRuleTokenStream stream_KW_ARCHIVE=new RewriteRuleTokenStream(adaptor,"token KW_ARCHIVE");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("archive statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1148:5: ( KW_ARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_ARCHIVE ( partitionSpec )* ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1148:7: KW_ARCHIVE ( partitionSpec )*
            {
            KW_ARCHIVE270=(Token)match(input,KW_ARCHIVE,FOLLOW_KW_ARCHIVE_in_alterStatementSuffixArchive4938); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_ARCHIVE.add(KW_ARCHIVE270);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1148:18: ( partitionSpec )*
            loop78:
            do {
                int alt78=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt78=1;
                    }
                    break;

                }

                switch (alt78) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1148:19: partitionSpec
            	    {
            	    pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixArchive4941);
            	    partitionSpec271=partitionSpec();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_partitionSpec.add(partitionSpec271.getTree());

            	    }
            	    break;

            	default :
            	    break loop78;
                }
            } while (true);


            // AST REWRITE
            // elements: partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1149:5: -> ^( TOK_ALTERTABLE_ARCHIVE ( partitionSpec )* )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1149:8: ^( TOK_ALTERTABLE_ARCHIVE ( partitionSpec )* )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_ARCHIVE, "TOK_ALTERTABLE_ARCHIVE")
                , root_1);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1149:33: ( partitionSpec )*
                while ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixArchive"


    public static class alterStatementSuffixUnArchive_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixUnArchive"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1152:1: alterStatementSuffixUnArchive : KW_UNARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_UNARCHIVE ( partitionSpec )* ) ;
    public final HiveParser.alterStatementSuffixUnArchive_return alterStatementSuffixUnArchive() throws RecognitionException {
        HiveParser.alterStatementSuffixUnArchive_return retval = new HiveParser.alterStatementSuffixUnArchive_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_UNARCHIVE272=null;
        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec273 =null;


        CommonTree KW_UNARCHIVE272_tree=null;
        RewriteRuleTokenStream stream_KW_UNARCHIVE=new RewriteRuleTokenStream(adaptor,"token KW_UNARCHIVE");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("unarchive statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1155:5: ( KW_UNARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_UNARCHIVE ( partitionSpec )* ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1155:7: KW_UNARCHIVE ( partitionSpec )*
            {
            KW_UNARCHIVE272=(Token)match(input,KW_UNARCHIVE,FOLLOW_KW_UNARCHIVE_in_alterStatementSuffixUnArchive4985); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_UNARCHIVE.add(KW_UNARCHIVE272);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1155:20: ( partitionSpec )*
            loop79:
            do {
                int alt79=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt79=1;
                    }
                    break;

                }

                switch (alt79) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1155:21: partitionSpec
            	    {
            	    pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixUnArchive4988);
            	    partitionSpec273=partitionSpec();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_partitionSpec.add(partitionSpec273.getTree());

            	    }
            	    break;

            	default :
            	    break loop79;
                }
            } while (true);


            // AST REWRITE
            // elements: partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1156:5: -> ^( TOK_ALTERTABLE_UNARCHIVE ( partitionSpec )* )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1156:8: ^( TOK_ALTERTABLE_UNARCHIVE ( partitionSpec )* )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_UNARCHIVE, "TOK_ALTERTABLE_UNARCHIVE")
                , root_1);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1156:35: ( partitionSpec )*
                while ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixUnArchive"


    public static class partitionLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "partitionLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1159:1: partitionLocation : KW_LOCATION locn= StringLiteral -> ^( TOK_PARTITIONLOCATION $locn) ;
    public final HiveParser.partitionLocation_return partitionLocation() throws RecognitionException {
        HiveParser.partitionLocation_return retval = new HiveParser.partitionLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token locn=null;
        Token KW_LOCATION274=null;

        CommonTree locn_tree=null;
        CommonTree KW_LOCATION274_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");

         pushMsg("partition location", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1162:5: ( KW_LOCATION locn= StringLiteral -> ^( TOK_PARTITIONLOCATION $locn) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1163:7: KW_LOCATION locn= StringLiteral
            {
            KW_LOCATION274=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_partitionLocation5038); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_LOCATION.add(KW_LOCATION274);


            locn=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_partitionLocation5042); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_StringLiteral.add(locn);


            // AST REWRITE
            // elements: locn
            // token labels: locn
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_locn=new RewriteRuleTokenStream(adaptor,"token locn",locn);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1163:38: -> ^( TOK_PARTITIONLOCATION $locn)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1163:41: ^( TOK_PARTITIONLOCATION $locn)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_PARTITIONLOCATION, "TOK_PARTITIONLOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_locn.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "partitionLocation"


    public static class alterStatementSuffixDropPartitions_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixDropPartitions"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1166:1: alterStatementSuffixDropPartitions[boolean table] : KW_DROP ( ifExists )? dropPartitionSpec ( COMMA dropPartitionSpec )* ( ignoreProtection )? ( KW_PURGE )? ( replicationClause )? -> { table }? ^( TOK_ALTERTABLE_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ( KW_PURGE )? ( replicationClause )? ) -> ^( TOK_ALTERVIEW_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ( replicationClause )? ) ;
    public final HiveParser.alterStatementSuffixDropPartitions_return alterStatementSuffixDropPartitions(boolean table) throws RecognitionException {
        HiveParser.alterStatementSuffixDropPartitions_return retval = new HiveParser.alterStatementSuffixDropPartitions_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP275=null;
        Token COMMA278=null;
        Token KW_PURGE281=null;
        HiveParser.ifExists_return ifExists276 =null;

        HiveParser_IdentifiersParser.dropPartitionSpec_return dropPartitionSpec277 =null;

        HiveParser_IdentifiersParser.dropPartitionSpec_return dropPartitionSpec279 =null;

        HiveParser.ignoreProtection_return ignoreProtection280 =null;

        HiveParser.replicationClause_return replicationClause282 =null;


        CommonTree KW_DROP275_tree=null;
        CommonTree COMMA278_tree=null;
        CommonTree KW_PURGE281_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_PURGE=new RewriteRuleTokenStream(adaptor,"token KW_PURGE");
        RewriteRuleSubtreeStream stream_dropPartitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule dropPartitionSpec");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_ignoreProtection=new RewriteRuleSubtreeStream(adaptor,"rule ignoreProtection");
        RewriteRuleSubtreeStream stream_replicationClause=new RewriteRuleSubtreeStream(adaptor,"rule replicationClause");
         pushMsg("drop partition statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1169:5: ( KW_DROP ( ifExists )? dropPartitionSpec ( COMMA dropPartitionSpec )* ( ignoreProtection )? ( KW_PURGE )? ( replicationClause )? -> { table }? ^( TOK_ALTERTABLE_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ( KW_PURGE )? ( replicationClause )? ) -> ^( TOK_ALTERVIEW_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ( replicationClause )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1169:7: KW_DROP ( ifExists )? dropPartitionSpec ( COMMA dropPartitionSpec )* ( ignoreProtection )? ( KW_PURGE )? ( replicationClause )?
            {
            KW_DROP275=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_alterStatementSuffixDropPartitions5079); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_DROP.add(KW_DROP275);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1169:15: ( ifExists )?
            int alt80=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt80=1;
                    }
                    break;
            }

            switch (alt80) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1169:15: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_alterStatementSuffixDropPartitions5081);
                    ifExists276=ifExists();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_ifExists.add(ifExists276.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_dropPartitionSpec_in_alterStatementSuffixDropPartitions5084);
            dropPartitionSpec277=dropPartitionSpec();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_dropPartitionSpec.add(dropPartitionSpec277.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1169:43: ( COMMA dropPartitionSpec )*
            loop81:
            do {
                int alt81=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt81=1;
                    }
                    break;

                }

                switch (alt81) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1169:44: COMMA dropPartitionSpec
            	    {
            	    COMMA278=(Token)match(input,COMMA,FOLLOW_COMMA_in_alterStatementSuffixDropPartitions5087); if (state.failed) return retval; 
            	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA278);


            	    pushFollow(FOLLOW_dropPartitionSpec_in_alterStatementSuffixDropPartitions5089);
            	    dropPartitionSpec279=dropPartitionSpec();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_dropPartitionSpec.add(dropPartitionSpec279.getTree());

            	    }
            	    break;

            	default :
            	    break loop81;
                }
            } while (true);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1169:70: ( ignoreProtection )?
            int alt82=2;
            switch ( input.LA(1) ) {
                case KW_IGNORE:
                    {
                    alt82=1;
                    }
                    break;
            }

            switch (alt82) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1169:70: ignoreProtection
                    {
                    pushFollow(FOLLOW_ignoreProtection_in_alterStatementSuffixDropPartitions5093);
                    ignoreProtection280=ignoreProtection();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_ignoreProtection.add(ignoreProtection280.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1169:88: ( KW_PURGE )?
            int alt83=2;
            switch ( input.LA(1) ) {
                case KW_PURGE:
                    {
                    alt83=1;
                    }
                    break;
            }

            switch (alt83) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1169:88: KW_PURGE
                    {
                    KW_PURGE281=(Token)match(input,KW_PURGE,FOLLOW_KW_PURGE_in_alterStatementSuffixDropPartitions5096); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_PURGE.add(KW_PURGE281);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1169:98: ( replicationClause )?
            int alt84=2;
            switch ( input.LA(1) ) {
                case KW_FOR:
                    {
                    alt84=1;
                    }
                    break;
            }

            switch (alt84) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1169:98: replicationClause
                    {
                    pushFollow(FOLLOW_replicationClause_in_alterStatementSuffixDropPartitions5099);
                    replicationClause282=replicationClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_replicationClause.add(replicationClause282.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: KW_PURGE, dropPartitionSpec, ignoreProtection, ignoreProtection, ifExists, replicationClause, dropPartitionSpec, replicationClause, ifExists
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1170:5: -> { table }? ^( TOK_ALTERTABLE_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ( KW_PURGE )? ( replicationClause )? )
            if ( table ) {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1170:19: ^( TOK_ALTERTABLE_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ( KW_PURGE )? ( replicationClause )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_DROPPARTS, "TOK_ALTERTABLE_DROPPARTS")
                , root_1);

                if ( !(stream_dropPartitionSpec.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_dropPartitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_dropPartitionSpec.nextTree());

                }
                stream_dropPartitionSpec.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1170:65: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1170:75: ( ignoreProtection )?
                if ( stream_ignoreProtection.hasNext() ) {
                    adaptor.addChild(root_1, stream_ignoreProtection.nextTree());

                }
                stream_ignoreProtection.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1170:93: ( KW_PURGE )?
                if ( stream_KW_PURGE.hasNext() ) {
                    adaptor.addChild(root_1, 
                    stream_KW_PURGE.nextNode()
                    );

                }
                stream_KW_PURGE.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1170:103: ( replicationClause )?
                if ( stream_replicationClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_replicationClause.nextTree());

                }
                stream_replicationClause.reset();

                adaptor.addChild(root_0, root_1);
                }

            }

            else // 1171:5: -> ^( TOK_ALTERVIEW_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ( replicationClause )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1171:19: ^( TOK_ALTERVIEW_DROPPARTS ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ( replicationClause )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERVIEW_DROPPARTS, "TOK_ALTERVIEW_DROPPARTS")
                , root_1);

                if ( !(stream_dropPartitionSpec.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_dropPartitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_dropPartitionSpec.nextTree());

                }
                stream_dropPartitionSpec.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1171:64: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1171:74: ( ignoreProtection )?
                if ( stream_ignoreProtection.hasNext() ) {
                    adaptor.addChild(root_1, stream_ignoreProtection.nextTree());

                }
                stream_ignoreProtection.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1171:92: ( replicationClause )?
                if ( stream_replicationClause.hasNext() ) {
                    adaptor.addChild(root_1, stream_replicationClause.nextTree());

                }
                stream_replicationClause.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixDropPartitions"


    public static class alterStatementSuffixProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1174:1: alterStatementSuffixProperties : ( KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_PROPERTIES tableProperties ) | KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_ALTERTABLE_DROPPROPERTIES tableProperties ( ifExists )? ) );
    public final HiveParser.alterStatementSuffixProperties_return alterStatementSuffixProperties() throws RecognitionException {
        HiveParser.alterStatementSuffixProperties_return retval = new HiveParser.alterStatementSuffixProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET283=null;
        Token KW_TBLPROPERTIES284=null;
        Token KW_UNSET286=null;
        Token KW_TBLPROPERTIES287=null;
        HiveParser.tableProperties_return tableProperties285 =null;

        HiveParser.ifExists_return ifExists288 =null;

        HiveParser.tableProperties_return tableProperties289 =null;


        CommonTree KW_SET283_tree=null;
        CommonTree KW_TBLPROPERTIES284_tree=null;
        CommonTree KW_UNSET286_tree=null;
        CommonTree KW_TBLPROPERTIES287_tree=null;
        RewriteRuleTokenStream stream_KW_UNSET=new RewriteRuleTokenStream(adaptor,"token KW_UNSET");
        RewriteRuleTokenStream stream_KW_TBLPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_TBLPROPERTIES");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
         pushMsg("alter properties statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1177:5: ( KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_PROPERTIES tableProperties ) | KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_ALTERTABLE_DROPPROPERTIES tableProperties ( ifExists )? ) )
            int alt86=2;
            switch ( input.LA(1) ) {
            case KW_SET:
                {
                alt86=1;
                }
                break;
            case KW_UNSET:
                {
                alt86=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 86, 0, input);

                throw nvae;

            }

            switch (alt86) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1177:7: KW_SET KW_TBLPROPERTIES tableProperties
                    {
                    KW_SET283=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixProperties5187); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SET.add(KW_SET283);


                    KW_TBLPROPERTIES284=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterStatementSuffixProperties5189); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES284);


                    pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixProperties5191);
                    tableProperties285=tableProperties();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableProperties.add(tableProperties285.getTree());

                    // AST REWRITE
                    // elements: tableProperties
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1178:5: -> ^( TOK_ALTERTABLE_PROPERTIES tableProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1178:8: ^( TOK_ALTERTABLE_PROPERTIES tableProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_PROPERTIES, "TOK_ALTERTABLE_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1179:7: KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties
                    {
                    KW_UNSET286=(Token)match(input,KW_UNSET,FOLLOW_KW_UNSET_in_alterStatementSuffixProperties5211); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_UNSET.add(KW_UNSET286);


                    KW_TBLPROPERTIES287=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterStatementSuffixProperties5213); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES287);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1179:33: ( ifExists )?
                    int alt85=2;
                    switch ( input.LA(1) ) {
                        case KW_IF:
                            {
                            alt85=1;
                            }
                            break;
                    }

                    switch (alt85) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1179:33: ifExists
                            {
                            pushFollow(FOLLOW_ifExists_in_alterStatementSuffixProperties5215);
                            ifExists288=ifExists();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_ifExists.add(ifExists288.getTree());

                            }
                            break;

                    }


                    pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixProperties5218);
                    tableProperties289=tableProperties();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableProperties.add(tableProperties289.getTree());

                    // AST REWRITE
                    // elements: ifExists, tableProperties
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1180:5: -> ^( TOK_ALTERTABLE_DROPPROPERTIES tableProperties ( ifExists )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1180:8: ^( TOK_ALTERTABLE_DROPPROPERTIES tableProperties ( ifExists )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_DROPPROPERTIES, "TOK_ALTERTABLE_DROPPROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1180:56: ( ifExists )?
                        if ( stream_ifExists.hasNext() ) {
                            adaptor.addChild(root_1, stream_ifExists.nextTree());

                        }
                        stream_ifExists.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixProperties"


    public static class alterViewSuffixProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterViewSuffixProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1183:1: alterViewSuffixProperties : ( KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERVIEW_PROPERTIES tableProperties ) | KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_ALTERVIEW_DROPPROPERTIES tableProperties ( ifExists )? ) );
    public final HiveParser.alterViewSuffixProperties_return alterViewSuffixProperties() throws RecognitionException {
        HiveParser.alterViewSuffixProperties_return retval = new HiveParser.alterViewSuffixProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET290=null;
        Token KW_TBLPROPERTIES291=null;
        Token KW_UNSET293=null;
        Token KW_TBLPROPERTIES294=null;
        HiveParser.tableProperties_return tableProperties292 =null;

        HiveParser.ifExists_return ifExists295 =null;

        HiveParser.tableProperties_return tableProperties296 =null;


        CommonTree KW_SET290_tree=null;
        CommonTree KW_TBLPROPERTIES291_tree=null;
        CommonTree KW_UNSET293_tree=null;
        CommonTree KW_TBLPROPERTIES294_tree=null;
        RewriteRuleTokenStream stream_KW_UNSET=new RewriteRuleTokenStream(adaptor,"token KW_UNSET");
        RewriteRuleTokenStream stream_KW_TBLPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_TBLPROPERTIES");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
         pushMsg("alter view properties statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1186:5: ( KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERVIEW_PROPERTIES tableProperties ) | KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_ALTERVIEW_DROPPROPERTIES tableProperties ( ifExists )? ) )
            int alt88=2;
            switch ( input.LA(1) ) {
            case KW_SET:
                {
                alt88=1;
                }
                break;
            case KW_UNSET:
                {
                alt88=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 88, 0, input);

                throw nvae;

            }

            switch (alt88) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1186:7: KW_SET KW_TBLPROPERTIES tableProperties
                    {
                    KW_SET290=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterViewSuffixProperties5260); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SET.add(KW_SET290);


                    KW_TBLPROPERTIES291=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterViewSuffixProperties5262); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES291);


                    pushFollow(FOLLOW_tableProperties_in_alterViewSuffixProperties5264);
                    tableProperties292=tableProperties();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableProperties.add(tableProperties292.getTree());

                    // AST REWRITE
                    // elements: tableProperties
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1187:5: -> ^( TOK_ALTERVIEW_PROPERTIES tableProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1187:8: ^( TOK_ALTERVIEW_PROPERTIES tableProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW_PROPERTIES, "TOK_ALTERVIEW_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1188:7: KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties
                    {
                    KW_UNSET293=(Token)match(input,KW_UNSET,FOLLOW_KW_UNSET_in_alterViewSuffixProperties5284); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_UNSET.add(KW_UNSET293);


                    KW_TBLPROPERTIES294=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterViewSuffixProperties5286); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES294);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1188:33: ( ifExists )?
                    int alt87=2;
                    switch ( input.LA(1) ) {
                        case KW_IF:
                            {
                            alt87=1;
                            }
                            break;
                    }

                    switch (alt87) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1188:33: ifExists
                            {
                            pushFollow(FOLLOW_ifExists_in_alterViewSuffixProperties5288);
                            ifExists295=ifExists();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_ifExists.add(ifExists295.getTree());

                            }
                            break;

                    }


                    pushFollow(FOLLOW_tableProperties_in_alterViewSuffixProperties5291);
                    tableProperties296=tableProperties();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableProperties.add(tableProperties296.getTree());

                    // AST REWRITE
                    // elements: tableProperties, ifExists
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1189:5: -> ^( TOK_ALTERVIEW_DROPPROPERTIES tableProperties ( ifExists )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1189:8: ^( TOK_ALTERVIEW_DROPPROPERTIES tableProperties ( ifExists )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW_DROPPROPERTIES, "TOK_ALTERVIEW_DROPPROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1189:55: ( ifExists )?
                        if ( stream_ifExists.hasNext() ) {
                            adaptor.addChild(root_1, stream_ifExists.nextTree());

                        }
                        stream_ifExists.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterViewSuffixProperties"


    public static class alterStatementSuffixSerdeProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixSerdeProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1192:1: alterStatementSuffixSerdeProperties : ( KW_SET KW_SERDE serdeName= StringLiteral ( KW_WITH KW_SERDEPROPERTIES tableProperties )? -> ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? ) | KW_SET KW_SERDEPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties ) );
    public final HiveParser.alterStatementSuffixSerdeProperties_return alterStatementSuffixSerdeProperties() throws RecognitionException {
        HiveParser.alterStatementSuffixSerdeProperties_return retval = new HiveParser.alterStatementSuffixSerdeProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token serdeName=null;
        Token KW_SET297=null;
        Token KW_SERDE298=null;
        Token KW_WITH299=null;
        Token KW_SERDEPROPERTIES300=null;
        Token KW_SET302=null;
        Token KW_SERDEPROPERTIES303=null;
        HiveParser.tableProperties_return tableProperties301 =null;

        HiveParser.tableProperties_return tableProperties304 =null;


        CommonTree serdeName_tree=null;
        CommonTree KW_SET297_tree=null;
        CommonTree KW_SERDE298_tree=null;
        CommonTree KW_WITH299_tree=null;
        CommonTree KW_SERDEPROPERTIES300_tree=null;
        CommonTree KW_SET302_tree=null;
        CommonTree KW_SERDEPROPERTIES303_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleTokenStream stream_KW_SERDEPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_SERDEPROPERTIES");
        RewriteRuleTokenStream stream_KW_SERDE=new RewriteRuleTokenStream(adaptor,"token KW_SERDE");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
         pushMsg("alter serdes statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1195:5: ( KW_SET KW_SERDE serdeName= StringLiteral ( KW_WITH KW_SERDEPROPERTIES tableProperties )? -> ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? ) | KW_SET KW_SERDEPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties ) )
            int alt90=2;
            switch ( input.LA(1) ) {
            case KW_SET:
                {
                switch ( input.LA(2) ) {
                case KW_SERDE:
                    {
                    alt90=1;
                    }
                    break;
                case KW_SERDEPROPERTIES:
                    {
                    alt90=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 90, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 90, 0, input);

                throw nvae;

            }

            switch (alt90) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1195:7: KW_SET KW_SERDE serdeName= StringLiteral ( KW_WITH KW_SERDEPROPERTIES tableProperties )?
                    {
                    KW_SET297=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixSerdeProperties5333); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SET.add(KW_SET297);


                    KW_SERDE298=(Token)match(input,KW_SERDE,FOLLOW_KW_SERDE_in_alterStatementSuffixSerdeProperties5335); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SERDE.add(KW_SERDE298);


                    serdeName=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixSerdeProperties5339); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_StringLiteral.add(serdeName);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1195:47: ( KW_WITH KW_SERDEPROPERTIES tableProperties )?
                    int alt89=2;
                    switch ( input.LA(1) ) {
                        case KW_WITH:
                            {
                            alt89=1;
                            }
                            break;
                    }

                    switch (alt89) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1195:48: KW_WITH KW_SERDEPROPERTIES tableProperties
                            {
                            KW_WITH299=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_alterStatementSuffixSerdeProperties5342); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_WITH.add(KW_WITH299);


                            KW_SERDEPROPERTIES300=(Token)match(input,KW_SERDEPROPERTIES,FOLLOW_KW_SERDEPROPERTIES_in_alterStatementSuffixSerdeProperties5344); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_SERDEPROPERTIES.add(KW_SERDEPROPERTIES300);


                            pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixSerdeProperties5346);
                            tableProperties301=tableProperties();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_tableProperties.add(tableProperties301.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: tableProperties, serdeName
                    // token labels: serdeName
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_serdeName=new RewriteRuleTokenStream(adaptor,"token serdeName",serdeName);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1196:5: -> ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1196:8: ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SERIALIZER, "TOK_ALTERTABLE_SERIALIZER")
                        , root_1);

                        adaptor.addChild(root_1, stream_serdeName.nextNode());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1196:47: ( tableProperties )?
                        if ( stream_tableProperties.hasNext() ) {
                            adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        }
                        stream_tableProperties.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1197:7: KW_SET KW_SERDEPROPERTIES tableProperties
                    {
                    KW_SET302=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixSerdeProperties5372); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SET.add(KW_SET302);


                    KW_SERDEPROPERTIES303=(Token)match(input,KW_SERDEPROPERTIES,FOLLOW_KW_SERDEPROPERTIES_in_alterStatementSuffixSerdeProperties5374); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SERDEPROPERTIES.add(KW_SERDEPROPERTIES303);


                    pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixSerdeProperties5376);
                    tableProperties304=tableProperties();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableProperties.add(tableProperties304.getTree());

                    // AST REWRITE
                    // elements: tableProperties
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1198:5: -> ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1198:8: ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SERDEPROPERTIES, "TOK_ALTERTABLE_SERDEPROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixSerdeProperties"


    public static class tablePartitionPrefix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "tablePartitionPrefix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1201:1: tablePartitionPrefix : tableName ( partitionSpec )? -> ^( TOK_TABLE_PARTITION tableName ( partitionSpec )? ) ;
    public final HiveParser.tablePartitionPrefix_return tablePartitionPrefix() throws RecognitionException {
        HiveParser.tablePartitionPrefix_return retval = new HiveParser.tablePartitionPrefix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser_FromClauseParser.tableName_return tableName305 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec306 =null;


        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        pushMsg("table partition prefix", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1204:3: ( tableName ( partitionSpec )? -> ^( TOK_TABLE_PARTITION tableName ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1204:5: tableName ( partitionSpec )?
            {
            pushFollow(FOLLOW_tableName_in_tablePartitionPrefix5413);
            tableName305=tableName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableName.add(tableName305.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1204:15: ( partitionSpec )?
            int alt91=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt91=1;
                    }
                    break;
            }

            switch (alt91) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1204:15: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_tablePartitionPrefix5415);
                    partitionSpec306=partitionSpec();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_partitionSpec.add(partitionSpec306.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: partitionSpec, tableName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1205:3: -> ^( TOK_TABLE_PARTITION tableName ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1205:5: ^( TOK_TABLE_PARTITION tableName ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABLE_PARTITION, "TOK_TABLE_PARTITION")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1205:37: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "tablePartitionPrefix"


    public static class alterStatementSuffixFileFormat_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixFileFormat"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1208:1: alterStatementSuffixFileFormat : KW_SET KW_FILEFORMAT fileFormat -> ^( TOK_ALTERTABLE_FILEFORMAT fileFormat ) ;
    public final HiveParser.alterStatementSuffixFileFormat_return alterStatementSuffixFileFormat() throws RecognitionException {
        HiveParser.alterStatementSuffixFileFormat_return retval = new HiveParser.alterStatementSuffixFileFormat_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET307=null;
        Token KW_FILEFORMAT308=null;
        HiveParser.fileFormat_return fileFormat309 =null;


        CommonTree KW_SET307_tree=null;
        CommonTree KW_FILEFORMAT308_tree=null;
        RewriteRuleTokenStream stream_KW_FILEFORMAT=new RewriteRuleTokenStream(adaptor,"token KW_FILEFORMAT");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_fileFormat=new RewriteRuleSubtreeStream(adaptor,"rule fileFormat");
        pushMsg("alter fileformat statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1211:2: ( KW_SET KW_FILEFORMAT fileFormat -> ^( TOK_ALTERTABLE_FILEFORMAT fileFormat ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1211:4: KW_SET KW_FILEFORMAT fileFormat
            {
            KW_SET307=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixFileFormat5450); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_SET.add(KW_SET307);


            KW_FILEFORMAT308=(Token)match(input,KW_FILEFORMAT,FOLLOW_KW_FILEFORMAT_in_alterStatementSuffixFileFormat5452); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_FILEFORMAT.add(KW_FILEFORMAT308);


            pushFollow(FOLLOW_fileFormat_in_alterStatementSuffixFileFormat5454);
            fileFormat309=fileFormat();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_fileFormat.add(fileFormat309.getTree());

            // AST REWRITE
            // elements: fileFormat
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1212:2: -> ^( TOK_ALTERTABLE_FILEFORMAT fileFormat )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1212:5: ^( TOK_ALTERTABLE_FILEFORMAT fileFormat )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_FILEFORMAT, "TOK_ALTERTABLE_FILEFORMAT")
                , root_1);

                adaptor.addChild(root_1, stream_fileFormat.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixFileFormat"


    public static class alterStatementSuffixClusterbySortby_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixClusterbySortby"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1215:1: alterStatementSuffixClusterbySortby : ( KW_NOT KW_CLUSTERED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED ) | KW_NOT KW_SORTED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED ) | tableBuckets -> ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets ) );
    public final HiveParser.alterStatementSuffixClusterbySortby_return alterStatementSuffixClusterbySortby() throws RecognitionException {
        HiveParser.alterStatementSuffixClusterbySortby_return retval = new HiveParser.alterStatementSuffixClusterbySortby_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_NOT310=null;
        Token KW_CLUSTERED311=null;
        Token KW_NOT312=null;
        Token KW_SORTED313=null;
        HiveParser.tableBuckets_return tableBuckets314 =null;


        CommonTree KW_NOT310_tree=null;
        CommonTree KW_CLUSTERED311_tree=null;
        CommonTree KW_NOT312_tree=null;
        CommonTree KW_SORTED313_tree=null;
        RewriteRuleTokenStream stream_KW_NOT=new RewriteRuleTokenStream(adaptor,"token KW_NOT");
        RewriteRuleTokenStream stream_KW_SORTED=new RewriteRuleTokenStream(adaptor,"token KW_SORTED");
        RewriteRuleTokenStream stream_KW_CLUSTERED=new RewriteRuleTokenStream(adaptor,"token KW_CLUSTERED");
        RewriteRuleSubtreeStream stream_tableBuckets=new RewriteRuleSubtreeStream(adaptor,"rule tableBuckets");
        pushMsg("alter partition cluster by sort by statement", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1218:3: ( KW_NOT KW_CLUSTERED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED ) | KW_NOT KW_SORTED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED ) | tableBuckets -> ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets ) )
            int alt92=3;
            switch ( input.LA(1) ) {
            case KW_NOT:
                {
                switch ( input.LA(2) ) {
                case KW_CLUSTERED:
                    {
                    alt92=1;
                    }
                    break;
                case KW_SORTED:
                    {
                    alt92=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 92, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_CLUSTERED:
                {
                alt92=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 92, 0, input);

                throw nvae;

            }

            switch (alt92) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1218:5: KW_NOT KW_CLUSTERED
                    {
                    KW_NOT310=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixClusterbySortby5485); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_NOT.add(KW_NOT310);


                    KW_CLUSTERED311=(Token)match(input,KW_CLUSTERED,FOLLOW_KW_CLUSTERED_in_alterStatementSuffixClusterbySortby5487); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_CLUSTERED.add(KW_CLUSTERED311);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1218:25: -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1218:28: ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CLUSTER_SORT, "TOK_ALTERTABLE_CLUSTER_SORT")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(TOK_NOT_CLUSTERED, "TOK_NOT_CLUSTERED")
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1219:5: KW_NOT KW_SORTED
                    {
                    KW_NOT312=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixClusterbySortby5501); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_NOT.add(KW_NOT312);


                    KW_SORTED313=(Token)match(input,KW_SORTED,FOLLOW_KW_SORTED_in_alterStatementSuffixClusterbySortby5503); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SORTED.add(KW_SORTED313);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1219:22: -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1219:25: ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CLUSTER_SORT, "TOK_ALTERTABLE_CLUSTER_SORT")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(TOK_NOT_SORTED, "TOK_NOT_SORTED")
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1220:5: tableBuckets
                    {
                    pushFollow(FOLLOW_tableBuckets_in_alterStatementSuffixClusterbySortby5517);
                    tableBuckets314=tableBuckets();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableBuckets.add(tableBuckets314.getTree());

                    // AST REWRITE
                    // elements: tableBuckets
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1220:18: -> ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1220:21: ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CLUSTER_SORT, "TOK_ALTERTABLE_CLUSTER_SORT")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableBuckets.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixClusterbySortby"


    public static class alterTblPartitionStatementSuffixSkewedLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterTblPartitionStatementSuffixSkewedLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1223:1: alterTblPartitionStatementSuffixSkewedLocation : KW_SET KW_SKEWED KW_LOCATION skewedLocations -> ^( TOK_ALTERTABLE_SKEWED_LOCATION skewedLocations ) ;
    public final HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return alterTblPartitionStatementSuffixSkewedLocation() throws RecognitionException {
        HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return retval = new HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET315=null;
        Token KW_SKEWED316=null;
        Token KW_LOCATION317=null;
        HiveParser.skewedLocations_return skewedLocations318 =null;


        CommonTree KW_SET315_tree=null;
        CommonTree KW_SKEWED316_tree=null;
        CommonTree KW_LOCATION317_tree=null;
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");
        RewriteRuleTokenStream stream_KW_SKEWED=new RewriteRuleTokenStream(adaptor,"token KW_SKEWED");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_skewedLocations=new RewriteRuleSubtreeStream(adaptor,"rule skewedLocations");
        pushMsg("alter partition skewed location", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1226:3: ( KW_SET KW_SKEWED KW_LOCATION skewedLocations -> ^( TOK_ALTERTABLE_SKEWED_LOCATION skewedLocations ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1226:5: KW_SET KW_SKEWED KW_LOCATION skewedLocations
            {
            KW_SET315=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterTblPartitionStatementSuffixSkewedLocation5548); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_SET.add(KW_SET315);


            KW_SKEWED316=(Token)match(input,KW_SKEWED,FOLLOW_KW_SKEWED_in_alterTblPartitionStatementSuffixSkewedLocation5550); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_SKEWED.add(KW_SKEWED316);


            KW_LOCATION317=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_alterTblPartitionStatementSuffixSkewedLocation5552); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_LOCATION.add(KW_LOCATION317);


            pushFollow(FOLLOW_skewedLocations_in_alterTblPartitionStatementSuffixSkewedLocation5554);
            skewedLocations318=skewedLocations();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_skewedLocations.add(skewedLocations318.getTree());

            // AST REWRITE
            // elements: skewedLocations
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1227:3: -> ^( TOK_ALTERTABLE_SKEWED_LOCATION skewedLocations )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1227:6: ^( TOK_ALTERTABLE_SKEWED_LOCATION skewedLocations )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_SKEWED_LOCATION, "TOK_ALTERTABLE_SKEWED_LOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_skewedLocations.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterTblPartitionStatementSuffixSkewedLocation"


    public static class skewedLocations_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "skewedLocations"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1230:1: skewedLocations : LPAREN skewedLocationsList RPAREN -> ^( TOK_SKEWED_LOCATIONS skewedLocationsList ) ;
    public final HiveParser.skewedLocations_return skewedLocations() throws RecognitionException {
        HiveParser.skewedLocations_return retval = new HiveParser.skewedLocations_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token LPAREN319=null;
        Token RPAREN321=null;
        HiveParser.skewedLocationsList_return skewedLocationsList320 =null;


        CommonTree LPAREN319_tree=null;
        CommonTree RPAREN321_tree=null;
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleSubtreeStream stream_skewedLocationsList=new RewriteRuleSubtreeStream(adaptor,"rule skewedLocationsList");
         pushMsg("skewed locations", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:5: ( LPAREN skewedLocationsList RPAREN -> ^( TOK_SKEWED_LOCATIONS skewedLocationsList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1234:7: LPAREN skewedLocationsList RPAREN
            {
            LPAREN319=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_skewedLocations5597); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LPAREN.add(LPAREN319);


            pushFollow(FOLLOW_skewedLocationsList_in_skewedLocations5599);
            skewedLocationsList320=skewedLocationsList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_skewedLocationsList.add(skewedLocationsList320.getTree());

            RPAREN321=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_skewedLocations5601); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RPAREN.add(RPAREN321);


            // AST REWRITE
            // elements: skewedLocationsList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1234:41: -> ^( TOK_SKEWED_LOCATIONS skewedLocationsList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1234:44: ^( TOK_SKEWED_LOCATIONS skewedLocationsList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SKEWED_LOCATIONS, "TOK_SKEWED_LOCATIONS")
                , root_1);

                adaptor.addChild(root_1, stream_skewedLocationsList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "skewedLocations"


    public static class skewedLocationsList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "skewedLocationsList"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1237:1: skewedLocationsList : skewedLocationMap ( COMMA skewedLocationMap )* -> ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ ) ;
    public final HiveParser.skewedLocationsList_return skewedLocationsList() throws RecognitionException {
        HiveParser.skewedLocationsList_return retval = new HiveParser.skewedLocationsList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA323=null;
        HiveParser.skewedLocationMap_return skewedLocationMap322 =null;

        HiveParser.skewedLocationMap_return skewedLocationMap324 =null;


        CommonTree COMMA323_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_skewedLocationMap=new RewriteRuleSubtreeStream(adaptor,"rule skewedLocationMap");
         pushMsg("skewed locations list", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1240:5: ( skewedLocationMap ( COMMA skewedLocationMap )* -> ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1241:7: skewedLocationMap ( COMMA skewedLocationMap )*
            {
            pushFollow(FOLLOW_skewedLocationMap_in_skewedLocationsList5642);
            skewedLocationMap322=skewedLocationMap();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_skewedLocationMap.add(skewedLocationMap322.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1241:25: ( COMMA skewedLocationMap )*
            loop93:
            do {
                int alt93=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt93=1;
                    }
                    break;

                }

                switch (alt93) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1241:26: COMMA skewedLocationMap
            	    {
            	    COMMA323=(Token)match(input,COMMA,FOLLOW_COMMA_in_skewedLocationsList5645); if (state.failed) return retval; 
            	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA323);


            	    pushFollow(FOLLOW_skewedLocationMap_in_skewedLocationsList5647);
            	    skewedLocationMap324=skewedLocationMap();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_skewedLocationMap.add(skewedLocationMap324.getTree());

            	    }
            	    break;

            	default :
            	    break loop93;
                }
            } while (true);


            // AST REWRITE
            // elements: skewedLocationMap
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1241:52: -> ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1241:55: ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SKEWED_LOCATION_LIST, "TOK_SKEWED_LOCATION_LIST")
                , root_1);

                if ( !(stream_skewedLocationMap.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_skewedLocationMap.hasNext() ) {
                    adaptor.addChild(root_1, stream_skewedLocationMap.nextTree());

                }
                stream_skewedLocationMap.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "skewedLocationsList"


    public static class skewedLocationMap_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "skewedLocationMap"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1244:1: skewedLocationMap : key= skewedValueLocationElement EQUAL value= StringLiteral -> ^( TOK_SKEWED_LOCATION_MAP $key $value) ;
    public final HiveParser.skewedLocationMap_return skewedLocationMap() throws RecognitionException {
        HiveParser.skewedLocationMap_return retval = new HiveParser.skewedLocationMap_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token value=null;
        Token EQUAL325=null;
        HiveParser.skewedValueLocationElement_return key =null;


        CommonTree value_tree=null;
        CommonTree EQUAL325_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_EQUAL=new RewriteRuleTokenStream(adaptor,"token EQUAL");
        RewriteRuleSubtreeStream stream_skewedValueLocationElement=new RewriteRuleSubtreeStream(adaptor,"rule skewedValueLocationElement");
         pushMsg("specifying skewed location map", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1247:5: (key= skewedValueLocationElement EQUAL value= StringLiteral -> ^( TOK_SKEWED_LOCATION_MAP $key $value) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1248:7: key= skewedValueLocationElement EQUAL value= StringLiteral
            {
            pushFollow(FOLLOW_skewedValueLocationElement_in_skewedLocationMap5693);
            key=skewedValueLocationElement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_skewedValueLocationElement.add(key.getTree());

            EQUAL325=(Token)match(input,EQUAL,FOLLOW_EQUAL_in_skewedLocationMap5695); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_EQUAL.add(EQUAL325);


            value=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_skewedLocationMap5699); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_StringLiteral.add(value);


            // AST REWRITE
            // elements: value, key
            // token labels: value
            // rule labels: key, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_value=new RewriteRuleTokenStream(adaptor,"token value",value);
            RewriteRuleSubtreeStream stream_key=new RewriteRuleSubtreeStream(adaptor,"rule key",key!=null?key.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1248:64: -> ^( TOK_SKEWED_LOCATION_MAP $key $value)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1248:67: ^( TOK_SKEWED_LOCATION_MAP $key $value)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SKEWED_LOCATION_MAP, "TOK_SKEWED_LOCATION_MAP")
                , root_1);

                adaptor.addChild(root_1, stream_key.nextTree());

                adaptor.addChild(root_1, stream_value.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "skewedLocationMap"


    public static class alterStatementSuffixLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1251:1: alterStatementSuffixLocation : KW_SET KW_LOCATION newLoc= StringLiteral -> ^( TOK_ALTERTABLE_LOCATION $newLoc) ;
    public final HiveParser.alterStatementSuffixLocation_return alterStatementSuffixLocation() throws RecognitionException {
        HiveParser.alterStatementSuffixLocation_return retval = new HiveParser.alterStatementSuffixLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token newLoc=null;
        Token KW_SET326=null;
        Token KW_LOCATION327=null;

        CommonTree newLoc_tree=null;
        CommonTree KW_SET326_tree=null;
        CommonTree KW_LOCATION327_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");

        pushMsg("alter location", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1254:3: ( KW_SET KW_LOCATION newLoc= StringLiteral -> ^( TOK_ALTERTABLE_LOCATION $newLoc) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1254:5: KW_SET KW_LOCATION newLoc= StringLiteral
            {
            KW_SET326=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixLocation5736); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_SET.add(KW_SET326);


            KW_LOCATION327=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_alterStatementSuffixLocation5738); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_LOCATION.add(KW_LOCATION327);


            newLoc=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixLocation5742); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_StringLiteral.add(newLoc);


            // AST REWRITE
            // elements: newLoc
            // token labels: newLoc
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_newLoc=new RewriteRuleTokenStream(adaptor,"token newLoc",newLoc);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1255:3: -> ^( TOK_ALTERTABLE_LOCATION $newLoc)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1255:6: ^( TOK_ALTERTABLE_LOCATION $newLoc)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_LOCATION, "TOK_ALTERTABLE_LOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_newLoc.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixLocation"


    public static class alterStatementSuffixSkewedby_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixSkewedby"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1259:1: alterStatementSuffixSkewedby : ( tableSkewed -> ^( TOK_ALTERTABLE_SKEWED tableSkewed ) | KW_NOT KW_SKEWED -> ^( TOK_ALTERTABLE_SKEWED ) | KW_NOT storedAsDirs -> ^( TOK_ALTERTABLE_SKEWED storedAsDirs ) );
    public final HiveParser.alterStatementSuffixSkewedby_return alterStatementSuffixSkewedby() throws RecognitionException {
        HiveParser.alterStatementSuffixSkewedby_return retval = new HiveParser.alterStatementSuffixSkewedby_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_NOT329=null;
        Token KW_SKEWED330=null;
        Token KW_NOT331=null;
        HiveParser.tableSkewed_return tableSkewed328 =null;

        HiveParser.storedAsDirs_return storedAsDirs332 =null;


        CommonTree KW_NOT329_tree=null;
        CommonTree KW_SKEWED330_tree=null;
        CommonTree KW_NOT331_tree=null;
        RewriteRuleTokenStream stream_KW_NOT=new RewriteRuleTokenStream(adaptor,"token KW_NOT");
        RewriteRuleTokenStream stream_KW_SKEWED=new RewriteRuleTokenStream(adaptor,"token KW_SKEWED");
        RewriteRuleSubtreeStream stream_tableSkewed=new RewriteRuleSubtreeStream(adaptor,"rule tableSkewed");
        RewriteRuleSubtreeStream stream_storedAsDirs=new RewriteRuleSubtreeStream(adaptor,"rule storedAsDirs");
        pushMsg("alter skewed by statement", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1262:2: ( tableSkewed -> ^( TOK_ALTERTABLE_SKEWED tableSkewed ) | KW_NOT KW_SKEWED -> ^( TOK_ALTERTABLE_SKEWED ) | KW_NOT storedAsDirs -> ^( TOK_ALTERTABLE_SKEWED storedAsDirs ) )
            int alt94=3;
            switch ( input.LA(1) ) {
            case KW_SKEWED:
                {
                alt94=1;
                }
                break;
            case KW_NOT:
                {
                switch ( input.LA(2) ) {
                case KW_SKEWED:
                    {
                    alt94=2;
                    }
                    break;
                case KW_STORED:
                    {
                    alt94=3;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 94, 2, input);

                    throw nvae;

                }

                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 94, 0, input);

                throw nvae;

            }

            switch (alt94) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1262:4: tableSkewed
                    {
                    pushFollow(FOLLOW_tableSkewed_in_alterStatementSuffixSkewedby5776);
                    tableSkewed328=tableSkewed();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableSkewed.add(tableSkewed328.getTree());

                    // AST REWRITE
                    // elements: tableSkewed
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1263:2: -> ^( TOK_ALTERTABLE_SKEWED tableSkewed )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1263:4: ^( TOK_ALTERTABLE_SKEWED tableSkewed )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SKEWED, "TOK_ALTERTABLE_SKEWED")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableSkewed.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1265:3: KW_NOT KW_SKEWED
                    {
                    KW_NOT329=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixSkewedby5791); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_NOT.add(KW_NOT329);


                    KW_SKEWED330=(Token)match(input,KW_SKEWED,FOLLOW_KW_SKEWED_in_alterStatementSuffixSkewedby5793); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SKEWED.add(KW_SKEWED330);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1266:2: -> ^( TOK_ALTERTABLE_SKEWED )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1266:4: ^( TOK_ALTERTABLE_SKEWED )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SKEWED, "TOK_ALTERTABLE_SKEWED")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1268:3: KW_NOT storedAsDirs
                    {
                    KW_NOT331=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixSkewedby5806); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_NOT.add(KW_NOT331);


                    pushFollow(FOLLOW_storedAsDirs_in_alterStatementSuffixSkewedby5808);
                    storedAsDirs332=storedAsDirs();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_storedAsDirs.add(storedAsDirs332.getTree());

                    // AST REWRITE
                    // elements: storedAsDirs
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1269:2: -> ^( TOK_ALTERTABLE_SKEWED storedAsDirs )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1269:4: ^( TOK_ALTERTABLE_SKEWED storedAsDirs )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SKEWED, "TOK_ALTERTABLE_SKEWED")
                        , root_1);

                        adaptor.addChild(root_1, stream_storedAsDirs.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixSkewedby"


    public static class alterStatementSuffixExchangePartition_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixExchangePartition"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1272:1: alterStatementSuffixExchangePartition : KW_EXCHANGE partitionSpec KW_WITH KW_TABLE exchangename= tableName -> ^( TOK_ALTERTABLE_EXCHANGEPARTITION partitionSpec $exchangename) ;
    public final HiveParser.alterStatementSuffixExchangePartition_return alterStatementSuffixExchangePartition() throws RecognitionException {
        HiveParser.alterStatementSuffixExchangePartition_return retval = new HiveParser.alterStatementSuffixExchangePartition_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_EXCHANGE333=null;
        Token KW_WITH335=null;
        Token KW_TABLE336=null;
        HiveParser_FromClauseParser.tableName_return exchangename =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec334 =null;


        CommonTree KW_EXCHANGE333_tree=null;
        CommonTree KW_WITH335_tree=null;
        CommonTree KW_TABLE336_tree=null;
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_EXCHANGE=new RewriteRuleTokenStream(adaptor,"token KW_EXCHANGE");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        pushMsg("alter exchange partition", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1275:5: ( KW_EXCHANGE partitionSpec KW_WITH KW_TABLE exchangename= tableName -> ^( TOK_ALTERTABLE_EXCHANGEPARTITION partitionSpec $exchangename) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1275:7: KW_EXCHANGE partitionSpec KW_WITH KW_TABLE exchangename= tableName
            {
            KW_EXCHANGE333=(Token)match(input,KW_EXCHANGE,FOLLOW_KW_EXCHANGE_in_alterStatementSuffixExchangePartition5839); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_EXCHANGE.add(KW_EXCHANGE333);


            pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixExchangePartition5841);
            partitionSpec334=partitionSpec();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_partitionSpec.add(partitionSpec334.getTree());

            KW_WITH335=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_alterStatementSuffixExchangePartition5843); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_WITH.add(KW_WITH335);


            KW_TABLE336=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_alterStatementSuffixExchangePartition5845); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TABLE.add(KW_TABLE336);


            pushFollow(FOLLOW_tableName_in_alterStatementSuffixExchangePartition5849);
            exchangename=tableName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableName.add(exchangename.getTree());

            // AST REWRITE
            // elements: partitionSpec, exchangename
            // token labels: 
            // rule labels: exchangename, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_exchangename=new RewriteRuleSubtreeStream(adaptor,"rule exchangename",exchangename!=null?exchangename.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1276:5: -> ^( TOK_ALTERTABLE_EXCHANGEPARTITION partitionSpec $exchangename)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1276:8: ^( TOK_ALTERTABLE_EXCHANGEPARTITION partitionSpec $exchangename)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_EXCHANGEPARTITION, "TOK_ALTERTABLE_EXCHANGEPARTITION")
                , root_1);

                adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                adaptor.addChild(root_1, stream_exchangename.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixExchangePartition"


    public static class alterStatementSuffixProtectMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixProtectMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1279:1: alterStatementSuffixProtectMode : alterProtectMode -> ^( TOK_ALTERTABLE_PROTECTMODE alterProtectMode ) ;
    public final HiveParser.alterStatementSuffixProtectMode_return alterStatementSuffixProtectMode() throws RecognitionException {
        HiveParser.alterStatementSuffixProtectMode_return retval = new HiveParser.alterStatementSuffixProtectMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterProtectMode_return alterProtectMode337 =null;


        RewriteRuleSubtreeStream stream_alterProtectMode=new RewriteRuleSubtreeStream(adaptor,"rule alterProtectMode");
         pushMsg("alter partition protect mode statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1282:5: ( alterProtectMode -> ^( TOK_ALTERTABLE_PROTECTMODE alterProtectMode ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1282:7: alterProtectMode
            {
            pushFollow(FOLLOW_alterProtectMode_in_alterStatementSuffixProtectMode5891);
            alterProtectMode337=alterProtectMode();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_alterProtectMode.add(alterProtectMode337.getTree());

            // AST REWRITE
            // elements: alterProtectMode
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1283:5: -> ^( TOK_ALTERTABLE_PROTECTMODE alterProtectMode )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1283:8: ^( TOK_ALTERTABLE_PROTECTMODE alterProtectMode )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_PROTECTMODE, "TOK_ALTERTABLE_PROTECTMODE")
                , root_1);

                adaptor.addChild(root_1, stream_alterProtectMode.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixProtectMode"


    public static class alterStatementSuffixRenamePart_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixRenamePart"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1286:1: alterStatementSuffixRenamePart : KW_RENAME KW_TO partitionSpec -> ^( TOK_ALTERTABLE_RENAMEPART partitionSpec ) ;
    public final HiveParser.alterStatementSuffixRenamePart_return alterStatementSuffixRenamePart() throws RecognitionException {
        HiveParser.alterStatementSuffixRenamePart_return retval = new HiveParser.alterStatementSuffixRenamePart_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_RENAME338=null;
        Token KW_TO339=null;
        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec340 =null;


        CommonTree KW_RENAME338_tree=null;
        CommonTree KW_TO339_tree=null;
        RewriteRuleTokenStream stream_KW_RENAME=new RewriteRuleTokenStream(adaptor,"token KW_RENAME");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         pushMsg("alter table rename partition statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1289:5: ( KW_RENAME KW_TO partitionSpec -> ^( TOK_ALTERTABLE_RENAMEPART partitionSpec ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1289:7: KW_RENAME KW_TO partitionSpec
            {
            KW_RENAME338=(Token)match(input,KW_RENAME,FOLLOW_KW_RENAME_in_alterStatementSuffixRenamePart5930); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_RENAME.add(KW_RENAME338);


            KW_TO339=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_alterStatementSuffixRenamePart5932); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TO.add(KW_TO339);


            pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixRenamePart5934);
            partitionSpec340=partitionSpec();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_partitionSpec.add(partitionSpec340.getTree());

            // AST REWRITE
            // elements: partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1290:5: -> ^( TOK_ALTERTABLE_RENAMEPART partitionSpec )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1290:7: ^( TOK_ALTERTABLE_RENAMEPART partitionSpec )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_RENAMEPART, "TOK_ALTERTABLE_RENAMEPART")
                , root_1);

                adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixRenamePart"


    public static class alterStatementSuffixStatsPart_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixStatsPart"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1293:1: alterStatementSuffixStatsPart : KW_UPDATE KW_STATISTICS KW_FOR ( KW_COLUMN )? colName= identifier KW_SET tableProperties ( KW_COMMENT comment= StringLiteral )? -> ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? ) ;
    public final HiveParser.alterStatementSuffixStatsPart_return alterStatementSuffixStatsPart() throws RecognitionException {
        HiveParser.alterStatementSuffixStatsPart_return retval = new HiveParser.alterStatementSuffixStatsPart_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_UPDATE341=null;
        Token KW_STATISTICS342=null;
        Token KW_FOR343=null;
        Token KW_COLUMN344=null;
        Token KW_SET345=null;
        Token KW_COMMENT347=null;
        HiveParser_IdentifiersParser.identifier_return colName =null;

        HiveParser.tableProperties_return tableProperties346 =null;


        CommonTree comment_tree=null;
        CommonTree KW_UPDATE341_tree=null;
        CommonTree KW_STATISTICS342_tree=null;
        CommonTree KW_FOR343_tree=null;
        CommonTree KW_COLUMN344_tree=null;
        CommonTree KW_SET345_tree=null;
        CommonTree KW_COMMENT347_tree=null;
        RewriteRuleTokenStream stream_KW_STATISTICS=new RewriteRuleTokenStream(adaptor,"token KW_STATISTICS");
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_FOR=new RewriteRuleTokenStream(adaptor,"token KW_FOR");
        RewriteRuleTokenStream stream_KW_UPDATE=new RewriteRuleTokenStream(adaptor,"token KW_UPDATE");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");
        RewriteRuleTokenStream stream_KW_COLUMN=new RewriteRuleTokenStream(adaptor,"token KW_COLUMN");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
         pushMsg("alter table stats partition statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:5: ( KW_UPDATE KW_STATISTICS KW_FOR ( KW_COLUMN )? colName= identifier KW_SET tableProperties ( KW_COMMENT comment= StringLiteral )? -> ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:7: KW_UPDATE KW_STATISTICS KW_FOR ( KW_COLUMN )? colName= identifier KW_SET tableProperties ( KW_COMMENT comment= StringLiteral )?
            {
            KW_UPDATE341=(Token)match(input,KW_UPDATE,FOLLOW_KW_UPDATE_in_alterStatementSuffixStatsPart5972); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_UPDATE.add(KW_UPDATE341);


            KW_STATISTICS342=(Token)match(input,KW_STATISTICS,FOLLOW_KW_STATISTICS_in_alterStatementSuffixStatsPart5974); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_STATISTICS.add(KW_STATISTICS342);


            KW_FOR343=(Token)match(input,KW_FOR,FOLLOW_KW_FOR_in_alterStatementSuffixStatsPart5976); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_FOR.add(KW_FOR343);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:38: ( KW_COLUMN )?
            int alt95=2;
            switch ( input.LA(1) ) {
                case KW_COLUMN:
                    {
                    alt95=1;
                    }
                    break;
            }

            switch (alt95) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:38: KW_COLUMN
                    {
                    KW_COLUMN344=(Token)match(input,KW_COLUMN,FOLLOW_KW_COLUMN_in_alterStatementSuffixStatsPart5978); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_COLUMN.add(KW_COLUMN344);


                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_alterStatementSuffixStatsPart5983);
            colName=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(colName.getTree());

            KW_SET345=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixStatsPart5985); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_SET.add(KW_SET345);


            pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixStatsPart5987);
            tableProperties346=tableProperties();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableProperties.add(tableProperties346.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:91: ( KW_COMMENT comment= StringLiteral )?
            int alt96=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt96=1;
                    }
                    break;
            }

            switch (alt96) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:92: KW_COMMENT comment= StringLiteral
                    {
                    KW_COMMENT347=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_alterStatementSuffixStatsPart5990); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_COMMENT.add(KW_COMMENT347);


                    comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixStatsPart5994); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_StringLiteral.add(comment);


                    }
                    break;

            }


            // AST REWRITE
            // elements: comment, tableProperties, colName
            // token labels: comment
            // rule labels: colName, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_colName=new RewriteRuleSubtreeStream(adaptor,"rule colName",colName!=null?colName.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1297:5: -> ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1297:7: ^( TOK_ALTERTABLE_UPDATECOLSTATS $colName tableProperties ( $comment)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_UPDATECOLSTATS, "TOK_ALTERTABLE_UPDATECOLSTATS")
                , root_1);

                adaptor.addChild(root_1, stream_colName.nextTree());

                adaptor.addChild(root_1, stream_tableProperties.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1297:65: ( $comment)?
                if ( stream_comment.hasNext() ) {
                    adaptor.addChild(root_1, stream_comment.nextNode());

                }
                stream_comment.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixStatsPart"


    public static class alterStatementSuffixMergeFiles_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixMergeFiles"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1300:1: alterStatementSuffixMergeFiles : KW_CONCATENATE -> ^( TOK_ALTERTABLE_MERGEFILES ) ;
    public final HiveParser.alterStatementSuffixMergeFiles_return alterStatementSuffixMergeFiles() throws RecognitionException {
        HiveParser.alterStatementSuffixMergeFiles_return retval = new HiveParser.alterStatementSuffixMergeFiles_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_CONCATENATE348=null;

        CommonTree KW_CONCATENATE348_tree=null;
        RewriteRuleTokenStream stream_KW_CONCATENATE=new RewriteRuleTokenStream(adaptor,"token KW_CONCATENATE");

         pushMsg("", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1303:5: ( KW_CONCATENATE -> ^( TOK_ALTERTABLE_MERGEFILES ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1303:7: KW_CONCATENATE
            {
            KW_CONCATENATE348=(Token)match(input,KW_CONCATENATE,FOLLOW_KW_CONCATENATE_in_alterStatementSuffixMergeFiles6041); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_CONCATENATE.add(KW_CONCATENATE348);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1304:5: -> ^( TOK_ALTERTABLE_MERGEFILES )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1304:8: ^( TOK_ALTERTABLE_MERGEFILES )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_MERGEFILES, "TOK_ALTERTABLE_MERGEFILES")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixMergeFiles"


    public static class alterProtectMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterProtectMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1307:1: alterProtectMode : ( KW_ENABLE alterProtectModeMode -> ^( TOK_ENABLE alterProtectModeMode ) | KW_DISABLE alterProtectModeMode -> ^( TOK_DISABLE alterProtectModeMode ) );
    public final HiveParser.alterProtectMode_return alterProtectMode() throws RecognitionException {
        HiveParser.alterProtectMode_return retval = new HiveParser.alterProtectMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ENABLE349=null;
        Token KW_DISABLE351=null;
        HiveParser.alterProtectModeMode_return alterProtectModeMode350 =null;

        HiveParser.alterProtectModeMode_return alterProtectModeMode352 =null;


        CommonTree KW_ENABLE349_tree=null;
        CommonTree KW_DISABLE351_tree=null;
        RewriteRuleTokenStream stream_KW_DISABLE=new RewriteRuleTokenStream(adaptor,"token KW_DISABLE");
        RewriteRuleTokenStream stream_KW_ENABLE=new RewriteRuleTokenStream(adaptor,"token KW_ENABLE");
        RewriteRuleSubtreeStream stream_alterProtectModeMode=new RewriteRuleSubtreeStream(adaptor,"rule alterProtectModeMode");
         pushMsg("protect mode specification enable", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1310:5: ( KW_ENABLE alterProtectModeMode -> ^( TOK_ENABLE alterProtectModeMode ) | KW_DISABLE alterProtectModeMode -> ^( TOK_DISABLE alterProtectModeMode ) )
            int alt97=2;
            switch ( input.LA(1) ) {
            case KW_ENABLE:
                {
                alt97=1;
                }
                break;
            case KW_DISABLE:
                {
                alt97=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 97, 0, input);

                throw nvae;

            }

            switch (alt97) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1310:7: KW_ENABLE alterProtectModeMode
                    {
                    KW_ENABLE349=(Token)match(input,KW_ENABLE,FOLLOW_KW_ENABLE_in_alterProtectMode6078); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_ENABLE.add(KW_ENABLE349);


                    pushFollow(FOLLOW_alterProtectModeMode_in_alterProtectMode6080);
                    alterProtectModeMode350=alterProtectModeMode();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_alterProtectModeMode.add(alterProtectModeMode350.getTree());

                    // AST REWRITE
                    // elements: alterProtectModeMode
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1310:39: -> ^( TOK_ENABLE alterProtectModeMode )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1310:42: ^( TOK_ENABLE alterProtectModeMode )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ENABLE, "TOK_ENABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_alterProtectModeMode.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1311:7: KW_DISABLE alterProtectModeMode
                    {
                    KW_DISABLE351=(Token)match(input,KW_DISABLE,FOLLOW_KW_DISABLE_in_alterProtectMode6097); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_DISABLE.add(KW_DISABLE351);


                    pushFollow(FOLLOW_alterProtectModeMode_in_alterProtectMode6099);
                    alterProtectModeMode352=alterProtectModeMode();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_alterProtectModeMode.add(alterProtectModeMode352.getTree());

                    // AST REWRITE
                    // elements: alterProtectModeMode
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1311:40: -> ^( TOK_DISABLE alterProtectModeMode )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1311:43: ^( TOK_DISABLE alterProtectModeMode )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DISABLE, "TOK_DISABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_alterProtectModeMode.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterProtectMode"


    public static class alterProtectModeMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterProtectModeMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1314:1: alterProtectModeMode : ( KW_OFFLINE -> ^( TOK_OFFLINE ) | KW_NO_DROP ( KW_CASCADE )? -> ^( TOK_NO_DROP ( KW_CASCADE )? ) | KW_READONLY -> ^( TOK_READONLY ) );
    public final HiveParser.alterProtectModeMode_return alterProtectModeMode() throws RecognitionException {
        HiveParser.alterProtectModeMode_return retval = new HiveParser.alterProtectModeMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_OFFLINE353=null;
        Token KW_NO_DROP354=null;
        Token KW_CASCADE355=null;
        Token KW_READONLY356=null;

        CommonTree KW_OFFLINE353_tree=null;
        CommonTree KW_NO_DROP354_tree=null;
        CommonTree KW_CASCADE355_tree=null;
        CommonTree KW_READONLY356_tree=null;
        RewriteRuleTokenStream stream_KW_CASCADE=new RewriteRuleTokenStream(adaptor,"token KW_CASCADE");
        RewriteRuleTokenStream stream_KW_READONLY=new RewriteRuleTokenStream(adaptor,"token KW_READONLY");
        RewriteRuleTokenStream stream_KW_OFFLINE=new RewriteRuleTokenStream(adaptor,"token KW_OFFLINE");
        RewriteRuleTokenStream stream_KW_NO_DROP=new RewriteRuleTokenStream(adaptor,"token KW_NO_DROP");

         pushMsg("protect mode specification enable", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1317:5: ( KW_OFFLINE -> ^( TOK_OFFLINE ) | KW_NO_DROP ( KW_CASCADE )? -> ^( TOK_NO_DROP ( KW_CASCADE )? ) | KW_READONLY -> ^( TOK_READONLY ) )
            int alt99=3;
            switch ( input.LA(1) ) {
            case KW_OFFLINE:
                {
                alt99=1;
                }
                break;
            case KW_NO_DROP:
                {
                alt99=2;
                }
                break;
            case KW_READONLY:
                {
                alt99=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 99, 0, input);

                throw nvae;

            }

            switch (alt99) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1317:7: KW_OFFLINE
                    {
                    KW_OFFLINE353=(Token)match(input,KW_OFFLINE,FOLLOW_KW_OFFLINE_in_alterProtectModeMode6135); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_OFFLINE.add(KW_OFFLINE353);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1317:19: -> ^( TOK_OFFLINE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1317:22: ^( TOK_OFFLINE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_OFFLINE, "TOK_OFFLINE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1318:7: KW_NO_DROP ( KW_CASCADE )?
                    {
                    KW_NO_DROP354=(Token)match(input,KW_NO_DROP,FOLLOW_KW_NO_DROP_in_alterProtectModeMode6150); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_NO_DROP.add(KW_NO_DROP354);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1318:18: ( KW_CASCADE )?
                    int alt98=2;
                    switch ( input.LA(1) ) {
                        case KW_CASCADE:
                            {
                            alt98=1;
                            }
                            break;
                    }

                    switch (alt98) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1318:18: KW_CASCADE
                            {
                            KW_CASCADE355=(Token)match(input,KW_CASCADE,FOLLOW_KW_CASCADE_in_alterProtectModeMode6152); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_CASCADE.add(KW_CASCADE355);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: KW_CASCADE
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1318:30: -> ^( TOK_NO_DROP ( KW_CASCADE )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1318:33: ^( TOK_NO_DROP ( KW_CASCADE )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_NO_DROP, "TOK_NO_DROP")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1318:47: ( KW_CASCADE )?
                        if ( stream_KW_CASCADE.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_KW_CASCADE.nextNode()
                            );

                        }
                        stream_KW_CASCADE.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1319:7: KW_READONLY
                    {
                    KW_READONLY356=(Token)match(input,KW_READONLY,FOLLOW_KW_READONLY_in_alterProtectModeMode6170); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_READONLY.add(KW_READONLY356);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1319:20: -> ^( TOK_READONLY )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1319:23: ^( TOK_READONLY )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_READONLY, "TOK_READONLY")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterProtectModeMode"


    public static class alterStatementSuffixBucketNum_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixBucketNum"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1322:1: alterStatementSuffixBucketNum : KW_INTO num= Number KW_BUCKETS -> ^( TOK_ALTERTABLE_BUCKETS $num) ;
    public final HiveParser.alterStatementSuffixBucketNum_return alterStatementSuffixBucketNum() throws RecognitionException {
        HiveParser.alterStatementSuffixBucketNum_return retval = new HiveParser.alterStatementSuffixBucketNum_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token num=null;
        Token KW_INTO357=null;
        Token KW_BUCKETS358=null;

        CommonTree num_tree=null;
        CommonTree KW_INTO357_tree=null;
        CommonTree KW_BUCKETS358_tree=null;
        RewriteRuleTokenStream stream_Number=new RewriteRuleTokenStream(adaptor,"token Number");
        RewriteRuleTokenStream stream_KW_INTO=new RewriteRuleTokenStream(adaptor,"token KW_INTO");
        RewriteRuleTokenStream stream_KW_BUCKETS=new RewriteRuleTokenStream(adaptor,"token KW_BUCKETS");

         pushMsg("", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1325:5: ( KW_INTO num= Number KW_BUCKETS -> ^( TOK_ALTERTABLE_BUCKETS $num) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1325:7: KW_INTO num= Number KW_BUCKETS
            {
            KW_INTO357=(Token)match(input,KW_INTO,FOLLOW_KW_INTO_in_alterStatementSuffixBucketNum6204); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_INTO.add(KW_INTO357);


            num=(Token)match(input,Number,FOLLOW_Number_in_alterStatementSuffixBucketNum6208); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_Number.add(num);


            KW_BUCKETS358=(Token)match(input,KW_BUCKETS,FOLLOW_KW_BUCKETS_in_alterStatementSuffixBucketNum6210); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_BUCKETS.add(KW_BUCKETS358);


            // AST REWRITE
            // elements: num
            // token labels: num
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_num=new RewriteRuleTokenStream(adaptor,"token num",num);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1326:5: -> ^( TOK_ALTERTABLE_BUCKETS $num)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1326:8: ^( TOK_ALTERTABLE_BUCKETS $num)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_BUCKETS, "TOK_ALTERTABLE_BUCKETS")
                , root_1);

                adaptor.addChild(root_1, stream_num.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixBucketNum"


    public static class alterStatementSuffixCompact_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixCompact"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1329:1: alterStatementSuffixCompact : KW_COMPACT compactType= StringLiteral -> ^( TOK_ALTERTABLE_COMPACT $compactType) ;
    public final HiveParser.alterStatementSuffixCompact_return alterStatementSuffixCompact() throws RecognitionException {
        HiveParser.alterStatementSuffixCompact_return retval = new HiveParser.alterStatementSuffixCompact_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token compactType=null;
        Token KW_COMPACT359=null;

        CommonTree compactType_tree=null;
        CommonTree KW_COMPACT359_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMPACT=new RewriteRuleTokenStream(adaptor,"token KW_COMPACT");

         msgs.push("compaction request"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1332:5: ( KW_COMPACT compactType= StringLiteral -> ^( TOK_ALTERTABLE_COMPACT $compactType) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1332:7: KW_COMPACT compactType= StringLiteral
            {
            KW_COMPACT359=(Token)match(input,KW_COMPACT,FOLLOW_KW_COMPACT_in_alterStatementSuffixCompact6250); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_COMPACT.add(KW_COMPACT359);


            compactType=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixCompact6254); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_StringLiteral.add(compactType);


            // AST REWRITE
            // elements: compactType
            // token labels: compactType
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_compactType=new RewriteRuleTokenStream(adaptor,"token compactType",compactType);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1333:5: -> ^( TOK_ALTERTABLE_COMPACT $compactType)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1333:8: ^( TOK_ALTERTABLE_COMPACT $compactType)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_COMPACT, "TOK_ALTERTABLE_COMPACT")
                , root_1);

                adaptor.addChild(root_1, stream_compactType.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { msgs.pop(); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixCompact"


    public static class fileFormat_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "fileFormat"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1337:1: fileFormat : ( KW_INPUTFORMAT inFmt= StringLiteral KW_OUTPUTFORMAT outFmt= StringLiteral KW_SERDE serdeCls= StringLiteral ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )? -> ^( TOK_TABLEFILEFORMAT $inFmt $outFmt $serdeCls ( $inDriver)? ( $outDriver)? ) |genericSpec= identifier -> ^( TOK_FILEFORMAT_GENERIC $genericSpec) );
    public final HiveParser.fileFormat_return fileFormat() throws RecognitionException {
        HiveParser.fileFormat_return retval = new HiveParser.fileFormat_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token inFmt=null;
        Token outFmt=null;
        Token serdeCls=null;
        Token inDriver=null;
        Token outDriver=null;
        Token KW_INPUTFORMAT360=null;
        Token KW_OUTPUTFORMAT361=null;
        Token KW_SERDE362=null;
        Token KW_INPUTDRIVER363=null;
        Token KW_OUTPUTDRIVER364=null;
        HiveParser_IdentifiersParser.identifier_return genericSpec =null;


        CommonTree inFmt_tree=null;
        CommonTree outFmt_tree=null;
        CommonTree serdeCls_tree=null;
        CommonTree inDriver_tree=null;
        CommonTree outDriver_tree=null;
        CommonTree KW_INPUTFORMAT360_tree=null;
        CommonTree KW_OUTPUTFORMAT361_tree=null;
        CommonTree KW_SERDE362_tree=null;
        CommonTree KW_INPUTDRIVER363_tree=null;
        CommonTree KW_OUTPUTDRIVER364_tree=null;
        RewriteRuleTokenStream stream_KW_INPUTFORMAT=new RewriteRuleTokenStream(adaptor,"token KW_INPUTFORMAT");
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_INPUTDRIVER=new RewriteRuleTokenStream(adaptor,"token KW_INPUTDRIVER");
        RewriteRuleTokenStream stream_KW_SERDE=new RewriteRuleTokenStream(adaptor,"token KW_SERDE");
        RewriteRuleTokenStream stream_KW_OUTPUTFORMAT=new RewriteRuleTokenStream(adaptor,"token KW_OUTPUTFORMAT");
        RewriteRuleTokenStream stream_KW_OUTPUTDRIVER=new RewriteRuleTokenStream(adaptor,"token KW_OUTPUTDRIVER");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("file format specification", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1340:5: ( KW_INPUTFORMAT inFmt= StringLiteral KW_OUTPUTFORMAT outFmt= StringLiteral KW_SERDE serdeCls= StringLiteral ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )? -> ^( TOK_TABLEFILEFORMAT $inFmt $outFmt $serdeCls ( $inDriver)? ( $outDriver)? ) |genericSpec= identifier -> ^( TOK_FILEFORMAT_GENERIC $genericSpec) )
            int alt101=2;
            switch ( input.LA(1) ) {
            case KW_INPUTFORMAT:
                {
                switch ( input.LA(2) ) {
                case StringLiteral:
                    {
                    alt101=1;
                    }
                    break;
                case EOF:
                    {
                    alt101=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 101, 1, input);

                    throw nvae;

                }

                }
                break;
            case Identifier:
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_AUTHORIZATION:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURRENT_DATE:
            case KW_CURRENT_TIMESTAMP:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DAY:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILE:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_HOUR:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_JAR:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_METADATA:
            case KW_MINUS:
            case KW_MINUTE:
            case KW_MONTH:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_OWNER:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PRINCIPALS:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RELOAD:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_REPLICATION:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_REWRITE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SECOND:
            case KW_SEMI:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SERVER:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRANSACTIONS:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_URI:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUES:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
            case KW_YEAR:
                {
                alt101=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 101, 0, input);

                throw nvae;

            }

            switch (alt101) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1340:7: KW_INPUTFORMAT inFmt= StringLiteral KW_OUTPUTFORMAT outFmt= StringLiteral KW_SERDE serdeCls= StringLiteral ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )?
                    {
                    KW_INPUTFORMAT360=(Token)match(input,KW_INPUTFORMAT,FOLLOW_KW_INPUTFORMAT_in_fileFormat6295); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_INPUTFORMAT.add(KW_INPUTFORMAT360);


                    inFmt=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat6299); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_StringLiteral.add(inFmt);


                    KW_OUTPUTFORMAT361=(Token)match(input,KW_OUTPUTFORMAT,FOLLOW_KW_OUTPUTFORMAT_in_fileFormat6301); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_OUTPUTFORMAT.add(KW_OUTPUTFORMAT361);


                    outFmt=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat6305); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_StringLiteral.add(outFmt);


                    KW_SERDE362=(Token)match(input,KW_SERDE,FOLLOW_KW_SERDE_in_fileFormat6307); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SERDE.add(KW_SERDE362);


                    serdeCls=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat6311); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_StringLiteral.add(serdeCls);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1340:111: ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )?
                    int alt100=2;
                    switch ( input.LA(1) ) {
                        case KW_INPUTDRIVER:
                            {
                            alt100=1;
                            }
                            break;
                    }

                    switch (alt100) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1340:112: KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral
                            {
                            KW_INPUTDRIVER363=(Token)match(input,KW_INPUTDRIVER,FOLLOW_KW_INPUTDRIVER_in_fileFormat6314); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_INPUTDRIVER.add(KW_INPUTDRIVER363);


                            inDriver=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat6318); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_StringLiteral.add(inDriver);


                            KW_OUTPUTDRIVER364=(Token)match(input,KW_OUTPUTDRIVER,FOLLOW_KW_OUTPUTDRIVER_in_fileFormat6320); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_OUTPUTDRIVER.add(KW_OUTPUTDRIVER364);


                            outDriver=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat6324); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_StringLiteral.add(outDriver);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: inDriver, outDriver, inFmt, outFmt, serdeCls
                    // token labels: inFmt, inDriver, outDriver, serdeCls, outFmt
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_inFmt=new RewriteRuleTokenStream(adaptor,"token inFmt",inFmt);
                    RewriteRuleTokenStream stream_inDriver=new RewriteRuleTokenStream(adaptor,"token inDriver",inDriver);
                    RewriteRuleTokenStream stream_outDriver=new RewriteRuleTokenStream(adaptor,"token outDriver",outDriver);
                    RewriteRuleTokenStream stream_serdeCls=new RewriteRuleTokenStream(adaptor,"token serdeCls",serdeCls);
                    RewriteRuleTokenStream stream_outFmt=new RewriteRuleTokenStream(adaptor,"token outFmt",outFmt);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1341:7: -> ^( TOK_TABLEFILEFORMAT $inFmt $outFmt $serdeCls ( $inDriver)? ( $outDriver)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1341:10: ^( TOK_TABLEFILEFORMAT $inFmt $outFmt $serdeCls ( $inDriver)? ( $outDriver)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_TABLEFILEFORMAT, "TOK_TABLEFILEFORMAT")
                        , root_1);

                        adaptor.addChild(root_1, stream_inFmt.nextNode());

                        adaptor.addChild(root_1, stream_outFmt.nextNode());

                        adaptor.addChild(root_1, stream_serdeCls.nextNode());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1341:58: ( $inDriver)?
                        if ( stream_inDriver.hasNext() ) {
                            adaptor.addChild(root_1, stream_inDriver.nextNode());

                        }
                        stream_inDriver.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1341:69: ( $outDriver)?
                        if ( stream_outDriver.hasNext() ) {
                            adaptor.addChild(root_1, stream_outDriver.nextNode());

                        }
                        stream_outDriver.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1342:7: genericSpec= identifier
                    {
                    pushFollow(FOLLOW_identifier_in_fileFormat6365);
                    genericSpec=identifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_identifier.add(genericSpec.getTree());

                    // AST REWRITE
                    // elements: genericSpec
                    // token labels: 
                    // rule labels: genericSpec, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_genericSpec=new RewriteRuleSubtreeStream(adaptor,"rule genericSpec",genericSpec!=null?genericSpec.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1342:30: -> ^( TOK_FILEFORMAT_GENERIC $genericSpec)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1342:33: ^( TOK_FILEFORMAT_GENERIC $genericSpec)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_FILEFORMAT_GENERIC, "TOK_FILEFORMAT_GENERIC")
                        , root_1);

                        adaptor.addChild(root_1, stream_genericSpec.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "fileFormat"


    public static class tabTypeExpr_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "tabTypeExpr"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1345:1: tabTypeExpr : identifier ( DOT ^ ( ( KW_ELEM_TYPE )=> KW_ELEM_TYPE | ( KW_KEY_TYPE )=> KW_KEY_TYPE | ( KW_VALUE_TYPE )=> KW_VALUE_TYPE | identifier ) )* ( identifier )? ;
    public final HiveParser.tabTypeExpr_return tabTypeExpr() throws RecognitionException {
        HiveParser.tabTypeExpr_return retval = new HiveParser.tabTypeExpr_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token DOT366=null;
        Token KW_ELEM_TYPE367=null;
        Token KW_KEY_TYPE368=null;
        Token KW_VALUE_TYPE369=null;
        HiveParser_IdentifiersParser.identifier_return identifier365 =null;

        HiveParser_IdentifiersParser.identifier_return identifier370 =null;

        HiveParser_IdentifiersParser.identifier_return identifier371 =null;


        CommonTree DOT366_tree=null;
        CommonTree KW_ELEM_TYPE367_tree=null;
        CommonTree KW_KEY_TYPE368_tree=null;
        CommonTree KW_VALUE_TYPE369_tree=null;

         pushMsg("specifying table types", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:4: ( identifier ( DOT ^ ( ( KW_ELEM_TYPE )=> KW_ELEM_TYPE | ( KW_KEY_TYPE )=> KW_KEY_TYPE | ( KW_VALUE_TYPE )=> KW_VALUE_TYPE | identifier ) )* ( identifier )? )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:6: identifier ( DOT ^ ( ( KW_ELEM_TYPE )=> KW_ELEM_TYPE | ( KW_KEY_TYPE )=> KW_KEY_TYPE | ( KW_VALUE_TYPE )=> KW_VALUE_TYPE | identifier ) )* ( identifier )?
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_identifier_in_tabTypeExpr6400);
            identifier365=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, identifier365.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:17: ( DOT ^ ( ( KW_ELEM_TYPE )=> KW_ELEM_TYPE | ( KW_KEY_TYPE )=> KW_KEY_TYPE | ( KW_VALUE_TYPE )=> KW_VALUE_TYPE | identifier ) )*
            loop103:
            do {
                int alt103=2;
                switch ( input.LA(1) ) {
                case DOT:
                    {
                    alt103=1;
                    }
                    break;

                }

                switch (alt103) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:18: DOT ^ ( ( KW_ELEM_TYPE )=> KW_ELEM_TYPE | ( KW_KEY_TYPE )=> KW_KEY_TYPE | ( KW_VALUE_TYPE )=> KW_VALUE_TYPE | identifier )
            	    {
            	    DOT366=(Token)match(input,DOT,FOLLOW_DOT_in_tabTypeExpr6403); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    DOT366_tree = 
            	    (CommonTree)adaptor.create(DOT366)
            	    ;
            	    root_0 = (CommonTree)adaptor.becomeRoot(DOT366_tree, root_0);
            	    }

            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:4: ( ( KW_ELEM_TYPE )=> KW_ELEM_TYPE | ( KW_KEY_TYPE )=> KW_KEY_TYPE | ( KW_VALUE_TYPE )=> KW_VALUE_TYPE | identifier )
            	    int alt102=4;
            	    switch ( input.LA(1) ) {
            	    case KW_ELEM_TYPE:
            	        {
            	        int LA102_1 = input.LA(2);

            	        if ( (synpred4_HiveParser()) ) {
            	            alt102=1;
            	        }
            	        else if ( (true) ) {
            	            alt102=4;
            	        }
            	        else {
            	            if (state.backtracking>0) {state.failed=true; return retval;}
            	            NoViableAltException nvae =
            	                new NoViableAltException("", 102, 1, input);

            	            throw nvae;

            	        }
            	        }
            	        break;
            	    case KW_KEY_TYPE:
            	        {
            	        int LA102_2 = input.LA(2);

            	        if ( (synpred5_HiveParser()) ) {
            	            alt102=2;
            	        }
            	        else if ( (true) ) {
            	            alt102=4;
            	        }
            	        else {
            	            if (state.backtracking>0) {state.failed=true; return retval;}
            	            NoViableAltException nvae =
            	                new NoViableAltException("", 102, 2, input);

            	            throw nvae;

            	        }
            	        }
            	        break;
            	    case KW_VALUE_TYPE:
            	        {
            	        int LA102_3 = input.LA(2);

            	        if ( (synpred6_HiveParser()) ) {
            	            alt102=3;
            	        }
            	        else if ( (true) ) {
            	            alt102=4;
            	        }
            	        else {
            	            if (state.backtracking>0) {state.failed=true; return retval;}
            	            NoViableAltException nvae =
            	                new NoViableAltException("", 102, 3, input);

            	            throw nvae;

            	        }
            	        }
            	        break;
            	    case Identifier:
            	    case KW_ADD:
            	    case KW_ADMIN:
            	    case KW_AFTER:
            	    case KW_ALL:
            	    case KW_ALTER:
            	    case KW_ANALYZE:
            	    case KW_ARCHIVE:
            	    case KW_ARRAY:
            	    case KW_AS:
            	    case KW_ASC:
            	    case KW_AUTHORIZATION:
            	    case KW_BEFORE:
            	    case KW_BETWEEN:
            	    case KW_BIGINT:
            	    case KW_BINARY:
            	    case KW_BOOLEAN:
            	    case KW_BOTH:
            	    case KW_BUCKET:
            	    case KW_BUCKETS:
            	    case KW_BY:
            	    case KW_CASCADE:
            	    case KW_CHANGE:
            	    case KW_CLUSTER:
            	    case KW_CLUSTERED:
            	    case KW_CLUSTERSTATUS:
            	    case KW_COLLECTION:
            	    case KW_COLUMNS:
            	    case KW_COMMENT:
            	    case KW_COMPACT:
            	    case KW_COMPACTIONS:
            	    case KW_COMPUTE:
            	    case KW_CONCATENATE:
            	    case KW_CONTINUE:
            	    case KW_CREATE:
            	    case KW_CUBE:
            	    case KW_CURRENT_DATE:
            	    case KW_CURRENT_TIMESTAMP:
            	    case KW_CURSOR:
            	    case KW_DATA:
            	    case KW_DATABASES:
            	    case KW_DATE:
            	    case KW_DATETIME:
            	    case KW_DAY:
            	    case KW_DBPROPERTIES:
            	    case KW_DECIMAL:
            	    case KW_DEFERRED:
            	    case KW_DEFINED:
            	    case KW_DELETE:
            	    case KW_DELIMITED:
            	    case KW_DEPENDENCY:
            	    case KW_DESC:
            	    case KW_DESCRIBE:
            	    case KW_DIRECTORIES:
            	    case KW_DIRECTORY:
            	    case KW_DISABLE:
            	    case KW_DISTRIBUTE:
            	    case KW_DOUBLE:
            	    case KW_DROP:
            	    case KW_ENABLE:
            	    case KW_ESCAPED:
            	    case KW_EXCLUSIVE:
            	    case KW_EXISTS:
            	    case KW_EXPLAIN:
            	    case KW_EXPORT:
            	    case KW_EXTERNAL:
            	    case KW_FALSE:
            	    case KW_FETCH:
            	    case KW_FIELDS:
            	    case KW_FILE:
            	    case KW_FILEFORMAT:
            	    case KW_FIRST:
            	    case KW_FLOAT:
            	    case KW_FOR:
            	    case KW_FORMAT:
            	    case KW_FORMATTED:
            	    case KW_FULL:
            	    case KW_FUNCTIONS:
            	    case KW_GRANT:
            	    case KW_GROUP:
            	    case KW_GROUPING:
            	    case KW_HOLD_DDLTIME:
            	    case KW_HOUR:
            	    case KW_IDXPROPERTIES:
            	    case KW_IGNORE:
            	    case KW_IMPORT:
            	    case KW_IN:
            	    case KW_INDEX:
            	    case KW_INDEXES:
            	    case KW_INNER:
            	    case KW_INPATH:
            	    case KW_INPUTDRIVER:
            	    case KW_INPUTFORMAT:
            	    case KW_INSERT:
            	    case KW_INT:
            	    case KW_INTERSECT:
            	    case KW_INTO:
            	    case KW_IS:
            	    case KW_ITEMS:
            	    case KW_JAR:
            	    case KW_KEYS:
            	    case KW_LATERAL:
            	    case KW_LEFT:
            	    case KW_LIKE:
            	    case KW_LIMIT:
            	    case KW_LINES:
            	    case KW_LOAD:
            	    case KW_LOCAL:
            	    case KW_LOCATION:
            	    case KW_LOCK:
            	    case KW_LOCKS:
            	    case KW_LOGICAL:
            	    case KW_LONG:
            	    case KW_MAPJOIN:
            	    case KW_MATERIALIZED:
            	    case KW_METADATA:
            	    case KW_MINUS:
            	    case KW_MINUTE:
            	    case KW_MONTH:
            	    case KW_MSCK:
            	    case KW_NONE:
            	    case KW_NOSCAN:
            	    case KW_NO_DROP:
            	    case KW_NULL:
            	    case KW_OF:
            	    case KW_OFFLINE:
            	    case KW_OPTION:
            	    case KW_ORDER:
            	    case KW_OUT:
            	    case KW_OUTER:
            	    case KW_OUTPUTDRIVER:
            	    case KW_OUTPUTFORMAT:
            	    case KW_OVERWRITE:
            	    case KW_OWNER:
            	    case KW_PARTITION:
            	    case KW_PARTITIONED:
            	    case KW_PARTITIONS:
            	    case KW_PERCENT:
            	    case KW_PLUS:
            	    case KW_PRETTY:
            	    case KW_PRINCIPALS:
            	    case KW_PROCEDURE:
            	    case KW_PROTECTION:
            	    case KW_PURGE:
            	    case KW_RANGE:
            	    case KW_READ:
            	    case KW_READONLY:
            	    case KW_READS:
            	    case KW_REBUILD:
            	    case KW_RECORDREADER:
            	    case KW_RECORDWRITER:
            	    case KW_REGEXP:
            	    case KW_RELOAD:
            	    case KW_RENAME:
            	    case KW_REPAIR:
            	    case KW_REPLACE:
            	    case KW_REPLICATION:
            	    case KW_RESTRICT:
            	    case KW_REVOKE:
            	    case KW_REWRITE:
            	    case KW_RIGHT:
            	    case KW_RLIKE:
            	    case KW_ROLE:
            	    case KW_ROLES:
            	    case KW_ROLLUP:
            	    case KW_ROW:
            	    case KW_ROWS:
            	    case KW_SCHEMA:
            	    case KW_SCHEMAS:
            	    case KW_SECOND:
            	    case KW_SEMI:
            	    case KW_SERDE:
            	    case KW_SERDEPROPERTIES:
            	    case KW_SERVER:
            	    case KW_SET:
            	    case KW_SETS:
            	    case KW_SHARED:
            	    case KW_SHOW:
            	    case KW_SHOW_DATABASE:
            	    case KW_SKEWED:
            	    case KW_SMALLINT:
            	    case KW_SORT:
            	    case KW_SORTED:
            	    case KW_SSL:
            	    case KW_STATISTICS:
            	    case KW_STORED:
            	    case KW_STREAMTABLE:
            	    case KW_STRING:
            	    case KW_STRUCT:
            	    case KW_TABLE:
            	    case KW_TABLES:
            	    case KW_TBLPROPERTIES:
            	    case KW_TEMPORARY:
            	    case KW_TERMINATED:
            	    case KW_TIMESTAMP:
            	    case KW_TINYINT:
            	    case KW_TO:
            	    case KW_TOUCH:
            	    case KW_TRANSACTIONS:
            	    case KW_TRIGGER:
            	    case KW_TRUE:
            	    case KW_TRUNCATE:
            	    case KW_UNARCHIVE:
            	    case KW_UNDO:
            	    case KW_UNION:
            	    case KW_UNIONTYPE:
            	    case KW_UNLOCK:
            	    case KW_UNSET:
            	    case KW_UNSIGNED:
            	    case KW_UPDATE:
            	    case KW_URI:
            	    case KW_USE:
            	    case KW_USER:
            	    case KW_USING:
            	    case KW_UTC:
            	    case KW_UTCTIMESTAMP:
            	    case KW_VALUES:
            	    case KW_VIEW:
            	    case KW_WHILE:
            	    case KW_WITH:
            	    case KW_YEAR:
            	        {
            	        alt102=4;
            	        }
            	        break;
            	    default:
            	        if (state.backtracking>0) {state.failed=true; return retval;}
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 102, 0, input);

            	        throw nvae;

            	    }

            	    switch (alt102) {
            	        case 1 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1350:4: ( KW_ELEM_TYPE )=> KW_ELEM_TYPE
            	            {
            	            KW_ELEM_TYPE367=(Token)match(input,KW_ELEM_TYPE,FOLLOW_KW_ELEM_TYPE_in_tabTypeExpr6421); if (state.failed) return retval;
            	            if ( state.backtracking==0 ) {
            	            KW_ELEM_TYPE367_tree = 
            	            (CommonTree)adaptor.create(KW_ELEM_TYPE367)
            	            ;
            	            adaptor.addChild(root_0, KW_ELEM_TYPE367_tree);
            	            }

            	            }
            	            break;
            	        case 2 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1352:4: ( KW_KEY_TYPE )=> KW_KEY_TYPE
            	            {
            	            KW_KEY_TYPE368=(Token)match(input,KW_KEY_TYPE,FOLLOW_KW_KEY_TYPE_in_tabTypeExpr6438); if (state.failed) return retval;
            	            if ( state.backtracking==0 ) {
            	            KW_KEY_TYPE368_tree = 
            	            (CommonTree)adaptor.create(KW_KEY_TYPE368)
            	            ;
            	            adaptor.addChild(root_0, KW_KEY_TYPE368_tree);
            	            }

            	            }
            	            break;
            	        case 3 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1354:4: ( KW_VALUE_TYPE )=> KW_VALUE_TYPE
            	            {
            	            KW_VALUE_TYPE369=(Token)match(input,KW_VALUE_TYPE,FOLLOW_KW_VALUE_TYPE_in_tabTypeExpr6455); if (state.failed) return retval;
            	            if ( state.backtracking==0 ) {
            	            KW_VALUE_TYPE369_tree = 
            	            (CommonTree)adaptor.create(KW_VALUE_TYPE369)
            	            ;
            	            adaptor.addChild(root_0, KW_VALUE_TYPE369_tree);
            	            }

            	            }
            	            break;
            	        case 4 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1355:6: identifier
            	            {
            	            pushFollow(FOLLOW_identifier_in_tabTypeExpr6463);
            	            identifier370=identifier();

            	            state._fsp--;
            	            if (state.failed) return retval;
            	            if ( state.backtracking==0 ) adaptor.addChild(root_0, identifier370.getTree());

            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop103;
                }
            } while (true);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1356:8: ( identifier )?
            int alt104=2;
            switch ( input.LA(1) ) {
                case Identifier:
                case KW_ADD:
                case KW_ADMIN:
                case KW_AFTER:
                case KW_ALL:
                case KW_ALTER:
                case KW_ANALYZE:
                case KW_ARCHIVE:
                case KW_ARRAY:
                case KW_AS:
                case KW_ASC:
                case KW_AUTHORIZATION:
                case KW_BEFORE:
                case KW_BETWEEN:
                case KW_BIGINT:
                case KW_BINARY:
                case KW_BOOLEAN:
                case KW_BOTH:
                case KW_BUCKET:
                case KW_BUCKETS:
                case KW_BY:
                case KW_CASCADE:
                case KW_CHANGE:
                case KW_CLUSTER:
                case KW_CLUSTERED:
                case KW_CLUSTERSTATUS:
                case KW_COLLECTION:
                case KW_COLUMNS:
                case KW_COMMENT:
                case KW_COMPACT:
                case KW_COMPACTIONS:
                case KW_COMPUTE:
                case KW_CONCATENATE:
                case KW_CONTINUE:
                case KW_CREATE:
                case KW_CUBE:
                case KW_CURRENT_DATE:
                case KW_CURRENT_TIMESTAMP:
                case KW_CURSOR:
                case KW_DATA:
                case KW_DATABASES:
                case KW_DATE:
                case KW_DATETIME:
                case KW_DAY:
                case KW_DBPROPERTIES:
                case KW_DECIMAL:
                case KW_DEFERRED:
                case KW_DEFINED:
                case KW_DELETE:
                case KW_DELIMITED:
                case KW_DEPENDENCY:
                case KW_DESC:
                case KW_DESCRIBE:
                case KW_DIRECTORIES:
                case KW_DIRECTORY:
                case KW_DISABLE:
                case KW_DISTRIBUTE:
                case KW_DOUBLE:
                case KW_DROP:
                case KW_ELEM_TYPE:
                case KW_ENABLE:
                case KW_ESCAPED:
                case KW_EXCLUSIVE:
                case KW_EXISTS:
                case KW_EXPLAIN:
                case KW_EXPORT:
                case KW_EXTERNAL:
                case KW_FALSE:
                case KW_FETCH:
                case KW_FIELDS:
                case KW_FILE:
                case KW_FILEFORMAT:
                case KW_FIRST:
                case KW_FLOAT:
                case KW_FOR:
                case KW_FORMAT:
                case KW_FORMATTED:
                case KW_FULL:
                case KW_FUNCTIONS:
                case KW_GRANT:
                case KW_GROUP:
                case KW_GROUPING:
                case KW_HOLD_DDLTIME:
                case KW_HOUR:
                case KW_IDXPROPERTIES:
                case KW_IGNORE:
                case KW_IMPORT:
                case KW_IN:
                case KW_INDEX:
                case KW_INDEXES:
                case KW_INNER:
                case KW_INPATH:
                case KW_INPUTDRIVER:
                case KW_INPUTFORMAT:
                case KW_INSERT:
                case KW_INT:
                case KW_INTERSECT:
                case KW_INTO:
                case KW_IS:
                case KW_ITEMS:
                case KW_JAR:
                case KW_KEYS:
                case KW_KEY_TYPE:
                case KW_LATERAL:
                case KW_LEFT:
                case KW_LIKE:
                case KW_LIMIT:
                case KW_LINES:
                case KW_LOAD:
                case KW_LOCAL:
                case KW_LOCATION:
                case KW_LOCK:
                case KW_LOCKS:
                case KW_LOGICAL:
                case KW_LONG:
                case KW_MAPJOIN:
                case KW_MATERIALIZED:
                case KW_METADATA:
                case KW_MINUS:
                case KW_MINUTE:
                case KW_MONTH:
                case KW_MSCK:
                case KW_NONE:
                case KW_NOSCAN:
                case KW_NO_DROP:
                case KW_NULL:
                case KW_OF:
                case KW_OFFLINE:
                case KW_OPTION:
                case KW_ORDER:
                case KW_OUT:
                case KW_OUTER:
                case KW_OUTPUTDRIVER:
                case KW_OUTPUTFORMAT:
                case KW_OVERWRITE:
                case KW_OWNER:
                case KW_PARTITIONED:
                case KW_PARTITIONS:
                case KW_PERCENT:
                case KW_PLUS:
                case KW_PRETTY:
                case KW_PRINCIPALS:
                case KW_PROCEDURE:
                case KW_PROTECTION:
                case KW_PURGE:
                case KW_RANGE:
                case KW_READ:
                case KW_READONLY:
                case KW_READS:
                case KW_REBUILD:
                case KW_RECORDREADER:
                case KW_RECORDWRITER:
                case KW_REGEXP:
                case KW_RELOAD:
                case KW_RENAME:
                case KW_REPAIR:
                case KW_REPLACE:
                case KW_REPLICATION:
                case KW_RESTRICT:
                case KW_REVOKE:
                case KW_REWRITE:
                case KW_RIGHT:
                case KW_RLIKE:
                case KW_ROLE:
                case KW_ROLES:
                case KW_ROLLUP:
                case KW_ROW:
                case KW_ROWS:
                case KW_SCHEMA:
                case KW_SCHEMAS:
                case KW_SECOND:
                case KW_SEMI:
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                case KW_SERVER:
                case KW_SET:
                case KW_SETS:
                case KW_SHARED:
                case KW_SHOW:
                case KW_SHOW_DATABASE:
                case KW_SKEWED:
                case KW_SMALLINT:
                case KW_SORT:
                case KW_SORTED:
                case KW_SSL:
                case KW_STATISTICS:
                case KW_STORED:
                case KW_STREAMTABLE:
                case KW_STRING:
                case KW_STRUCT:
                case KW_TABLE:
                case KW_TABLES:
                case KW_TBLPROPERTIES:
                case KW_TEMPORARY:
                case KW_TERMINATED:
                case KW_TIMESTAMP:
                case KW_TINYINT:
                case KW_TO:
                case KW_TOUCH:
                case KW_TRANSACTIONS:
                case KW_TRIGGER:
                case KW_TRUE:
                case KW_TRUNCATE:
                case KW_UNARCHIVE:
                case KW_UNDO:
                case KW_UNION:
                case KW_UNIONTYPE:
                case KW_UNLOCK:
                case KW_UNSET:
                case KW_UNSIGNED:
                case KW_UPDATE:
                case KW_URI:
                case KW_USE:
                case KW_USER:
                case KW_USING:
                case KW_UTC:
                case KW_UTCTIMESTAMP:
                case KW_VALUES:
                case KW_VALUE_TYPE:
                case KW_VIEW:
                case KW_WHILE:
                case KW_WITH:
                case KW_YEAR:
                    {
                    alt104=1;
                    }
                    break;
                case KW_PARTITION:
                    {
                    switch ( input.LA(2) ) {
                        case EOF:
                        case KW_EXTENDED:
                        case KW_PARTITION:
                            {
                            alt104=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt104) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1356:8: identifier
                    {
                    pushFollow(FOLLOW_identifier_in_tabTypeExpr6472);
                    identifier371=identifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, identifier371.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "tabTypeExpr"


    public static class partTypeExpr_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "partTypeExpr"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1359:1: partTypeExpr : tabTypeExpr ( partitionSpec )? -> ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? ) ;
    public final HiveParser.partTypeExpr_return partTypeExpr() throws RecognitionException {
        HiveParser.partTypeExpr_return retval = new HiveParser.partTypeExpr_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.tabTypeExpr_return tabTypeExpr372 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec373 =null;


        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_tabTypeExpr=new RewriteRuleSubtreeStream(adaptor,"rule tabTypeExpr");
         pushMsg("specifying table partitions", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1362:5: ( tabTypeExpr ( partitionSpec )? -> ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1362:8: tabTypeExpr ( partitionSpec )?
            {
            pushFollow(FOLLOW_tabTypeExpr_in_partTypeExpr6500);
            tabTypeExpr372=tabTypeExpr();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tabTypeExpr.add(tabTypeExpr372.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1362:20: ( partitionSpec )?
            int alt105=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt105=1;
                    }
                    break;
            }

            switch (alt105) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1362:20: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_partTypeExpr6502);
                    partitionSpec373=partitionSpec();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_partitionSpec.add(partitionSpec373.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: partitionSpec, tabTypeExpr
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1362:35: -> ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1362:38: ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABTYPE, "TOK_TABTYPE")
                , root_1);

                adaptor.addChild(root_1, stream_tabTypeExpr.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1362:64: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "partTypeExpr"


    public static class descStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "descStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1365:1: descStatement : ( KW_DESCRIBE | KW_DESC ) ( ( KW_DATABASE | KW_SCHEMA )=> ( KW_DATABASE | KW_SCHEMA ) ( KW_EXTENDED )? (dbName= identifier ) -> ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? ) | ( KW_FUNCTION )=> KW_FUNCTION ( KW_EXTENDED )? (name= descFuncNames ) -> ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? ) | ( KW_FORMATTED | KW_EXTENDED | KW_PRETTY )=> ( (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY ) parttype= partTypeExpr ) -> ^( TOK_DESCTABLE $parttype $descOptions) |parttype= partTypeExpr -> ^( TOK_DESCTABLE $parttype) ) ;
    public final HiveParser.descStatement_return descStatement() throws RecognitionException {
        HiveParser.descStatement_return retval = new HiveParser.descStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token descOptions=null;
        Token KW_DESCRIBE374=null;
        Token KW_DESC375=null;
        Token KW_DATABASE376=null;
        Token KW_SCHEMA377=null;
        Token KW_EXTENDED378=null;
        Token KW_FUNCTION379=null;
        Token KW_EXTENDED380=null;
        HiveParser_IdentifiersParser.identifier_return dbName =null;

        HiveParser_IdentifiersParser.descFuncNames_return name =null;

        HiveParser.partTypeExpr_return parttype =null;


        CommonTree descOptions_tree=null;
        CommonTree KW_DESCRIBE374_tree=null;
        CommonTree KW_DESC375_tree=null;
        CommonTree KW_DATABASE376_tree=null;
        CommonTree KW_SCHEMA377_tree=null;
        CommonTree KW_EXTENDED378_tree=null;
        CommonTree KW_FUNCTION379_tree=null;
        CommonTree KW_EXTENDED380_tree=null;
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_PRETTY=new RewriteRuleTokenStream(adaptor,"token KW_PRETTY");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_EXTENDED=new RewriteRuleTokenStream(adaptor,"token KW_EXTENDED");
        RewriteRuleTokenStream stream_KW_DESC=new RewriteRuleTokenStream(adaptor,"token KW_DESC");
        RewriteRuleTokenStream stream_KW_FUNCTION=new RewriteRuleTokenStream(adaptor,"token KW_FUNCTION");
        RewriteRuleTokenStream stream_KW_FORMATTED=new RewriteRuleTokenStream(adaptor,"token KW_FORMATTED");
        RewriteRuleTokenStream stream_KW_DESCRIBE=new RewriteRuleTokenStream(adaptor,"token KW_DESCRIBE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_partTypeExpr=new RewriteRuleSubtreeStream(adaptor,"rule partTypeExpr");
        RewriteRuleSubtreeStream stream_descFuncNames=new RewriteRuleSubtreeStream(adaptor,"rule descFuncNames");
         pushMsg("describe statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1368:5: ( ( KW_DESCRIBE | KW_DESC ) ( ( KW_DATABASE | KW_SCHEMA )=> ( KW_DATABASE | KW_SCHEMA ) ( KW_EXTENDED )? (dbName= identifier ) -> ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? ) | ( KW_FUNCTION )=> KW_FUNCTION ( KW_EXTENDED )? (name= descFuncNames ) -> ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? ) | ( KW_FORMATTED | KW_EXTENDED | KW_PRETTY )=> ( (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY ) parttype= partTypeExpr ) -> ^( TOK_DESCTABLE $parttype $descOptions) |parttype= partTypeExpr -> ^( TOK_DESCTABLE $parttype) ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1369:5: ( KW_DESCRIBE | KW_DESC ) ( ( KW_DATABASE | KW_SCHEMA )=> ( KW_DATABASE | KW_SCHEMA ) ( KW_EXTENDED )? (dbName= identifier ) -> ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? ) | ( KW_FUNCTION )=> KW_FUNCTION ( KW_EXTENDED )? (name= descFuncNames ) -> ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? ) | ( KW_FORMATTED | KW_EXTENDED | KW_PRETTY )=> ( (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY ) parttype= partTypeExpr ) -> ^( TOK_DESCTABLE $parttype $descOptions) |parttype= partTypeExpr -> ^( TOK_DESCTABLE $parttype) )
            {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1369:5: ( KW_DESCRIBE | KW_DESC )
            int alt106=2;
            switch ( input.LA(1) ) {
            case KW_DESCRIBE:
                {
                alt106=1;
                }
                break;
            case KW_DESC:
                {
                alt106=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 106, 0, input);

                throw nvae;

            }

            switch (alt106) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1369:6: KW_DESCRIBE
                    {
                    KW_DESCRIBE374=(Token)match(input,KW_DESCRIBE,FOLLOW_KW_DESCRIBE_in_descStatement6546); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_DESCRIBE.add(KW_DESCRIBE374);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1369:18: KW_DESC
                    {
                    KW_DESC375=(Token)match(input,KW_DESC,FOLLOW_KW_DESC_in_descStatement6548); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_DESC.add(KW_DESC375);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1370:5: ( ( KW_DATABASE | KW_SCHEMA )=> ( KW_DATABASE | KW_SCHEMA ) ( KW_EXTENDED )? (dbName= identifier ) -> ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? ) | ( KW_FUNCTION )=> KW_FUNCTION ( KW_EXTENDED )? (name= descFuncNames ) -> ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? ) | ( KW_FORMATTED | KW_EXTENDED | KW_PRETTY )=> ( (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY ) parttype= partTypeExpr ) -> ^( TOK_DESCTABLE $parttype $descOptions) |parttype= partTypeExpr -> ^( TOK_DESCTABLE $parttype) )
            int alt111=4;
            alt111 = dfa111.predict(input);
            switch (alt111) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1371:5: ( KW_DATABASE | KW_SCHEMA )=> ( KW_DATABASE | KW_SCHEMA ) ( KW_EXTENDED )? (dbName= identifier )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1371:32: ( KW_DATABASE | KW_SCHEMA )
                    int alt107=2;
                    switch ( input.LA(1) ) {
                    case KW_DATABASE:
                        {
                        alt107=1;
                        }
                        break;
                    case KW_SCHEMA:
                        {
                        alt107=2;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 107, 0, input);

                        throw nvae;

                    }

                    switch (alt107) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1371:33: KW_DATABASE
                            {
                            KW_DATABASE376=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_descStatement6570); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_DATABASE.add(KW_DATABASE376);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1371:45: KW_SCHEMA
                            {
                            KW_SCHEMA377=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_descStatement6572); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_SCHEMA.add(KW_SCHEMA377);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1371:56: ( KW_EXTENDED )?
                    int alt108=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTENDED:
                            {
                            alt108=1;
                            }
                            break;
                    }

                    switch (alt108) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1371:56: KW_EXTENDED
                            {
                            KW_EXTENDED378=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_descStatement6575); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_EXTENDED.add(KW_EXTENDED378);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1371:69: (dbName= identifier )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1371:70: dbName= identifier
                    {
                    pushFollow(FOLLOW_identifier_in_descStatement6581);
                    dbName=identifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_identifier.add(dbName.getTree());

                    }


                    // AST REWRITE
                    // elements: dbName, KW_EXTENDED
                    // token labels: 
                    // rule labels: dbName, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_dbName=new RewriteRuleSubtreeStream(adaptor,"rule dbName",dbName!=null?dbName.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1371:89: -> ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1371:92: ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DESCDATABASE, "TOK_DESCDATABASE")
                        , root_1);

                        adaptor.addChild(root_1, stream_dbName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1371:119: ( KW_EXTENDED )?
                        if ( stream_KW_EXTENDED.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_KW_EXTENDED.nextNode()
                            );

                        }
                        stream_KW_EXTENDED.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1373:5: ( KW_FUNCTION )=> KW_FUNCTION ( KW_EXTENDED )? (name= descFuncNames )
                    {
                    KW_FUNCTION379=(Token)match(input,KW_FUNCTION,FOLLOW_KW_FUNCTION_in_descStatement6612); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_FUNCTION.add(KW_FUNCTION379);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1373:34: ( KW_EXTENDED )?
                    int alt109=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTENDED:
                            {
                            alt109=1;
                            }
                            break;
                    }

                    switch (alt109) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1373:34: KW_EXTENDED
                            {
                            KW_EXTENDED380=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_descStatement6614); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_EXTENDED.add(KW_EXTENDED380);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1373:47: (name= descFuncNames )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1373:48: name= descFuncNames
                    {
                    pushFollow(FOLLOW_descFuncNames_in_descStatement6620);
                    name=descFuncNames();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_descFuncNames.add(name.getTree());

                    }


                    // AST REWRITE
                    // elements: KW_EXTENDED, name
                    // token labels: 
                    // rule labels: name, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1373:68: -> ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1373:71: ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DESCFUNCTION, "TOK_DESCFUNCTION")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1373:96: ( KW_EXTENDED )?
                        if ( stream_KW_EXTENDED.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_KW_EXTENDED.nextNode()
                            );

                        }
                        stream_KW_EXTENDED.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1375:5: ( KW_FORMATTED | KW_EXTENDED | KW_PRETTY )=> ( (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY ) parttype= partTypeExpr )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1375:45: ( (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY ) parttype= partTypeExpr )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1375:46: (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY ) parttype= partTypeExpr
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1375:46: (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY )
                    int alt110=3;
                    switch ( input.LA(1) ) {
                    case KW_FORMATTED:
                        {
                        alt110=1;
                        }
                        break;
                    case KW_EXTENDED:
                        {
                        alt110=2;
                        }
                        break;
                    case KW_PRETTY:
                        {
                        alt110=3;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 110, 0, input);

                        throw nvae;

                    }

                    switch (alt110) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1375:47: descOptions= KW_FORMATTED
                            {
                            descOptions=(Token)match(input,KW_FORMATTED,FOLLOW_KW_FORMATTED_in_descStatement6659); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_FORMATTED.add(descOptions);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1375:72: descOptions= KW_EXTENDED
                            {
                            descOptions=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_descStatement6663); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_EXTENDED.add(descOptions);


                            }
                            break;
                        case 3 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1375:96: descOptions= KW_PRETTY
                            {
                            descOptions=(Token)match(input,KW_PRETTY,FOLLOW_KW_PRETTY_in_descStatement6667); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_PRETTY.add(descOptions);


                            }
                            break;

                    }


                    pushFollow(FOLLOW_partTypeExpr_in_descStatement6672);
                    parttype=partTypeExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_partTypeExpr.add(parttype.getTree());

                    }


                    // AST REWRITE
                    // elements: parttype, descOptions
                    // token labels: descOptions
                    // rule labels: parttype, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_descOptions=new RewriteRuleTokenStream(adaptor,"token descOptions",descOptions);
                    RewriteRuleSubtreeStream stream_parttype=new RewriteRuleSubtreeStream(adaptor,"rule parttype",parttype!=null?parttype.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1375:142: -> ^( TOK_DESCTABLE $parttype $descOptions)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1375:145: ^( TOK_DESCTABLE $parttype $descOptions)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DESCTABLE, "TOK_DESCTABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_parttype.nextTree());

                        adaptor.addChild(root_1, stream_descOptions.nextNode());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1377:5: parttype= partTypeExpr
                    {
                    pushFollow(FOLLOW_partTypeExpr_in_descStatement6699);
                    parttype=partTypeExpr();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_partTypeExpr.add(parttype.getTree());

                    // AST REWRITE
                    // elements: parttype
                    // token labels: 
                    // rule labels: parttype, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_parttype=new RewriteRuleSubtreeStream(adaptor,"rule parttype",parttype!=null?parttype.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1377:27: -> ^( TOK_DESCTABLE $parttype)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1377:30: ^( TOK_DESCTABLE $parttype)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DESCTABLE, "TOK_DESCTABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_parttype.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "descStatement"


    public static class analyzeStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "analyzeStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1381:1: analyzeStatement : KW_ANALYZE KW_TABLE (parttype= tableOrPartition ) KW_COMPUTE KW_STATISTICS ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS (statsColumnName= columnNameList )? ) )? -> ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( KW_COLUMNS )? ( $statsColumnName)? ) ;
    public final HiveParser.analyzeStatement_return analyzeStatement() throws RecognitionException {
        HiveParser.analyzeStatement_return retval = new HiveParser.analyzeStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token noscan=null;
        Token partialscan=null;
        Token KW_ANALYZE381=null;
        Token KW_TABLE382=null;
        Token KW_COMPUTE383=null;
        Token KW_STATISTICS384=null;
        Token KW_FOR385=null;
        Token KW_COLUMNS386=null;
        HiveParser_IdentifiersParser.tableOrPartition_return parttype =null;

        HiveParser.columnNameList_return statsColumnName =null;


        CommonTree noscan_tree=null;
        CommonTree partialscan_tree=null;
        CommonTree KW_ANALYZE381_tree=null;
        CommonTree KW_TABLE382_tree=null;
        CommonTree KW_COMPUTE383_tree=null;
        CommonTree KW_STATISTICS384_tree=null;
        CommonTree KW_FOR385_tree=null;
        CommonTree KW_COLUMNS386_tree=null;
        RewriteRuleTokenStream stream_KW_STATISTICS=new RewriteRuleTokenStream(adaptor,"token KW_STATISTICS");
        RewriteRuleTokenStream stream_KW_ANALYZE=new RewriteRuleTokenStream(adaptor,"token KW_ANALYZE");
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_KW_FOR=new RewriteRuleTokenStream(adaptor,"token KW_FOR");
        RewriteRuleTokenStream stream_KW_PARTIALSCAN=new RewriteRuleTokenStream(adaptor,"token KW_PARTIALSCAN");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_COMPUTE=new RewriteRuleTokenStream(adaptor,"token KW_COMPUTE");
        RewriteRuleTokenStream stream_KW_NOSCAN=new RewriteRuleTokenStream(adaptor,"token KW_NOSCAN");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
         pushMsg("analyze statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:5: ( KW_ANALYZE KW_TABLE (parttype= tableOrPartition ) KW_COMPUTE KW_STATISTICS ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS (statsColumnName= columnNameList )? ) )? -> ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( KW_COLUMNS )? ( $statsColumnName)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:7: KW_ANALYZE KW_TABLE (parttype= tableOrPartition ) KW_COMPUTE KW_STATISTICS ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS (statsColumnName= columnNameList )? ) )?
            {
            KW_ANALYZE381=(Token)match(input,KW_ANALYZE,FOLLOW_KW_ANALYZE_in_analyzeStatement6741); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_ANALYZE.add(KW_ANALYZE381);


            KW_TABLE382=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_analyzeStatement6743); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TABLE.add(KW_TABLE382);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:27: (parttype= tableOrPartition )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:28: parttype= tableOrPartition
            {
            pushFollow(FOLLOW_tableOrPartition_in_analyzeStatement6748);
            parttype=tableOrPartition();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableOrPartition.add(parttype.getTree());

            }


            KW_COMPUTE383=(Token)match(input,KW_COMPUTE,FOLLOW_KW_COMPUTE_in_analyzeStatement6751); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_COMPUTE.add(KW_COMPUTE383);


            KW_STATISTICS384=(Token)match(input,KW_STATISTICS,FOLLOW_KW_STATISTICS_in_analyzeStatement6753); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_STATISTICS.add(KW_STATISTICS384);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:80: ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS (statsColumnName= columnNameList )? ) )?
            int alt113=4;
            switch ( input.LA(1) ) {
                case KW_NOSCAN:
                    {
                    alt113=1;
                    }
                    break;
                case KW_PARTIALSCAN:
                    {
                    alt113=2;
                    }
                    break;
                case KW_FOR:
                    {
                    alt113=3;
                    }
                    break;
            }

            switch (alt113) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:81: (noscan= KW_NOSCAN )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:81: (noscan= KW_NOSCAN )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:82: noscan= KW_NOSCAN
                    {
                    noscan=(Token)match(input,KW_NOSCAN,FOLLOW_KW_NOSCAN_in_analyzeStatement6759); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_NOSCAN.add(noscan);


                    }


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:102: (partialscan= KW_PARTIALSCAN )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:102: (partialscan= KW_PARTIALSCAN )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1384:103: partialscan= KW_PARTIALSCAN
                    {
                    partialscan=(Token)match(input,KW_PARTIALSCAN,FOLLOW_KW_PARTIALSCAN_in_analyzeStatement6767); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_PARTIALSCAN.add(partialscan);


                    }


                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1385:57: ( KW_FOR KW_COLUMNS (statsColumnName= columnNameList )? )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1385:57: ( KW_FOR KW_COLUMNS (statsColumnName= columnNameList )? )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1385:58: KW_FOR KW_COLUMNS (statsColumnName= columnNameList )?
                    {
                    KW_FOR385=(Token)match(input,KW_FOR,FOLLOW_KW_FOR_in_analyzeStatement6828); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_FOR.add(KW_FOR385);


                    KW_COLUMNS386=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_analyzeStatement6830); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_COLUMNS.add(KW_COLUMNS386);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1385:76: (statsColumnName= columnNameList )?
                    int alt112=2;
                    switch ( input.LA(1) ) {
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_AUTHORIZATION:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURRENT_DATE:
                        case KW_CURRENT_TIMESTAMP:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DAY:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_HOUR:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIKE:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_METADATA:
                        case KW_MINUS:
                        case KW_MINUTE:
                        case KW_MONTH:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RELOAD:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_REPLICATION:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_REWRITE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SECOND:
                        case KW_SEMI:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SERVER:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_URI:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUES:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                        case KW_YEAR:
                            {
                            alt112=1;
                            }
                            break;
                    }

                    switch (alt112) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1385:77: statsColumnName= columnNameList
                            {
                            pushFollow(FOLLOW_columnNameList_in_analyzeStatement6835);
                            statsColumnName=columnNameList();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_columnNameList.add(statsColumnName.getTree());

                            }
                            break;

                    }


                    }


                    }
                    break;

            }


            // AST REWRITE
            // elements: statsColumnName, partialscan, KW_COLUMNS, parttype, noscan
            // token labels: partialscan, noscan
            // rule labels: statsColumnName, parttype, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_partialscan=new RewriteRuleTokenStream(adaptor,"token partialscan",partialscan);
            RewriteRuleTokenStream stream_noscan=new RewriteRuleTokenStream(adaptor,"token noscan",noscan);
            RewriteRuleSubtreeStream stream_statsColumnName=new RewriteRuleSubtreeStream(adaptor,"rule statsColumnName",statsColumnName!=null?statsColumnName.tree:null);
            RewriteRuleSubtreeStream stream_parttype=new RewriteRuleSubtreeStream(adaptor,"rule parttype",parttype!=null?parttype.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1386:7: -> ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( KW_COLUMNS )? ( $statsColumnName)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1386:10: ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( KW_COLUMNS )? ( $statsColumnName)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ANALYZE, "TOK_ANALYZE")
                , root_1);

                adaptor.addChild(root_1, stream_parttype.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1386:35: ( $noscan)?
                if ( stream_noscan.hasNext() ) {
                    adaptor.addChild(root_1, stream_noscan.nextNode());

                }
                stream_noscan.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1386:44: ( $partialscan)?
                if ( stream_partialscan.hasNext() ) {
                    adaptor.addChild(root_1, stream_partialscan.nextNode());

                }
                stream_partialscan.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1386:57: ( KW_COLUMNS )?
                if ( stream_KW_COLUMNS.hasNext() ) {
                    adaptor.addChild(root_1, 
                    stream_KW_COLUMNS.nextNode()
                    );

                }
                stream_KW_COLUMNS.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1386:70: ( $statsColumnName)?
                if ( stream_statsColumnName.hasNext() ) {
                    adaptor.addChild(root_1, stream_statsColumnName.nextTree());

                }
                stream_statsColumnName.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "analyzeStatement"


    public static class showStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1389:1: showStatement : ( KW_SHOW ( KW_DATABASES | KW_SCHEMAS ) ( KW_LIKE showStmtIdentifier )? -> ^( TOK_SHOWDATABASES ( showStmtIdentifier )? ) | KW_SHOW KW_TABLES ( ( KW_FROM | KW_IN ) db_name= identifier )? ( KW_LIKE showStmtIdentifier | showStmtIdentifier )? -> ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? ) | KW_SHOW KW_COLUMNS ( KW_FROM | KW_IN ) tableName ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWCOLUMNS tableName ( $db_name)? ) | KW_SHOW KW_FUNCTIONS ( KW_LIKE showFunctionIdentifier | showFunctionIdentifier )? -> ^( TOK_SHOWFUNCTIONS ( KW_LIKE )? ( showFunctionIdentifier )? ) | KW_SHOW KW_PARTITIONS tabName= tableName ( partitionSpec )? -> ^( TOK_SHOWPARTITIONS $tabName ( partitionSpec )? ) | KW_SHOW KW_CREATE KW_TABLE tabName= tableName -> ^( TOK_SHOW_CREATETABLE $tabName) | KW_SHOW KW_TABLE KW_EXTENDED ( ( KW_FROM | KW_IN ) db_name= identifier )? KW_LIKE showStmtIdentifier ( partitionSpec )? -> ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? ) | KW_SHOW KW_TBLPROPERTIES tableName ( LPAREN prptyName= StringLiteral RPAREN )? -> ^( TOK_SHOW_TBLPROPERTIES tableName ( $prptyName)? ) | KW_SHOW KW_LOCKS ( ( KW_DATABASE | KW_SCHEMA )=> ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWDBLOCKS $dbName ( $isExtended)? ) | (parttype= partTypeExpr )? (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? ) ) | KW_SHOW (showOptions= KW_FORMATTED )? ( KW_INDEX | KW_INDEXES ) KW_ON showStmtIdentifier ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? ) | KW_SHOW KW_COMPACTIONS -> ^( TOK_SHOW_COMPACTIONS ) | KW_SHOW KW_TRANSACTIONS -> ^( TOK_SHOW_TRANSACTIONS ) | KW_SHOW KW_CONF StringLiteral -> ^( TOK_SHOWCONF StringLiteral ) );
    public final HiveParser.showStatement_return showStatement() throws RecognitionException {
        HiveParser.showStatement_return retval = new HiveParser.showStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token prptyName=null;
        Token dbName=null;
        Token isExtended=null;
        Token showOptions=null;
        Token KW_SHOW387=null;
        Token KW_DATABASES388=null;
        Token KW_SCHEMAS389=null;
        Token KW_LIKE390=null;
        Token KW_SHOW392=null;
        Token KW_TABLES393=null;
        Token KW_FROM394=null;
        Token KW_IN395=null;
        Token KW_LIKE396=null;
        Token KW_SHOW399=null;
        Token KW_COLUMNS400=null;
        Token KW_FROM401=null;
        Token KW_IN402=null;
        Token KW_FROM404=null;
        Token KW_IN405=null;
        Token KW_SHOW406=null;
        Token KW_FUNCTIONS407=null;
        Token KW_LIKE408=null;
        Token KW_SHOW411=null;
        Token KW_PARTITIONS412=null;
        Token KW_SHOW414=null;
        Token KW_CREATE415=null;
        Token KW_TABLE416=null;
        Token KW_SHOW417=null;
        Token KW_TABLE418=null;
        Token KW_EXTENDED419=null;
        Token KW_FROM420=null;
        Token KW_IN421=null;
        Token KW_LIKE422=null;
        Token KW_SHOW425=null;
        Token KW_TBLPROPERTIES426=null;
        Token LPAREN428=null;
        Token RPAREN429=null;
        Token KW_SHOW430=null;
        Token KW_LOCKS431=null;
        Token KW_DATABASE432=null;
        Token KW_SCHEMA433=null;
        Token KW_SHOW434=null;
        Token KW_INDEX435=null;
        Token KW_INDEXES436=null;
        Token KW_ON437=null;
        Token KW_FROM439=null;
        Token KW_IN440=null;
        Token KW_SHOW441=null;
        Token KW_COMPACTIONS442=null;
        Token KW_SHOW443=null;
        Token KW_TRANSACTIONS444=null;
        Token KW_SHOW445=null;
        Token KW_CONF446=null;
        Token StringLiteral447=null;
        HiveParser_IdentifiersParser.identifier_return db_name =null;

        HiveParser_FromClauseParser.tableName_return tabName =null;

        HiveParser.partTypeExpr_return parttype =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier391 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier397 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier398 =null;

        HiveParser_FromClauseParser.tableName_return tableName403 =null;

        HiveParser.showFunctionIdentifier_return showFunctionIdentifier409 =null;

        HiveParser.showFunctionIdentifier_return showFunctionIdentifier410 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec413 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier423 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec424 =null;

        HiveParser_FromClauseParser.tableName_return tableName427 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier438 =null;


        CommonTree prptyName_tree=null;
        CommonTree dbName_tree=null;
        CommonTree isExtended_tree=null;
        CommonTree showOptions_tree=null;
        CommonTree KW_SHOW387_tree=null;
        CommonTree KW_DATABASES388_tree=null;
        CommonTree KW_SCHEMAS389_tree=null;
        CommonTree KW_LIKE390_tree=null;
        CommonTree KW_SHOW392_tree=null;
        CommonTree KW_TABLES393_tree=null;
        CommonTree KW_FROM394_tree=null;
        CommonTree KW_IN395_tree=null;
        CommonTree KW_LIKE396_tree=null;
        CommonTree KW_SHOW399_tree=null;
        CommonTree KW_COLUMNS400_tree=null;
        CommonTree KW_FROM401_tree=null;
        CommonTree KW_IN402_tree=null;
        CommonTree KW_FROM404_tree=null;
        CommonTree KW_IN405_tree=null;
        CommonTree KW_SHOW406_tree=null;
        CommonTree KW_FUNCTIONS407_tree=null;
        CommonTree KW_LIKE408_tree=null;
        CommonTree KW_SHOW411_tree=null;
        CommonTree KW_PARTITIONS412_tree=null;
        CommonTree KW_SHOW414_tree=null;
        CommonTree KW_CREATE415_tree=null;
        CommonTree KW_TABLE416_tree=null;
        CommonTree KW_SHOW417_tree=null;
        CommonTree KW_TABLE418_tree=null;
        CommonTree KW_EXTENDED419_tree=null;
        CommonTree KW_FROM420_tree=null;
        CommonTree KW_IN421_tree=null;
        CommonTree KW_LIKE422_tree=null;
        CommonTree KW_SHOW425_tree=null;
        CommonTree KW_TBLPROPERTIES426_tree=null;
        CommonTree LPAREN428_tree=null;
        CommonTree RPAREN429_tree=null;
        CommonTree KW_SHOW430_tree=null;
        CommonTree KW_LOCKS431_tree=null;
        CommonTree KW_DATABASE432_tree=null;
        CommonTree KW_SCHEMA433_tree=null;
        CommonTree KW_SHOW434_tree=null;
        CommonTree KW_INDEX435_tree=null;
        CommonTree KW_INDEXES436_tree=null;
        CommonTree KW_ON437_tree=null;
        CommonTree KW_FROM439_tree=null;
        CommonTree KW_IN440_tree=null;
        CommonTree KW_SHOW441_tree=null;
        CommonTree KW_COMPACTIONS442_tree=null;
        CommonTree KW_SHOW443_tree=null;
        CommonTree KW_TRANSACTIONS444_tree=null;
        CommonTree KW_SHOW445_tree=null;
        CommonTree KW_CONF446_tree=null;
        CommonTree StringLiteral447_tree=null;
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_LIKE=new RewriteRuleTokenStream(adaptor,"token KW_LIKE");
        RewriteRuleTokenStream stream_KW_PARTITIONS=new RewriteRuleTokenStream(adaptor,"token KW_PARTITIONS");
        RewriteRuleTokenStream stream_KW_IN=new RewriteRuleTokenStream(adaptor,"token KW_IN");
        RewriteRuleTokenStream stream_KW_LOCKS=new RewriteRuleTokenStream(adaptor,"token KW_LOCKS");
        RewriteRuleTokenStream stream_Identifier=new RewriteRuleTokenStream(adaptor,"token Identifier");
        RewriteRuleTokenStream stream_KW_TABLES=new RewriteRuleTokenStream(adaptor,"token KW_TABLES");
        RewriteRuleTokenStream stream_KW_FUNCTIONS=new RewriteRuleTokenStream(adaptor,"token KW_FUNCTIONS");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_EXTENDED=new RewriteRuleTokenStream(adaptor,"token KW_EXTENDED");
        RewriteRuleTokenStream stream_KW_CONF=new RewriteRuleTokenStream(adaptor,"token KW_CONF");
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_KW_TRANSACTIONS=new RewriteRuleTokenStream(adaptor,"token KW_TRANSACTIONS");
        RewriteRuleTokenStream stream_KW_SCHEMAS=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMAS");
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleTokenStream stream_KW_FORMATTED=new RewriteRuleTokenStream(adaptor,"token KW_FORMATTED");
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_COMPACTIONS=new RewriteRuleTokenStream(adaptor,"token KW_COMPACTIONS");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_DATABASES=new RewriteRuleTokenStream(adaptor,"token KW_DATABASES");
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_INDEXES=new RewriteRuleTokenStream(adaptor,"token KW_INDEXES");
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_TBLPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_TBLPROPERTIES");
        RewriteRuleSubtreeStream stream_showStmtIdentifier=new RewriteRuleSubtreeStream(adaptor,"rule showStmtIdentifier");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_showFunctionIdentifier=new RewriteRuleSubtreeStream(adaptor,"rule showFunctionIdentifier");
        RewriteRuleSubtreeStream stream_partTypeExpr=new RewriteRuleSubtreeStream(adaptor,"rule partTypeExpr");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
         pushMsg("show statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:5: ( KW_SHOW ( KW_DATABASES | KW_SCHEMAS ) ( KW_LIKE showStmtIdentifier )? -> ^( TOK_SHOWDATABASES ( showStmtIdentifier )? ) | KW_SHOW KW_TABLES ( ( KW_FROM | KW_IN ) db_name= identifier )? ( KW_LIKE showStmtIdentifier | showStmtIdentifier )? -> ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? ) | KW_SHOW KW_COLUMNS ( KW_FROM | KW_IN ) tableName ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWCOLUMNS tableName ( $db_name)? ) | KW_SHOW KW_FUNCTIONS ( KW_LIKE showFunctionIdentifier | showFunctionIdentifier )? -> ^( TOK_SHOWFUNCTIONS ( KW_LIKE )? ( showFunctionIdentifier )? ) | KW_SHOW KW_PARTITIONS tabName= tableName ( partitionSpec )? -> ^( TOK_SHOWPARTITIONS $tabName ( partitionSpec )? ) | KW_SHOW KW_CREATE KW_TABLE tabName= tableName -> ^( TOK_SHOW_CREATETABLE $tabName) | KW_SHOW KW_TABLE KW_EXTENDED ( ( KW_FROM | KW_IN ) db_name= identifier )? KW_LIKE showStmtIdentifier ( partitionSpec )? -> ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? ) | KW_SHOW KW_TBLPROPERTIES tableName ( LPAREN prptyName= StringLiteral RPAREN )? -> ^( TOK_SHOW_TBLPROPERTIES tableName ( $prptyName)? ) | KW_SHOW KW_LOCKS ( ( KW_DATABASE | KW_SCHEMA )=> ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWDBLOCKS $dbName ( $isExtended)? ) | (parttype= partTypeExpr )? (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? ) ) | KW_SHOW (showOptions= KW_FORMATTED )? ( KW_INDEX | KW_INDEXES ) KW_ON showStmtIdentifier ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? ) | KW_SHOW KW_COMPACTIONS -> ^( TOK_SHOW_COMPACTIONS ) | KW_SHOW KW_TRANSACTIONS -> ^( TOK_SHOW_TRANSACTIONS ) | KW_SHOW KW_CONF StringLiteral -> ^( TOK_SHOWCONF StringLiteral ) )
            int alt137=13;
            switch ( input.LA(1) ) {
            case KW_SHOW:
                {
                switch ( input.LA(2) ) {
                case KW_TABLES:
                    {
                    alt137=2;
                    }
                    break;
                case KW_COLUMNS:
                    {
                    alt137=3;
                    }
                    break;
                case KW_FUNCTIONS:
                    {
                    alt137=4;
                    }
                    break;
                case KW_PARTITIONS:
                    {
                    alt137=5;
                    }
                    break;
                case KW_CREATE:
                    {
                    alt137=6;
                    }
                    break;
                case KW_TABLE:
                    {
                    alt137=7;
                    }
                    break;
                case KW_TBLPROPERTIES:
                    {
                    alt137=8;
                    }
                    break;
                case KW_LOCKS:
                    {
                    alt137=9;
                    }
                    break;
                case KW_COMPACTIONS:
                    {
                    alt137=11;
                    }
                    break;
                case KW_TRANSACTIONS:
                    {
                    alt137=12;
                    }
                    break;
                case KW_CONF:
                    {
                    alt137=13;
                    }
                    break;
                case KW_DATABASES:
                case KW_SCHEMAS:
                    {
                    alt137=1;
                    }
                    break;
                case KW_FORMATTED:
                case KW_INDEX:
                case KW_INDEXES:
                    {
                    alt137=10;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 137, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 137, 0, input);

                throw nvae;

            }

            switch (alt137) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:7: KW_SHOW ( KW_DATABASES | KW_SCHEMAS ) ( KW_LIKE showStmtIdentifier )?
                    {
                    KW_SHOW387=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6897); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW387);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:15: ( KW_DATABASES | KW_SCHEMAS )
                    int alt114=2;
                    switch ( input.LA(1) ) {
                    case KW_DATABASES:
                        {
                        alt114=1;
                        }
                        break;
                    case KW_SCHEMAS:
                        {
                        alt114=2;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 114, 0, input);

                        throw nvae;

                    }

                    switch (alt114) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:16: KW_DATABASES
                            {
                            KW_DATABASES388=(Token)match(input,KW_DATABASES,FOLLOW_KW_DATABASES_in_showStatement6900); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_DATABASES.add(KW_DATABASES388);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:29: KW_SCHEMAS
                            {
                            KW_SCHEMAS389=(Token)match(input,KW_SCHEMAS,FOLLOW_KW_SCHEMAS_in_showStatement6902); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_SCHEMAS.add(KW_SCHEMAS389);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:41: ( KW_LIKE showStmtIdentifier )?
                    int alt115=2;
                    switch ( input.LA(1) ) {
                        case KW_LIKE:
                            {
                            alt115=1;
                            }
                            break;
                    }

                    switch (alt115) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:42: KW_LIKE showStmtIdentifier
                            {
                            KW_LIKE390=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_showStatement6906); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_LIKE.add(KW_LIKE390);


                            pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6908);
                            showStmtIdentifier391=showStmtIdentifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_showStmtIdentifier.add(showStmtIdentifier391.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: showStmtIdentifier
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1392:71: -> ^( TOK_SHOWDATABASES ( showStmtIdentifier )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:74: ^( TOK_SHOWDATABASES ( showStmtIdentifier )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWDATABASES, "TOK_SHOWDATABASES")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:94: ( showStmtIdentifier )?
                        if ( stream_showStmtIdentifier.hasNext() ) {
                            adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        }
                        stream_showStmtIdentifier.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:7: KW_SHOW KW_TABLES ( ( KW_FROM | KW_IN ) db_name= identifier )? ( KW_LIKE showStmtIdentifier | showStmtIdentifier )?
                    {
                    KW_SHOW392=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6927); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW392);


                    KW_TABLES393=(Token)match(input,KW_TABLES,FOLLOW_KW_TABLES_in_showStatement6929); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_TABLES.add(KW_TABLES393);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:25: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt117=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                            {
                            alt117=1;
                            }
                            break;
                        case KW_IN:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                case KW_ADD:
                                case KW_ADMIN:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_AUTHORIZATION:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPACT:
                                case KW_COMPACTIONS:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURRENT_DATE:
                                case KW_CURRENT_TIMESTAMP:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DAY:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILE:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_HOUR:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_JAR:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_METADATA:
                                case KW_MINUS:
                                case KW_MINUTE:
                                case KW_MONTH:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_OWNER:
                                case KW_PARTITION:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PRINCIPALS:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RELOAD:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_REPLICATION:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_REWRITE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SECOND:
                                case KW_SEMI:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SERVER:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRANSACTIONS:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_URI:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUES:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                case KW_YEAR:
                                    {
                                    alt117=1;
                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    switch (alt117) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:26: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:26: ( KW_FROM | KW_IN )
                            int alt116=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt116=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt116=2;
                                }
                                break;
                            default:
                                if (state.backtracking>0) {state.failed=true; return retval;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 116, 0, input);

                                throw nvae;

                            }

                            switch (alt116) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:27: KW_FROM
                                    {
                                    KW_FROM394=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6933); if (state.failed) return retval; 
                                    if ( state.backtracking==0 ) stream_KW_FROM.add(KW_FROM394);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:35: KW_IN
                                    {
                                    KW_IN395=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6935); if (state.failed) return retval; 
                                    if ( state.backtracking==0 ) stream_KW_IN.add(KW_IN395);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement6940);
                            db_name=identifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:63: ( KW_LIKE showStmtIdentifier | showStmtIdentifier )?
                    int alt118=3;
                    switch ( input.LA(1) ) {
                        case KW_LIKE:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                case KW_ADD:
                                case KW_ADMIN:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_AUTHORIZATION:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPACT:
                                case KW_COMPACTIONS:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURRENT_DATE:
                                case KW_CURRENT_TIMESTAMP:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DAY:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILE:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_HOUR:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_JAR:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_METADATA:
                                case KW_MINUS:
                                case KW_MINUTE:
                                case KW_MONTH:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_OWNER:
                                case KW_PARTITION:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PRINCIPALS:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RELOAD:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_REPLICATION:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_REWRITE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SECOND:
                                case KW_SEMI:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SERVER:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRANSACTIONS:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_URI:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUES:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                case KW_YEAR:
                                case StringLiteral:
                                    {
                                    alt118=1;
                                    }
                                    break;
                                case EOF:
                                    {
                                    alt118=2;
                                    }
                                    break;
                            }

                            }
                            break;
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_AUTHORIZATION:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURRENT_DATE:
                        case KW_CURRENT_TIMESTAMP:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DAY:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_HOUR:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_METADATA:
                        case KW_MINUS:
                        case KW_MINUTE:
                        case KW_MONTH:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RELOAD:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_REPLICATION:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_REWRITE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SECOND:
                        case KW_SEMI:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SERVER:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_URI:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUES:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                        case KW_YEAR:
                        case StringLiteral:
                            {
                            alt118=2;
                            }
                            break;
                    }

                    switch (alt118) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:64: KW_LIKE showStmtIdentifier
                            {
                            KW_LIKE396=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_showStatement6945); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_LIKE.add(KW_LIKE396);


                            pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6947);
                            showStmtIdentifier397=showStmtIdentifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_showStmtIdentifier.add(showStmtIdentifier397.getTree());

                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:91: showStmtIdentifier
                            {
                            pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6949);
                            showStmtIdentifier398=showStmtIdentifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_showStmtIdentifier.add(showStmtIdentifier398.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: db_name, showStmtIdentifier
                    // token labels: 
                    // rule labels: db_name, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1393:113: -> ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:116: ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWTABLES, "TOK_SHOWTABLES")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:133: ( TOK_FROM $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, 
                            (CommonTree)adaptor.create(TOK_FROM, "TOK_FROM")
                            );

                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:154: ( showStmtIdentifier )?
                        if ( stream_showStmtIdentifier.hasNext() ) {
                            adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        }
                        stream_showStmtIdentifier.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1394:7: KW_SHOW KW_COLUMNS ( KW_FROM | KW_IN ) tableName ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    {
                    KW_SHOW399=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6977); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW399);


                    KW_COLUMNS400=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_showStatement6979); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_COLUMNS.add(KW_COLUMNS400);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1394:26: ( KW_FROM | KW_IN )
                    int alt119=2;
                    switch ( input.LA(1) ) {
                    case KW_FROM:
                        {
                        alt119=1;
                        }
                        break;
                    case KW_IN:
                        {
                        alt119=2;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 119, 0, input);

                        throw nvae;

                    }

                    switch (alt119) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1394:27: KW_FROM
                            {
                            KW_FROM401=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6982); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_FROM.add(KW_FROM401);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1394:35: KW_IN
                            {
                            KW_IN402=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6984); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_IN.add(KW_IN402);


                            }
                            break;

                    }


                    pushFollow(FOLLOW_tableName_in_showStatement6987);
                    tableName403=tableName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableName.add(tableName403.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1394:52: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt121=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                        case KW_IN:
                            {
                            alt121=1;
                            }
                            break;
                    }

                    switch (alt121) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1394:53: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1394:53: ( KW_FROM | KW_IN )
                            int alt120=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt120=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt120=2;
                                }
                                break;
                            default:
                                if (state.backtracking>0) {state.failed=true; return retval;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 120, 0, input);

                                throw nvae;

                            }

                            switch (alt120) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1394:54: KW_FROM
                                    {
                                    KW_FROM404=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6991); if (state.failed) return retval; 
                                    if ( state.backtracking==0 ) stream_KW_FROM.add(KW_FROM404);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1394:62: KW_IN
                                    {
                                    KW_IN405=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6993); if (state.failed) return retval; 
                                    if ( state.backtracking==0 ) stream_KW_IN.add(KW_IN405);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement6998);
                            db_name=identifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: tableName, db_name
                    // token labels: 
                    // rule labels: db_name, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1395:5: -> ^( TOK_SHOWCOLUMNS tableName ( $db_name)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1395:8: ^( TOK_SHOWCOLUMNS tableName ( $db_name)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWCOLUMNS, "TOK_SHOWCOLUMNS")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1395:37: ( $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1396:7: KW_SHOW KW_FUNCTIONS ( KW_LIKE showFunctionIdentifier | showFunctionIdentifier )?
                    {
                    KW_SHOW406=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement7024); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW406);


                    KW_FUNCTIONS407=(Token)match(input,KW_FUNCTIONS,FOLLOW_KW_FUNCTIONS_in_showStatement7026); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_FUNCTIONS.add(KW_FUNCTIONS407);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1396:28: ( KW_LIKE showFunctionIdentifier | showFunctionIdentifier )?
                    int alt122=3;
                    switch ( input.LA(1) ) {
                        case KW_LIKE:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                case KW_ADD:
                                case KW_ADMIN:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_AUTHORIZATION:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPACT:
                                case KW_COMPACTIONS:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURRENT_DATE:
                                case KW_CURRENT_TIMESTAMP:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DAY:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILE:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_HOUR:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_JAR:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_METADATA:
                                case KW_MINUS:
                                case KW_MINUTE:
                                case KW_MONTH:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_OWNER:
                                case KW_PARTITION:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PRINCIPALS:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RELOAD:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_REPLICATION:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_REWRITE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SECOND:
                                case KW_SEMI:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SERVER:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRANSACTIONS:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_URI:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUES:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                case KW_YEAR:
                                case StringLiteral:
                                    {
                                    alt122=1;
                                    }
                                    break;
                                case EOF:
                                case DOT:
                                    {
                                    alt122=2;
                                    }
                                    break;
                            }

                            }
                            break;
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_AUTHORIZATION:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURRENT_DATE:
                        case KW_CURRENT_TIMESTAMP:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DAY:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_HOUR:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_METADATA:
                        case KW_MINUS:
                        case KW_MINUTE:
                        case KW_MONTH:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RELOAD:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_REPLICATION:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_REWRITE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SECOND:
                        case KW_SEMI:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SERVER:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_URI:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUES:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                        case KW_YEAR:
                        case StringLiteral:
                            {
                            alt122=2;
                            }
                            break;
                    }

                    switch (alt122) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1396:29: KW_LIKE showFunctionIdentifier
                            {
                            KW_LIKE408=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_showStatement7029); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_LIKE.add(KW_LIKE408);


                            pushFollow(FOLLOW_showFunctionIdentifier_in_showStatement7031);
                            showFunctionIdentifier409=showFunctionIdentifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_showFunctionIdentifier.add(showFunctionIdentifier409.getTree());

                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1396:60: showFunctionIdentifier
                            {
                            pushFollow(FOLLOW_showFunctionIdentifier_in_showStatement7033);
                            showFunctionIdentifier410=showFunctionIdentifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_showFunctionIdentifier.add(showFunctionIdentifier410.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: showFunctionIdentifier, KW_LIKE
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1396:86: -> ^( TOK_SHOWFUNCTIONS ( KW_LIKE )? ( showFunctionIdentifier )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1396:89: ^( TOK_SHOWFUNCTIONS ( KW_LIKE )? ( showFunctionIdentifier )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWFUNCTIONS, "TOK_SHOWFUNCTIONS")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1396:109: ( KW_LIKE )?
                        if ( stream_KW_LIKE.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_KW_LIKE.nextNode()
                            );

                        }
                        stream_KW_LIKE.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1396:118: ( showFunctionIdentifier )?
                        if ( stream_showFunctionIdentifier.hasNext() ) {
                            adaptor.addChild(root_1, stream_showFunctionIdentifier.nextTree());

                        }
                        stream_showFunctionIdentifier.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1397:7: KW_SHOW KW_PARTITIONS tabName= tableName ( partitionSpec )?
                    {
                    KW_SHOW411=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement7056); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW411);


                    KW_PARTITIONS412=(Token)match(input,KW_PARTITIONS,FOLLOW_KW_PARTITIONS_in_showStatement7058); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_PARTITIONS.add(KW_PARTITIONS412);


                    pushFollow(FOLLOW_tableName_in_showStatement7062);
                    tabName=tableName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableName.add(tabName.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1397:47: ( partitionSpec )?
                    int alt123=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITION:
                            {
                            alt123=1;
                            }
                            break;
                    }

                    switch (alt123) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1397:47: partitionSpec
                            {
                            pushFollow(FOLLOW_partitionSpec_in_showStatement7064);
                            partitionSpec413=partitionSpec();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_partitionSpec.add(partitionSpec413.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: tabName, partitionSpec
                    // token labels: 
                    // rule labels: tabName, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_tabName=new RewriteRuleSubtreeStream(adaptor,"rule tabName",tabName!=null?tabName.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1397:62: -> ^( TOK_SHOWPARTITIONS $tabName ( partitionSpec )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1397:65: ^( TOK_SHOWPARTITIONS $tabName ( partitionSpec )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWPARTITIONS, "TOK_SHOWPARTITIONS")
                        , root_1);

                        adaptor.addChild(root_1, stream_tabName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1397:95: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1398:7: KW_SHOW KW_CREATE KW_TABLE tabName= tableName
                    {
                    KW_SHOW414=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement7086); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW414);


                    KW_CREATE415=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_showStatement7088); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_CREATE.add(KW_CREATE415);


                    KW_TABLE416=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_showStatement7090); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_TABLE.add(KW_TABLE416);


                    pushFollow(FOLLOW_tableName_in_showStatement7094);
                    tabName=tableName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableName.add(tabName.getTree());

                    // AST REWRITE
                    // elements: tabName
                    // token labels: 
                    // rule labels: tabName, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_tabName=new RewriteRuleSubtreeStream(adaptor,"rule tabName",tabName!=null?tabName.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1398:52: -> ^( TOK_SHOW_CREATETABLE $tabName)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1398:55: ^( TOK_SHOW_CREATETABLE $tabName)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_CREATETABLE, "TOK_SHOW_CREATETABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_tabName.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:7: KW_SHOW KW_TABLE KW_EXTENDED ( ( KW_FROM | KW_IN ) db_name= identifier )? KW_LIKE showStmtIdentifier ( partitionSpec )?
                    {
                    KW_SHOW417=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement7111); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW417);


                    KW_TABLE418=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_showStatement7113); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_TABLE.add(KW_TABLE418);


                    KW_EXTENDED419=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_showStatement7115); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_EXTENDED.add(KW_EXTENDED419);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:36: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt125=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                        case KW_IN:
                            {
                            alt125=1;
                            }
                            break;
                    }

                    switch (alt125) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:37: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:37: ( KW_FROM | KW_IN )
                            int alt124=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt124=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt124=2;
                                }
                                break;
                            default:
                                if (state.backtracking>0) {state.failed=true; return retval;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 124, 0, input);

                                throw nvae;

                            }

                            switch (alt124) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:38: KW_FROM
                                    {
                                    KW_FROM420=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement7119); if (state.failed) return retval; 
                                    if ( state.backtracking==0 ) stream_KW_FROM.add(KW_FROM420);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:46: KW_IN
                                    {
                                    KW_IN421=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement7121); if (state.failed) return retval; 
                                    if ( state.backtracking==0 ) stream_KW_IN.add(KW_IN421);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement7126);
                            db_name=identifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    KW_LIKE422=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_showStatement7130); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_LIKE.add(KW_LIKE422);


                    pushFollow(FOLLOW_showStmtIdentifier_in_showStatement7132);
                    showStmtIdentifier423=showStmtIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_showStmtIdentifier.add(showStmtIdentifier423.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:101: ( partitionSpec )?
                    int alt126=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITION:
                            {
                            alt126=1;
                            }
                            break;
                    }

                    switch (alt126) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1399:101: partitionSpec
                            {
                            pushFollow(FOLLOW_partitionSpec_in_showStatement7134);
                            partitionSpec424=partitionSpec();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_partitionSpec.add(partitionSpec424.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: showStmtIdentifier, db_name, partitionSpec
                    // token labels: 
                    // rule labels: db_name, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1400:5: -> ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1400:8: ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_TABLESTATUS, "TOK_SHOW_TABLESTATUS")
                        , root_1);

                        adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1400:51: ( $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1400:60: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1401:7: KW_SHOW KW_TBLPROPERTIES tableName ( LPAREN prptyName= StringLiteral RPAREN )?
                    {
                    KW_SHOW425=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement7162); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW425);


                    KW_TBLPROPERTIES426=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_showStatement7164); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES426);


                    pushFollow(FOLLOW_tableName_in_showStatement7166);
                    tableName427=tableName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_tableName.add(tableName427.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1401:42: ( LPAREN prptyName= StringLiteral RPAREN )?
                    int alt127=2;
                    switch ( input.LA(1) ) {
                        case LPAREN:
                            {
                            alt127=1;
                            }
                            break;
                    }

                    switch (alt127) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1401:43: LPAREN prptyName= StringLiteral RPAREN
                            {
                            LPAREN428=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_showStatement7169); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_LPAREN.add(LPAREN428);


                            prptyName=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_showStatement7173); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_StringLiteral.add(prptyName);


                            RPAREN429=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_showStatement7175); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_RPAREN.add(RPAREN429);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: prptyName, tableName
                    // token labels: prptyName
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_prptyName=new RewriteRuleTokenStream(adaptor,"token prptyName",prptyName);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1401:83: -> ^( TOK_SHOW_TBLPROPERTIES tableName ( $prptyName)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1401:86: ^( TOK_SHOW_TBLPROPERTIES tableName ( $prptyName)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_TBLPROPERTIES, "TOK_SHOW_TBLPROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1401:122: ( $prptyName)?
                        if ( stream_prptyName.hasNext() ) {
                            adaptor.addChild(root_1, stream_prptyName.nextNode());

                        }
                        stream_prptyName.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1402:7: KW_SHOW KW_LOCKS ( ( KW_DATABASE | KW_SCHEMA )=> ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWDBLOCKS $dbName ( $isExtended)? ) | (parttype= partTypeExpr )? (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? ) )
                    {
                    KW_SHOW430=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement7197); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW430);


                    KW_LOCKS431=(Token)match(input,KW_LOCKS,FOLLOW_KW_LOCKS_in_showStatement7199); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_LOCKS.add(KW_LOCKS431);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1403:7: ( ( KW_DATABASE | KW_SCHEMA )=> ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWDBLOCKS $dbName ( $isExtended)? ) | (parttype= partTypeExpr )? (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? ) )
                    int alt132=2;
                    int LA132_0 = input.LA(1);

                    if ( (LA132_0==KW_DATABASE) && (synpred10_HiveParser())) {
                        alt132=1;
                    }
                    else if ( (LA132_0==KW_SCHEMA) ) {
                        switch ( input.LA(2) ) {
                        case Identifier:
                            {
                            int LA132_8 = input.LA(3);

                            if ( (synpred10_HiveParser()) ) {
                                alt132=1;
                            }
                            else if ( (true) ) {
                                alt132=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return retval;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 132, 8, input);

                                throw nvae;

                            }
                            }
                            break;
                        case EOF:
                        case DOT:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_AUTHORIZATION:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURRENT_DATE:
                        case KW_CURRENT_TIMESTAMP:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DAY:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTENDED:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_HOUR:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIKE:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_METADATA:
                        case KW_MINUS:
                        case KW_MINUTE:
                        case KW_MONTH:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RELOAD:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_REPLICATION:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_REWRITE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SECOND:
                        case KW_SEMI:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SERVER:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_URI:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUES:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                        case KW_YEAR:
                            {
                            alt132=2;
                            }
                            break;
                        default:
                            if (state.backtracking>0) {state.failed=true; return retval;}
                            NoViableAltException nvae =
                                new NoViableAltException("", 132, 2, input);

                            throw nvae;

                        }

                    }
                    else if ( (LA132_0==EOF||(LA132_0 >= Identifier && LA132_0 <= KW_ANALYZE)||(LA132_0 >= KW_ARCHIVE && LA132_0 <= KW_CASCADE)||LA132_0==KW_CHANGE||(LA132_0 >= KW_CLUSTER && LA132_0 <= KW_COLLECTION)||(LA132_0 >= KW_COLUMNS && LA132_0 <= KW_CONCATENATE)||(LA132_0 >= KW_CONTINUE && LA132_0 <= KW_CREATE)||LA132_0==KW_CUBE||(LA132_0 >= KW_CURRENT_DATE && LA132_0 <= KW_DATA)||(LA132_0 >= KW_DATABASES && LA132_0 <= KW_DISABLE)||(LA132_0 >= KW_DISTRIBUTE && LA132_0 <= KW_ELEM_TYPE)||LA132_0==KW_ENABLE||LA132_0==KW_ESCAPED||(LA132_0 >= KW_EXCLUSIVE && LA132_0 <= KW_FLOAT)||(LA132_0 >= KW_FOR && LA132_0 <= KW_FORMATTED)||LA132_0==KW_FULL||(LA132_0 >= KW_FUNCTIONS && LA132_0 <= KW_GROUPING)||(LA132_0 >= KW_HOLD_DDLTIME && LA132_0 <= KW_IDXPROPERTIES)||(LA132_0 >= KW_IGNORE && LA132_0 <= KW_INTERSECT)||(LA132_0 >= KW_INTO && LA132_0 <= KW_JAR)||(LA132_0 >= KW_KEYS && LA132_0 <= KW_LEFT)||(LA132_0 >= KW_LIKE && LA132_0 <= KW_LONG)||(LA132_0 >= KW_MAPJOIN && LA132_0 <= KW_MONTH)||(LA132_0 >= KW_MSCK && LA132_0 <= KW_NOSCAN)||(LA132_0 >= KW_NO_DROP && LA132_0 <= KW_OFFLINE)||LA132_0==KW_OPTION||(LA132_0 >= KW_ORDER && LA132_0 <= KW_OUTPUTFORMAT)||(LA132_0 >= KW_OVERWRITE && LA132_0 <= KW_OWNER)||(LA132_0 >= KW_PARTITION && LA132_0 <= KW_PLUS)||(LA132_0 >= KW_PRETTY && LA132_0 <= KW_RECORDWRITER)||(LA132_0 >= KW_REGEXP && LA132_0 <= KW_ROWS)||(LA132_0 >= KW_SCHEMAS && LA132_0 <= KW_SECOND)||(LA132_0 >= KW_SEMI && LA132_0 <= KW_TABLES)||(LA132_0 >= KW_TBLPROPERTIES && LA132_0 <= KW_TERMINATED)||(LA132_0 >= KW_TIMESTAMP && LA132_0 <= KW_TRANSACTIONS)||(LA132_0 >= KW_TRIGGER && LA132_0 <= KW_UNARCHIVE)||(LA132_0 >= KW_UNDO && LA132_0 <= KW_UNIONTYPE)||(LA132_0 >= KW_UNLOCK && LA132_0 <= KW_VALUE_TYPE)||LA132_0==KW_VIEW||LA132_0==KW_WHILE||(LA132_0 >= KW_WITH && LA132_0 <= KW_YEAR)) ) {
                        alt132=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 132, 0, input);

                        throw nvae;

                    }
                    switch (alt132) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1404:7: ( KW_DATABASE | KW_SCHEMA )=> ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) (isExtended= KW_EXTENDED )?
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1404:34: ( KW_DATABASE | KW_SCHEMA )
                            int alt128=2;
                            switch ( input.LA(1) ) {
                            case KW_DATABASE:
                                {
                                alt128=1;
                                }
                                break;
                            case KW_SCHEMA:
                                {
                                alt128=2;
                                }
                                break;
                            default:
                                if (state.backtracking>0) {state.failed=true; return retval;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 128, 0, input);

                                throw nvae;

                            }

                            switch (alt128) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1404:35: KW_DATABASE
                                    {
                                    KW_DATABASE432=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_showStatement7225); if (state.failed) return retval; 
                                    if ( state.backtracking==0 ) stream_KW_DATABASE.add(KW_DATABASE432);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1404:47: KW_SCHEMA
                                    {
                                    KW_SCHEMA433=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_showStatement7227); if (state.failed) return retval; 
                                    if ( state.backtracking==0 ) stream_KW_SCHEMA.add(KW_SCHEMA433);


                                    }
                                    break;

                            }


                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1404:58: (dbName= Identifier )
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1404:59: dbName= Identifier
                            {
                            dbName=(Token)match(input,Identifier,FOLLOW_Identifier_in_showStatement7233); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_Identifier.add(dbName);


                            }


                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1404:78: (isExtended= KW_EXTENDED )?
                            int alt129=2;
                            switch ( input.LA(1) ) {
                                case KW_EXTENDED:
                                    {
                                    alt129=1;
                                    }
                                    break;
                            }

                            switch (alt129) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1404:79: isExtended= KW_EXTENDED
                                    {
                                    isExtended=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_showStatement7239); if (state.failed) return retval; 
                                    if ( state.backtracking==0 ) stream_KW_EXTENDED.add(isExtended);


                                    }
                                    break;

                            }


                            // AST REWRITE
                            // elements: isExtended, dbName
                            // token labels: dbName, isExtended
                            // rule labels: retval
                            // token list labels: 
                            // rule list labels: 
                            // wildcard labels: 
                            if ( state.backtracking==0 ) {

                            retval.tree = root_0;
                            RewriteRuleTokenStream stream_dbName=new RewriteRuleTokenStream(adaptor,"token dbName",dbName);
                            RewriteRuleTokenStream stream_isExtended=new RewriteRuleTokenStream(adaptor,"token isExtended",isExtended);
                            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                            root_0 = (CommonTree)adaptor.nil();
                            // 1404:104: -> ^( TOK_SHOWDBLOCKS $dbName ( $isExtended)? )
                            {
                                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1404:107: ^( TOK_SHOWDBLOCKS $dbName ( $isExtended)? )
                                {
                                CommonTree root_1 = (CommonTree)adaptor.nil();
                                root_1 = (CommonTree)adaptor.becomeRoot(
                                (CommonTree)adaptor.create(TOK_SHOWDBLOCKS, "TOK_SHOWDBLOCKS")
                                , root_1);

                                adaptor.addChild(root_1, stream_dbName.nextNode());

                                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1404:134: ( $isExtended)?
                                if ( stream_isExtended.hasNext() ) {
                                    adaptor.addChild(root_1, stream_isExtended.nextNode());

                                }
                                stream_isExtended.reset();

                                adaptor.addChild(root_0, root_1);
                                }

                            }


                            retval.tree = root_0;
                            }

                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1406:7: (parttype= partTypeExpr )? (isExtended= KW_EXTENDED )?
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1406:7: (parttype= partTypeExpr )?
                            int alt130=2;
                            switch ( input.LA(1) ) {
                                case Identifier:
                                case KW_ADD:
                                case KW_ADMIN:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_AUTHORIZATION:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPACT:
                                case KW_COMPACTIONS:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURRENT_DATE:
                                case KW_CURRENT_TIMESTAMP:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DAY:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILE:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_HOUR:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_JAR:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_METADATA:
                                case KW_MINUS:
                                case KW_MINUTE:
                                case KW_MONTH:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_OWNER:
                                case KW_PARTITION:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PRINCIPALS:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RELOAD:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_REPLICATION:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_REWRITE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SECOND:
                                case KW_SEMI:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SERVER:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRANSACTIONS:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_URI:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUES:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                case KW_YEAR:
                                    {
                                    alt130=1;
                                    }
                                    break;
                            }

                            switch (alt130) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1406:8: parttype= partTypeExpr
                                    {
                                    pushFollow(FOLLOW_partTypeExpr_in_showStatement7273);
                                    parttype=partTypeExpr();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) stream_partTypeExpr.add(parttype.getTree());

                                    }
                                    break;

                            }


                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1406:32: (isExtended= KW_EXTENDED )?
                            int alt131=2;
                            switch ( input.LA(1) ) {
                                case KW_EXTENDED:
                                    {
                                    alt131=1;
                                    }
                                    break;
                            }

                            switch (alt131) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1406:33: isExtended= KW_EXTENDED
                                    {
                                    isExtended=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_showStatement7280); if (state.failed) return retval; 
                                    if ( state.backtracking==0 ) stream_KW_EXTENDED.add(isExtended);


                                    }
                                    break;

                            }


                            // AST REWRITE
                            // elements: parttype, isExtended
                            // token labels: isExtended
                            // rule labels: parttype, retval
                            // token list labels: 
                            // rule list labels: 
                            // wildcard labels: 
                            if ( state.backtracking==0 ) {

                            retval.tree = root_0;
                            RewriteRuleTokenStream stream_isExtended=new RewriteRuleTokenStream(adaptor,"token isExtended",isExtended);
                            RewriteRuleSubtreeStream stream_parttype=new RewriteRuleSubtreeStream(adaptor,"rule parttype",parttype!=null?parttype.tree:null);
                            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                            root_0 = (CommonTree)adaptor.nil();
                            // 1406:58: -> ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? )
                            {
                                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1406:61: ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? )
                                {
                                CommonTree root_1 = (CommonTree)adaptor.nil();
                                root_1 = (CommonTree)adaptor.becomeRoot(
                                (CommonTree)adaptor.create(TOK_SHOWLOCKS, "TOK_SHOWLOCKS")
                                , root_1);

                                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1406:78: ( $parttype)?
                                if ( stream_parttype.hasNext() ) {
                                    adaptor.addChild(root_1, stream_parttype.nextTree());

                                }
                                stream_parttype.reset();

                                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1406:89: ( $isExtended)?
                                if ( stream_isExtended.hasNext() ) {
                                    adaptor.addChild(root_1, stream_isExtended.nextNode());

                                }
                                stream_isExtended.reset();

                                adaptor.addChild(root_0, root_1);
                                }

                            }


                            retval.tree = root_0;
                            }

                            }
                            break;

                    }


                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:7: KW_SHOW (showOptions= KW_FORMATTED )? ( KW_INDEX | KW_INDEXES ) KW_ON showStmtIdentifier ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    {
                    KW_SHOW434=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement7312); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW434);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:15: (showOptions= KW_FORMATTED )?
                    int alt133=2;
                    switch ( input.LA(1) ) {
                        case KW_FORMATTED:
                            {
                            alt133=1;
                            }
                            break;
                    }

                    switch (alt133) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:16: showOptions= KW_FORMATTED
                            {
                            showOptions=(Token)match(input,KW_FORMATTED,FOLLOW_KW_FORMATTED_in_showStatement7317); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_FORMATTED.add(showOptions);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:43: ( KW_INDEX | KW_INDEXES )
                    int alt134=2;
                    switch ( input.LA(1) ) {
                    case KW_INDEX:
                        {
                        alt134=1;
                        }
                        break;
                    case KW_INDEXES:
                        {
                        alt134=2;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 134, 0, input);

                        throw nvae;

                    }

                    switch (alt134) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:44: KW_INDEX
                            {
                            KW_INDEX435=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_showStatement7322); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_INDEX.add(KW_INDEX435);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:53: KW_INDEXES
                            {
                            KW_INDEXES436=(Token)match(input,KW_INDEXES,FOLLOW_KW_INDEXES_in_showStatement7324); if (state.failed) return retval; 
                            if ( state.backtracking==0 ) stream_KW_INDEXES.add(KW_INDEXES436);


                            }
                            break;

                    }


                    KW_ON437=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_showStatement7327); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_ON.add(KW_ON437);


                    pushFollow(FOLLOW_showStmtIdentifier_in_showStatement7329);
                    showStmtIdentifier438=showStmtIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_showStmtIdentifier.add(showStmtIdentifier438.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:90: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt136=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                        case KW_IN:
                            {
                            alt136=1;
                            }
                            break;
                    }

                    switch (alt136) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:91: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:91: ( KW_FROM | KW_IN )
                            int alt135=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt135=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt135=2;
                                }
                                break;
                            default:
                                if (state.backtracking>0) {state.failed=true; return retval;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 135, 0, input);

                                throw nvae;

                            }

                            switch (alt135) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:92: KW_FROM
                                    {
                                    KW_FROM439=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement7333); if (state.failed) return retval; 
                                    if ( state.backtracking==0 ) stream_KW_FROM.add(KW_FROM439);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:100: KW_IN
                                    {
                                    KW_IN440=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement7335); if (state.failed) return retval; 
                                    if ( state.backtracking==0 ) stream_KW_IN.add(KW_IN440);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement7340);
                            db_name=identifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: db_name, showOptions, showStmtIdentifier
                    // token labels: showOptions
                    // rule labels: db_name, retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_showOptions=new RewriteRuleTokenStream(adaptor,"token showOptions",showOptions);
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1409:5: -> ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1409:8: ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWINDEXES, "TOK_SHOWINDEXES")
                        , root_1);

                        adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1409:46: ( $showOptions)?
                        if ( stream_showOptions.hasNext() ) {
                            adaptor.addChild(root_1, stream_showOptions.nextNode());

                        }
                        stream_showOptions.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1409:60: ( $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 11 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1410:7: KW_SHOW KW_COMPACTIONS
                    {
                    KW_SHOW441=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement7370); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW441);


                    KW_COMPACTIONS442=(Token)match(input,KW_COMPACTIONS,FOLLOW_KW_COMPACTIONS_in_showStatement7372); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_COMPACTIONS.add(KW_COMPACTIONS442);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1410:30: -> ^( TOK_SHOW_COMPACTIONS )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1410:33: ^( TOK_SHOW_COMPACTIONS )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_COMPACTIONS, "TOK_SHOW_COMPACTIONS")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 12 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1411:7: KW_SHOW KW_TRANSACTIONS
                    {
                    KW_SHOW443=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement7386); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW443);


                    KW_TRANSACTIONS444=(Token)match(input,KW_TRANSACTIONS,FOLLOW_KW_TRANSACTIONS_in_showStatement7388); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_TRANSACTIONS.add(KW_TRANSACTIONS444);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1411:31: -> ^( TOK_SHOW_TRANSACTIONS )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1411:34: ^( TOK_SHOW_TRANSACTIONS )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_TRANSACTIONS, "TOK_SHOW_TRANSACTIONS")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 13 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1412:7: KW_SHOW KW_CONF StringLiteral
                    {
                    KW_SHOW445=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement7402); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW445);


                    KW_CONF446=(Token)match(input,KW_CONF,FOLLOW_KW_CONF_in_showStatement7404); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_CONF.add(KW_CONF446);


                    StringLiteral447=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_showStatement7406); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_StringLiteral.add(StringLiteral447);


                    // AST REWRITE
                    // elements: StringLiteral
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1412:37: -> ^( TOK_SHOWCONF StringLiteral )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1412:40: ^( TOK_SHOWCONF StringLiteral )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWCONF, "TOK_SHOWCONF")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_StringLiteral.nextNode()
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showStatement"


    public static class lockStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lockStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1415:1: lockStatement : KW_LOCK KW_TABLE tableName ( partitionSpec )? lockMode -> ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? ) ;
    public final HiveParser.lockStatement_return lockStatement() throws RecognitionException {
        HiveParser.lockStatement_return retval = new HiveParser.lockStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_LOCK448=null;
        Token KW_TABLE449=null;
        HiveParser_FromClauseParser.tableName_return tableName450 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec451 =null;

        HiveParser.lockMode_return lockMode452 =null;


        CommonTree KW_LOCK448_tree=null;
        CommonTree KW_TABLE449_tree=null;
        RewriteRuleTokenStream stream_KW_LOCK=new RewriteRuleTokenStream(adaptor,"token KW_LOCK");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_lockMode=new RewriteRuleSubtreeStream(adaptor,"rule lockMode");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
         pushMsg("lock statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1418:5: ( KW_LOCK KW_TABLE tableName ( partitionSpec )? lockMode -> ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1418:7: KW_LOCK KW_TABLE tableName ( partitionSpec )? lockMode
            {
            KW_LOCK448=(Token)match(input,KW_LOCK,FOLLOW_KW_LOCK_in_lockStatement7441); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_LOCK.add(KW_LOCK448);


            KW_TABLE449=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_lockStatement7443); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TABLE.add(KW_TABLE449);


            pushFollow(FOLLOW_tableName_in_lockStatement7445);
            tableName450=tableName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableName.add(tableName450.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1418:34: ( partitionSpec )?
            int alt138=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt138=1;
                    }
                    break;
            }

            switch (alt138) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1418:34: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_lockStatement7447);
                    partitionSpec451=partitionSpec();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_partitionSpec.add(partitionSpec451.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_lockMode_in_lockStatement7450);
            lockMode452=lockMode();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_lockMode.add(lockMode452.getTree());

            // AST REWRITE
            // elements: lockMode, partitionSpec, tableName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1418:58: -> ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1418:61: ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_LOCKTABLE, "TOK_LOCKTABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                adaptor.addChild(root_1, stream_lockMode.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1418:96: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lockStatement"


    public static class lockDatabase_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lockDatabase"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:1: lockDatabase : KW_LOCK ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) lockMode -> ^( TOK_LOCKDB $dbName lockMode ) ;
    public final HiveParser.lockDatabase_return lockDatabase() throws RecognitionException {
        HiveParser.lockDatabase_return retval = new HiveParser.lockDatabase_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token dbName=null;
        Token KW_LOCK453=null;
        Token KW_DATABASE454=null;
        Token KW_SCHEMA455=null;
        HiveParser.lockMode_return lockMode456 =null;


        CommonTree dbName_tree=null;
        CommonTree KW_LOCK453_tree=null;
        CommonTree KW_DATABASE454_tree=null;
        CommonTree KW_SCHEMA455_tree=null;
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_Identifier=new RewriteRuleTokenStream(adaptor,"token Identifier");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_LOCK=new RewriteRuleTokenStream(adaptor,"token KW_LOCK");
        RewriteRuleSubtreeStream stream_lockMode=new RewriteRuleSubtreeStream(adaptor,"rule lockMode");
         pushMsg("lock database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1424:5: ( KW_LOCK ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) lockMode -> ^( TOK_LOCKDB $dbName lockMode ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1424:7: KW_LOCK ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) lockMode
            {
            KW_LOCK453=(Token)match(input,KW_LOCK,FOLLOW_KW_LOCK_in_lockDatabase7490); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_LOCK.add(KW_LOCK453);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1424:15: ( KW_DATABASE | KW_SCHEMA )
            int alt139=2;
            switch ( input.LA(1) ) {
            case KW_DATABASE:
                {
                alt139=1;
                }
                break;
            case KW_SCHEMA:
                {
                alt139=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 139, 0, input);

                throw nvae;

            }

            switch (alt139) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1424:16: KW_DATABASE
                    {
                    KW_DATABASE454=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_lockDatabase7493); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_DATABASE.add(KW_DATABASE454);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1424:28: KW_SCHEMA
                    {
                    KW_SCHEMA455=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_lockDatabase7495); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SCHEMA.add(KW_SCHEMA455);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1424:39: (dbName= Identifier )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1424:40: dbName= Identifier
            {
            dbName=(Token)match(input,Identifier,FOLLOW_Identifier_in_lockDatabase7501); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_Identifier.add(dbName);


            }


            pushFollow(FOLLOW_lockMode_in_lockDatabase7504);
            lockMode456=lockMode();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_lockMode.add(lockMode456.getTree());

            // AST REWRITE
            // elements: lockMode, dbName
            // token labels: dbName
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_dbName=new RewriteRuleTokenStream(adaptor,"token dbName",dbName);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1424:68: -> ^( TOK_LOCKDB $dbName lockMode )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1424:71: ^( TOK_LOCKDB $dbName lockMode )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_LOCKDB, "TOK_LOCKDB")
                , root_1);

                adaptor.addChild(root_1, stream_dbName.nextNode());

                adaptor.addChild(root_1, stream_lockMode.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lockDatabase"


    public static class lockMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lockMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1427:1: lockMode : ( KW_SHARED | KW_EXCLUSIVE );
    public final HiveParser.lockMode_return lockMode() throws RecognitionException {
        HiveParser.lockMode_return retval = new HiveParser.lockMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token set457=null;

        CommonTree set457_tree=null;

         pushMsg("lock mode", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1430:5: ( KW_SHARED | KW_EXCLUSIVE )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:
            {
            root_0 = (CommonTree)adaptor.nil();


            set457=(Token)input.LT(1);

            if ( input.LA(1)==KW_EXCLUSIVE||input.LA(1)==KW_SHARED ) {
                input.consume();
                if ( state.backtracking==0 ) adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(set457)
                );
                state.errorRecovery=false;
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lockMode"


    public static class unlockStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "unlockStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1433:1: unlockStatement : KW_UNLOCK KW_TABLE tableName ( partitionSpec )? -> ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? ) ;
    public final HiveParser.unlockStatement_return unlockStatement() throws RecognitionException {
        HiveParser.unlockStatement_return retval = new HiveParser.unlockStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_UNLOCK458=null;
        Token KW_TABLE459=null;
        HiveParser_FromClauseParser.tableName_return tableName460 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec461 =null;


        CommonTree KW_UNLOCK458_tree=null;
        CommonTree KW_TABLE459_tree=null;
        RewriteRuleTokenStream stream_KW_UNLOCK=new RewriteRuleTokenStream(adaptor,"token KW_UNLOCK");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
         pushMsg("unlock statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1436:5: ( KW_UNLOCK KW_TABLE tableName ( partitionSpec )? -> ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1436:7: KW_UNLOCK KW_TABLE tableName ( partitionSpec )?
            {
            KW_UNLOCK458=(Token)match(input,KW_UNLOCK,FOLLOW_KW_UNLOCK_in_unlockStatement7573); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_UNLOCK.add(KW_UNLOCK458);


            KW_TABLE459=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_unlockStatement7575); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TABLE.add(KW_TABLE459);


            pushFollow(FOLLOW_tableName_in_unlockStatement7577);
            tableName460=tableName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_tableName.add(tableName460.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1436:36: ( partitionSpec )?
            int alt140=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt140=1;
                    }
                    break;
            }

            switch (alt140) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1436:36: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_unlockStatement7579);
                    partitionSpec461=partitionSpec();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_partitionSpec.add(partitionSpec461.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: tableName, partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1436:52: -> ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1436:55: ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_UNLOCKTABLE, "TOK_UNLOCKTABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1436:83: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "unlockStatement"


    public static class unlockDatabase_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "unlockDatabase"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1439:1: unlockDatabase : KW_UNLOCK ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) -> ^( TOK_UNLOCKDB $dbName) ;
    public final HiveParser.unlockDatabase_return unlockDatabase() throws RecognitionException {
        HiveParser.unlockDatabase_return retval = new HiveParser.unlockDatabase_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token dbName=null;
        Token KW_UNLOCK462=null;
        Token KW_DATABASE463=null;
        Token KW_SCHEMA464=null;

        CommonTree dbName_tree=null;
        CommonTree KW_UNLOCK462_tree=null;
        CommonTree KW_DATABASE463_tree=null;
        CommonTree KW_SCHEMA464_tree=null;
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_Identifier=new RewriteRuleTokenStream(adaptor,"token Identifier");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_UNLOCK=new RewriteRuleTokenStream(adaptor,"token KW_UNLOCK");

         pushMsg("unlock database statement", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1442:5: ( KW_UNLOCK ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier ) -> ^( TOK_UNLOCKDB $dbName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1442:7: KW_UNLOCK ( KW_DATABASE | KW_SCHEMA ) (dbName= Identifier )
            {
            KW_UNLOCK462=(Token)match(input,KW_UNLOCK,FOLLOW_KW_UNLOCK_in_unlockDatabase7619); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_UNLOCK.add(KW_UNLOCK462);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1442:17: ( KW_DATABASE | KW_SCHEMA )
            int alt141=2;
            switch ( input.LA(1) ) {
            case KW_DATABASE:
                {
                alt141=1;
                }
                break;
            case KW_SCHEMA:
                {
                alt141=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 141, 0, input);

                throw nvae;

            }

            switch (alt141) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1442:18: KW_DATABASE
                    {
                    KW_DATABASE463=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_unlockDatabase7622); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_DATABASE.add(KW_DATABASE463);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1442:30: KW_SCHEMA
                    {
                    KW_SCHEMA464=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_unlockDatabase7624); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_SCHEMA.add(KW_SCHEMA464);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1442:41: (dbName= Identifier )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1442:42: dbName= Identifier
            {
            dbName=(Token)match(input,Identifier,FOLLOW_Identifier_in_unlockDatabase7630); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_Identifier.add(dbName);


            }


            // AST REWRITE
            // elements: dbName
            // token labels: dbName
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleTokenStream stream_dbName=new RewriteRuleTokenStream(adaptor,"token dbName",dbName);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1442:61: -> ^( TOK_UNLOCKDB $dbName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1442:64: ^( TOK_UNLOCKDB $dbName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_UNLOCKDB, "TOK_UNLOCKDB")
                , root_1);

                adaptor.addChild(root_1, stream_dbName.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "unlockDatabase"


    public static class createRoleStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createRoleStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1445:1: createRoleStatement : KW_CREATE KW_ROLE roleName= identifier -> ^( TOK_CREATEROLE $roleName) ;
    public final HiveParser.createRoleStatement_return createRoleStatement() throws RecognitionException {
        HiveParser.createRoleStatement_return retval = new HiveParser.createRoleStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_CREATE465=null;
        Token KW_ROLE466=null;
        HiveParser_IdentifiersParser.identifier_return roleName =null;


        CommonTree KW_CREATE465_tree=null;
        CommonTree KW_ROLE466_tree=null;
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         pushMsg("create role", state); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1448:5: ( KW_CREATE KW_ROLE roleName= identifier -> ^( TOK_CREATEROLE $roleName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1448:7: KW_CREATE KW_ROLE roleName= identifier
            {
            KW_CREATE465=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createRoleStatement7667); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_CREATE.add(KW_CREATE465);


            KW_ROLE466=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_createRoleStatement7669); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_ROLE.add(KW_ROLE466);


            pushFollow(FOLLOW_identifier_in_createRoleStatement7673);
            roleName=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(roleName.getTree());

            // AST REWRITE
            // elements: roleName
            // token labels: 
            // rule labels: roleName, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_roleName=new RewriteRuleSubtreeStream(adaptor,"rule roleName",roleName!=null?roleName.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1449:5: -> ^( TOK_CREATEROLE $roleName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1449:8: ^( TOK_CREATEROLE $roleName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEROLE, "TOK_CREATEROLE")
                , root_1);

                adaptor.addChild(root_1, stream_roleName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) { popMsg(state); }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createRoleStatement"


    public static class dropRoleStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropRoleStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1452:1: dropRoleStatement : KW_DROP KW_ROLE roleName= identifier -> ^( TOK_DROPROLE $roleName) ;
    public final HiveParser.dropRoleStatement_return dropRoleStatement() throws RecognitionException {
        HiveParser.dropRoleStatement_return retval = new HiveParser.dropRoleStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP467=null;
        Token KW_ROLE468=null;
        HiveParser_IdentifiersParser.identifier_return roleName =null;


        CommonTree KW_DROP467_tree=null;
        CommonTree KW_ROLE468_tree=null;
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("drop role", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1455:5: ( KW_DROP KW_ROLE roleName= identifier -> ^( TOK_DROPROLE $roleName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1455:7: KW_DROP KW_ROLE roleName= identifier
            {
            KW_DROP467=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropRoleStatement7713); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_DROP.add(KW_DROP467);


            KW_ROLE468=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_dropRoleStatement7715); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_ROLE.add(KW_ROLE468);


            pushFollow(FOLLOW_identifier_in_dropRoleStatement7719);
            roleName=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(roleName.getTree());

            // AST REWRITE
            // elements: roleName
            // token labels: 
            // rule labels: roleName, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_roleName=new RewriteRuleSubtreeStream(adaptor,"rule roleName",roleName!=null?roleName.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1456:5: -> ^( TOK_DROPROLE $roleName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1456:8: ^( TOK_DROPROLE $roleName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPROLE, "TOK_DROPROLE")
                , root_1);

                adaptor.addChild(root_1, stream_roleName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropRoleStatement"


    public static class grantPrivileges_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "grantPrivileges"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1459:1: grantPrivileges : KW_GRANT privList= privilegeList ( privilegeObject )? KW_TO principalSpecification ( withGrantOption )? -> ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withGrantOption )? ) ;
    public final HiveParser.grantPrivileges_return grantPrivileges() throws RecognitionException {
        HiveParser.grantPrivileges_return retval = new HiveParser.grantPrivileges_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_GRANT469=null;
        Token KW_TO471=null;
        HiveParser.privilegeList_return privList =null;

        HiveParser.privilegeObject_return privilegeObject470 =null;

        HiveParser.principalSpecification_return principalSpecification472 =null;

        HiveParser.withGrantOption_return withGrantOption473 =null;


        CommonTree KW_GRANT469_tree=null;
        CommonTree KW_TO471_tree=null;
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleSubtreeStream stream_withGrantOption=new RewriteRuleSubtreeStream(adaptor,"rule withGrantOption");
        RewriteRuleSubtreeStream stream_privilegeList=new RewriteRuleSubtreeStream(adaptor,"rule privilegeList");
        RewriteRuleSubtreeStream stream_privilegeObject=new RewriteRuleSubtreeStream(adaptor,"rule privilegeObject");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        pushMsg("grant privileges", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1462:5: ( KW_GRANT privList= privilegeList ( privilegeObject )? KW_TO principalSpecification ( withGrantOption )? -> ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withGrantOption )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1462:7: KW_GRANT privList= privilegeList ( privilegeObject )? KW_TO principalSpecification ( withGrantOption )?
            {
            KW_GRANT469=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_grantPrivileges7759); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_GRANT.add(KW_GRANT469);


            pushFollow(FOLLOW_privilegeList_in_grantPrivileges7763);
            privList=privilegeList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_privilegeList.add(privList.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1463:7: ( privilegeObject )?
            int alt142=2;
            switch ( input.LA(1) ) {
                case KW_ON:
                    {
                    alt142=1;
                    }
                    break;
            }

            switch (alt142) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1463:7: privilegeObject
                    {
                    pushFollow(FOLLOW_privilegeObject_in_grantPrivileges7771);
                    privilegeObject470=privilegeObject();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_privilegeObject.add(privilegeObject470.getTree());

                    }
                    break;

            }


            KW_TO471=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_grantPrivileges7780); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TO.add(KW_TO471);


            pushFollow(FOLLOW_principalSpecification_in_grantPrivileges7782);
            principalSpecification472=principalSpecification();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_principalSpecification.add(principalSpecification472.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1465:7: ( withGrantOption )?
            int alt143=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt143=1;
                    }
                    break;
            }

            switch (alt143) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1465:7: withGrantOption
                    {
                    pushFollow(FOLLOW_withGrantOption_in_grantPrivileges7790);
                    withGrantOption473=withGrantOption();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_withGrantOption.add(withGrantOption473.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: privList, withGrantOption, principalSpecification, privilegeObject
            // token labels: 
            // rule labels: privList, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_privList=new RewriteRuleSubtreeStream(adaptor,"rule privList",privList!=null?privList.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1466:5: -> ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withGrantOption )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1466:8: ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withGrantOption )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_GRANT, "TOK_GRANT")
                , root_1);

                adaptor.addChild(root_1, stream_privList.nextTree());

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1466:53: ( privilegeObject )?
                if ( stream_privilegeObject.hasNext() ) {
                    adaptor.addChild(root_1, stream_privilegeObject.nextTree());

                }
                stream_privilegeObject.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1466:70: ( withGrantOption )?
                if ( stream_withGrantOption.hasNext() ) {
                    adaptor.addChild(root_1, stream_withGrantOption.nextTree());

                }
                stream_withGrantOption.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "grantPrivileges"


    public static class revokePrivileges_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "revokePrivileges"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1469:1: revokePrivileges : KW_REVOKE ( grantOptionFor )? privilegeList ( privilegeObject )? KW_FROM principalSpecification -> ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? ( grantOptionFor )? ) ;
    public final HiveParser.revokePrivileges_return revokePrivileges() throws RecognitionException {
        HiveParser.revokePrivileges_return retval = new HiveParser.revokePrivileges_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_REVOKE474=null;
        Token KW_FROM478=null;
        HiveParser.grantOptionFor_return grantOptionFor475 =null;

        HiveParser.privilegeList_return privilegeList476 =null;

        HiveParser.privilegeObject_return privilegeObject477 =null;

        HiveParser.principalSpecification_return principalSpecification479 =null;


        CommonTree KW_REVOKE474_tree=null;
        CommonTree KW_FROM478_tree=null;
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleTokenStream stream_KW_REVOKE=new RewriteRuleTokenStream(adaptor,"token KW_REVOKE");
        RewriteRuleSubtreeStream stream_grantOptionFor=new RewriteRuleSubtreeStream(adaptor,"rule grantOptionFor");
        RewriteRuleSubtreeStream stream_privilegeList=new RewriteRuleSubtreeStream(adaptor,"rule privilegeList");
        RewriteRuleSubtreeStream stream_privilegeObject=new RewriteRuleSubtreeStream(adaptor,"rule privilegeObject");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        pushMsg("revoke privileges", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1472:5: ( KW_REVOKE ( grantOptionFor )? privilegeList ( privilegeObject )? KW_FROM principalSpecification -> ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? ( grantOptionFor )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1472:7: KW_REVOKE ( grantOptionFor )? privilegeList ( privilegeObject )? KW_FROM principalSpecification
            {
            KW_REVOKE474=(Token)match(input,KW_REVOKE,FOLLOW_KW_REVOKE_in_revokePrivileges7839); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_REVOKE.add(KW_REVOKE474);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1472:17: ( grantOptionFor )?
            int alt144=2;
            switch ( input.LA(1) ) {
                case KW_GRANT:
                    {
                    alt144=1;
                    }
                    break;
            }

            switch (alt144) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1472:17: grantOptionFor
                    {
                    pushFollow(FOLLOW_grantOptionFor_in_revokePrivileges7841);
                    grantOptionFor475=grantOptionFor();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_grantOptionFor.add(grantOptionFor475.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_privilegeList_in_revokePrivileges7844);
            privilegeList476=privilegeList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_privilegeList.add(privilegeList476.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1472:47: ( privilegeObject )?
            int alt145=2;
            switch ( input.LA(1) ) {
                case KW_ON:
                    {
                    alt145=1;
                    }
                    break;
            }

            switch (alt145) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1472:47: privilegeObject
                    {
                    pushFollow(FOLLOW_privilegeObject_in_revokePrivileges7846);
                    privilegeObject477=privilegeObject();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_privilegeObject.add(privilegeObject477.getTree());

                    }
                    break;

            }


            KW_FROM478=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_revokePrivileges7849); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_FROM.add(KW_FROM478);


            pushFollow(FOLLOW_principalSpecification_in_revokePrivileges7851);
            principalSpecification479=principalSpecification();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_principalSpecification.add(principalSpecification479.getTree());

            // AST REWRITE
            // elements: privilegeList, principalSpecification, privilegeObject, grantOptionFor
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1473:5: -> ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? ( grantOptionFor )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1473:8: ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? ( grantOptionFor )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_REVOKE, "TOK_REVOKE")
                , root_1);

                adaptor.addChild(root_1, stream_privilegeList.nextTree());

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1473:58: ( privilegeObject )?
                if ( stream_privilegeObject.hasNext() ) {
                    adaptor.addChild(root_1, stream_privilegeObject.nextTree());

                }
                stream_privilegeObject.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1473:75: ( grantOptionFor )?
                if ( stream_grantOptionFor.hasNext() ) {
                    adaptor.addChild(root_1, stream_grantOptionFor.nextTree());

                }
                stream_grantOptionFor.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "revokePrivileges"


    public static class grantRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "grantRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1476:1: grantRole : KW_GRANT ( KW_ROLE )? identifier ( COMMA identifier )* KW_TO principalSpecification ( withAdminOption )? -> ^( TOK_GRANT_ROLE principalSpecification ( withAdminOption )? ( identifier )+ ) ;
    public final HiveParser.grantRole_return grantRole() throws RecognitionException {
        HiveParser.grantRole_return retval = new HiveParser.grantRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_GRANT480=null;
        Token KW_ROLE481=null;
        Token COMMA483=null;
        Token KW_TO485=null;
        HiveParser_IdentifiersParser.identifier_return identifier482 =null;

        HiveParser_IdentifiersParser.identifier_return identifier484 =null;

        HiveParser.principalSpecification_return principalSpecification486 =null;

        HiveParser.withAdminOption_return withAdminOption487 =null;


        CommonTree KW_GRANT480_tree=null;
        CommonTree KW_ROLE481_tree=null;
        CommonTree COMMA483_tree=null;
        CommonTree KW_TO485_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_withAdminOption=new RewriteRuleSubtreeStream(adaptor,"rule withAdminOption");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        pushMsg("grant role", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1479:5: ( KW_GRANT ( KW_ROLE )? identifier ( COMMA identifier )* KW_TO principalSpecification ( withAdminOption )? -> ^( TOK_GRANT_ROLE principalSpecification ( withAdminOption )? ( identifier )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1479:7: KW_GRANT ( KW_ROLE )? identifier ( COMMA identifier )* KW_TO principalSpecification ( withAdminOption )?
            {
            KW_GRANT480=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_grantRole7898); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_GRANT.add(KW_GRANT480);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1479:16: ( KW_ROLE )?
            int alt146=2;
            switch ( input.LA(1) ) {
                case KW_ROLE:
                    {
                    switch ( input.LA(2) ) {
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_AUTHORIZATION:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURRENT_DATE:
                        case KW_CURRENT_TIMESTAMP:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DAY:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_HOUR:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIKE:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_METADATA:
                        case KW_MINUS:
                        case KW_MINUTE:
                        case KW_MONTH:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RELOAD:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_REPLICATION:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_REWRITE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SECOND:
                        case KW_SEMI:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SERVER:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_URI:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUES:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                        case KW_YEAR:
                            {
                            alt146=1;
                            }
                            break;
                        case KW_TO:
                            {
                            switch ( input.LA(3) ) {
                                case COMMA:
                                case KW_TO:
                                    {
                                    alt146=1;
                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt146) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1479:16: KW_ROLE
                    {
                    KW_ROLE481=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_grantRole7900); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_ROLE.add(KW_ROLE481);


                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_grantRole7903);
            identifier482=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(identifier482.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1479:36: ( COMMA identifier )*
            loop147:
            do {
                int alt147=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt147=1;
                    }
                    break;

                }

                switch (alt147) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1479:37: COMMA identifier
            	    {
            	    COMMA483=(Token)match(input,COMMA,FOLLOW_COMMA_in_grantRole7906); if (state.failed) return retval; 
            	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA483);


            	    pushFollow(FOLLOW_identifier_in_grantRole7908);
            	    identifier484=identifier();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_identifier.add(identifier484.getTree());

            	    }
            	    break;

            	default :
            	    break loop147;
                }
            } while (true);


            KW_TO485=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_grantRole7912); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_TO.add(KW_TO485);


            pushFollow(FOLLOW_principalSpecification_in_grantRole7914);
            principalSpecification486=principalSpecification();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_principalSpecification.add(principalSpecification486.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1479:85: ( withAdminOption )?
            int alt148=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt148=1;
                    }
                    break;
            }

            switch (alt148) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1479:85: withAdminOption
                    {
                    pushFollow(FOLLOW_withAdminOption_in_grantRole7916);
                    withAdminOption487=withAdminOption();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_withAdminOption.add(withAdminOption487.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: withAdminOption, identifier, principalSpecification
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1480:5: -> ^( TOK_GRANT_ROLE principalSpecification ( withAdminOption )? ( identifier )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1480:8: ^( TOK_GRANT_ROLE principalSpecification ( withAdminOption )? ( identifier )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_GRANT_ROLE, "TOK_GRANT_ROLE")
                , root_1);

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1480:48: ( withAdminOption )?
                if ( stream_withAdminOption.hasNext() ) {
                    adaptor.addChild(root_1, stream_withAdminOption.nextTree());

                }
                stream_withAdminOption.reset();

                if ( !(stream_identifier.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_identifier.hasNext() ) {
                    adaptor.addChild(root_1, stream_identifier.nextTree());

                }
                stream_identifier.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "grantRole"


    public static class revokeRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "revokeRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1483:1: revokeRole : KW_REVOKE ( adminOptionFor )? ( KW_ROLE )? identifier ( COMMA identifier )* KW_FROM principalSpecification -> ^( TOK_REVOKE_ROLE principalSpecification ( adminOptionFor )? ( identifier )+ ) ;
    public final HiveParser.revokeRole_return revokeRole() throws RecognitionException {
        HiveParser.revokeRole_return retval = new HiveParser.revokeRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_REVOKE488=null;
        Token KW_ROLE490=null;
        Token COMMA492=null;
        Token KW_FROM494=null;
        HiveParser.adminOptionFor_return adminOptionFor489 =null;

        HiveParser_IdentifiersParser.identifier_return identifier491 =null;

        HiveParser_IdentifiersParser.identifier_return identifier493 =null;

        HiveParser.principalSpecification_return principalSpecification495 =null;


        CommonTree KW_REVOKE488_tree=null;
        CommonTree KW_ROLE490_tree=null;
        CommonTree COMMA492_tree=null;
        CommonTree KW_FROM494_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleTokenStream stream_KW_REVOKE=new RewriteRuleTokenStream(adaptor,"token KW_REVOKE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_adminOptionFor=new RewriteRuleSubtreeStream(adaptor,"rule adminOptionFor");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        pushMsg("revoke role", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1486:5: ( KW_REVOKE ( adminOptionFor )? ( KW_ROLE )? identifier ( COMMA identifier )* KW_FROM principalSpecification -> ^( TOK_REVOKE_ROLE principalSpecification ( adminOptionFor )? ( identifier )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1486:7: KW_REVOKE ( adminOptionFor )? ( KW_ROLE )? identifier ( COMMA identifier )* KW_FROM principalSpecification
            {
            KW_REVOKE488=(Token)match(input,KW_REVOKE,FOLLOW_KW_REVOKE_in_revokeRole7962); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_REVOKE.add(KW_REVOKE488);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1486:17: ( adminOptionFor )?
            int alt149=2;
            switch ( input.LA(1) ) {
                case KW_ADMIN:
                    {
                    switch ( input.LA(2) ) {
                        case KW_OPTION:
                            {
                            alt149=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt149) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1486:17: adminOptionFor
                    {
                    pushFollow(FOLLOW_adminOptionFor_in_revokeRole7964);
                    adminOptionFor489=adminOptionFor();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_adminOptionFor.add(adminOptionFor489.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1486:33: ( KW_ROLE )?
            int alt150=2;
            switch ( input.LA(1) ) {
                case KW_ROLE:
                    {
                    switch ( input.LA(2) ) {
                        case Identifier:
                        case KW_ADD:
                        case KW_ADMIN:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_AUTHORIZATION:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPACT:
                        case KW_COMPACTIONS:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURRENT_DATE:
                        case KW_CURRENT_TIMESTAMP:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DAY:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILE:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_HOUR:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_JAR:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIKE:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_METADATA:
                        case KW_MINUS:
                        case KW_MINUTE:
                        case KW_MONTH:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_OWNER:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PRINCIPALS:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RELOAD:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_REPLICATION:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_REWRITE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SECOND:
                        case KW_SEMI:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SERVER:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRANSACTIONS:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_URI:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUES:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                        case KW_YEAR:
                            {
                            alt150=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt150) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1486:33: KW_ROLE
                    {
                    KW_ROLE490=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_revokeRole7967); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_ROLE.add(KW_ROLE490);


                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_revokeRole7970);
            identifier491=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(identifier491.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1486:53: ( COMMA identifier )*
            loop151:
            do {
                int alt151=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt151=1;
                    }
                    break;

                }

                switch (alt151) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1486:54: COMMA identifier
            	    {
            	    COMMA492=(Token)match(input,COMMA,FOLLOW_COMMA_in_revokeRole7973); if (state.failed) return retval; 
            	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA492);


            	    pushFollow(FOLLOW_identifier_in_revokeRole7975);
            	    identifier493=identifier();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_identifier.add(identifier493.getTree());

            	    }
            	    break;

            	default :
            	    break loop151;
                }
            } while (true);


            KW_FROM494=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_revokeRole7979); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_FROM.add(KW_FROM494);


            pushFollow(FOLLOW_principalSpecification_in_revokeRole7981);
            principalSpecification495=principalSpecification();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_principalSpecification.add(principalSpecification495.getTree());

            // AST REWRITE
            // elements: adminOptionFor, principalSpecification, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1487:5: -> ^( TOK_REVOKE_ROLE principalSpecification ( adminOptionFor )? ( identifier )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1487:8: ^( TOK_REVOKE_ROLE principalSpecification ( adminOptionFor )? ( identifier )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_REVOKE_ROLE, "TOK_REVOKE_ROLE")
                , root_1);

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1487:49: ( adminOptionFor )?
                if ( stream_adminOptionFor.hasNext() ) {
                    adaptor.addChild(root_1, stream_adminOptionFor.nextTree());

                }
                stream_adminOptionFor.reset();

                if ( !(stream_identifier.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_identifier.hasNext() ) {
                    adaptor.addChild(root_1, stream_identifier.nextTree());

                }
                stream_identifier.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "revokeRole"


    public static class showRoleGrants_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showRoleGrants"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1490:1: showRoleGrants : KW_SHOW KW_ROLE KW_GRANT principalName -> ^( TOK_SHOW_ROLE_GRANT principalName ) ;
    public final HiveParser.showRoleGrants_return showRoleGrants() throws RecognitionException {
        HiveParser.showRoleGrants_return retval = new HiveParser.showRoleGrants_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW496=null;
        Token KW_ROLE497=null;
        Token KW_GRANT498=null;
        HiveParser.principalName_return principalName499 =null;


        CommonTree KW_SHOW496_tree=null;
        CommonTree KW_ROLE497_tree=null;
        CommonTree KW_GRANT498_tree=null;
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleSubtreeStream stream_principalName=new RewriteRuleSubtreeStream(adaptor,"rule principalName");
        pushMsg("show role grants", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1493:5: ( KW_SHOW KW_ROLE KW_GRANT principalName -> ^( TOK_SHOW_ROLE_GRANT principalName ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1493:7: KW_SHOW KW_ROLE KW_GRANT principalName
            {
            KW_SHOW496=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showRoleGrants8026); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW496);


            KW_ROLE497=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_showRoleGrants8028); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_ROLE.add(KW_ROLE497);


            KW_GRANT498=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_showRoleGrants8030); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_GRANT.add(KW_GRANT498);


            pushFollow(FOLLOW_principalName_in_showRoleGrants8032);
            principalName499=principalName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_principalName.add(principalName499.getTree());

            // AST REWRITE
            // elements: principalName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1494:5: -> ^( TOK_SHOW_ROLE_GRANT principalName )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1494:8: ^( TOK_SHOW_ROLE_GRANT principalName )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_ROLE_GRANT, "TOK_SHOW_ROLE_GRANT")
                , root_1);

                adaptor.addChild(root_1, stream_principalName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showRoleGrants"


    public static class showRoles_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showRoles"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1498:1: showRoles : KW_SHOW KW_ROLES -> ^( TOK_SHOW_ROLES ) ;
    public final HiveParser.showRoles_return showRoles() throws RecognitionException {
        HiveParser.showRoles_return retval = new HiveParser.showRoles_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW500=null;
        Token KW_ROLES501=null;

        CommonTree KW_SHOW500_tree=null;
        CommonTree KW_ROLES501_tree=null;
        RewriteRuleTokenStream stream_KW_ROLES=new RewriteRuleTokenStream(adaptor,"token KW_ROLES");
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");

        pushMsg("show roles", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1501:5: ( KW_SHOW KW_ROLES -> ^( TOK_SHOW_ROLES ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1501:7: KW_SHOW KW_ROLES
            {
            KW_SHOW500=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showRoles8072); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW500);


            KW_ROLES501=(Token)match(input,KW_ROLES,FOLLOW_KW_ROLES_in_showRoles8074); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_ROLES.add(KW_ROLES501);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1502:5: -> ^( TOK_SHOW_ROLES )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1502:8: ^( TOK_SHOW_ROLES )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_ROLES, "TOK_SHOW_ROLES")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showRoles"


    public static class showCurrentRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showCurrentRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1505:1: showCurrentRole : KW_SHOW KW_CURRENT KW_ROLES -> ^( TOK_SHOW_SET_ROLE ) ;
    public final HiveParser.showCurrentRole_return showCurrentRole() throws RecognitionException {
        HiveParser.showCurrentRole_return retval = new HiveParser.showCurrentRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW502=null;
        Token KW_CURRENT503=null;
        Token KW_ROLES504=null;

        CommonTree KW_SHOW502_tree=null;
        CommonTree KW_CURRENT503_tree=null;
        CommonTree KW_ROLES504_tree=null;
        RewriteRuleTokenStream stream_KW_ROLES=new RewriteRuleTokenStream(adaptor,"token KW_ROLES");
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_CURRENT=new RewriteRuleTokenStream(adaptor,"token KW_CURRENT");

        pushMsg("show current role", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1508:5: ( KW_SHOW KW_CURRENT KW_ROLES -> ^( TOK_SHOW_SET_ROLE ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1508:7: KW_SHOW KW_CURRENT KW_ROLES
            {
            KW_SHOW502=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showCurrentRole8111); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW502);


            KW_CURRENT503=(Token)match(input,KW_CURRENT,FOLLOW_KW_CURRENT_in_showCurrentRole8113); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_CURRENT.add(KW_CURRENT503);


            KW_ROLES504=(Token)match(input,KW_ROLES,FOLLOW_KW_ROLES_in_showCurrentRole8115); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_ROLES.add(KW_ROLES504);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1509:5: -> ^( TOK_SHOW_SET_ROLE )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1509:8: ^( TOK_SHOW_SET_ROLE )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_SET_ROLE, "TOK_SHOW_SET_ROLE")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showCurrentRole"


    public static class setRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "setRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1512:1: setRole : KW_SET KW_ROLE ( ( KW_ALL )=> (all= KW_ALL ) -> ^( TOK_SHOW_SET_ROLE Identifier[$all.text] ) | ( KW_NONE )=> (none= KW_NONE ) -> ^( TOK_SHOW_SET_ROLE Identifier[$none.text] ) | identifier -> ^( TOK_SHOW_SET_ROLE identifier ) ) ;
    public final HiveParser.setRole_return setRole() throws RecognitionException {
        HiveParser.setRole_return retval = new HiveParser.setRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token all=null;
        Token none=null;
        Token KW_SET505=null;
        Token KW_ROLE506=null;
        HiveParser_IdentifiersParser.identifier_return identifier507 =null;


        CommonTree all_tree=null;
        CommonTree none_tree=null;
        CommonTree KW_SET505_tree=null;
        CommonTree KW_ROLE506_tree=null;
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_KW_NONE=new RewriteRuleTokenStream(adaptor,"token KW_NONE");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_ALL=new RewriteRuleTokenStream(adaptor,"token KW_ALL");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("set role", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1515:5: ( KW_SET KW_ROLE ( ( KW_ALL )=> (all= KW_ALL ) -> ^( TOK_SHOW_SET_ROLE Identifier[$all.text] ) | ( KW_NONE )=> (none= KW_NONE ) -> ^( TOK_SHOW_SET_ROLE Identifier[$none.text] ) | identifier -> ^( TOK_SHOW_SET_ROLE identifier ) ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1515:7: KW_SET KW_ROLE ( ( KW_ALL )=> (all= KW_ALL ) -> ^( TOK_SHOW_SET_ROLE Identifier[$all.text] ) | ( KW_NONE )=> (none= KW_NONE ) -> ^( TOK_SHOW_SET_ROLE Identifier[$none.text] ) | identifier -> ^( TOK_SHOW_SET_ROLE identifier ) )
            {
            KW_SET505=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_setRole8152); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_SET.add(KW_SET505);


            KW_ROLE506=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_setRole8154); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_ROLE.add(KW_ROLE506);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1516:5: ( ( KW_ALL )=> (all= KW_ALL ) -> ^( TOK_SHOW_SET_ROLE Identifier[$all.text] ) | ( KW_NONE )=> (none= KW_NONE ) -> ^( TOK_SHOW_SET_ROLE Identifier[$none.text] ) | identifier -> ^( TOK_SHOW_SET_ROLE identifier ) )
            int alt152=3;
            switch ( input.LA(1) ) {
            case KW_ALL:
                {
                int LA152_1 = input.LA(2);

                if ( (synpred11_HiveParser()) ) {
                    alt152=1;
                }
                else if ( ((useSQL11ReservedKeywordsForIdentifier())) ) {
                    alt152=3;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 152, 1, input);

                    throw nvae;

                }
                }
                break;
            case KW_NONE:
                {
                int LA152_2 = input.LA(2);

                if ( (synpred12_HiveParser()) ) {
                    alt152=2;
                }
                else if ( ((useSQL11ReservedKeywordsForIdentifier())) ) {
                    alt152=3;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 152, 2, input);

                    throw nvae;

                }
                }
                break;
            case Identifier:
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_AUTHORIZATION:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURRENT_DATE:
            case KW_CURRENT_TIMESTAMP:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DAY:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILE:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_HOUR:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_JAR:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_METADATA:
            case KW_MINUS:
            case KW_MINUTE:
            case KW_MONTH:
            case KW_MSCK:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_OWNER:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PRINCIPALS:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RELOAD:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_REPLICATION:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_REWRITE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SECOND:
            case KW_SEMI:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SERVER:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRANSACTIONS:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_URI:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUES:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
            case KW_YEAR:
                {
                alt152=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 152, 0, input);

                throw nvae;

            }

            switch (alt152) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1517:5: ( KW_ALL )=> (all= KW_ALL )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1517:17: (all= KW_ALL )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1517:18: all= KW_ALL
                    {
                    all=(Token)match(input,KW_ALL,FOLLOW_KW_ALL_in_setRole8176); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_ALL.add(all);


                    }


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1517:30: -> ^( TOK_SHOW_SET_ROLE Identifier[$all.text] )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1517:33: ^( TOK_SHOW_SET_ROLE Identifier[$all.text] )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_SET_ROLE, "TOK_SHOW_SET_ROLE")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(Identifier, (all!=null?all.getText():null))
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1519:5: ( KW_NONE )=> (none= KW_NONE )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1519:18: (none= KW_NONE )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1519:19: none= KW_NONE
                    {
                    none=(Token)match(input,KW_NONE,FOLLOW_KW_NONE_in_setRole8207); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_NONE.add(none);


                    }


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1519:33: -> ^( TOK_SHOW_SET_ROLE Identifier[$none.text] )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1519:36: ^( TOK_SHOW_SET_ROLE Identifier[$none.text] )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_SET_ROLE, "TOK_SHOW_SET_ROLE")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(Identifier, (none!=null?none.getText():null))
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1521:5: identifier
                    {
                    pushFollow(FOLLOW_identifier_in_setRole8229);
                    identifier507=identifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_identifier.add(identifier507.getTree());

                    // AST REWRITE
                    // elements: identifier
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1521:16: -> ^( TOK_SHOW_SET_ROLE identifier )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1521:19: ^( TOK_SHOW_SET_ROLE identifier )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_SET_ROLE, "TOK_SHOW_SET_ROLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_identifier.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "setRole"


    public static class showGrants_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showGrants"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1525:1: showGrants : KW_SHOW KW_GRANT ( principalName )? ( KW_ON privilegeIncludeColObject )? -> ^( TOK_SHOW_GRANT ( principalName )? ( privilegeIncludeColObject )? ) ;
    public final HiveParser.showGrants_return showGrants() throws RecognitionException {
        HiveParser.showGrants_return retval = new HiveParser.showGrants_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW508=null;
        Token KW_GRANT509=null;
        Token KW_ON511=null;
        HiveParser.principalName_return principalName510 =null;

        HiveParser.privilegeIncludeColObject_return privilegeIncludeColObject512 =null;


        CommonTree KW_SHOW508_tree=null;
        CommonTree KW_GRANT509_tree=null;
        CommonTree KW_ON511_tree=null;
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleSubtreeStream stream_privilegeIncludeColObject=new RewriteRuleSubtreeStream(adaptor,"rule privilegeIncludeColObject");
        RewriteRuleSubtreeStream stream_principalName=new RewriteRuleSubtreeStream(adaptor,"rule principalName");
        pushMsg("show grants", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1528:5: ( KW_SHOW KW_GRANT ( principalName )? ( KW_ON privilegeIncludeColObject )? -> ^( TOK_SHOW_GRANT ( principalName )? ( privilegeIncludeColObject )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1528:7: KW_SHOW KW_GRANT ( principalName )? ( KW_ON privilegeIncludeColObject )?
            {
            KW_SHOW508=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showGrants8270); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW508);


            KW_GRANT509=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_showGrants8272); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_GRANT.add(KW_GRANT509);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1528:24: ( principalName )?
            int alt153=2;
            switch ( input.LA(1) ) {
                case KW_GROUP:
                case KW_ROLE:
                case KW_USER:
                    {
                    alt153=1;
                    }
                    break;
            }

            switch (alt153) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1528:24: principalName
                    {
                    pushFollow(FOLLOW_principalName_in_showGrants8274);
                    principalName510=principalName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_principalName.add(principalName510.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1528:39: ( KW_ON privilegeIncludeColObject )?
            int alt154=2;
            switch ( input.LA(1) ) {
                case KW_ON:
                    {
                    alt154=1;
                    }
                    break;
            }

            switch (alt154) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1528:40: KW_ON privilegeIncludeColObject
                    {
                    KW_ON511=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_showGrants8278); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_KW_ON.add(KW_ON511);


                    pushFollow(FOLLOW_privilegeIncludeColObject_in_showGrants8280);
                    privilegeIncludeColObject512=privilegeIncludeColObject();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_privilegeIncludeColObject.add(privilegeIncludeColObject512.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: privilegeIncludeColObject, principalName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1529:5: -> ^( TOK_SHOW_GRANT ( principalName )? ( privilegeIncludeColObject )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1529:8: ^( TOK_SHOW_GRANT ( principalName )? ( privilegeIncludeColObject )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_GRANT, "TOK_SHOW_GRANT")
                , root_1);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1529:25: ( principalName )?
                if ( stream_principalName.hasNext() ) {
                    adaptor.addChild(root_1, stream_principalName.nextTree());

                }
                stream_principalName.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1529:40: ( privilegeIncludeColObject )?
                if ( stream_privilegeIncludeColObject.hasNext() ) {
                    adaptor.addChild(root_1, stream_privilegeIncludeColObject.nextTree());

                }
                stream_privilegeIncludeColObject.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showGrants"


    public static class showRolePrincipals_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showRolePrincipals"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1532:1: showRolePrincipals : KW_SHOW KW_PRINCIPALS roleName= identifier -> ^( TOK_SHOW_ROLE_PRINCIPALS $roleName) ;
    public final HiveParser.showRolePrincipals_return showRolePrincipals() throws RecognitionException {
        HiveParser.showRolePrincipals_return retval = new HiveParser.showRolePrincipals_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW513=null;
        Token KW_PRINCIPALS514=null;
        HiveParser_IdentifiersParser.identifier_return roleName =null;


        CommonTree KW_SHOW513_tree=null;
        CommonTree KW_PRINCIPALS514_tree=null;
        RewriteRuleTokenStream stream_KW_PRINCIPALS=new RewriteRuleTokenStream(adaptor,"token KW_PRINCIPALS");
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        pushMsg("show role principals", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1535:5: ( KW_SHOW KW_PRINCIPALS roleName= identifier -> ^( TOK_SHOW_ROLE_PRINCIPALS $roleName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1535:7: KW_SHOW KW_PRINCIPALS roleName= identifier
            {
            KW_SHOW513=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showRolePrincipals8325); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_SHOW.add(KW_SHOW513);


            KW_PRINCIPALS514=(Token)match(input,KW_PRINCIPALS,FOLLOW_KW_PRINCIPALS_in_showRolePrincipals8327); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_KW_PRINCIPALS.add(KW_PRINCIPALS514);


            pushFollow(FOLLOW_identifier_in_showRolePrincipals8331);
            roleName=identifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_identifier.add(roleName.getTree());

            // AST REWRITE
            // elements: roleName
            // token labels: 
            // rule labels: roleName, retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_roleName=new RewriteRuleSubtreeStream(adaptor,"rule roleName",roleName!=null?roleName.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1536:5: -> ^( TOK_SHOW_ROLE_PRINCIPALS $roleName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1536:8: ^( TOK_SHOW_ROLE_PRINCIPALS $roleName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_ROLE_PRINCIPALS, "TOK_SHOW_ROLE_PRINCIPALS")
                , root_1);

                adaptor.addChild(root_1, stream_roleName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {popMsg(state);}
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showRolePrincipals"


    public static class privilegeIncludeColObject_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "privilegeIncludeColObject"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1540:1: privilegeIncludeColObject : ( ( KW_ALL )=> KW_ALL -> ^( TOK_RESOURCE_ALL ) | privObjectCols -> ^( TOK_PRIV_OBJECT_COL privObjectCols ) );
    public final HiveParser.privilegeIncludeColObject_return privilegeIncludeColObject() throws RecognitionException {
        HiveParser.privilegeIncludeColObject_return retval = new HiveParser.privilegeIncludeColObject_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ALL515=null;
        HiveParser.privObjectCols_return privObjectCols516 =null;


        CommonTree KW_ALL515_tree=null;
        RewriteRuleTokenStream stream_KW_ALL=new RewriteRuleTokenStream(adaptor,"token KW_ALL");
        RewriteRuleSubtreeStream stream_privObjectCols=new RewriteRuleSubtreeStream(adaptor,"rule privObjectCols");
        pushMsg("privilege object including columns", state);
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1543:5: ( ( KW_ALL )=> KW_ALL -> ^( TOK_RESOURCE_ALL ) | privObjectCols -> ^( TOK_PRIV_OBJECT_COL privObjectCols ) )
            int alt155=2;
            switch ( input.LA(1) ) {
            case KW_ALL:
                {
                int LA155_1 = input.LA(2);

                if ( (synpred13_HiveParser()) ) {
                    alt155=1;
                }
                else if ( ((useSQL11ReservedKeywordsForIdentifier())) ) {
                    alt155=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 155, 1, input);

                    throw nvae;

                }
                }
                break;
            case Identifier:
            case KW_ADD:
            case KW_ADMIN:
            case KW_AFTER:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_AUTHORIZATION:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPACT:
            case KW_COMPACTIONS:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURRENT_DATE:
            case KW_CURRENT_TIMESTAMP:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASE:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DAY:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP